/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Movie {
    private final long mNativeMovie;

    private Movie(long l) {
        if (l == 0L) {
            throw new RuntimeException("native movie creation failed");
        }
        this.mNativeMovie = l;
    }

    public static native Movie decodeByteArray(byte[] var0, int var1, int var2);

    public static Movie decodeFile(String string2) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return Movie.decodeTempStream(fileInputStream);
    }

    public static Movie decodeStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        if (inputStream instanceof AssetManager.AssetInputStream) {
            return Movie.nativeDecodeAsset(((AssetManager.AssetInputStream)inputStream).getNativeAsset());
        }
        return Movie.nativeDecodeStream(inputStream);
    }

    private static Movie decodeTempStream(InputStream inputStream) {
        Movie movie = null;
        try {
            movie = Movie.decodeStream(inputStream);
            inputStream.close();
            return movie;
        }
        catch (IOException iOException) {
            return movie;
        }
    }

    private static native Movie nativeDecodeAsset(long var0);

    private static native Movie nativeDecodeStream(InputStream var0);

    private static native void nativeDestructor(long var0);

    public void draw(Canvas canvas, float f, float f2) {
        this.draw(canvas, f, f2, null);
    }

    public native void draw(Canvas var1, float var2, float var3, Paint var4);

    public native int duration();

    protected void finalize() throws Throwable {
        try {
            Movie.nativeDestructor(this.mNativeMovie);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public native int height();

    public native boolean isOpaque();

    public native boolean setTime(int var1);

    public native int width();
}

