/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Shader;

public class LinearGradient
extends Shader {
    private static final int TYPE_COLORS_AND_POSITIONS = 1;
    private static final int TYPE_COLOR_START_AND_COLOR_END = 2;
    private int mColor0;
    private int mColor1;
    private int[] mColors;
    private float[] mPositions;
    private Shader.TileMode mTileMode;
    private int mType;
    private float mX0;
    private float mX1;
    private float mY0;
    private float mY1;

    public LinearGradient(float f, float f2, float f3, float f4, int n, int n2, Shader.TileMode tileMode) {
        this.mType = 2;
        this.mX0 = f;
        this.mY0 = f2;
        this.mX1 = f3;
        this.mY1 = f4;
        this.mColor0 = n;
        this.mColor1 = n2;
        this.mTileMode = tileMode;
        this.init(this.nativeCreate2(f, f2, f3, f4, n, n2, tileMode.nativeInt));
    }

    public LinearGradient(float f, float f2, float f3, float f4, int[] nArray, float[] fArray, Shader.TileMode tileMode) {
        if (nArray.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        if (fArray != null && nArray.length != fArray.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mType = 1;
        this.mX0 = f;
        this.mY0 = f2;
        this.mX1 = f3;
        this.mY1 = f4;
        this.mColors = nArray;
        this.mPositions = fArray;
        this.mTileMode = tileMode;
        this.init(this.nativeCreate1(f, f2, f3, f4, nArray, fArray, tileMode.nativeInt));
    }

    private native long nativeCreate1(float var1, float var2, float var3, float var4, int[] var5, float[] var6, int var7);

    private native long nativeCreate2(float var1, float var2, float var3, float var4, int var5, int var6, int var7);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Shader copy() {
        LinearGradient linearGradient;
        switch (this.mType) {
            default: {
                throw new IllegalArgumentException("LinearGradient should be created with either colors and positions or start color and end color");
            }
            case 1: {
                float f = this.mX0;
                float f2 = this.mY0;
                float f3 = this.mX1;
                float f4 = this.mY1;
                int[] nArray = (int[])this.mColors.clone();
                float[] fArray = this.mPositions != null ? (float[])this.mPositions.clone() : null;
                linearGradient = new LinearGradient(f, f2, f3, f4, nArray, fArray, this.mTileMode);
                break;
            }
            case 2: {
                linearGradient = new LinearGradient(this.mX0, this.mY0, this.mX1, this.mY1, this.mColor0, this.mColor1, this.mTileMode);
            }
        }
        this.copyLocalMatrix(linearGradient);
        return linearGradient;
    }
}

