/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.util.FloatMath;
import java.util.Arrays;

public class ColorMatrix {
    private final float[] mArray = new float[20];

    public ColorMatrix() {
        this.reset();
    }

    public ColorMatrix(ColorMatrix colorMatrix) {
        System.arraycopy((float[])colorMatrix.mArray, (int)0, (float[])this.mArray, (int)0, (int)20);
    }

    public ColorMatrix(float[] fArray) {
        System.arraycopy((float[])fArray, (int)0, (float[])this.mArray, (int)0, (int)20);
    }

    public final float[] getArray() {
        return this.mArray;
    }

    public void postConcat(ColorMatrix colorMatrix) {
        this.setConcat(colorMatrix, this);
    }

    public void preConcat(ColorMatrix colorMatrix) {
        this.setConcat(this, colorMatrix);
    }

    public void reset() {
        float[] fArray = this.mArray;
        Arrays.fill(fArray, 0.0f);
        fArray[18] = 1.0f;
        fArray[12] = 1.0f;
        fArray[6] = 1.0f;
        fArray[0] = 1.0f;
    }

    public void set(ColorMatrix colorMatrix) {
        System.arraycopy((float[])colorMatrix.mArray, (int)0, (float[])this.mArray, (int)0, (int)20);
    }

    public void set(float[] fArray) {
        System.arraycopy((float[])fArray, (int)0, (float[])this.mArray, (int)0, (int)20);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setConcat(ColorMatrix colorMatrix, ColorMatrix colorMatrix2) {
        float[] fArray = colorMatrix == this || colorMatrix2 == this ? new float[20] : this.mArray;
        float[] fArray2 = colorMatrix.mArray;
        float[] fArray3 = colorMatrix2.mArray;
        int n = 0;
        for (int i = 0; i < 20; i += 5) {
            int n2 = n;
            for (int j = 0; j < 4; ++j) {
                int n3 = n2 + 1;
                fArray[n2] = fArray2[i + 0] * fArray3[j + 0] + fArray2[i + 1] * fArray3[j + 5] + fArray2[i + 2] * fArray3[j + 10] + fArray2[i + 3] * fArray3[j + 15];
                n2 = n3;
            }
            n = n2 + 1;
            fArray[n2] = fArray2[i + 0] * fArray3[4] + fArray2[i + 1] * fArray3[9] + fArray2[i + 2] * fArray3[14] + fArray2[i + 3] * fArray3[19] + fArray2[i + 4];
        }
        if (fArray != this.mArray) {
            System.arraycopy((float[])fArray, (int)0, (float[])this.mArray, (int)0, (int)20);
        }
    }

    public void setRGB2YUV() {
        this.reset();
        float[] fArray = this.mArray;
        fArray[0] = 0.299f;
        fArray[1] = 0.587f;
        fArray[2] = 0.114f;
        fArray[5] = -0.16874f;
        fArray[6] = -0.33126f;
        fArray[7] = 0.5f;
        fArray[10] = 0.5f;
        fArray[11] = -0.41869f;
        fArray[12] = -0.08131f;
    }

    public void setRotate(int n, float f) {
        this.reset();
        float f2 = (float)Math.PI * f / 180.0f;
        float f3 = FloatMath.cos(f2);
        float f4 = FloatMath.sin(f2);
        switch (n) {
            default: {
                throw new RuntimeException();
            }
            case 0: {
                float[] fArray = this.mArray;
                this.mArray[12] = f3;
                fArray[6] = f3;
                this.mArray[7] = f4;
                this.mArray[11] = -f4;
                return;
            }
            case 1: {
                float[] fArray = this.mArray;
                this.mArray[12] = f3;
                fArray[0] = f3;
                this.mArray[2] = -f4;
                this.mArray[10] = f4;
                return;
            }
            case 2: 
        }
        float[] fArray = this.mArray;
        this.mArray[6] = f3;
        fArray[0] = f3;
        this.mArray[1] = f4;
        this.mArray[5] = -f4;
    }

    public void setSaturation(float f) {
        this.reset();
        float[] fArray = this.mArray;
        float f2 = 1.0f - f;
        float f3 = 0.213f * f2;
        float f4 = 0.715f * f2;
        float f5 = 0.072f * f2;
        fArray[0] = f3 + f;
        fArray[1] = f4;
        fArray[2] = f5;
        fArray[5] = f3;
        fArray[6] = f4 + f;
        fArray[7] = f5;
        fArray[10] = f3;
        fArray[11] = f4;
        fArray[12] = f5 + f;
    }

    public void setScale(float f, float f2, float f3, float f4) {
        float[] fArray = this.mArray;
        for (int i = 19; i > 0; --i) {
            fArray[i] = 0.0f;
        }
        fArray[0] = f;
        fArray[6] = f2;
        fArray[12] = f3;
        fArray[18] = f4;
    }

    public void setYUV2RGB() {
        this.reset();
        float[] fArray = this.mArray;
        fArray[2] = 1.402f;
        fArray[5] = 1.0f;
        fArray[6] = -0.34414f;
        fArray[7] = -0.71414f;
        fArray[10] = 1.0f;
        fArray[11] = 1.772f;
        fArray[12] = 0.0f;
    }
}

