/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.videosrc;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.opengl.Matrix;
import android.util.Log;
import android.view.Surface;
import java.io.IOException;

public class MediaSource
extends Filter {
    private static final int NEWFRAME_TIMEOUT = 100;
    private static final int NEWFRAME_TIMEOUT_REPEAT = 10;
    private static final int PREP_TIMEOUT = 100;
    private static final int PREP_TIMEOUT_REPEAT = 100;
    private static final String TAG = "MediaSource";
    private static final float[] mSourceCoords_0 = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] mSourceCoords_180;
    private static final float[] mSourceCoords_270;
    private static final float[] mSourceCoords_90;
    private boolean mCompleted;
    @GenerateFieldPort(hasDefault=true, name="context")
    private Context mContext = null;
    private ShaderProgram mFrameExtractor;
    private final String mFrameShader;
    private boolean mGotSize;
    private int mHeight;
    private final boolean mLogVerbose;
    @GenerateFieldPort(hasDefault=true, name="loop")
    private boolean mLooping = true;
    private GLFrame mMediaFrame;
    private MediaPlayer mMediaPlayer;
    private boolean mNewFrameAvailable = false;
    @GenerateFieldPort(hasDefault=true, name="orientation")
    private int mOrientation = 0;
    private boolean mOrientationUpdated;
    private MutableFrameFormat mOutputFormat;
    private boolean mPaused;
    private boolean mPlaying;
    private boolean mPrepared;
    @GenerateFieldPort(hasDefault=true, name="sourceIsUrl")
    private boolean mSelectedIsUrl = false;
    @GenerateFieldPort(hasDefault=true, name="sourceAsset")
    private AssetFileDescriptor mSourceAsset = null;
    @GenerateFieldPort(hasDefault=true, name="sourceUrl")
    private String mSourceUrl = "";
    private SurfaceTexture mSurfaceTexture;
    @GenerateFieldPort(hasDefault=true, name="volume")
    private float mVolume = 0.0f;
    @GenerateFinalPort(hasDefault=true, name="waitForNewFrame")
    private boolean mWaitForNewFrame = true;
    private int mWidth;
    private MediaPlayer.OnCompletionListener onCompletionListener;
    private SurfaceTexture.OnFrameAvailableListener onMediaFrameAvailableListener;
    private MediaPlayer.OnPreparedListener onPreparedListener;
    private MediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener = new MediaPlayer.OnVideoSizeChangedListener(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
            if (MediaSource.this.mLogVerbose) {
                Log.v(MediaSource.TAG, "MediaPlayer sent dimensions: " + n + " x " + n2);
            }
            if (!MediaSource.this.mGotSize) {
                if (MediaSource.this.mOrientation == 0 || MediaSource.this.mOrientation == 180) {
                    MediaSource.this.mOutputFormat.setDimensions(n, n2);
                } else {
                    MediaSource.this.mOutputFormat.setDimensions(n2, n);
                }
                MediaSource.access$402(MediaSource.this, n);
                MediaSource.access$502(MediaSource.this, n2);
            } else if (MediaSource.this.mOutputFormat.getWidth() != n || MediaSource.this.mOutputFormat.getHeight() != n2) {
                Log.e(MediaSource.TAG, "Multiple video size change events received!");
            }
            MediaSource mediaSource = MediaSource.this;
            synchronized (mediaSource) {
                MediaSource.access$102(MediaSource.this, true);
                MediaSource.this.notify();
                return;
            }
        }
    };

    static {
        mSourceCoords_270 = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        mSourceCoords_180 = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        mSourceCoords_90 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    public MediaSource(String string2) {
        super(string2);
        this.mFrameShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n";
        this.onPreparedListener = new MediaPlayer.OnPreparedListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onPrepared(MediaPlayer mediaPlayer) {
                if (MediaSource.this.mLogVerbose) {
                    Log.v(MediaSource.TAG, "MediaPlayer is prepared");
                }
                MediaSource mediaSource = MediaSource.this;
                synchronized (mediaSource) {
                    MediaSource.access$602(MediaSource.this, true);
                    MediaSource.this.notify();
                    return;
                }
            }
        };
        this.onCompletionListener = new MediaPlayer.OnCompletionListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCompletion(MediaPlayer mediaPlayer) {
                if (MediaSource.this.mLogVerbose) {
                    Log.v(MediaSource.TAG, "MediaPlayer has completed playback");
                }
                MediaSource mediaSource = MediaSource.this;
                synchronized (mediaSource) {
                    MediaSource.access$702(MediaSource.this, true);
                    return;
                }
            }
        };
        this.onMediaFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                if (MediaSource.this.mLogVerbose) {
                    Log.v(MediaSource.TAG, "New frame from media player");
                }
                MediaSource mediaSource = MediaSource.this;
                synchronized (mediaSource) {
                    if (MediaSource.this.mLogVerbose) {
                        Log.v(MediaSource.TAG, "New frame: notify");
                    }
                    MediaSource.access$802(MediaSource.this, true);
                    MediaSource.this.notify();
                    if (MediaSource.this.mLogVerbose) {
                        Log.v(MediaSource.TAG, "New frame: notify done");
                    }
                    return;
                }
            }
        };
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    static /* synthetic */ boolean access$102(MediaSource mediaSource, boolean bl) {
        mediaSource.mGotSize = bl;
        return bl;
    }

    static /* synthetic */ int access$402(MediaSource mediaSource, int n) {
        mediaSource.mWidth = n;
        return n;
    }

    static /* synthetic */ int access$502(MediaSource mediaSource, int n) {
        mediaSource.mHeight = n;
        return n;
    }

    static /* synthetic */ boolean access$602(MediaSource mediaSource, boolean bl) {
        mediaSource.mPrepared = bl;
        return bl;
    }

    static /* synthetic */ boolean access$702(MediaSource mediaSource, boolean bl) {
        mediaSource.mCompleted = bl;
        return bl;
    }

    static /* synthetic */ boolean access$802(MediaSource mediaSource, boolean bl) {
        mediaSource.mNewFrameAvailable = bl;
        return bl;
    }

    private void createFormats() {
        this.mOutputFormat = ImageFormat.create(3, 3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setupMediaPlayer(boolean var1_1) {
        synchronized (this) {
            block20: {
                block19: {
                    block22: {
                        block21: {
                            this.mPrepared = false;
                            this.mGotSize = false;
                            this.mPlaying = false;
                            this.mPaused = false;
                            this.mCompleted = false;
                            this.mNewFrameAvailable = false;
                            if (this.mLogVerbose) {
                                Log.v("MediaSource", "Setting up playback.");
                            }
                            if (this.mMediaPlayer == null) break block21;
                            if (this.mLogVerbose) {
                                Log.v("MediaSource", "Resetting existing MediaPlayer.");
                            }
                            this.mMediaPlayer.reset();
lbl16:
                            // 2 sources

                            while (this.mMediaPlayer == null) {
                                throw new RuntimeException("Unable to create a MediaPlayer!");
                            }
                            break block22;
                        }
                        if (this.mLogVerbose) {
                            Log.v("MediaSource", "Creating new MediaPlayer.");
                        }
                        this.mMediaPlayer = new MediaPlayer();
                        ** GOTO lbl16
                    }
                    if (!var1_1) ** GOTO lbl-1000
                    try {
                        if (this.mLogVerbose) {
                            Log.v("MediaSource", "Setting MediaPlayer source to URI " + this.mSourceUrl);
                        }
                        if (this.mContext == null) {
                            this.mMediaPlayer.setDataSource(this.mSourceUrl);
                        }
                        ** GOTO lbl-1000
                    }
                    catch (IOException var8_3) {
                        this.mMediaPlayer.release();
                        this.mMediaPlayer = null;
                        if (var1_1) {
                            var9_4 = new Object[]{this.mSourceUrl};
                            throw new RuntimeException(String.format("Unable to set MediaPlayer to URL %s!", var9_4), var8_3);
                        }
                        break block19;
                    }
                    catch (IllegalArgumentException var3_5) {
                        this.mMediaPlayer.release();
                        this.mMediaPlayer = null;
                        if (var1_1) {
                            var4_6 = new Object[]{this.mSourceUrl};
                            throw new RuntimeException(String.format("Unable to set MediaPlayer to URL %s!", var4_6), var3_5);
                        }
                        break block20;
                    }
lbl49:
                    // 3 sources

                    while (true) {
                        this.mMediaPlayer.setLooping(this.mLooping);
                        this.mMediaPlayer.setVolume(this.mVolume, this.mVolume);
                        var6_2 = new Surface(this.mSurfaceTexture);
                        this.mMediaPlayer.setSurface(var6_2);
                        var6_2.release();
                        this.mMediaPlayer.setOnVideoSizeChangedListener(this.onVideoSizeChangedListener);
                        this.mMediaPlayer.setOnPreparedListener(this.onPreparedListener);
                        this.mMediaPlayer.setOnCompletionListener(this.onCompletionListener);
                        this.mSurfaceTexture.setOnFrameAvailableListener(this.onMediaFrameAvailableListener);
                        if (this.mLogVerbose) {
                            Log.v("MediaSource", "Preparing MediaPlayer.");
                        }
                        this.mMediaPlayer.prepareAsync();
                        return true;
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.mMediaPlayer.setDataSource(this.mContext, Uri.parse(this.mSourceUrl.toString()));
                        ** GOTO lbl49
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (this.mLogVerbose) {
                            Log.v("MediaSource", "Setting MediaPlayer source to asset " + this.mSourceAsset);
                        }
                        this.mMediaPlayer.setDataSource(this.mSourceAsset.getFileDescriptor(), this.mSourceAsset.getStartOffset(), this.mSourceAsset.getLength());
                        ** continue;
                    }
                }
                var10_7 = new Object[]{this.mSourceAsset};
                throw new RuntimeException(String.format("Unable to set MediaPlayer to asset %s!", var10_7), var8_3);
            }
            var5_8 = new Object[]{this.mSourceAsset};
            throw new RuntimeException(String.format("Unable to set MediaPlayer to asset %s!", var5_8), var3_5);
        }
    }

    @Override
    public void close(FilterContext filterContext) {
        if (this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.stop();
        }
        this.mPrepared = false;
        this.mGotSize = false;
        this.mPlaying = false;
        this.mPaused = false;
        this.mCompleted = false;
        this.mNewFrameAvailable = false;
        this.mMediaPlayer.release();
        this.mMediaPlayer = null;
        this.mSurfaceTexture.release();
        this.mSurfaceTexture = null;
        if (this.mLogVerbose) {
            Log.v(TAG, "MediaSource closed");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Parameter update");
        }
        if (string2.equals("sourceUrl")) {
            if (!this.isOpen()) return;
            if (this.mLogVerbose) {
                Log.v(TAG, "Opening new source URL");
            }
            if (!this.mSelectedIsUrl) return;
            this.setupMediaPlayer(this.mSelectedIsUrl);
            return;
        }
        if (string2.equals("sourceAsset")) {
            if (!this.isOpen()) return;
            if (this.mLogVerbose) {
                Log.v(TAG, "Opening new source FD");
            }
            if (this.mSelectedIsUrl) return;
            this.setupMediaPlayer(this.mSelectedIsUrl);
            return;
        }
        if (string2.equals("loop")) {
            if (!this.isOpen()) return;
            this.mMediaPlayer.setLooping(this.mLooping);
            return;
        }
        if (string2.equals("sourceIsUrl")) {
            if (!this.isOpen()) return;
            if (this.mSelectedIsUrl) {
                if (this.mLogVerbose) {
                    Log.v(TAG, "Opening new source URL");
                }
            } else if (this.mLogVerbose) {
                Log.v(TAG, "Opening new source Asset");
            }
            this.setupMediaPlayer(this.mSelectedIsUrl);
            return;
        }
        if (string2.equals("volume")) {
            if (!this.isOpen()) return;
            this.mMediaPlayer.setVolume(this.mVolume, this.mVolume);
            return;
        }
        if (!string2.equals("orientation") || !this.mGotSize) return;
        if (this.mOrientation == 0 || this.mOrientation == 180) {
            this.mOutputFormat.setDimensions(this.mWidth, this.mHeight);
        } else {
            this.mOutputFormat.setDimensions(this.mHeight, this.mWidth);
        }
        this.mOrientationUpdated = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void open(FilterContext filterContext) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Opening MediaSource");
            if (this.mSelectedIsUrl) {
                Log.v(TAG, "Current URL is " + this.mSourceUrl);
            } else {
                Log.v(TAG, "Current source is Asset!");
            }
        }
        this.mMediaFrame = (GLFrame)filterContext.getFrameManager().newBoundFrame(this.mOutputFormat, 104, 0L);
        this.mSurfaceTexture = new SurfaceTexture(this.mMediaFrame.getTextureId());
        if (!this.setupMediaPlayer(this.mSelectedIsUrl)) {
            throw new RuntimeException("Error setting up MediaPlayer!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pauseVideo(boolean bl) {
        synchronized (this) {
            if (this.isOpen()) {
                if (bl && !this.mPaused) {
                    this.mMediaPlayer.pause();
                } else if (!bl && this.mPaused) {
                    this.mMediaPlayer.start();
                }
            }
            this.mPaused = bl;
            return;
        }
    }

    @Override
    protected void prepare(FilterContext filterContext) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Preparing MediaSource");
        }
        this.mFrameExtractor = new ShaderProgram(filterContext, "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n");
        this.mFrameExtractor.setSourceRect(0.0f, 1.0f, 1.0f, -1.0f);
        this.createFormats();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(FilterContext var1_1) {
        block27: {
            block28: {
                if (this.mLogVerbose) {
                    Log.v("MediaSource", "Processing new frame");
                }
                if (this.mMediaPlayer == null) {
                    throw new NullPointerException("Unexpected null media player!");
                }
                if (this.mCompleted) {
                    this.closeOutputPort("video");
                    return;
                }
                if (!this.mPlaying) {
                    var18_2 = this.mLogVerbose;
                    var19_3 = 0;
                    if (var18_2) {
                        Log.v("MediaSource", "Waiting for preparation to complete");
                    }
                    block9: while (!this.mGotSize || !this.mPrepared) {
                        try {
                            this.wait(100L);
lbl18:
                            // 2 sources

                            while (true) {
                                if (!this.mCompleted) break block26;
                                break;
                            }
                        }
                        catch (InterruptedException var20_4) {
                            ** continue;
                        }
                        {
                            block26: {
                                this.closeOutputPort("video");
                                return;
                            }
                            if (++var19_3 != 100) continue block9;
                            this.mMediaPlayer.release();
                            throw new RuntimeException("MediaPlayer timed out while preparing!");
                        }
                    }
                    if (this.mLogVerbose) {
                        Log.v("MediaSource", "Starting playback");
                    }
                    this.mMediaPlayer.start();
                }
                if (this.mPaused && this.mPlaying) break block27;
                if (!this.mWaitForNewFrame) break block28;
                if (this.mLogVerbose) {
                    Log.v("MediaSource", "Waiting for new frame");
                }
                var13_5 = 0;
                block11: while (!this.mNewFrameAvailable) {
                    if (var13_5 == 10) {
                        if (this.mCompleted) {
                            this.closeOutputPort("video");
                            return;
                        }
                        throw new RuntimeException("Timeout waiting for new frame!");
                    }
                    try {
                        this.wait(100L);
lbl46:
                        // 3 sources

                        while (true) {
                            ++var13_5;
                            continue block11;
                            break;
                        }
                    }
                    catch (InterruptedException var15_6) {
                        if (!this.mLogVerbose) ** GOTO lbl46
                        Log.v("MediaSource", "interrupted");
                        ** continue;
                    }
                }
                this.mNewFrameAvailable = false;
                if (this.mLogVerbose) {
                    Log.v("MediaSource", "Got new frame");
                }
            }
            this.mSurfaceTexture.updateTexImage();
            this.mOrientationUpdated = true;
        }
        if (!this.mOrientationUpdated) ** GOTO lbl79
        var7_7 = new float[16];
        this.mSurfaceTexture.getTransformMatrix(var7_7);
        var8_8 = new float[16];
        switch (this.mOrientation) {
            default: {
                Matrix.multiplyMM(var8_8, 0, var7_7, 0, MediaSource.mSourceCoords_0, 0);
lbl69:
                // 4 sources

                while (true) {
                    if (this.mLogVerbose) {
                        Log.v("MediaSource", "OrientationHint = " + this.mOrientation);
                        var11_9 = new Object[]{Float.valueOf(var8_8[4]), Float.valueOf(var8_8[5]), Float.valueOf(var8_8[0]), Float.valueOf(var8_8[1]), Float.valueOf(var8_8[12]), Float.valueOf(var8_8[13]), Float.valueOf(var8_8[8]), Float.valueOf(var8_8[9])};
                        Log.v("MediaSource", String.format("SetSourceRegion: %.2f, %.2f, %.2f, %.2f, %.2f, %.2f, %.2f, %.2f", var11_9));
                    }
                    this.mFrameExtractor.setSourceRegion(var8_8[4], var8_8[5], var8_8[0], var8_8[1], var8_8[12], var8_8[13], var8_8[8], var8_8[9]);
                    this.mOrientationUpdated = false;
lbl79:
                    // 2 sources

                    var2_10 = var1_1.getFrameManager().newFrame(this.mOutputFormat);
                    this.mFrameExtractor.process(this.mMediaFrame, var2_10);
                    var3_11 = this.mSurfaceTexture.getTimestamp();
                    if (this.mLogVerbose) {
                        Log.v("MediaSource", "Timestamp: " + (double)var3_11 / 1.0E9 + " s");
                    }
                    var2_10.setTimestamp(var3_11);
                    this.pushOutput("video", var2_10);
                    var2_10.release();
                    this.mPlaying = true;
                    return;
                }
            }
            case 90: {
                Matrix.multiplyMM(var8_8, 0, var7_7, 0, MediaSource.mSourceCoords_90, 0);
                ** GOTO lbl69
            }
            case 180: {
                Matrix.multiplyMM(var8_8, 0, var7_7, 0, MediaSource.mSourceCoords_180, 0);
                ** GOTO lbl69
            }
            case 270: 
        }
        Matrix.multiplyMM(var8_8, 0, var7_7, 0, MediaSource.mSourceCoords_270, 0);
        ** while (true)
    }

    @Override
    public void setupPorts() {
        this.addOutputPort("video", ImageFormat.create(3, 3));
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        if (this.mMediaFrame != null) {
            this.mMediaFrame.release();
        }
    }
}

