/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;

public class ResizeFilter
extends Filter {
    @GenerateFieldPort(hasDefault=true, name="generateMipMap")
    private boolean mGenerateMipMap = false;
    private int mInputChannels;
    @GenerateFieldPort(hasDefault=true, name="keepAspectRatio")
    private boolean mKeepAspectRatio = false;
    private FrameFormat mLastFormat = null;
    @GenerateFieldPort(name="oheight")
    private int mOHeight;
    @GenerateFieldPort(name="owidth")
    private int mOWidth;
    private MutableFrameFormat mOutputFormat;
    private Program mProgram;

    public ResizeFilter(String string2) {
        super(string2);
    }

    protected void createProgram(FilterContext filterContext, FrameFormat frameFormat) {
        if (this.mLastFormat != null && this.mLastFormat.getTarget() == frameFormat.getTarget()) {
            return;
        }
        this.mLastFormat = frameFormat;
        switch (frameFormat.getTarget()) {
            default: {
                throw new RuntimeException("ResizeFilter could not create suitable program!");
            }
            case 2: {
                throw new RuntimeException("Native ResizeFilter not implemented yet!");
            }
            case 3: 
        }
        this.mProgram = ShaderProgram.createIdentity(filterContext);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return frameFormat;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("image");
        this.createProgram(filterContext, frame.getFormat());
        MutableFrameFormat mutableFrameFormat = frame.getFormat().mutableCopy();
        if (this.mKeepAspectRatio) {
            FrameFormat frameFormat = frame.getFormat();
            this.mOHeight = this.mOWidth * frameFormat.getHeight() / frameFormat.getWidth();
        }
        mutableFrameFormat.setDimensions(this.mOWidth, this.mOHeight);
        Frame frame2 = filterContext.getFrameManager().newFrame(mutableFrameFormat);
        if (this.mGenerateMipMap) {
            GLFrame gLFrame = (GLFrame)filterContext.getFrameManager().newFrame(frame.getFormat());
            gLFrame.setTextureParameter(10241, 9985);
            gLFrame.setDataFromFrame(frame);
            gLFrame.generateMipMap();
            this.mProgram.process(gLFrame, frame2);
            gLFrame.release();
        } else {
            this.mProgram.process(frame, frame2);
        }
        this.pushOutput("image", frame2);
        frame2.release();
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }
}

