/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;

public class FlipFilter
extends Filter {
    @GenerateFieldPort(hasDefault=true, name="horizontal")
    private boolean mHorizontal = false;
    private Program mProgram;
    private int mTarget = 0;
    @GenerateFieldPort(hasDefault=true, name="tile_size")
    private int mTileSize = 640;
    @GenerateFieldPort(hasDefault=true, name="vertical")
    private boolean mVertical = false;

    public FlipFilter(String string2) {
        super(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateParameters() {
        float f = this.mHorizontal ? 1.0f : 0.0f;
        float f2 = this.mVertical ? 1.0f : 0.0f;
        float f3 = this.mHorizontal ? -1.0f : 1.0f;
        float f4 = this.mVertical ? -1.0f : 1.0f;
        ((ShaderProgram)this.mProgram).setSourceRect(f, f2, f3, f4);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        if (this.mProgram != null) {
            this.updateParameters();
        }
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return frameFormat;
    }

    public void initProgram(FilterContext filterContext, int n) {
        switch (n) {
            default: {
                throw new RuntimeException("Filter Sharpen does not support frames of target " + n + "!");
            }
            case 3: 
        }
        ShaderProgram shaderProgram = ShaderProgram.createIdentity(filterContext);
        shaderProgram.setMaximumTileSize(this.mTileSize);
        this.mProgram = shaderProgram;
        this.mTarget = n;
        this.updateParameters();
    }

    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("image");
        FrameFormat frameFormat = frame.getFormat();
        if (this.mProgram == null || frameFormat.getTarget() != this.mTarget) {
            this.initProgram(filterContext, frameFormat.getTarget());
        }
        Frame frame2 = filterContext.getFrameManager().newFrame(frameFormat);
        this.mProgram.process(frame, frame2);
        this.pushOutput("image", frame2);
        frame2.release();
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }
}

