/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;

public class CropRectFilter
extends Filter {
    private int mHeight = 0;
    @GenerateFieldPort(name="height")
    private int mOutputHeight;
    @GenerateFieldPort(name="width")
    private int mOutputWidth;
    private Program mProgram;
    private int mTarget = 0;
    @GenerateFieldPort(hasDefault=true, name="tile_size")
    private int mTileSize = 640;
    private int mWidth = 0;
    @GenerateFieldPort(name="xorigin")
    private int mXorigin;
    @GenerateFieldPort(name="yorigin")
    private int mYorigin;

    public CropRectFilter(String string2) {
        super(string2);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        if (this.mProgram != null) {
            this.updateSourceRect(this.mWidth, this.mHeight);
        }
    }

    public void initProgram(FilterContext filterContext, int n) {
        switch (n) {
            default: {
                throw new RuntimeException("Filter Sharpen does not support frames of target " + n + "!");
            }
            case 3: 
        }
        ShaderProgram shaderProgram = ShaderProgram.createIdentity(filterContext);
        shaderProgram.setMaximumTileSize(this.mTileSize);
        this.mProgram = shaderProgram;
        this.mTarget = n;
    }

    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("image");
        FrameFormat frameFormat = frame.getFormat();
        MutableFrameFormat mutableFrameFormat = ImageFormat.create(this.mOutputWidth, this.mOutputHeight, 3, 3);
        Frame frame2 = filterContext.getFrameManager().newFrame(mutableFrameFormat);
        if (this.mProgram == null || frameFormat.getTarget() != this.mTarget) {
            this.initProgram(filterContext, frameFormat.getTarget());
        }
        if (frameFormat.getWidth() != this.mWidth || frameFormat.getHeight() != this.mHeight) {
            this.updateSourceRect(frameFormat.getWidth(), frameFormat.getHeight());
        }
        this.mProgram.process(frame, frame2);
        this.pushOutput("image", frame2);
        frame2.release();
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    void updateSourceRect(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
        ((ShaderProgram)this.mProgram).setSourceRect((float)this.mXorigin / (float)this.mWidth, (float)this.mYorigin / (float)this.mHeight, (float)this.mOutputWidth / (float)this.mWidth, (float)this.mOutputHeight / (float)this.mHeight);
    }
}

