/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.NativeFrame;
import android.filterfw.core.Program;

public class NativeProgram
extends Program {
    private boolean mHasGetValueFunction = false;
    private boolean mHasInitFunction = false;
    private boolean mHasResetFunction = false;
    private boolean mHasSetValueFunction = false;
    private boolean mHasTeardownFunction = false;
    private boolean mTornDown = false;
    private int nativeProgramId;

    static {
        System.loadLibrary("filterfw");
    }

    public NativeProgram(String string2, String string3) {
        this.allocate();
        String string4 = "lib" + string2 + ".so";
        if (!this.openNativeLibrary(string4)) {
            throw new RuntimeException("Could not find native library named '" + string4 + "' " + "required for native program!");
        }
        String string5 = string3 + "_process";
        if (!this.bindProcessFunction(string5)) {
            throw new RuntimeException("Could not find native program function name " + string5 + " in library " + string4 + "! " + "This function is required!");
        }
        this.mHasInitFunction = this.bindInitFunction(string3 + "_init");
        this.mHasTeardownFunction = this.bindTeardownFunction(string3 + "_teardown");
        this.mHasSetValueFunction = this.bindSetValueFunction(string3 + "_setvalue");
        this.mHasGetValueFunction = this.bindGetValueFunction(string3 + "_getvalue");
        this.mHasResetFunction = this.bindResetFunction(string3 + "_reset");
        if (this.mHasInitFunction && !this.callNativeInit()) {
            throw new RuntimeException("Could not initialize NativeProgram!");
        }
    }

    private native boolean allocate();

    private native boolean bindGetValueFunction(String var1);

    private native boolean bindInitFunction(String var1);

    private native boolean bindProcessFunction(String var1);

    private native boolean bindResetFunction(String var1);

    private native boolean bindSetValueFunction(String var1);

    private native boolean bindTeardownFunction(String var1);

    private native String callNativeGetValue(String var1);

    private native boolean callNativeInit();

    private native boolean callNativeProcess(NativeFrame[] var1, NativeFrame var2);

    private native boolean callNativeReset();

    private native boolean callNativeSetValue(String var1, String var2);

    private native boolean callNativeTeardown();

    private native boolean deallocate();

    private native boolean nativeInit();

    private native boolean openNativeLibrary(String var1);

    protected void finalize() throws Throwable {
        this.tearDown();
    }

    @Override
    public Object getHostValue(String string2) {
        if (this.mTornDown) {
            throw new RuntimeException("NativeProgram already torn down!");
        }
        if (!this.mHasGetValueFunction) {
            throw new RuntimeException("Attempting to get native variable, but native code does not define native getvalue function!");
        }
        return this.callNativeGetValue(string2);
    }

    @Override
    public void process(Frame[] frameArray, Frame frame) {
        if (this.mTornDown) {
            throw new RuntimeException("NativeProgram already torn down!");
        }
        NativeFrame[] nativeFrameArray = new NativeFrame[frameArray.length];
        for (int i = 0; i < frameArray.length; ++i) {
            if (frameArray[i] == null || frameArray[i] instanceof NativeFrame) {
                nativeFrameArray[i] = (NativeFrame)frameArray[i];
                continue;
            }
            throw new RuntimeException("NativeProgram got non-native frame as input " + i + "!");
        }
        if (frame == null || frame instanceof NativeFrame) {
            if (!this.callNativeProcess(nativeFrameArray, (NativeFrame)frame)) {
                throw new RuntimeException("Calling native process() caused error!");
            }
        } else {
            throw new RuntimeException("NativeProgram got non-native output frame!");
        }
    }

    @Override
    public void reset() {
        if (this.mHasResetFunction && !this.callNativeReset()) {
            throw new RuntimeException("Could not reset NativeProgram!");
        }
    }

    @Override
    public void setHostValue(String string2, Object object) {
        if (this.mTornDown) {
            throw new RuntimeException("NativeProgram already torn down!");
        }
        if (!this.mHasSetValueFunction) {
            throw new RuntimeException("Attempting to set native variable, but native code does not define native setvalue function!");
        }
        if (!this.callNativeSetValue(string2, object.toString())) {
            throw new RuntimeException("Error setting native value for variable '" + string2 + "'!");
        }
    }

    public void tearDown() {
        if (this.mTornDown) {
            return;
        }
        if (this.mHasTeardownFunction && !this.callNativeTeardown()) {
            throw new RuntimeException("Could not tear down NativeProgram!");
        }
        this.deallocate();
        this.mTornDown = true;
    }
}

