/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.InputPort;
import android.filterfw.core.KeyValueMap;
import android.filterfw.core.OutputPort;
import android.filterpacks.base.FrameBranch;
import android.filterpacks.base.NullFilter;
import android.util.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class FilterGraph {
    public static final int AUTOBRANCH_OFF = 0;
    public static final int AUTOBRANCH_SYNCED = 1;
    public static final int AUTOBRANCH_UNSYNCED = 2;
    public static final int TYPECHECK_DYNAMIC = 1;
    public static final int TYPECHECK_OFF = 0;
    public static final int TYPECHECK_STRICT = 2;
    private String TAG = "FilterGraph";
    private int mAutoBranchMode = 0;
    private boolean mDiscardUnconnectedOutputs = false;
    private HashSet<Filter> mFilters = new HashSet();
    private boolean mIsReady = false;
    private boolean mLogVerbose;
    private HashMap<String, Filter> mNameMap = new HashMap();
    private HashMap<OutputPort, LinkedList<InputPort>> mPreconnections = new HashMap();
    private int mTypeCheckMode = 2;

    public FilterGraph() {
        this.mLogVerbose = Log.isLoggable(this.TAG, 2);
    }

    private void checkConnections() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectPorts() {
        int n = 1;
        Iterator<Map.Entry<OutputPort, LinkedList<InputPort>>> iterator = this.mPreconnections.entrySet().iterator();
        while (true) {
            int n2;
            if (iterator.hasNext()) {
                Map.Entry<OutputPort, LinkedList<InputPort>> entry = iterator.next();
                OutputPort outputPort = entry.getKey();
                LinkedList<InputPort> linkedList = entry.getValue();
                if (linkedList.size() == 1) {
                    outputPort.connectTo(linkedList.get(0));
                    continue;
                }
                if (this.mAutoBranchMode == 0) {
                    throw new RuntimeException("Attempting to connect " + outputPort + " to multiple " + "filter ports! Enable auto-branching to allow this.");
                }
                if (this.mLogVerbose) {
                    Log.v(this.TAG, "Creating branch for " + outputPort + "!");
                }
                if (this.mAutoBranchMode != 1) throw new RuntimeException("TODO: Unsynced branches not implemented yet!");
                StringBuilder stringBuilder = new StringBuilder().append("branch");
                n2 = n + 1;
                FrameBranch frameBranch = new FrameBranch(stringBuilder.append(n).toString());
                new KeyValueMap();
                Object[] objectArray = new Object[]{"outputs", linkedList.size()};
                frameBranch.initWithAssignmentList(objectArray);
                this.addFilter(frameBranch);
                outputPort.connectTo(frameBranch.getInputPort("in"));
                Iterator iterator2 = linkedList.iterator();
                Iterator<OutputPort> iterator3 = frameBranch.getOutputPorts().iterator();
                while (iterator3.hasNext()) {
                    iterator3.next().connectTo((InputPort)iterator2.next());
                }
            } else {
                this.mPreconnections.clear();
                return;
            }
            n = n2;
        }
    }

    private void discardUnconnectedOutputs() {
        LinkedList<NullFilter> linkedList = new LinkedList<NullFilter>();
        for (Filter filter : this.mFilters) {
            int n = 0;
            for (OutputPort outputPort : filter.getOutputPorts()) {
                if (outputPort.isConnected()) continue;
                if (this.mLogVerbose) {
                    Log.v(this.TAG, "Autoconnecting unconnected " + outputPort + " to Null filter.");
                }
                NullFilter nullFilter = new NullFilter(filter.getName() + "ToNull" + n);
                nullFilter.init();
                linkedList.add(nullFilter);
                outputPort.connectTo(nullFilter.getInputPort("frame"));
                ++n;
            }
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            this.addFilter((Filter)iterator.next());
        }
    }

    private HashSet<Filter> getSourceFilters() {
        HashSet<Filter> hashSet = new HashSet<Filter>();
        for (Filter filter : this.getFilters()) {
            if (filter.getNumberOfConnectedInputs() != 0) continue;
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Found source filter: " + filter);
            }
            hashSet.add(filter);
        }
        return hashSet;
    }

    private void preconnect(OutputPort outputPort, InputPort inputPort) {
        LinkedList<InputPort> linkedList = this.mPreconnections.get(outputPort);
        if (linkedList == null) {
            linkedList = new LinkedList();
            this.mPreconnections.put(outputPort, linkedList);
        }
        linkedList.add(inputPort);
    }

    private boolean readyForProcessing(Filter filter, Set<Filter> set) {
        if (set.contains(filter)) {
            return false;
        }
        Iterator<InputPort> iterator = filter.getInputPorts().iterator();
        while (iterator.hasNext()) {
            Filter filter2 = iterator.next().getSourceFilter();
            if (filter2 == null || set.contains(filter2)) continue;
            return false;
        }
        return true;
    }

    private void removeFilter(Filter filter) {
        this.mFilters.remove(filter);
        this.mNameMap.remove(filter.getName());
    }

    private void runTypeCheck() {
        Stack<Filter> stack = new Stack<Filter>();
        HashSet<Filter> hashSet = new HashSet<Filter>();
        stack.addAll(this.getSourceFilters());
        while (!stack.empty()) {
            Filter filter = (Filter)stack.pop();
            hashSet.add(filter);
            this.updateOutputs(filter);
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Running type check on " + filter + "...");
            }
            this.runTypeCheckOn(filter);
            Iterator<OutputPort> iterator = filter.getOutputPorts().iterator();
            while (iterator.hasNext()) {
                Filter filter2 = iterator.next().getTargetFilter();
                if (filter2 == null || !this.readyForProcessing(filter2, hashSet)) continue;
                stack.push(filter2);
            }
        }
        if (hashSet.size() != this.getFilters().size()) {
            throw new RuntimeException("Could not schedule all filters! Is your graph malformed?");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void runTypeCheckOn(Filter filter) {
        FrameFormat frameFormat;
        FrameFormat frameFormat2;
        Iterator<InputPort> iterator = filter.getInputPorts().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return;
            }
            InputPort inputPort = iterator.next();
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Type checking port " + inputPort);
            }
            frameFormat2 = inputPort.getSourceFormat();
            frameFormat = inputPort.getPortFormat();
            if (frameFormat2 == null || frameFormat == null) continue;
            if (this.mLogVerbose) {
                Log.v(this.TAG, "Checking " + frameFormat2 + " against " + frameFormat + ".");
            }
            boolean bl = true;
            switch (this.mTypeCheckMode) {
                case 0: {
                    inputPort.setChecksType(false);
                    break;
                }
                case 1: {
                    bl = frameFormat2.mayBeCompatibleWith(frameFormat);
                    inputPort.setChecksType(true);
                    break;
                }
                case 2: {
                    bl = frameFormat2.isCompatibleWith(frameFormat);
                    inputPort.setChecksType(false);
                    break;
                }
            }
            if (!bl) break;
        }
        throw new RuntimeException("Type mismatch: Filter " + filter + " expects a " + "format of type " + frameFormat + " but got a format of type " + frameFormat2 + "!");
    }

    private void updateOutputs(Filter filter) {
        for (OutputPort outputPort : filter.getOutputPorts()) {
            InputPort inputPort = outputPort.getBasePort();
            if (inputPort == null) continue;
            FrameFormat frameFormat = inputPort.getSourceFormat();
            FrameFormat frameFormat2 = filter.getOutputFormat(outputPort.getName(), frameFormat);
            if (frameFormat2 == null) {
                throw new RuntimeException("Filter did not return an output format for " + outputPort + "!");
            }
            outputPort.setPortFormat(frameFormat2);
        }
    }

    public boolean addFilter(Filter filter) {
        if (!this.containsFilter(filter)) {
            this.mFilters.add(filter);
            this.mNameMap.put(filter.getName(), filter);
            return true;
        }
        return false;
    }

    public void beginProcessing() {
        if (this.mLogVerbose) {
            Log.v(this.TAG, "Opening all filter connections...");
        }
        Iterator<Filter> iterator = this.mFilters.iterator();
        while (iterator.hasNext()) {
            iterator.next().openOutputs();
        }
        this.mIsReady = true;
    }

    public void closeFilters(FilterContext filterContext) {
        if (this.mLogVerbose) {
            Log.v(this.TAG, "Closing all filters...");
        }
        Iterator<Filter> iterator = this.mFilters.iterator();
        while (iterator.hasNext()) {
            iterator.next().performClose(filterContext);
        }
        this.mIsReady = false;
    }

    public void connect(Filter filter, String string2, Filter filter2, String string3) {
        if (filter == null || filter2 == null) {
            throw new IllegalArgumentException("Passing null Filter in connect()!");
        }
        if (!this.containsFilter(filter) || !this.containsFilter(filter2)) {
            throw new RuntimeException("Attempting to connect filter not in graph!");
        }
        OutputPort outputPort = filter.getOutputPort(string2);
        InputPort inputPort = filter2.getInputPort(string3);
        if (outputPort == null) {
            throw new RuntimeException("Unknown output port '" + string2 + "' on Filter " + filter + "!");
        }
        if (inputPort == null) {
            throw new RuntimeException("Unknown input port '" + string3 + "' on Filter " + filter2 + "!");
        }
        this.preconnect(outputPort, inputPort);
    }

    public void connect(String string2, String string3, String string4, String string5) {
        Filter filter = this.getFilter(string2);
        Filter filter2 = this.getFilter(string4);
        if (filter == null) {
            throw new RuntimeException("Attempting to connect unknown source filter '" + string2 + "'!");
        }
        if (filter2 == null) {
            throw new RuntimeException("Attempting to connect unknown target filter '" + string4 + "'!");
        }
        this.connect(filter, string3, filter2, string5);
    }

    public boolean containsFilter(Filter filter) {
        return this.mFilters.contains(filter);
    }

    public void flushFrames() {
        Iterator<Filter> iterator = this.mFilters.iterator();
        while (iterator.hasNext()) {
            iterator.next().clearOutputs();
        }
    }

    public Filter getFilter(String string2) {
        return this.mNameMap.get(string2);
    }

    public Set<Filter> getFilters() {
        return this.mFilters;
    }

    public boolean isReady() {
        return this.mIsReady;
    }

    public void setAutoBranchMode(int n) {
        this.mAutoBranchMode = n;
    }

    public void setDiscardUnconnectedOutputs(boolean bl) {
        this.mDiscardUnconnectedOutputs = bl;
    }

    public void setTypeCheckMode(int n) {
        this.mTypeCheckMode = n;
    }

    void setupFilters() {
        if (this.mDiscardUnconnectedOutputs) {
            this.discardUnconnectedOutputs();
        }
        this.connectPorts();
        this.checkConnections();
        this.runTypeCheck();
    }

    public void tearDown(FilterContext filterContext) {
        if (!this.mFilters.isEmpty()) {
            this.flushFrames();
            Iterator<Filter> iterator = this.mFilters.iterator();
            while (iterator.hasNext()) {
                iterator.next().performTearDown(filterContext);
            }
            this.mFilters.clear();
            this.mNameMap.clear();
            this.mIsReady = false;
        }
    }
}

