/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.util.Log;
import dalvik.system.PathClassLoader;
import java.lang.reflect.Constructor;
import java.util.HashSet;

public class FilterFactory {
    private static final String TAG = "FilterFactory";
    private static Object mClassLoaderGuard;
    private static ClassLoader mCurrentClassLoader;
    private static HashSet<String> mLibraries;
    private static boolean mLogVerbose;
    private static FilterFactory mSharedFactory;
    private HashSet<String> mPackages = new HashSet();

    static {
        mCurrentClassLoader = Thread.currentThread().getContextClassLoader();
        mLibraries = new HashSet();
        mClassLoaderGuard = new Object();
        mLogVerbose = Log.isLoggable(TAG, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addFilterLibrary(String string2) {
        if (mLogVerbose) {
            Log.v(TAG, "Adding filter library " + string2);
        }
        Object object = mClassLoaderGuard;
        synchronized (object) {
            if (!mLibraries.contains(string2)) {
                mLibraries.add(string2);
                mCurrentClassLoader = new PathClassLoader(string2, mCurrentClassLoader);
                return;
            }
            if (mLogVerbose) {
                Log.v(TAG, "Library already added");
            }
            return;
        }
    }

    public static FilterFactory sharedFactory() {
        if (mSharedFactory == null) {
            mSharedFactory = new FilterFactory();
        }
        return mSharedFactory;
    }

    public void addPackage(String string2) {
        if (mLogVerbose) {
            Log.v(TAG, "Adding package " + string2);
        }
        this.mPackages.add(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Filter createFilterByClass(Class clazz, String string2) {
        Filter filter;
        Constructor constructor;
        try {
            clazz.asSubclass(Filter.class);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Attempting to allocate class '" + clazz + "' which is not a subclass of Filter!");
        }
        try {
            constructor = clazz.getConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("The filter class '" + clazz + "' does not have a constructor of the form <init>(String name)!");
        }
        try {
            filter = (Filter)constructor.newInstance(string2);
        }
        catch (Throwable throwable) {
            filter = null;
        }
        if (filter == null) {
            throw new IllegalArgumentException("Could not construct the filter '" + string2 + "'!");
        }
        return filter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Filter createFilterByClassName(String string2, String string3) {
        if (mLogVerbose) {
            Log.v(TAG, "Looking up class " + string2);
        }
        Class<?> clazz = null;
        for (String string4 : this.mPackages) {
            try {
                if (mLogVerbose) {
                    Log.v(TAG, "Trying " + string4 + "." + string2);
                }
                Object object = mClassLoaderGuard;
                synchronized (object) {
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            {
                clazz = mCurrentClassLoader.loadClass(string4 + "." + string2);
                if (clazz == null) continue;
            }
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown filter class '" + string2 + "'!");
        }
        return this.createFilterByClass(clazz, string3);
    }
}

