/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GLEnvironment;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FilterContext {
    private FrameManager mFrameManager;
    private GLEnvironment mGLEnvironment;
    private Set<FilterGraph> mGraphs;
    private HashMap<String, Frame> mStoredFrames = new HashMap();

    public FilterContext() {
        this.mGraphs = new HashSet<FilterGraph>();
    }

    final void addGraph(FilterGraph filterGraph) {
        this.mGraphs.add(filterGraph);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Frame fetchFrame(String string2) {
        synchronized (this) {
            Frame frame = this.mStoredFrames.get(string2);
            if (frame != null) {
                frame.onFrameFetch();
            }
            return frame;
        }
    }

    public FrameManager getFrameManager() {
        return this.mFrameManager;
    }

    public GLEnvironment getGLEnvironment() {
        return this.mGLEnvironment;
    }

    public void initGLEnvironment(GLEnvironment gLEnvironment) {
        if (this.mGLEnvironment == null) {
            this.mGLEnvironment = gLEnvironment;
            return;
        }
        throw new RuntimeException("Attempting to re-initialize GL Environment for FilterContext!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFrame(String string2) {
        synchronized (this) {
            Frame frame = this.mStoredFrames.get(string2);
            if (frame != null) {
                this.mStoredFrames.remove(string2);
                frame.release();
            }
            return;
        }
    }

    public void setFrameManager(FrameManager frameManager) {
        if (frameManager == null) {
            throw new NullPointerException("Attempting to set null FrameManager!");
        }
        if (frameManager.getContext() != null) {
            throw new IllegalArgumentException("Attempting to set FrameManager which is already bound to another FilterContext!");
        }
        this.mFrameManager = frameManager;
        this.mFrameManager.setContext(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeFrame(String string2, Frame frame) {
        synchronized (this) {
            Frame frame2 = this.fetchFrame(string2);
            if (frame2 != null) {
                frame2.release();
            }
            frame.onFrameStore();
            this.mStoredFrames.put(string2, frame.retain());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void tearDown() {
        synchronized (this) {
            Iterator<Frame> iterator = this.mStoredFrames.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
            this.mStoredFrames.clear();
            Iterator<FilterGraph> iterator2 = this.mGraphs.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().tearDown(this);
            }
            this.mGraphs.clear();
            if (this.mFrameManager != null) {
                this.mFrameManager.tearDown();
                this.mFrameManager = null;
            }
            if (this.mGLEnvironment != null) {
                this.mGLEnvironment.tearDown();
                this.mGLEnvironment = null;
            }
            return;
        }
    }

    public static interface OnFrameReceivedListener {
        public void onFrameReceived(Filter var1, Frame var2, Object var3);
    }
}

