/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw;

import android.content.Context;
import android.filterfw.MffEnvironment;
import android.filterfw.core.AsyncRunner;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GraphRunner;
import android.filterfw.core.RoundRobinScheduler;
import android.filterfw.core.SyncRunner;
import android.filterfw.io.GraphIOException;
import android.filterfw.io.GraphReader;
import android.filterfw.io.TextGraphReader;
import java.util.ArrayList;

public class GraphEnvironment
extends MffEnvironment {
    public static final int MODE_ASYNCHRONOUS = 1;
    public static final int MODE_SYNCHRONOUS = 2;
    private GraphReader mGraphReader;
    private ArrayList<GraphHandle> mGraphs = new ArrayList();

    public GraphEnvironment() {
        super(null);
    }

    public GraphEnvironment(FrameManager frameManager, GraphReader graphReader) {
        super(frameManager);
        this.mGraphReader = graphReader;
    }

    public int addGraph(FilterGraph filterGraph) {
        GraphHandle graphHandle = new GraphHandle(filterGraph);
        this.mGraphs.add(graphHandle);
        return -1 + this.mGraphs.size();
    }

    public void addReferences(Object ... objectArray) {
        this.getGraphReader().addReferencesByKeysAndValues(objectArray);
    }

    public FilterGraph getGraph(int n) {
        if (n < 0 || n >= this.mGraphs.size()) {
            throw new IllegalArgumentException("Invalid graph ID " + n + " specified in runGraph()!");
        }
        return this.mGraphs.get(n).getGraph();
    }

    public GraphReader getGraphReader() {
        if (this.mGraphReader == null) {
            this.mGraphReader = new TextGraphReader();
        }
        return this.mGraphReader;
    }

    public GraphRunner getRunner(int n, int n2) {
        switch (n2) {
            default: {
                throw new RuntimeException("Invalid execution mode " + n2 + " specified in getRunner()!");
            }
            case 1: {
                return this.mGraphs.get(n).getAsyncRunner(this.getContext());
            }
            case 2: 
        }
        return this.mGraphs.get(n).getSyncRunner(this.getContext());
    }

    public int loadGraph(Context context, int n) {
        try {
            FilterGraph filterGraph = this.getGraphReader().readGraphResource(context, n);
            return this.addGraph(filterGraph);
        }
        catch (GraphIOException graphIOException) {
            throw new RuntimeException("Could not read graph: " + graphIOException.getMessage());
        }
    }

    private class GraphHandle {
        private AsyncRunner mAsyncRunner;
        private FilterGraph mGraph;
        private SyncRunner mSyncRunner;

        public GraphHandle(FilterGraph filterGraph) {
            this.mGraph = filterGraph;
        }

        public AsyncRunner getAsyncRunner(FilterContext filterContext) {
            if (this.mAsyncRunner == null) {
                this.mAsyncRunner = new AsyncRunner(filterContext, RoundRobinScheduler.class);
                this.mAsyncRunner.setGraph(this.mGraph);
            }
            return this.mAsyncRunner;
        }

        public FilterGraph getGraph() {
            return this.mGraph;
        }

        public GraphRunner getSyncRunner(FilterContext filterContext) {
            if (this.mSyncRunner == null) {
                this.mSyncRunner = new SyncRunner(filterContext, this.mGraph, RoundRobinScheduler.class);
            }
            return this.mSyncRunner;
        }
    }
}

