/*
 * Decompiled with CFR 0.152.
 */
package android.emoji;

import android.graphics.Bitmap;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;

public final class EmojiFactory {
    private Map<Integer, WeakReference<Bitmap>> mCache;
    private String mName;
    private long mNativeEmojiFactory;
    private int sCacheSize = 100;

    private EmojiFactory(long l, String string2) {
        this.mNativeEmojiFactory = l;
        this.mName = string2;
        this.mCache = new CustomLinkedHashMap<Integer, WeakReference<Bitmap>>();
    }

    private native void nativeDestructor(long var1);

    private native int nativeGetAndroidPuaFromVendorSpecificPua(long var1, int var3);

    private native int nativeGetAndroidPuaFromVendorSpecificSjis(long var1, char var3);

    private native Bitmap nativeGetBitmapFromAndroidPua(long var1, int var3);

    private native int nativeGetMaximumAndroidPua(long var1);

    private native int nativeGetMaximumVendorSpecificPua(long var1);

    private native int nativeGetMinimumAndroidPua(long var1);

    private native int nativeGetMinimumVendorSpecificPua(long var1);

    private native int nativeGetVendorSpecificPuaFromAndroidPua(long var1, int var3);

    private native int nativeGetVendorSpecificSjisFromAndroidPua(long var1, int var3);

    public static native EmojiFactory newAvailableInstance();

    public static native EmojiFactory newInstance(String var0);

    protected void finalize() throws Throwable {
        try {
            this.nativeDestructor(this.mNativeEmojiFactory);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getAndroidPuaFromVendorSpecificPua(int n) {
        return this.nativeGetAndroidPuaFromVendorSpecificPua(this.mNativeEmojiFactory, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getAndroidPuaFromVendorSpecificPua(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = this.nativeGetMinimumVendorSpecificPua(this.mNativeEmojiFactory);
        int n2 = this.nativeGetMaximumVendorSpecificPua(this.mNativeEmojiFactory);
        int n3 = string2.length();
        int[] nArray = new int[string2.codePointCount(0, n3)];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6;
            int n7 = string2.codePointAt(n5);
            nArray[n4] = n <= n7 && n7 <= n2 && (n6 = this.getAndroidPuaFromVendorSpecificPua(n7)) > 0 ? n6 : n7;
            n5 = string2.offsetByCodePoints(n5, 1);
            ++n4;
        }
        return new String(nArray, 0, n4);
    }

    public int getAndroidPuaFromVendorSpecificSjis(char c) {
        return this.nativeGetAndroidPuaFromVendorSpecificSjis(this.mNativeEmojiFactory, c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap getBitmapFromAndroidPua(int n) {
        synchronized (this) {
            Bitmap bitmap;
            WeakReference<Bitmap> weakReference = this.mCache.get(n);
            if (weakReference == null) {
                bitmap = this.nativeGetBitmapFromAndroidPua(this.mNativeEmojiFactory, n);
                if (bitmap == null) return bitmap;
                this.mCache.put(n, new WeakReference<Bitmap>(bitmap));
            } else {
                Bitmap bitmap2 = (Bitmap)weakReference.get();
                if (bitmap2 != null) return bitmap2;
                bitmap = this.nativeGetBitmapFromAndroidPua(this.mNativeEmojiFactory, n);
                this.mCache.put(n, new WeakReference<Bitmap>(bitmap));
            }
            return bitmap;
        }
    }

    public Bitmap getBitmapFromVendorSpecificPua(int n) {
        synchronized (this) {
            Bitmap bitmap = this.getBitmapFromAndroidPua(this.getAndroidPuaFromVendorSpecificPua(n));
            return bitmap;
        }
    }

    public Bitmap getBitmapFromVendorSpecificSjis(char c) {
        synchronized (this) {
            Bitmap bitmap = this.getBitmapFromAndroidPua(this.getAndroidPuaFromVendorSpecificSjis(c));
            return bitmap;
        }
    }

    public int getMaximumAndroidPua() {
        return this.nativeGetMaximumAndroidPua(this.mNativeEmojiFactory);
    }

    public int getMinimumAndroidPua() {
        return this.nativeGetMinimumAndroidPua(this.mNativeEmojiFactory);
    }

    public int getVendorSpecificPuaFromAndroidPua(int n) {
        return this.nativeGetVendorSpecificPuaFromAndroidPua(this.mNativeEmojiFactory, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getVendorSpecificPuaFromAndroidPua(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = this.nativeGetMinimumAndroidPua(this.mNativeEmojiFactory);
        int n2 = this.nativeGetMaximumAndroidPua(this.mNativeEmojiFactory);
        int n3 = string2.length();
        int[] nArray = new int[string2.codePointCount(0, n3)];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6;
            int n7 = string2.codePointAt(n5);
            nArray[n4] = n <= n7 && n7 <= n2 && (n6 = this.getVendorSpecificPuaFromAndroidPua(n7)) > 0 ? n6 : n7;
            n5 = string2.offsetByCodePoints(n5, 1);
            ++n4;
        }
        return new String(nArray, 0, n4);
    }

    public int getVendorSpecificSjisFromAndroidPua(int n) {
        return this.nativeGetVendorSpecificSjisFromAndroidPua(this.mNativeEmojiFactory, n);
    }

    public String name() {
        return this.mName;
    }

    private class CustomLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        public CustomLinkedHashMap() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > EmojiFactory.this.sCacheSize;
        }
    }
}

