/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteProgram;
import android.os.ParcelFileDescriptor;

public final class SQLiteStatement
extends SQLiteProgram {
    SQLiteStatement(SQLiteDatabase sQLiteDatabase, String string2, Object[] objectArray) {
        super(sQLiteDatabase, string2, objectArray, null);
    }

    public void execute() {
        this.acquireReference();
        try {
            this.getSession().execute(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
            return;
        }
        catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {
            this.onCorruption();
            throw sQLiteDatabaseCorruptException;
        }
        finally {
            this.releaseReference();
        }
    }

    public long executeInsert() {
        this.acquireReference();
        try {
            long l = this.getSession().executeForLastInsertedRowId(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
            return l;
        }
        catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {
            this.onCorruption();
            throw sQLiteDatabaseCorruptException;
        }
        finally {
            this.releaseReference();
        }
    }

    public int executeUpdateDelete() {
        this.acquireReference();
        try {
            int n = this.getSession().executeForChangedRowCount(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
            return n;
        }
        catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {
            this.onCorruption();
            throw sQLiteDatabaseCorruptException;
        }
        finally {
            this.releaseReference();
        }
    }

    public ParcelFileDescriptor simpleQueryForBlobFileDescriptor() {
        this.acquireReference();
        try {
            ParcelFileDescriptor parcelFileDescriptor = this.getSession().executeForBlobFileDescriptor(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
            return parcelFileDescriptor;
        }
        catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {
            this.onCorruption();
            throw sQLiteDatabaseCorruptException;
        }
        finally {
            this.releaseReference();
        }
    }

    public long simpleQueryForLong() {
        this.acquireReference();
        try {
            long l = this.getSession().executeForLong(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
            return l;
        }
        catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {
            this.onCorruption();
            throw sQLiteDatabaseCorruptException;
        }
        finally {
            this.releaseReference();
        }
    }

    public String simpleQueryForString() {
        this.acquireReference();
        try {
            String string2 = this.getSession().executeForString(this.getSql(), this.getBindArgs(), this.getConnectionFlags(), null);
            return string2;
        }
        catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {
            this.onCorruption();
            throw sQLiteDatabaseCorruptException;
        }
        finally {
            this.releaseReference();
        }
    }

    public String toString() {
        return "SQLiteProgram: " + this.getSql();
    }
}

