/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;
import android.util.Pair;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public final class DefaultDatabaseErrorHandler
implements DatabaseErrorHandler {
    private static final String TAG = "DefaultDatabaseErrorHandler";

    private void deleteDatabaseFile(String string2) {
        if (string2.equalsIgnoreCase(":memory:") || string2.trim().length() == 0) {
            return;
        }
        Log.e(TAG, "deleting the database file: " + string2);
        try {
            SQLiteDatabase.deleteDatabase(new File(string2));
            return;
        }
        catch (Exception exception) {
            Log.w(TAG, "delete failed: " + exception.getMessage());
            return;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onCorruption(SQLiteDatabase sQLiteDatabase) {
        block13: {
            List<Pair<String, String>> list;
            block12: {
                Log.e(TAG, "Corruption reported by sqlite on database: " + sQLiteDatabase.getPath());
                if (!sQLiteDatabase.isOpen()) {
                    this.deleteDatabaseFile(sQLiteDatabase.getPath());
                    return;
                }
                list = null;
                try {
                    List<Pair<String, String>> list2;
                    list = list2 = sQLiteDatabase.getAttachedDbs();
                    break block12;
                }
                catch (Throwable throwable) {
                    if (list != null) {
                        Iterator<Pair<String, String>> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            this.deleteDatabaseFile((String)iterator.next().second);
                        }
                        throw throwable;
                    } else {
                        this.deleteDatabaseFile(sQLiteDatabase.getPath());
                    }
                    throw throwable;
                }
                catch (SQLiteException sQLiteException) {
                    list = null;
                }
            }
            try {
                sQLiteDatabase.close();
            }
            catch (SQLiteException sQLiteException) {}
            if (list != null) {
                Iterator<Pair<String, String>> iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.deleteDatabaseFile((String)iterator.next().second);
                }
            }
            break block13;
            return;
        }
        this.deleteDatabaseFile(sQLiteDatabase.getPath());
    }
}

