/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.BulkCursorDescriptor;
import android.database.BulkCursorNative;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.CrossProcessCursorWrapper;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.IContentObserver;
import android.database.StaleDataException;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;

public final class CursorToBulkCursorAdaptor
extends BulkCursorNative
implements IBinder.DeathRecipient {
    private static final String TAG = "Cursor";
    private CrossProcessCursor mCursor;
    private CursorWindow mFilledWindow;
    private final Object mLock = new Object();
    private ContentObserverProxy mObserver;
    private final String mProviderName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CursorToBulkCursorAdaptor(Cursor cursor, IContentObserver iContentObserver, String string2) {
        this.mCursor = cursor instanceof CrossProcessCursor ? (CrossProcessCursor)cursor : new CrossProcessCursorWrapper(cursor);
        this.mProviderName = string2;
        Object object = this.mLock;
        synchronized (object) {
            this.createAndRegisterObserverProxyLocked(iContentObserver);
            return;
        }
    }

    private void closeFilledWindowLocked() {
        if (this.mFilledWindow != null) {
            this.mFilledWindow.close();
            this.mFilledWindow = null;
        }
    }

    private void createAndRegisterObserverProxyLocked(IContentObserver iContentObserver) {
        if (this.mObserver != null) {
            throw new IllegalStateException("an observer is already registered");
        }
        this.mObserver = new ContentObserverProxy(iContentObserver, this);
        this.mCursor.registerContentObserver(this.mObserver);
    }

    private void disposeLocked() {
        if (this.mCursor != null) {
            this.unregisterObserverProxyLocked();
            this.mCursor.close();
            this.mCursor = null;
        }
        this.closeFilledWindowLocked();
    }

    private void throwIfCursorIsClosed() {
        if (this.mCursor == null) {
            throw new StaleDataException("Attempted to access a cursor after it has been closed.");
        }
    }

    private void unregisterObserverProxyLocked() {
        if (this.mObserver != null) {
            this.mCursor.unregisterContentObserver(this.mObserver);
            this.mObserver.unlinkToDeath(this);
            this.mObserver = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void binderDied() {
        Object object = this.mLock;
        synchronized (object) {
            this.disposeLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.disposeLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deactivate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCursor != null) {
                this.unregisterObserverProxyLocked();
                this.mCursor.deactivate();
            }
            this.closeFilledWindowLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BulkCursorDescriptor getBulkCursorDescriptor() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            BulkCursorDescriptor bulkCursorDescriptor = new BulkCursorDescriptor();
            bulkCursorDescriptor.cursor = this;
            bulkCursorDescriptor.columnNames = this.mCursor.getColumnNames();
            bulkCursorDescriptor.wantsAllOnMoveCalls = this.mCursor.getWantsAllOnMoveCalls();
            bulkCursorDescriptor.count = this.mCursor.getCount();
            bulkCursorDescriptor.window = this.mCursor.getWindow();
            if (bulkCursorDescriptor.window != null) {
                bulkCursorDescriptor.window.acquireReference();
            }
            return bulkCursorDescriptor;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Bundle getExtras() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            return this.mCursor.getExtras();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CursorWindow getWindow(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            if (!this.mCursor.moveToPosition(n)) {
                this.closeFilledWindowLocked();
                return null;
            }
            CursorWindow cursorWindow = this.mCursor.getWindow();
            if (cursorWindow != null) {
                this.closeFilledWindowLocked();
            } else {
                cursorWindow = this.mFilledWindow;
                if (cursorWindow == null) {
                    cursorWindow = this.mFilledWindow = new CursorWindow(this.mProviderName);
                } else if (n < cursorWindow.getStartPosition() || n >= cursorWindow.getStartPosition() + cursorWindow.getNumRows()) {
                    cursorWindow.clear();
                }
                this.mCursor.fillWindow(n, cursorWindow);
            }
            if (cursorWindow != null) {
                cursorWindow.acquireReference();
            }
            return cursorWindow;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onMove(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            this.mCursor.onMove(this.mCursor.getPosition(), n);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int requery(IContentObserver iContentObserver) {
        Object object = this.mLock;
        synchronized (object) {
            block5: {
                this.throwIfCursorIsClosed();
                this.closeFilledWindowLocked();
                try {
                    boolean bl = this.mCursor.requery();
                    if (bl) break block5;
                }
                catch (IllegalStateException illegalStateException) {
                    throw new IllegalStateException(this.mProviderName + " Requery misuse db, mCursor isClosed:" + this.mCursor.isClosed(), illegalStateException);
                }
                return -1;
            }
            this.unregisterObserverProxyLocked();
            this.createAndRegisterObserverProxyLocked(iContentObserver);
            return this.mCursor.getCount();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Bundle respond(Bundle bundle) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            return this.mCursor.respond(bundle);
        }
    }

    private static final class ContentObserverProxy
    extends ContentObserver {
        protected IContentObserver mRemote;

        public ContentObserverProxy(IContentObserver iContentObserver, IBinder.DeathRecipient deathRecipient) {
            super(null);
            this.mRemote = iContentObserver;
            try {
                iContentObserver.asBinder().linkToDeath(deathRecipient, 0);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        @Override
        public boolean deliverSelfNotifications() {
            return false;
        }

        @Override
        public void onChange(boolean bl, Uri uri) {
            try {
                this.mRemote.onChange(bl, uri, Process.myUid());
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        public boolean unlinkToDeath(IBinder.DeathRecipient deathRecipient) {
            return this.mRemote.asBinder().unlinkToDeath(deathRecipient, 0);
        }
    }
}

