/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObservable;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.os.Bundle;
import android.os.UserHandle;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCursor
implements CrossProcessCursor {
    private static final String TAG = "Cursor";
    protected boolean mClosed;
    private final ContentObservable mContentObservable;
    protected ContentResolver mContentResolver;
    @Deprecated
    protected Long mCurrentRowID = null;
    private final DataSetObservable mDataSetObservable;
    private Bundle mExtras;
    private Uri mNotifyUri;
    protected int mPos = -1;
    @Deprecated
    protected int mRowIdColumnIndex = -1;
    private ContentObserver mSelfObserver;
    private final Object mSelfObserverLock = new Object();
    private boolean mSelfObserverRegistered;
    @Deprecated
    protected HashMap<Long, Map<String, Object>> mUpdatedRows;

    public AbstractCursor() {
        this.mDataSetObservable = new DataSetObservable();
        this.mContentObservable = new ContentObservable();
        this.mExtras = Bundle.EMPTY;
        this.mUpdatedRows = new HashMap();
    }

    protected void checkPosition() {
        if (-1 == this.mPos || this.getCount() == this.mPos) {
            throw new CursorIndexOutOfBoundsException(this.mPos, this.getCount());
        }
    }

    @Override
    public void close() {
        this.mClosed = true;
        this.mContentObservable.unregisterAll();
        this.onDeactivateOrClose();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void copyStringToBuffer(int n, CharArrayBuffer charArrayBuffer) {
        String string2 = this.getString(n);
        if (string2 == null) {
            charArrayBuffer.sizeCopied = 0;
            return;
        }
        char[] cArray = charArrayBuffer.data;
        if (cArray == null || cArray.length < string2.length()) {
            charArrayBuffer.data = string2.toCharArray();
        } else {
            string2.getChars(0, string2.length(), cArray, 0);
        }
        charArrayBuffer.sizeCopied = string2.length();
    }

    @Override
    public void deactivate() {
        this.onDeactivateOrClose();
    }

    @Override
    public void fillWindow(int n, CursorWindow cursorWindow) {
        DatabaseUtils.cursorFillWindow(this, n, cursorWindow);
    }

    protected void finalize() {
        if (this.mSelfObserver != null && this.mSelfObserverRegistered) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
        }
        try {
            if (!this.mClosed) {
                this.close();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public byte[] getBlob(int n) {
        throw new UnsupportedOperationException("getBlob is not supported");
    }

    @Override
    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    @Override
    public int getColumnIndex(String string2) {
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            Exception exception = new Exception();
            Log.e(TAG, "requesting column name with table name -- " + string2, exception);
            string2 = string2.substring(n + 1);
        }
        String[] stringArray = this.getColumnNames();
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getColumnIndexOrThrow(String string2) {
        int n = this.getColumnIndex(string2);
        if (n < 0) {
            throw new IllegalArgumentException("column '" + string2 + "' does not exist");
        }
        return n;
    }

    @Override
    public String getColumnName(int n) {
        return this.getColumnNames()[n];
    }

    @Override
    public abstract String[] getColumnNames();

    @Override
    public abstract int getCount();

    @Override
    public abstract double getDouble(int var1);

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public abstract float getFloat(int var1);

    @Override
    public abstract int getInt(int var1);

    @Override
    public abstract long getLong(int var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Uri getNotificationUri() {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            return this.mNotifyUri;
        }
    }

    @Override
    public final int getPosition() {
        return this.mPos;
    }

    @Override
    public abstract short getShort(int var1);

    @Override
    public abstract String getString(int var1);

    @Override
    public int getType(int n) {
        return 3;
    }

    @Deprecated
    protected Object getUpdatedField(int n) {
        return null;
    }

    @Override
    public boolean getWantsAllOnMoveCalls() {
        return false;
    }

    @Override
    public CursorWindow getWindow() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final boolean isAfterLast() {
        return this.getCount() == 0 || this.mPos == this.getCount();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final boolean isBeforeFirst() {
        return this.getCount() == 0 || this.mPos == -1;
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Deprecated
    protected boolean isFieldUpdated(int n) {
        return false;
    }

    @Override
    public final boolean isFirst() {
        return this.mPos == 0 && this.getCount() != 0;
    }

    @Override
    public final boolean isLast() {
        int n = this.getCount();
        return this.mPos == n - 1 && n != 0;
    }

    @Override
    public abstract boolean isNull(int var1);

    @Override
    public final boolean move(int n) {
        return this.moveToPosition(n + this.mPos);
    }

    @Override
    public final boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    @Override
    public final boolean moveToLast() {
        return this.moveToPosition(-1 + this.getCount());
    }

    @Override
    public final boolean moveToNext() {
        return this.moveToPosition(1 + this.mPos);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final boolean moveToPosition(int n) {
        boolean bl = false;
        int n2 = this.getCount();
        if (n >= n2) {
            this.mPos = n2;
            return bl;
        } else {
            if (n < 0) {
                this.mPos = -1;
                return false;
            }
            if (n == this.mPos) {
                return true;
            }
            bl = this.onMove(this.mPos, n);
            if (!bl) {
                this.mPos = -1;
                return bl;
            }
            this.mPos = n;
            if (this.mRowIdColumnIndex == -1) return bl;
            this.mCurrentRowID = this.getLong(this.mRowIdColumnIndex);
            return bl;
        }
    }

    @Override
    public final boolean moveToPrevious() {
        return this.moveToPosition(-1 + this.mPos);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onChange(boolean bl) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mContentObservable.dispatchChange(bl, null);
            if (this.mNotifyUri != null && bl) {
                this.mContentResolver.notifyChange(this.mNotifyUri, this.mSelfObserver);
            }
            return;
        }
    }

    protected void onDeactivateOrClose() {
        if (this.mSelfObserver != null) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            this.mSelfObserverRegistered = false;
        }
        this.mDataSetObservable.notifyInvalidated();
    }

    @Override
    public boolean onMove(int n, int n2) {
        return true;
    }

    @Override
    public void registerContentObserver(ContentObserver contentObserver) {
        this.mContentObservable.registerObserver(contentObserver);
    }

    @Override
    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        this.mDataSetObservable.registerObserver(dataSetObserver);
    }

    @Override
    public boolean requery() {
        if (this.mSelfObserver != null && !this.mSelfObserverRegistered) {
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver);
            this.mSelfObserverRegistered = true;
        }
        this.mDataSetObservable.notifyChanged();
        return true;
    }

    @Override
    public Bundle respond(Bundle bundle) {
        return Bundle.EMPTY;
    }

    public void setExtras(Bundle bundle) {
        if (bundle == null) {
            bundle = Bundle.EMPTY;
        }
        this.mExtras = bundle;
    }

    @Override
    public void setNotificationUri(ContentResolver contentResolver, Uri uri) {
        this.setNotificationUri(contentResolver, uri, UserHandle.myUserId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNotificationUri(ContentResolver contentResolver, Uri uri, int n) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mNotifyUri = uri;
            this.mContentResolver = contentResolver;
            if (this.mSelfObserver != null) {
                this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            }
            this.mSelfObserver = new SelfContentObserver(this);
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver, n);
            this.mSelfObserverRegistered = true;
            return;
        }
    }

    @Override
    public void unregisterContentObserver(ContentObserver contentObserver) {
        if (!this.mClosed) {
            this.mContentObservable.unregisterObserver(contentObserver);
        }
    }

    @Override
    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        this.mDataSetObservable.unregisterObserver(dataSetObserver);
    }

    protected static class SelfContentObserver
    extends ContentObserver {
        WeakReference<AbstractCursor> mCursor;

        public SelfContentObserver(AbstractCursor abstractCursor) {
            super(null);
            this.mCursor = new WeakReference<AbstractCursor>(abstractCursor);
        }

        @Override
        public boolean deliverSelfNotifications() {
            return false;
        }

        @Override
        public void onChange(boolean bl) {
            AbstractCursor abstractCursor = (AbstractCursor)this.mCursor.get();
            if (abstractCursor != null) {
                abstractCursor.onChange(false);
            }
        }
    }
}

