/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.pm.ActivityInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.graphics.Movie;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Trace;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.Pools;
import android.util.TypedValue;
import android.view.ViewDebug;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Locale;
import libcore.icu.NativePluralRules;
import org.xmlpull.v1.XmlPullParserException;

public class Resources {
    private static final boolean DEBUG_CONFIG = false;
    private static final boolean DEBUG_LOAD = false;
    private static final int ID_OTHER = 0x1000004;
    private static final int LAYOUT_DIR_CONFIG = 0;
    static final String TAG = "Resources";
    private static final boolean TRACE_FOR_MISS_PRELOAD;
    private static final boolean TRACE_FOR_PRELOAD;
    static Resources mSystem;
    private static boolean sPreloaded;
    private static final LongSparseArray<Drawable.ConstantState> sPreloadedColorDrawables;
    private static final LongSparseArray<ColorStateList> sPreloadedColorStateLists;
    private static int sPreloadedDensity;
    private static final LongSparseArray<Drawable.ConstantState>[] sPreloadedDrawables;
    private static final Object sSync;
    private final Object mAccessLock;
    final AssetManager mAssets;
    private TypedArray mCachedStyledAttributes = null;
    private final int[] mCachedXmlBlockIds;
    private final XmlBlock[] mCachedXmlBlocks;
    private final ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> mColorDrawableCache;
    private final LongSparseArray<WeakReference<ColorStateList>> mColorStateListCache;
    private CompatibilityInfo mCompatibilityInfo;
    private final Configuration mConfiguration;
    private final ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> mDrawableCache;
    private int mLastCachedXmlBlockIndex = -1;
    final DisplayMetrics mMetrics;
    private NativePluralRules mPluralRule;
    private boolean mPreloading;
    private final Configuration mTmpConfig;
    private TypedValue mTmpValue;
    private WeakReference<IBinder> mToken;
    final Pools.SynchronizedPool<TypedArray> mTypedArrayPool = new Pools.SynchronizedPool(5);

    static {
        LAYOUT_DIR_CONFIG = ActivityInfo.activityInfoConfigToNative(8192);
        sSync = new Object();
        sPreloadedColorDrawables = new LongSparseArray();
        sPreloadedColorStateLists = new LongSparseArray();
        mSystem = null;
        sPreloadedDrawables = new LongSparseArray[2];
        Resources.sPreloadedDrawables[0] = new LongSparseArray();
        Resources.sPreloadedDrawables[1] = new LongSparseArray();
    }

    private Resources() {
        this.mAccessLock = new Object();
        this.mTmpConfig = new Configuration();
        this.mDrawableCache = new ArrayMap();
        this.mColorDrawableCache = new ArrayMap();
        this.mColorStateListCache = new LongSparseArray();
        this.mTmpValue = new TypedValue();
        this.mCachedXmlBlockIds = new int[]{0, 0, 0, 0};
        this.mCachedXmlBlocks = new XmlBlock[4];
        this.mMetrics = new DisplayMetrics();
        this.mConfiguration = new Configuration();
        this.mCompatibilityInfo = CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
        this.mAssets = AssetManager.getSystem();
        this.mConfiguration.setToDefaults();
        this.mMetrics.setToDefaults();
        this.updateConfiguration(null, null);
        this.mAssets.ensureStringBlocks();
    }

    public Resources(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration) {
        this(assetManager, displayMetrics, configuration, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
    }

    public Resources(AssetManager assetManager, DisplayMetrics displayMetrics, Configuration configuration, CompatibilityInfo compatibilityInfo, IBinder iBinder) {
        this.mAccessLock = new Object();
        this.mTmpConfig = new Configuration();
        this.mDrawableCache = new ArrayMap();
        this.mColorDrawableCache = new ArrayMap();
        this.mColorStateListCache = new LongSparseArray();
        this.mTmpValue = new TypedValue();
        this.mCachedXmlBlockIds = new int[]{0, 0, 0, 0};
        this.mCachedXmlBlocks = new XmlBlock[4];
        this.mMetrics = new DisplayMetrics();
        this.mConfiguration = new Configuration();
        this.mCompatibilityInfo = CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO;
        this.mAssets = assetManager;
        this.mMetrics.setToDefaults();
        if (compatibilityInfo != null) {
            this.mCompatibilityInfo = compatibilityInfo;
        }
        this.mToken = new WeakReference<IBinder>(iBinder);
        this.updateConfiguration(configuration, displayMetrics);
        assetManager.ensureStringBlocks();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String adjustLanguageTag(String string2) {
        String string3;
        String string4;
        int n = string2.indexOf(45);
        if (n == -1) {
            string4 = string2;
            string3 = "";
            return Locale.adjustLanguageCode((String)string4) + string3;
        }
        string4 = string2.substring(0, n);
        string3 = string2.substring(n);
        return Locale.adjustLanguageCode((String)string4) + string3;
    }

    private static int attrForQuantityCode(int n) {
        switch (n) {
            default: {
                return 0x1000004;
            }
            case 0: {
                return 0x1000005;
            }
            case 1: {
                return 0x1000006;
            }
            case 2: {
                return 0x1000007;
            }
            case 3: {
                return 0x1000008;
            }
            case 4: 
        }
        return 0x1000009;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cacheDrawable(TypedValue typedValue, Theme theme, boolean bl, ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> arrayMap, long l, Drawable drawable2) {
        Drawable.ConstantState constantState = drawable2.getConstantState();
        if (constantState == null) return;
        if (this.mPreloading) {
            int n = constantState.getChangingConfigurations();
            if (bl) {
                if (!this.verifyPreloadConfig(n, 0, typedValue.resourceId, "drawable")) return;
                sPreloadedColorDrawables.put(l, constantState);
                return;
            }
            if (!this.verifyPreloadConfig(n, LAYOUT_DIR_CONFIG, typedValue.resourceId, "drawable")) {
                return;
            }
            if ((n & LAYOUT_DIR_CONFIG) == 0) {
                sPreloadedDrawables[0].put(l, constantState);
                sPreloadedDrawables[1].put(l, constantState);
                return;
            }
            sPreloadedDrawables[this.mConfiguration.getLayoutDirection()].put(l, constantState);
            return;
        }
        Object object = this.mAccessLock;
        synchronized (object) {
            String string2;
            String string3 = theme == null ? "" : (string2 = theme.mKey);
            LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray = arrayMap.get(string3);
            if (longSparseArray == null) {
                longSparseArray = new LongSparseArray(1);
                arrayMap.put(string3, longSparseArray);
            }
            longSparseArray.put(l, new WeakReference<Drawable.ConstantState>(constantState));
            return;
        }
    }

    private void clearDrawableCacheLocked(LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray, int n) {
        int n2 = longSparseArray.size();
        for (int i = 0; i < n2; ++i) {
            Drawable.ConstantState constantState;
            WeakReference<Drawable.ConstantState> weakReference = longSparseArray.valueAt(i);
            if (weakReference == null || (constantState = (Drawable.ConstantState)weakReference.get()) == null || !Configuration.needNewResources(n, constantState.getChangingConfigurations())) continue;
            longSparseArray.setValueAt(i, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void clearDrawableCachesLocked(ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> arrayMap, int n) {
        if (Configuration.needNewResources(n, 0) && arrayMap.size() > 0) {
            arrayMap.clear();
            return;
        } else {
            int n2 = arrayMap.size();
            for (int i = 0; i < n2; ++i) {
                this.clearDrawableCacheLocked(arrayMap.valueAt(i), n);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ColorStateList getCachedColorStateList(long l) {
        Object object = this.mAccessLock;
        synchronized (object) {
            WeakReference<ColorStateList> weakReference = this.mColorStateListCache.get(l);
            if (weakReference != null) {
                ColorStateList colorStateList = (ColorStateList)weakReference.get();
                if (colorStateList != null) {
                    return colorStateList;
                }
                this.mColorStateListCache.delete(l);
            }
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable getCachedDrawable(ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> arrayMap, long l, Theme theme) {
        Object object = this.mAccessLock;
        synchronized (object) {
            Drawable drawable2;
            String string2 = theme != null ? theme.mKey : "";
            LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray = arrayMap.get(string2);
            if (longSparseArray != null && (drawable2 = this.getCachedDrawableLocked(longSparseArray, l)) != null) {
                return drawable2;
            }
            return null;
        }
    }

    private Drawable getCachedDrawableLocked(LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray, long l) {
        Drawable.ConstantState constantState = this.getConstantStateLocked(longSparseArray, l);
        if (constantState != null) {
            return constantState.newDrawable(this);
        }
        return null;
    }

    private Drawable.ConstantState getConstantStateLocked(LongSparseArray<WeakReference<Drawable.ConstantState>> longSparseArray, long l) {
        WeakReference<Drawable.ConstantState> weakReference = longSparseArray.get(l);
        if (weakReference != null) {
            Drawable.ConstantState constantState = (Drawable.ConstantState)weakReference.get();
            if (constantState != null) {
                return constantState;
            }
            longSparseArray.delete(l);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NativePluralRules getPluralRule() {
        Object object = sSync;
        synchronized (object) {
            if (this.mPluralRule != null) return this.mPluralRule;
            this.mPluralRule = NativePluralRules.forLocale((Locale)this.mConfiguration.locale);
            return this.mPluralRule;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Resources getSystem() {
        Object object = sSync;
        synchronized (object) {
            Resources resources = mSystem;
            if (resources == null) {
                mSystem = resources = new Resources();
            }
            return resources;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Drawable loadDrawableForCookie(TypedValue typedValue, int n, Theme theme) {
        Drawable drawable2;
        if (typedValue.string == null) {
            throw new NotFoundException("Resource \"" + this.getResourceName(n) + "\" (" + Integer.toHexString(n) + ")  is not a Drawable (color or path): " + typedValue);
        }
        String string2 = typedValue.string.toString();
        Trace.traceBegin(8192L, string2);
        try {
            if (!string2.endsWith(".xml")) {
                InputStream inputStream = this.mAssets.openNonAsset(typedValue.assetCookie, string2, 2);
                drawable2 = Drawable.createFromResourceStream(this, typedValue, inputStream, string2, null);
                inputStream.close();
            }
            XmlResourceParser xmlResourceParser = this.loadXmlResourceParser(string2, n, typedValue.assetCookie, "drawable");
            drawable2 = Drawable.createFromXml(this, xmlResourceParser, theme);
            xmlResourceParser.close();
        }
        catch (Exception exception) {
            Trace.traceEnd(8192L);
            NotFoundException notFoundException = new NotFoundException("File " + string2 + " from drawable resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(exception);
            throw notFoundException;
        }
        Trace.traceEnd(8192L);
        return drawable2;
    }

    public static boolean resourceHasPackage(int n) {
        return n >>> 24 != 0;
    }

    public static int selectDefaultTheme(int n, int n2) {
        return Resources.selectSystemTheme(n, n2, 16973829, 16973931, 16974120, 16974143);
    }

    public static int selectSystemTheme(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n != 0) {
            return n;
        }
        if (n2 < 11) {
            return n3;
        }
        if (n2 < 14) {
            return n4;
        }
        if (n2 < 10000) {
            return n5;
        }
        return n6;
    }

    private static String stringForQuantityCode(int n) {
        switch (n) {
            default: {
                return "other";
            }
            case 0: {
                return "zero";
            }
            case 1: {
                return "one";
            }
            case 2: {
                return "two";
            }
            case 3: {
                return "few";
            }
            case 4: 
        }
        return "many";
    }

    public static void updateSystemConfiguration(Configuration configuration, DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo) {
        if (mSystem != null) {
            mSystem.updateConfiguration(configuration, displayMetrics, compatibilityInfo);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verifyPreloadConfig(int n, int n2, int n3, String string2) {
        String string3;
        if ((0xBFFFEFFF & n & ~n2) == 0) {
            return true;
        }
        try {
            String string4;
            string3 = string4 = this.getResourceName(n3);
        }
        catch (NotFoundException notFoundException) {
            string3 = "?";
        }
        Log.w(TAG, "Preloaded " + string2 + " resource #0x" + Integer.toHexString(n3) + " (" + string3 + ") that varies with configuration!!");
        return false;
    }

    public final void finishPreloading() {
        if (this.mPreloading) {
            this.mPreloading = false;
            this.flushLayoutCache();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void flushLayoutCache() {
        int[] nArray = this.mCachedXmlBlockIds;
        synchronized (nArray) {
            int n = this.mCachedXmlBlockIds.length;
            int n2 = 0;
            while (n2 < n) {
                this.mCachedXmlBlockIds[n2] = 0;
                XmlBlock xmlBlock = this.mCachedXmlBlocks[n2];
                if (xmlBlock != null) {
                    xmlBlock.close();
                }
                this.mCachedXmlBlocks[n2] = null;
                ++n2;
            }
            return;
        }
    }

    public XmlResourceParser getAnimation(int n) throws NotFoundException {
        return this.loadXmlResourceParser(n, "anim");
    }

    public final AssetManager getAssets() {
        return this.mAssets;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getBoolean(int n) throws NotFoundException {
        boolean bl = true;
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue typedValue = this.mTmpValue;
            if (typedValue == null) {
                this.mTmpValue = typedValue = new TypedValue();
            }
            this.getValue(n, typedValue, true);
            if (typedValue.type < 16) throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n) + " type #0x" + Integer.toHexString(typedValue.type) + " is not valid");
            if (typedValue.type > 31) throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n) + " type #0x" + Integer.toHexString(typedValue.type) + " is not valid");
            if (typedValue.data == 0) return false;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getColor(int n) throws NotFoundException {
        TypedValue typedValue;
        Object object = this.mAccessLock;
        synchronized (object) {
            typedValue = this.mTmpValue;
            if (typedValue == null) {
                typedValue = new TypedValue();
            }
            this.getValue(n, typedValue, true);
            if (typedValue.type >= 16 && typedValue.type <= 31) {
                this.mTmpValue = typedValue;
                return typedValue.data;
            }
            if (typedValue.type != 3) {
                throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n) + " type #0x" + Integer.toHexString(typedValue.type) + " is not valid");
            }
            this.mTmpValue = null;
        }
        ColorStateList colorStateList = this.loadColorStateList(typedValue, n);
        Object object2 = this.mAccessLock;
        synchronized (object2) {
            if (this.mTmpValue != null) return colorStateList.getDefaultColor();
            this.mTmpValue = typedValue;
            return colorStateList.getDefaultColor();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ColorStateList getColorStateList(int n) throws NotFoundException {
        TypedValue typedValue;
        Object object = this.mAccessLock;
        synchronized (object) {
            typedValue = this.mTmpValue;
            if (typedValue == null) {
                typedValue = new TypedValue();
            } else {
                this.mTmpValue = null;
            }
            this.getValue(n, typedValue, true);
        }
        ColorStateList colorStateList = this.loadColorStateList(typedValue, n);
        Object object2 = this.mAccessLock;
        synchronized (object2) {
            if (this.mTmpValue == null) {
                this.mTmpValue = typedValue;
            }
            return colorStateList;
        }
    }

    public CompatibilityInfo getCompatibilityInfo() {
        return this.mCompatibilityInfo;
    }

    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getDimension(int n) throws NotFoundException {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue typedValue = this.mTmpValue;
            if (typedValue == null) {
                this.mTmpValue = typedValue = new TypedValue();
            }
            this.getValue(n, typedValue, true);
            if (typedValue.type != 5) throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n) + " type #0x" + Integer.toHexString(typedValue.type) + " is not valid");
            return TypedValue.complexToDimension(typedValue.data, this.mMetrics);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getDimensionPixelOffset(int n) throws NotFoundException {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue typedValue = this.mTmpValue;
            if (typedValue == null) {
                this.mTmpValue = typedValue = new TypedValue();
            }
            this.getValue(n, typedValue, true);
            if (typedValue.type != 5) throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n) + " type #0x" + Integer.toHexString(typedValue.type) + " is not valid");
            return TypedValue.complexToDimensionPixelOffset(typedValue.data, this.mMetrics);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getDimensionPixelSize(int n) throws NotFoundException {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue typedValue = this.mTmpValue;
            if (typedValue == null) {
                this.mTmpValue = typedValue = new TypedValue();
            }
            this.getValue(n, typedValue, true);
            if (typedValue.type != 5) throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n) + " type #0x" + Integer.toHexString(typedValue.type) + " is not valid");
            return TypedValue.complexToDimensionPixelSize(typedValue.data, this.mMetrics);
        }
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mMetrics;
    }

    public Drawable getDrawable(int n) throws NotFoundException {
        Drawable drawable2 = this.getDrawable(n, null);
        if (drawable2.canApplyTheme()) {
            Log.w(TAG, "Drawable " + this.getResourceName(n) + " has unresolved theme " + "attributes! Consider using Resources.getDrawable(int, Theme) or " + "Context.getDrawable(int).", new RuntimeException());
        }
        return drawable2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Drawable getDrawable(int n, Theme theme) throws NotFoundException {
        TypedValue typedValue;
        Object object = this.mAccessLock;
        synchronized (object) {
            typedValue = this.mTmpValue;
            if (typedValue == null) {
                typedValue = new TypedValue();
            } else {
                this.mTmpValue = null;
            }
            this.getValue(n, typedValue, true);
        }
        Drawable drawable2 = this.loadDrawable(typedValue, n, theme);
        Object object2 = this.mAccessLock;
        synchronized (object2) {
            if (this.mTmpValue == null) {
                this.mTmpValue = typedValue;
            }
            return drawable2;
        }
    }

    public Drawable getDrawableForDensity(int n, int n2) throws NotFoundException {
        return this.getDrawableForDensity(n, n2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Drawable getDrawableForDensity(int n, int n2, Theme theme) {
        TypedValue typedValue;
        Object object = this.mAccessLock;
        synchronized (object) {
            typedValue = this.mTmpValue;
            if (typedValue == null) {
                typedValue = new TypedValue();
            } else {
                this.mTmpValue = null;
            }
            this.getValueForDensity(n, n2, typedValue, true);
            if (typedValue.density > 0 && typedValue.density != 65535) {
                typedValue.density = typedValue.density == n2 ? this.mMetrics.densityDpi : typedValue.density * this.mMetrics.densityDpi / n2;
            }
        }
        Drawable drawable2 = this.loadDrawable(typedValue, n, theme);
        Object object2 = this.mAccessLock;
        synchronized (object2) {
            if (this.mTmpValue == null) {
                this.mTmpValue = typedValue;
            }
            return drawable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getFloat(int n) {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue typedValue = this.mTmpValue;
            if (typedValue == null) {
                this.mTmpValue = typedValue = new TypedValue();
            }
            this.getValue(n, typedValue, true);
            if (typedValue.type != 4) throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n) + " type #0x" + Integer.toHexString(typedValue.type) + " is not valid");
            return typedValue.getFloat();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getFraction(int n, int n2, int n3) {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue typedValue = this.mTmpValue;
            if (typedValue == null) {
                this.mTmpValue = typedValue = new TypedValue();
            }
            this.getValue(n, typedValue, true);
            if (typedValue.type != 6) throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n) + " type #0x" + Integer.toHexString(typedValue.type) + " is not valid");
            return TypedValue.complexToFraction(typedValue.data, n2, n3);
        }
    }

    public int getIdentifier(String string2, String string3, String string4) {
        if (string2 == null) {
            throw new NullPointerException("name is null");
        }
        try {
            int n = Integer.parseInt(string2);
            return n;
        }
        catch (Exception exception) {
            return this.mAssets.getResourceIdentifier(string2, string3, string4);
        }
    }

    public int[] getIntArray(int n) throws NotFoundException {
        int[] nArray = this.mAssets.getArrayIntResource(n);
        if (nArray != null) {
            return nArray;
        }
        throw new NotFoundException("Int array resource ID #0x" + Integer.toHexString(n));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getInteger(int n) throws NotFoundException {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue typedValue = this.mTmpValue;
            if (typedValue == null) {
                this.mTmpValue = typedValue = new TypedValue();
            }
            this.getValue(n, typedValue, true);
            if (typedValue.type < 16) throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n) + " type #0x" + Integer.toHexString(typedValue.type) + " is not valid");
            if (typedValue.type > 31) throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n) + " type #0x" + Integer.toHexString(typedValue.type) + " is not valid");
            return typedValue.data;
        }
    }

    public XmlResourceParser getLayout(int n) throws NotFoundException {
        return this.loadXmlResourceParser(n, "layout");
    }

    public Movie getMovie(int n) throws NotFoundException {
        InputStream inputStream = this.openRawResource(n);
        Movie movie = Movie.decodeStream(inputStream);
        try {
            inputStream.close();
            return movie;
        }
        catch (IOException iOException) {
            return movie;
        }
    }

    public LongSparseArray<Drawable.ConstantState> getPreloadedDrawables() {
        return sPreloadedDrawables[0];
    }

    public String getQuantityString(int n, int n2) throws NotFoundException {
        return this.getQuantityText(n, n2).toString();
    }

    public String getQuantityString(int n, int n2, Object ... objectArray) throws NotFoundException {
        String string2 = this.getQuantityText(n, n2).toString();
        return String.format(this.mConfiguration.locale, string2, objectArray);
    }

    public CharSequence getQuantityText(int n, int n2) throws NotFoundException {
        NativePluralRules nativePluralRules = this.getPluralRule();
        CharSequence charSequence = this.mAssets.getResourceBagText(n, Resources.attrForQuantityCode(nativePluralRules.quantityForInt(n2)));
        if (charSequence != null) {
            return charSequence;
        }
        CharSequence charSequence2 = this.mAssets.getResourceBagText(n, 0x1000004);
        if (charSequence2 != null) {
            return charSequence2;
        }
        throw new NotFoundException("Plural resource ID #0x" + Integer.toHexString(n) + " quantity=" + n2 + " item=" + Resources.stringForQuantityCode(nativePluralRules.quantityForInt(n2)));
    }

    public String getResourceEntryName(int n) throws NotFoundException {
        String string2 = this.mAssets.getResourceEntryName(n);
        if (string2 != null) {
            return string2;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(n));
    }

    public String getResourceName(int n) throws NotFoundException {
        String string2 = this.mAssets.getResourceName(n);
        if (string2 != null) {
            return string2;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(n));
    }

    public String getResourcePackageName(int n) throws NotFoundException {
        String string2 = this.mAssets.getResourcePackageName(n);
        if (string2 != null) {
            return string2;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(n));
    }

    public String getResourceTypeName(int n) throws NotFoundException {
        String string2 = this.mAssets.getResourceTypeName(n);
        if (string2 != null) {
            return string2;
        }
        throw new NotFoundException("Unable to find resource ID #0x" + Integer.toHexString(n));
    }

    public String getString(int n) throws NotFoundException {
        CharSequence charSequence = this.getText(n);
        if (charSequence != null) {
            return charSequence.toString();
        }
        throw new NotFoundException("String resource ID #0x" + Integer.toHexString(n));
    }

    public String getString(int n, Object ... objectArray) throws NotFoundException {
        String string2 = this.getString(n);
        return String.format(this.mConfiguration.locale, string2, objectArray);
    }

    public String[] getStringArray(int n) throws NotFoundException {
        String[] stringArray = this.mAssets.getResourceStringArray(n);
        if (stringArray != null) {
            return stringArray;
        }
        throw new NotFoundException("String array resource ID #0x" + Integer.toHexString(n));
    }

    public CharSequence getText(int n) throws NotFoundException {
        CharSequence charSequence = this.mAssets.getResourceText(n);
        if (charSequence != null) {
            return charSequence;
        }
        throw new NotFoundException("String resource ID #0x" + Integer.toHexString(n));
    }

    /*
     * Enabled aggressive block sorting
     */
    public CharSequence getText(int n, CharSequence charSequence) {
        CharSequence charSequence2 = n != 0 ? this.mAssets.getResourceText(n) : null;
        if (charSequence2 != null) {
            return charSequence2;
        }
        return charSequence;
    }

    public CharSequence[] getTextArray(int n) throws NotFoundException {
        CharSequence[] charSequenceArray = this.mAssets.getResourceTextArray(n);
        if (charSequenceArray != null) {
            return charSequenceArray;
        }
        throw new NotFoundException("Text array resource ID #0x" + Integer.toHexString(n));
    }

    public void getValue(int n, TypedValue typedValue, boolean bl) throws NotFoundException {
        if (this.mAssets.getResourceValue(n, 0, typedValue, bl)) {
            return;
        }
        throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n));
    }

    public void getValue(String string2, TypedValue typedValue, boolean bl) throws NotFoundException {
        int n = this.getIdentifier(string2, "string", null);
        if (n != 0) {
            this.getValue(n, typedValue, bl);
            return;
        }
        throw new NotFoundException("String resource name " + string2);
    }

    public void getValueForDensity(int n, int n2, TypedValue typedValue, boolean bl) throws NotFoundException {
        if (this.mAssets.getResourceValue(n, n2, typedValue, bl)) {
            return;
        }
        throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n));
    }

    public XmlResourceParser getXml(int n) throws NotFoundException {
        return this.loadXmlResourceParser(n, "xml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ColorStateList loadColorStateList(TypedValue typedValue, int n) throws NotFoundException {
        ColorStateList colorStateList;
        long l = (long)typedValue.assetCookie << 32 | (long)typedValue.data;
        if (typedValue.type >= 28 && typedValue.type <= 31) {
            ColorStateList colorStateList2 = sPreloadedColorStateLists.get(l);
            if (colorStateList2 != null) {
                return colorStateList2;
            }
            ColorStateList colorStateList3 = ColorStateList.valueOf(typedValue.data);
            if (!this.mPreloading) return colorStateList3;
            if (!this.verifyPreloadConfig(typedValue.changingConfigurations, 0, typedValue.resourceId, "color")) return colorStateList3;
            sPreloadedColorStateLists.put(l, colorStateList3);
            return colorStateList3;
        }
        ColorStateList colorStateList4 = this.getCachedColorStateList(l);
        if (colorStateList4 != null) {
            return colorStateList4;
        }
        ColorStateList colorStateList5 = sPreloadedColorStateLists.get(l);
        if (colorStateList5 != null) {
            return colorStateList5;
        }
        if (typedValue.string == null) {
            throw new NotFoundException("Resource is not a ColorStateList (color or path): " + typedValue);
        }
        String string2 = typedValue.string.toString();
        if (!string2.endsWith(".xml")) throw new NotFoundException("File " + string2 + " from drawable resource ID #0x" + Integer.toHexString(n) + ": .xml extension required");
        Trace.traceBegin(8192L, string2);
        try {
            XmlResourceParser xmlResourceParser = this.loadXmlResourceParser(string2, n, typedValue.assetCookie, "colorstatelist");
            colorStateList = ColorStateList.createFromXml(this, xmlResourceParser);
            xmlResourceParser.close();
        }
        catch (Exception exception) {
            Trace.traceEnd(8192L);
            NotFoundException notFoundException = new NotFoundException("File " + string2 + " from color state list resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(exception);
            throw notFoundException;
        }
        Trace.traceEnd(8192L);
        if (colorStateList == null) return colorStateList;
        if (this.mPreloading) {
            if (!this.verifyPreloadConfig(typedValue.changingConfigurations, 0, typedValue.resourceId, "color")) return colorStateList;
            sPreloadedColorStateLists.put(l, colorStateList);
            return colorStateList;
        }
        Object object = this.mAccessLock;
        synchronized (object) {
            this.mColorStateListCache.put(l, new WeakReference<ColorStateList>(colorStateList));
            return colorStateList;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    Drawable loadDrawable(TypedValue typedValue, int n, Theme theme) throws NotFoundException {
        Drawable drawable2;
        long l;
        ArrayMap<String, LongSparseArray<WeakReference<Drawable.ConstantState>>> arrayMap;
        boolean bl;
        if (typedValue.type >= 28 && typedValue.type <= 31) {
            bl = true;
            arrayMap = this.mColorDrawableCache;
            l = typedValue.data;
        } else {
            arrayMap = this.mDrawableCache;
            l = (long)typedValue.assetCookie << 32 | (long)typedValue.data;
            bl = false;
        }
        if (!this.mPreloading && (drawable2 = this.getCachedDrawable(arrayMap, l, theme)) != null) {
            return drawable2;
        }
        Drawable.ConstantState constantState = bl ? sPreloadedColorDrawables.get(l) : sPreloadedDrawables[this.mConfiguration.getLayoutDirection()].get(l);
        Drawable drawable3 = constantState != null ? constantState.newDrawable(this, theme) : (bl ? new ColorDrawable(typedValue.data) : this.loadDrawableForCookie(typedValue, n, theme));
        if (drawable3 != null) {
            drawable3.setChangingConfigurations(typedValue.changingConfigurations);
            this.cacheDrawable(typedValue, theme, bl, arrayMap, l, drawable3);
        }
        return drawable3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    XmlResourceParser loadXmlResourceParser(int n, String string2) throws NotFoundException {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedValue typedValue = this.mTmpValue;
            if (typedValue == null) {
                this.mTmpValue = typedValue = new TypedValue();
            }
            this.getValue(n, typedValue, true);
            if (typedValue.type != 3) throw new NotFoundException("Resource ID #0x" + Integer.toHexString(n) + " type #0x" + Integer.toHexString(typedValue.type) + " is not valid");
            return this.loadXmlResourceParser(typedValue.string.toString(), n, typedValue.assetCookie, string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    XmlResourceParser loadXmlResourceParser(String string2, int n, int n2, String string3) throws NotFoundException {
        if (n == 0) throw new NotFoundException("File " + string2 + " from xml type " + string3 + " resource ID #0x" + Integer.toHexString(n));
        try {
            int[] nArray = this.mCachedXmlBlockIds;
            synchronized (nArray) {
            }
        }
        catch (Exception exception) {
            NotFoundException notFoundException = new NotFoundException("File " + string2 + " from xml type " + string3 + " resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(exception);
            throw notFoundException;
        }
        {
            int n3 = this.mCachedXmlBlockIds.length;
            int n4 = 0;
            while (true) {
                if (n4 < n3) {
                    if (this.mCachedXmlBlockIds[n4] == n) {
                        return this.mCachedXmlBlocks[n4].newParser();
                    }
                } else {
                    XmlBlock xmlBlock = this.mAssets.openXmlBlockAsset(n2, string2);
                    if (xmlBlock == null) throw new NotFoundException("File " + string2 + " from xml type " + string3 + " resource ID #0x" + Integer.toHexString(n));
                    int n5 = 1 + this.mLastCachedXmlBlockIndex;
                    if (n5 >= n3) {
                        n5 = 0;
                    }
                    this.mLastCachedXmlBlockIndex = n5;
                    XmlBlock xmlBlock2 = this.mCachedXmlBlocks[n5];
                    if (xmlBlock2 != null) {
                        xmlBlock2.close();
                    }
                    this.mCachedXmlBlockIds[n5] = n;
                    this.mCachedXmlBlocks[n5] = xmlBlock;
                    return xmlBlock.newParser();
                }
                ++n4;
            }
        }
    }

    public final Theme newTheme() {
        return new Theme();
    }

    public TypedArray obtainAttributes(AttributeSet attributeSet, int[] nArray) {
        TypedArray typedArray = TypedArray.obtain(this, nArray.length);
        XmlBlock.Parser parser = (XmlBlock.Parser)attributeSet;
        this.mAssets.retrieveAttributes(parser.mParseState, nArray, typedArray.mData, typedArray.mIndices);
        typedArray.mXml = parser;
        return typedArray;
    }

    public TypedArray obtainTypedArray(int n) throws NotFoundException {
        int n2 = this.mAssets.getArraySize(n);
        if (n2 < 0) {
            throw new NotFoundException("Array resource ID #0x" + Integer.toHexString(n));
        }
        TypedArray typedArray = TypedArray.obtain(this, n2);
        typedArray.mLength = this.mAssets.retrieveArray(n, typedArray.mData);
        typedArray.mIndices[0] = 0;
        return typedArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream openRawResource(int n) throws NotFoundException {
        TypedValue typedValue;
        Object object = this.mAccessLock;
        synchronized (object) {
            typedValue = this.mTmpValue;
            if (typedValue == null) {
                typedValue = new TypedValue();
            } else {
                this.mTmpValue = null;
            }
        }
        InputStream inputStream = this.openRawResource(n, typedValue);
        Object object2 = this.mAccessLock;
        synchronized (object2) {
            if (this.mTmpValue == null) {
                this.mTmpValue = typedValue;
            }
            return inputStream;
        }
    }

    public InputStream openRawResource(int n, TypedValue typedValue) throws NotFoundException {
        this.getValue(n, typedValue, true);
        try {
            InputStream inputStream = this.mAssets.openNonAsset(typedValue.assetCookie, typedValue.string.toString(), 2);
            return inputStream;
        }
        catch (Exception exception) {
            NotFoundException notFoundException = new NotFoundException("File " + typedValue.string.toString() + " from drawable resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(exception);
            throw notFoundException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AssetFileDescriptor openRawResourceFd(int n) throws NotFoundException {
        TypedValue typedValue;
        Object object = this.mAccessLock;
        synchronized (object) {
            typedValue = this.mTmpValue;
            if (typedValue == null) {
                typedValue = new TypedValue();
            } else {
                this.mTmpValue = null;
            }
            this.getValue(n, typedValue, true);
        }
        try {
            AssetFileDescriptor assetFileDescriptor = this.mAssets.openNonAssetFd(typedValue.assetCookie, typedValue.string.toString());
            return assetFileDescriptor;
        }
        catch (Exception exception) {
            NotFoundException notFoundException = new NotFoundException("File " + typedValue.string.toString() + " from drawable resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause(exception);
            throw notFoundException;
        }
        finally {
            Object object2 = this.mAccessLock;
            synchronized (object2) {
                if (this.mTmpValue == null) {
                    this.mTmpValue = typedValue;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void parseBundleExtra(String string2, AttributeSet attributeSet, Bundle bundle) throws XmlPullParserException {
        boolean bl = true;
        TypedArray typedArray = this.obtainAttributes(attributeSet, R.styleable.Extra);
        String string3 = typedArray.getString(0);
        if (string3 == null) {
            typedArray.recycle();
            throw new XmlPullParserException("<" + string2 + "> requires an android:name attribute at " + attributeSet.getPositionDescription());
        }
        TypedValue typedValue = typedArray.peekValue(bl ? 1 : 0);
        if (typedValue == null) {
            typedArray.recycle();
            throw new XmlPullParserException("<" + string2 + "> requires an android:value or android:resource attribute at " + attributeSet.getPositionDescription());
        }
        if (typedValue.type == 3) {
            bundle.putCharSequence(string3, typedValue.coerceToString());
        } else if (typedValue.type == 18) {
            if (typedValue.data == 0) {
                bl = false;
            }
            bundle.putBoolean(string3, bl);
        } else if (typedValue.type >= 16 && typedValue.type <= 31) {
            bundle.putInt(string3, typedValue.data);
        } else {
            if (typedValue.type != 4) {
                typedArray.recycle();
                throw new XmlPullParserException("<" + string2 + "> only supports string, integer, float, color, and boolean at " + attributeSet.getPositionDescription());
            }
            bundle.putFloat(string3, typedValue.getFloat());
        }
        typedArray.recycle();
    }

    public void parseBundleExtras(XmlResourceParser xmlResourceParser, Bundle bundle) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlResourceParser.getDepth();
        while ((n = xmlResourceParser.next()) != 1 && (n != 3 || xmlResourceParser.getDepth() > n2)) {
            if (n == 3 || n == 4) continue;
            if (xmlResourceParser.getName().equals("extra")) {
                this.parseBundleExtra("extra", xmlResourceParser, bundle);
                XmlUtils.skipCurrentTag(xmlResourceParser);
                continue;
            }
            XmlUtils.skipCurrentTag(xmlResourceParser);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void recreateStringBlocks() {
        Object object = this.mAccessLock;
        synchronized (object) {
            this.mAssets.recreateStringBlocks();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void recycleCachedStyledAttributes(TypedArray typedArray) {
        Object object = this.mAccessLock;
        synchronized (object) {
            TypedArray typedArray2 = this.mCachedStyledAttributes;
            if (typedArray2 == null || typedArray2.mData.length < typedArray.mData.length) {
                this.mCachedStyledAttributes = typedArray;
            }
            return;
        }
    }

    public void setCompatibilityInfo(CompatibilityInfo compatibilityInfo) {
        if (compatibilityInfo != null) {
            this.mCompatibilityInfo = compatibilityInfo;
            this.updateConfiguration(this.mConfiguration, this.mMetrics);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void startPreloading() {
        Object object = sSync;
        synchronized (object) {
            if (sPreloaded) {
                throw new IllegalStateException("Resources already preloaded");
            }
            sPreloaded = true;
            this.mPreloading = true;
            this.mConfiguration.densityDpi = sPreloadedDensity = DisplayMetrics.DENSITY_DEVICE;
            this.updateConfiguration(null, null);
            return;
        }
    }

    public void updateConfiguration(Configuration configuration, DisplayMetrics displayMetrics) {
        this.updateConfiguration(configuration, displayMetrics, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateConfiguration(Configuration configuration, DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo) {
        Object object = this.mAccessLock;
        synchronized (object) {
            int n;
            int n2;
            int n3;
            if (compatibilityInfo != null) {
                this.mCompatibilityInfo = compatibilityInfo;
            }
            if (displayMetrics != null) {
                this.mMetrics.setTo(displayMetrics);
            }
            this.mCompatibilityInfo.applyToDisplayMetrics(this.mMetrics);
            int n4 = 0xFFFFFFF;
            if (configuration != null) {
                int n5;
                this.mTmpConfig.setTo(configuration);
                int n6 = configuration.densityDpi;
                if (n6 == 0) {
                    n6 = this.mMetrics.noncompatDensityDpi;
                }
                CompatibilityInfo compatibilityInfo2 = this.mCompatibilityInfo;
                Configuration configuration2 = this.mTmpConfig;
                compatibilityInfo2.applyToConfiguration(n6, configuration2);
                if (this.mTmpConfig.locale == null) {
                    this.mTmpConfig.locale = Locale.getDefault();
                    this.mTmpConfig.setLayoutDirection(this.mTmpConfig.locale);
                }
                boolean bl = (0x8000 & (n5 = this.mConfiguration.updateFrom(this.mTmpConfig))) != 0;
                int n7 = ActivityInfo.activityInfoConfigToNative(n5);
                int n8 = bl ? 32768 : 0;
                n4 = n7 | n8;
            }
            if (this.mConfiguration.locale == null) {
                this.mConfiguration.locale = Locale.getDefault();
                this.mConfiguration.setLayoutDirection(this.mConfiguration.locale);
            }
            if (this.mConfiguration.densityDpi != 0) {
                this.mMetrics.densityDpi = this.mConfiguration.densityDpi;
                this.mMetrics.density = 0.00625f * (float)this.mConfiguration.densityDpi;
            }
            this.mMetrics.scaledDensity = this.mMetrics.density * this.mConfiguration.fontScale;
            Locale locale = this.mConfiguration.locale;
            String string2 = null;
            if (locale != null) {
                string2 = Resources.adjustLanguageTag(this.mConfiguration.locale.toLanguageTag());
            }
            if (this.mMetrics.widthPixels >= this.mMetrics.heightPixels) {
                n3 = this.mMetrics.widthPixels;
                n2 = this.mMetrics.heightPixels;
            } else {
                n3 = this.mMetrics.heightPixels;
                n2 = this.mMetrics.widthPixels;
            }
            if ((n = this.mConfiguration.keyboardHidden) == 1 && this.mConfiguration.hardKeyboardHidden == 2) {
                n = 3;
            }
            this.mAssets.setConfiguration(this.mConfiguration.mcc, this.mConfiguration.mnc, string2, this.mConfiguration.orientation, this.mConfiguration.touchscreen, this.mConfiguration.densityDpi, this.mConfiguration.keyboard, n, this.mConfiguration.navigation, n3, n2, this.mConfiguration.smallestScreenWidthDp, this.mConfiguration.screenWidthDp, this.mConfiguration.screenHeightDp, this.mConfiguration.screenLayout, this.mConfiguration.uiMode, Build.VERSION.RESOURCES_SDK_INT);
            this.clearDrawableCachesLocked(this.mDrawableCache, n4);
            this.clearDrawableCachesLocked(this.mColorDrawableCache, n4);
            this.mColorStateListCache.clear();
            this.flushLayoutCache();
        }
        Object object2 = sSync;
        synchronized (object2) {
            if (this.mPluralRule != null) {
                this.mPluralRule = NativePluralRules.forLocale((Locale)configuration.locale);
            }
            return;
        }
    }

    public static class NotFoundException
    extends RuntimeException {
        public NotFoundException() {
        }

        public NotFoundException(String string2) {
            super(string2);
        }
    }

    public final class Theme {
        private final AssetManager mAssets;
        private String mKey = "";
        private final long mTheme;
        private int mThemeResId = 0;

        Theme() {
            this.mAssets = Resources.this.mAssets;
            this.mTheme = this.mAssets.createTheme();
        }

        private String getResourceNameFromHexString(String string2) {
            return Resources.this.getResourceName(Integer.parseInt(string2, 16));
        }

        /*
         * Enabled aggressive block sorting
         */
        public void applyStyle(int n, boolean bl) {
            AssetManager.applyThemeStyle(this.mTheme, n, bl);
            this.mThemeResId = n;
            StringBuilder stringBuilder = new StringBuilder().append(this.mKey).append(Integer.toHexString(n));
            String string2 = bl ? "! " : " ";
            this.mKey = stringBuilder.append(string2).toString();
        }

        public void dump(int n, String string2, String string3) {
            AssetManager.dumpTheme(this.mTheme, n, string2, string3);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.mAssets.releaseTheme(this.mTheme);
        }

        public int[] getAllAttributes() {
            return this.mAssets.getStyleAttributes(this.getAppliedStyleResId());
        }

        int getAppliedStyleResId() {
            return this.mThemeResId;
        }

        public Drawable getDrawable(int n) throws NotFoundException {
            return Resources.this.getDrawable(n, this);
        }

        String getKey() {
            return this.mKey;
        }

        long getNativeTheme() {
            return this.mTheme;
        }

        public Resources getResources() {
            return Resources.this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @ViewDebug.ExportedProperty(category="theme", hasAdjacentMapping=true)
        public String[] getTheme() {
            String[] stringArray = this.mKey.split(" ");
            String[] stringArray2 = new String[2 * stringArray.length];
            int n = 0;
            int n2 = -1 + stringArray.length;
            while (n < stringArray2.length) {
                String string2 = stringArray[n2];
                boolean bl = string2.endsWith("!");
                String string3 = bl ? this.getResourceNameFromHexString(string2.substring(0, -1 + string2.length())) : this.getResourceNameFromHexString(string2);
                stringArray2[n] = string3;
                int n3 = n + 1;
                String string4 = bl ? "forced" : "not forced";
                stringArray2[n3] = string4;
                n += 2;
                --n2;
            }
            return stringArray2;
        }

        public TypedArray obtainStyledAttributes(int n, int[] nArray) throws NotFoundException {
            int n2 = nArray.length;
            TypedArray typedArray = TypedArray.obtain(Resources.this, n2);
            typedArray.mTheme = this;
            AssetManager.applyStyle(this.mTheme, 0, n, 0L, nArray, typedArray.mData, typedArray.mIndices);
            return typedArray;
        }

        /*
         * Enabled aggressive block sorting
         */
        public TypedArray obtainStyledAttributes(AttributeSet attributeSet, int[] nArray, int n, int n2) {
            int n3 = nArray.length;
            TypedArray typedArray = TypedArray.obtain(Resources.this, n3);
            XmlBlock.Parser parser = (XmlBlock.Parser)attributeSet;
            long l = this.mTheme;
            long l2 = parser != null ? parser.mParseState : 0L;
            AssetManager.applyStyle(l, n, n2, l2, nArray, typedArray.mData, typedArray.mIndices);
            typedArray.mTheme = this;
            typedArray.mXml = parser;
            return typedArray;
        }

        public TypedArray obtainStyledAttributes(int[] nArray) {
            int n = nArray.length;
            TypedArray typedArray = TypedArray.obtain(Resources.this, n);
            typedArray.mTheme = this;
            AssetManager.applyStyle(this.mTheme, 0, 0, 0L, nArray, typedArray.mData, typedArray.mIndices);
            return typedArray;
        }

        public boolean resolveAttribute(int n, TypedValue typedValue, boolean bl) {
            return this.mAssets.getThemeValue(this.mTheme, n, typedValue, bl);
        }

        public TypedArray resolveAttributes(int[] nArray, int[] nArray2) {
            int n = nArray2.length;
            if (nArray != null && n != nArray.length) {
                throw new IllegalArgumentException("Base attribute values must be null or the same length as attrs");
            }
            TypedArray typedArray = TypedArray.obtain(Resources.this, n);
            AssetManager.resolveAttrs(this.mTheme, 0, 0, nArray, nArray2, typedArray.mData, typedArray.mIndices);
            typedArray.mTheme = this;
            typedArray.mXml = null;
            return typedArray;
        }

        public void setTo(Theme theme) {
            AssetManager.copyTheme(this.mTheme, theme.mTheme);
            this.mThemeResId = theme.mThemeResId;
            this.mKey = theme.mKey;
        }
    }
}

