/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.util.AndroidException;
import android.util.Log;
import android.util.Printer;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class IntentFilter
implements Parcelable {
    private static final String ACTION_STR = "action";
    private static final String AUTH_STR = "auth";
    private static final String CAT_STR = "cat";
    public static final Parcelable.Creator<IntentFilter> CREATOR = new Parcelable.Creator<IntentFilter>(){

        @Override
        public IntentFilter createFromParcel(Parcel parcel) {
            return new IntentFilter(parcel);
        }

        public IntentFilter[] newArray(int n) {
            return new IntentFilter[n];
        }
    };
    private static final String HOST_STR = "host";
    private static final String LITERAL_STR = "literal";
    public static final int MATCH_ADJUSTMENT_MASK = 65535;
    public static final int MATCH_ADJUSTMENT_NORMAL = 32768;
    public static final int MATCH_CATEGORY_EMPTY = 0x100000;
    public static final int MATCH_CATEGORY_HOST = 0x300000;
    public static final int MATCH_CATEGORY_MASK = 0xFFF0000;
    public static final int MATCH_CATEGORY_PATH = 0x500000;
    public static final int MATCH_CATEGORY_PORT = 0x400000;
    public static final int MATCH_CATEGORY_SCHEME = 0x200000;
    public static final int MATCH_CATEGORY_SCHEME_SPECIFIC_PART = 0x580000;
    public static final int MATCH_CATEGORY_TYPE = 0x600000;
    private static final String NAME_STR = "name";
    public static final int NO_MATCH_ACTION = -3;
    public static final int NO_MATCH_CATEGORY = -4;
    public static final int NO_MATCH_DATA = -2;
    public static final int NO_MATCH_TYPE = -1;
    private static final String PATH_STR = "path";
    private static final String PORT_STR = "port";
    private static final String PREFIX_STR = "prefix";
    private static final String SCHEME_STR = "scheme";
    private static final String SGLOB_STR = "sglob";
    private static final String SSP_STR = "ssp";
    public static final int SYSTEM_HIGH_PRIORITY = 1000;
    public static final int SYSTEM_LOW_PRIORITY = -1000;
    private static final String TYPE_STR = "type";
    private final ArrayList<String> mActions;
    private ArrayList<String> mCategories = null;
    private ArrayList<AuthorityEntry> mDataAuthorities = null;
    private ArrayList<PatternMatcher> mDataPaths = null;
    private ArrayList<PatternMatcher> mDataSchemeSpecificParts = null;
    private ArrayList<String> mDataSchemes = null;
    private ArrayList<String> mDataTypes = null;
    private boolean mHasPartialTypes = false;
    private int mPriority;

    public IntentFilter() {
        this.mPriority = 0;
        this.mActions = new ArrayList();
    }

    public IntentFilter(IntentFilter intentFilter) {
        this.mPriority = intentFilter.mPriority;
        this.mActions = new ArrayList<String>(intentFilter.mActions);
        if (intentFilter.mCategories != null) {
            this.mCategories = new ArrayList<String>(intentFilter.mCategories);
        }
        if (intentFilter.mDataTypes != null) {
            this.mDataTypes = new ArrayList<String>(intentFilter.mDataTypes);
        }
        if (intentFilter.mDataSchemes != null) {
            this.mDataSchemes = new ArrayList<String>(intentFilter.mDataSchemes);
        }
        if (intentFilter.mDataSchemeSpecificParts != null) {
            this.mDataSchemeSpecificParts = new ArrayList<PatternMatcher>(intentFilter.mDataSchemeSpecificParts);
        }
        if (intentFilter.mDataAuthorities != null) {
            this.mDataAuthorities = new ArrayList<AuthorityEntry>(intentFilter.mDataAuthorities);
        }
        if (intentFilter.mDataPaths != null) {
            this.mDataPaths = new ArrayList<PatternMatcher>(intentFilter.mDataPaths);
        }
        this.mHasPartialTypes = intentFilter.mHasPartialTypes;
    }

    private IntentFilter(Parcel parcel) {
        int n;
        int n2;
        int n3;
        this.mActions = new ArrayList();
        parcel.readStringList(this.mActions);
        if (parcel.readInt() != 0) {
            this.mCategories = new ArrayList();
            parcel.readStringList(this.mCategories);
        }
        if (parcel.readInt() != 0) {
            this.mDataSchemes = new ArrayList();
            parcel.readStringList(this.mDataSchemes);
        }
        if (parcel.readInt() != 0) {
            this.mDataTypes = new ArrayList();
            parcel.readStringList(this.mDataTypes);
        }
        if ((n3 = parcel.readInt()) > 0) {
            this.mDataSchemeSpecificParts = new ArrayList(n3);
            for (int i = 0; i < n3; ++i) {
                this.mDataSchemeSpecificParts.add(new PatternMatcher(parcel));
            }
        }
        if ((n2 = parcel.readInt()) > 0) {
            this.mDataAuthorities = new ArrayList(n2);
            for (int i = 0; i < n2; ++i) {
                this.mDataAuthorities.add(new AuthorityEntry(parcel));
            }
        }
        if ((n = parcel.readInt()) > 0) {
            this.mDataPaths = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                this.mDataPaths.add(new PatternMatcher(parcel));
            }
        }
        this.mPriority = parcel.readInt();
        int n4 = parcel.readInt();
        boolean bl = false;
        if (n4 > 0) {
            bl = true;
        }
        this.mHasPartialTypes = bl;
    }

    public IntentFilter(String string2) {
        this.mPriority = 0;
        this.mActions = new ArrayList();
        this.addAction(string2);
    }

    public IntentFilter(String string2, String string3) throws MalformedMimeTypeException {
        this.mPriority = 0;
        this.mActions = new ArrayList();
        this.addAction(string2);
        this.addDataType(string3);
    }

    private static String[] addStringToSet(String[] stringArray, String string2, int[] nArray, int n) {
        if (IntentFilter.findStringInSet(stringArray, string2, nArray, n) >= 0) {
            return stringArray;
        }
        if (stringArray == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = string2;
            nArray[n] = 1;
            return stringArray2;
        }
        int n2 = nArray[n];
        if (n2 < stringArray.length) {
            stringArray[n2] = string2;
            nArray[n] = n2 + 1;
            return stringArray;
        }
        String[] stringArray3 = new String[2 + n2 * 3 / 2];
        System.arraycopy(stringArray, 0, stringArray3, 0, n2);
        stringArray3[n2] = string2;
        nArray[n] = n2 + 1;
        return stringArray3;
    }

    public static IntentFilter create(String string2, String string3) {
        try {
            IntentFilter intentFilter = new IntentFilter(string2, string3);
            return intentFilter;
        }
        catch (MalformedMimeTypeException malformedMimeTypeException) {
            throw new RuntimeException("Bad MIME type", malformedMimeTypeException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean findMimeType(String string2) {
        int n;
        boolean bl = true;
        ArrayList<String> arrayList = this.mDataTypes;
        if (string2 == null) {
            return false;
        }
        if (arrayList.contains(string2)) return bl;
        int n2 = string2.length();
        if (n2 == 3 && string2.equals("*/*")) {
            if (!arrayList.isEmpty()) return bl;
            return false;
        }
        if (this.mHasPartialTypes) {
            if (arrayList.contains("*")) return bl;
        }
        if ((n = string2.indexOf(47)) <= 0) return false;
        if (this.mHasPartialTypes) {
            if (arrayList.contains(string2.substring(0, n))) return bl;
        }
        if (n2 != n + 2) return false;
        if (string2.charAt(n + 1) != '*') return false;
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            if (string2.regionMatches(0, arrayList.get(n4), 0, n + 1)) return bl;
            ++n4;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findStringInSet(String[] stringArray, String string2, int[] nArray, int n) {
        if (stringArray == null) {
            return -1;
        }
        int n2 = nArray[n];
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray[n3].equals(string2)) return n3;
            ++n3;
        }
        return -1;
    }

    private static String[] removeStringFromSet(String[] stringArray, String string2, int[] nArray, int n) {
        int n2 = IntentFilter.findStringInSet(stringArray, string2, nArray, n);
        if (n2 < 0) {
            return stringArray;
        }
        int n3 = nArray[n];
        if (n3 > stringArray.length / 4) {
            int n4 = n3 - (n2 + 1);
            if (n4 > 0) {
                System.arraycopy(stringArray, n2 + 1, stringArray, n2, n4);
            }
            stringArray[n3 - 1] = null;
            nArray[n] = n3 - 1;
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length / 3];
        if (n2 > 0) {
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        }
        if (n2 + 1 < n3) {
            System.arraycopy(stringArray, n2 + 1, stringArray2, n2, n3 - (n2 + 1));
        }
        return stringArray2;
    }

    public final Iterator<String> actionsIterator() {
        if (this.mActions != null) {
            return this.mActions.iterator();
        }
        return null;
    }

    public final void addAction(String string2) {
        if (!this.mActions.contains(string2)) {
            this.mActions.add(string2.intern());
        }
    }

    public final void addCategory(String string2) {
        if (this.mCategories == null) {
            this.mCategories = new ArrayList();
        }
        if (!this.mCategories.contains(string2)) {
            this.mCategories.add(string2.intern());
        }
    }

    public final void addDataAuthority(AuthorityEntry authorityEntry) {
        if (this.mDataAuthorities == null) {
            this.mDataAuthorities = new ArrayList();
        }
        this.mDataAuthorities.add(authorityEntry);
    }

    public final void addDataAuthority(String string2, String string3) {
        if (string3 != null) {
            string3 = string3.intern();
        }
        this.addDataAuthority(new AuthorityEntry(string2.intern(), string3));
    }

    public final void addDataPath(PatternMatcher patternMatcher) {
        if (this.mDataPaths == null) {
            this.mDataPaths = new ArrayList();
        }
        this.mDataPaths.add(patternMatcher);
    }

    public final void addDataPath(String string2, int n) {
        this.addDataPath(new PatternMatcher(string2.intern(), n));
    }

    public final void addDataScheme(String string2) {
        if (this.mDataSchemes == null) {
            this.mDataSchemes = new ArrayList();
        }
        if (!this.mDataSchemes.contains(string2)) {
            this.mDataSchemes.add(string2.intern());
        }
    }

    public final void addDataSchemeSpecificPart(PatternMatcher patternMatcher) {
        if (this.mDataSchemeSpecificParts == null) {
            this.mDataSchemeSpecificParts = new ArrayList();
        }
        this.mDataSchemeSpecificParts.add(patternMatcher);
    }

    public final void addDataSchemeSpecificPart(String string2, int n) {
        this.addDataSchemeSpecificPart(new PatternMatcher(string2, n));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void addDataType(String string2) throws MalformedMimeTypeException {
        int n = string2.indexOf(47);
        int n2 = string2.length();
        if (n <= 0 || n2 < n + 2) throw new MalformedMimeTypeException(string2);
        if (this.mDataTypes == null) {
            this.mDataTypes = new ArrayList();
        }
        if (n2 == n + 2 && string2.charAt(n + 1) == '*') {
            String string3 = string2.substring(0, n);
            if (!this.mDataTypes.contains(string3)) {
                this.mDataTypes.add(string3.intern());
            }
            this.mHasPartialTypes = true;
            return;
        } else {
            if (this.mDataTypes.contains(string2)) return;
            this.mDataTypes.add(string2.intern());
            return;
        }
    }

    public final Iterator<AuthorityEntry> authoritiesIterator() {
        if (this.mDataAuthorities != null) {
            return this.mDataAuthorities.iterator();
        }
        return null;
    }

    public final Iterator<String> categoriesIterator() {
        if (this.mCategories != null) {
            return this.mCategories.iterator();
        }
        return null;
    }

    public final int countActions() {
        return this.mActions.size();
    }

    public final int countCategories() {
        if (this.mCategories != null) {
            return this.mCategories.size();
        }
        return 0;
    }

    public final int countDataAuthorities() {
        if (this.mDataAuthorities != null) {
            return this.mDataAuthorities.size();
        }
        return 0;
    }

    public final int countDataPaths() {
        if (this.mDataPaths != null) {
            return this.mDataPaths.size();
        }
        return 0;
    }

    public final int countDataSchemeSpecificParts() {
        if (this.mDataSchemeSpecificParts != null) {
            return this.mDataSchemeSpecificParts.size();
        }
        return 0;
    }

    public final int countDataSchemes() {
        if (this.mDataSchemes != null) {
            return this.mDataSchemes.size();
        }
        return 0;
    }

    public final int countDataTypes() {
        if (this.mDataTypes != null) {
            return this.mDataTypes.size();
        }
        return 0;
    }

    public boolean debugCheck() {
        return true;
    }

    @Override
    public final int describeContents() {
        return 0;
    }

    public void dump(Printer printer, String string2) {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (this.mActions.size() > 0) {
            Iterator<String> iterator = this.mActions.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Action: \"");
                stringBuilder.append(iterator.next());
                stringBuilder.append("\"");
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mCategories != null) {
            Iterator<String> iterator = this.mCategories.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Category: \"");
                stringBuilder.append(iterator.next());
                stringBuilder.append("\"");
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mDataSchemes != null) {
            Iterator<String> iterator = this.mDataSchemes.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Scheme: \"");
                stringBuilder.append(iterator.next());
                stringBuilder.append("\"");
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mDataSchemeSpecificParts != null) {
            for (PatternMatcher patternMatcher : this.mDataSchemeSpecificParts) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Ssp: \"");
                stringBuilder.append(patternMatcher);
                stringBuilder.append("\"");
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mDataAuthorities != null) {
            for (AuthorityEntry authorityEntry : this.mDataAuthorities) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Authority: \"");
                stringBuilder.append(authorityEntry.mHost);
                stringBuilder.append("\": ");
                stringBuilder.append(authorityEntry.mPort);
                if (authorityEntry.mWild) {
                    stringBuilder.append(" WILD");
                }
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mDataPaths != null) {
            for (PatternMatcher patternMatcher : this.mDataPaths) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Path: \"");
                stringBuilder.append(patternMatcher);
                stringBuilder.append("\"");
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mDataTypes != null) {
            Iterator<String> iterator = this.mDataTypes.iterator();
            while (iterator.hasNext()) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                stringBuilder.append("Type: \"");
                stringBuilder.append(iterator.next());
                stringBuilder.append("\"");
                printer.println(stringBuilder.toString());
            }
        }
        if (this.mPriority != 0 || this.mHasPartialTypes) {
            stringBuilder.setLength(0);
            stringBuilder.append(string2);
            stringBuilder.append("mPriority=");
            stringBuilder.append(this.mPriority);
            stringBuilder.append(", mHasPartialTypes=");
            stringBuilder.append(this.mHasPartialTypes);
            printer.println(stringBuilder.toString());
        }
    }

    public final String getAction(int n) {
        return this.mActions.get(n);
    }

    public final String getCategory(int n) {
        return this.mCategories.get(n);
    }

    public final AuthorityEntry getDataAuthority(int n) {
        return this.mDataAuthorities.get(n);
    }

    public final PatternMatcher getDataPath(int n) {
        return this.mDataPaths.get(n);
    }

    public final String getDataScheme(int n) {
        return this.mDataSchemes.get(n);
    }

    public final PatternMatcher getDataSchemeSpecificPart(int n) {
        return this.mDataSchemeSpecificParts.get(n);
    }

    public final String getDataType(int n) {
        return this.mDataTypes.get(n);
    }

    public final int getPriority() {
        return this.mPriority;
    }

    public final boolean hasAction(String string2) {
        return string2 != null && this.mActions.contains(string2);
    }

    public final boolean hasCategory(String string2) {
        return this.mCategories != null && this.mCategories.contains(string2);
    }

    public final boolean hasDataAuthority(AuthorityEntry authorityEntry) {
        if (this.mDataAuthorities == null) {
            return false;
        }
        int n = this.mDataAuthorities.size();
        for (int i = 0; i < n; ++i) {
            if (!this.mDataAuthorities.get(i).match(authorityEntry)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasDataAuthority(Uri uri) {
        return this.matchDataAuthority(uri) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean hasDataPath(PatternMatcher patternMatcher) {
        if (this.mDataPaths != null) {
            int n = this.mDataPaths.size();
            for (int i = 0; i < n; ++i) {
                PatternMatcher patternMatcher2 = this.mDataPaths.get(i);
                if (patternMatcher2.getType() != patternMatcher.getType() || !patternMatcher2.getPath().equals(patternMatcher.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean hasDataPath(String string2) {
        if (this.mDataPaths != null) {
            int n = this.mDataPaths.size();
            for (int i = 0; i < n; ++i) {
                if (!this.mDataPaths.get(i).match(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasDataScheme(String string2) {
        return this.mDataSchemes != null && this.mDataSchemes.contains(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean hasDataSchemeSpecificPart(PatternMatcher patternMatcher) {
        if (this.mDataSchemeSpecificParts != null) {
            int n = this.mDataSchemeSpecificParts.size();
            for (int i = 0; i < n; ++i) {
                PatternMatcher patternMatcher2 = this.mDataSchemeSpecificParts.get(i);
                if (patternMatcher2.getType() != patternMatcher.getType() || !patternMatcher2.getPath().equals(patternMatcher.getPath())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean hasDataSchemeSpecificPart(String string2) {
        if (this.mDataSchemeSpecificParts != null) {
            int n = this.mDataSchemeSpecificParts.size();
            for (int i = 0; i < n; ++i) {
                if (!this.mDataSchemeSpecificParts.get(i).match(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean hasDataType(String string2) {
        return this.mDataTypes != null && this.findMimeType(string2);
    }

    public final boolean hasExactDataType(String string2) {
        return this.mDataTypes != null && this.mDataTypes.contains(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int match(ContentResolver contentResolver, Intent intent, boolean bl, String string2) {
        String string3;
        if (bl) {
            string3 = intent.resolveType(contentResolver);
            return this.match(intent.getAction(), string3, intent.getScheme(), intent.getData(), intent.getCategories(), string2);
        }
        string3 = intent.getType();
        return this.match(intent.getAction(), string3, intent.getScheme(), intent.getData(), intent.getCategories(), string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int match(String string2, String string3, String string4, Uri uri, Set<String> set, String string5) {
        if (string2 != null && !this.matchAction(string2)) {
            return -3;
        }
        int n = this.matchData(string3, string4, uri);
        if (n < 0) return n;
        if (this.matchCategories(set) == null) return n;
        return -4;
    }

    public final boolean matchAction(String string2) {
        return this.hasAction(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String matchCategories(Set<String> set) {
        String string2;
        if (set == null) return null;
        Iterator<String> iterator = set.iterator();
        if (this.mCategories == null) {
            if (!iterator.hasNext()) return null;
            return iterator.next();
        }
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (this.mCategories.contains(string2 = iterator.next()));
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int matchData(String string2, String string3, Uri uri) {
        int n = -2;
        ArrayList<String> arrayList = this.mDataTypes;
        ArrayList<String> arrayList2 = this.mDataSchemes;
        int n2 = 0x100000;
        if (arrayList == null && arrayList2 == null) {
            if (string2 != null) return n;
            if (uri != null) return n;
            return 0x108000;
        }
        if (arrayList2 != null) {
            if (string3 == null) {
                string3 = "";
            }
            if (!arrayList2.contains(string3)) return n;
            n2 = 0x200000;
            if (this.mDataSchemeSpecificParts != null) {
                n2 = this.hasDataSchemeSpecificPart(uri.getSchemeSpecificPart()) ? 0x580000 : n;
            }
            if (n2 != 0x580000 && this.mDataAuthorities != null) {
                int n3 = this.matchDataAuthority(uri);
                if (n3 < 0) return n;
                if (this.mDataPaths == null) {
                    n2 = n3;
                } else {
                    if (!this.hasDataPath(uri.getPath())) return n;
                    n2 = 0x500000;
                }
            }
            if (n2 == n) {
                return n;
            }
        } else if (!(string3 == null || "".equals(string3) || "content".equals(string3) || "file".equals(string3))) {
            return n;
        }
        if (arrayList != null) {
            if (this.findMimeType(string2)) return 0x608000;
            return -1;
        }
        if (string2 == null) return 32768 + n2;
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int matchDataAuthority(Uri uri) {
        if (this.mDataAuthorities == null) {
            return -2;
        }
        int n = this.mDataAuthorities.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.mDataAuthorities.get(n2).match(uri);
            if (n3 >= 0) return n3;
            ++n2;
        }
        return -2;
    }

    public final Iterator<PatternMatcher> pathsIterator() {
        if (this.mDataPaths != null) {
            return this.mDataPaths.iterator();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFromXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n;
        int n2 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n2)) {
            block15: {
                String string2;
                block22: {
                    block23: {
                        block21: {
                            block19: {
                                block20: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                block14: {
                                                    if (n == 3 || n == 4) continue;
                                                    string2 = xmlPullParser.getName();
                                                    if (!string2.equals(ACTION_STR)) break block14;
                                                    String string3 = xmlPullParser.getAttributeValue(null, NAME_STR);
                                                    if (string3 != null) {
                                                        this.addAction(string3);
                                                    }
                                                    break block15;
                                                }
                                                if (!string2.equals(CAT_STR)) break block16;
                                                String string4 = xmlPullParser.getAttributeValue(null, NAME_STR);
                                                if (string4 != null) {
                                                    this.addCategory(string4);
                                                }
                                                break block15;
                                            }
                                            if (!string2.equals(TYPE_STR)) break block17;
                                            String string5 = xmlPullParser.getAttributeValue(null, NAME_STR);
                                            if (string5 != null) {
                                                try {
                                                    this.addDataType(string5);
                                                }
                                                catch (MalformedMimeTypeException malformedMimeTypeException) {}
                                            }
                                            break block15;
                                        }
                                        if (!string2.equals(SCHEME_STR)) break block18;
                                        String string6 = xmlPullParser.getAttributeValue(null, NAME_STR);
                                        if (string6 != null) {
                                            this.addDataScheme(string6);
                                        }
                                        break block15;
                                    }
                                    if (!string2.equals(SSP_STR)) break block19;
                                    String string7 = xmlPullParser.getAttributeValue(null, LITERAL_STR);
                                    if (string7 == null) break block20;
                                    this.addDataSchemeSpecificPart(string7, 0);
                                    break block15;
                                }
                                String string8 = xmlPullParser.getAttributeValue(null, PREFIX_STR);
                                if (string8 != null) {
                                    this.addDataSchemeSpecificPart(string8, 1);
                                    break block15;
                                } else {
                                    String string9 = xmlPullParser.getAttributeValue(null, SGLOB_STR);
                                    if (string9 != null) {
                                        this.addDataSchemeSpecificPart(string9, 2);
                                    }
                                }
                                break block15;
                            }
                            if (!string2.equals(AUTH_STR)) break block21;
                            String string10 = xmlPullParser.getAttributeValue(null, HOST_STR);
                            String string11 = xmlPullParser.getAttributeValue(null, PORT_STR);
                            if (string10 != null) {
                                this.addDataAuthority(string10, string11);
                            }
                            break block15;
                        }
                        if (!string2.equals(PATH_STR)) break block22;
                        String string12 = xmlPullParser.getAttributeValue(null, LITERAL_STR);
                        if (string12 == null) break block23;
                        this.addDataPath(string12, 0);
                        break block15;
                    }
                    String string13 = xmlPullParser.getAttributeValue(null, PREFIX_STR);
                    if (string13 != null) {
                        this.addDataPath(string13, 1);
                        break block15;
                    } else {
                        String string14 = xmlPullParser.getAttributeValue(null, SGLOB_STR);
                        if (string14 != null) {
                            this.addDataPath(string14, 2);
                        }
                    }
                    break block15;
                }
                Log.w("IntentFilter", "Unknown tag parsing IntentFilter: " + string2);
            }
            XmlUtils.skipCurrentTag(xmlPullParser);
        }
    }

    public final Iterator<PatternMatcher> schemeSpecificPartsIterator() {
        if (this.mDataSchemeSpecificParts != null) {
            return this.mDataSchemeSpecificParts.iterator();
        }
        return null;
    }

    public final Iterator<String> schemesIterator() {
        if (this.mDataSchemes != null) {
            return this.mDataSchemes.iterator();
        }
        return null;
    }

    public final void setPriority(int n) {
        this.mPriority = n;
    }

    public final Iterator<String> typesIterator() {
        if (this.mDataTypes != null) {
            return this.mDataTypes.iterator();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void writeToParcel(Parcel parcel, int n) {
        parcel.writeStringList(this.mActions);
        if (this.mCategories != null) {
            parcel.writeInt(1);
            parcel.writeStringList(this.mCategories);
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataSchemes != null) {
            parcel.writeInt(1);
            parcel.writeStringList(this.mDataSchemes);
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataTypes != null) {
            parcel.writeInt(1);
            parcel.writeStringList(this.mDataTypes);
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataSchemeSpecificParts != null) {
            int n2 = this.mDataSchemeSpecificParts.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                this.mDataSchemeSpecificParts.get(i).writeToParcel(parcel, n);
            }
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataAuthorities != null) {
            int n3 = this.mDataAuthorities.size();
            parcel.writeInt(n3);
            for (int i = 0; i < n3; ++i) {
                this.mDataAuthorities.get(i).writeToParcel(parcel);
            }
        } else {
            parcel.writeInt(0);
        }
        if (this.mDataPaths != null) {
            int n4 = this.mDataPaths.size();
            parcel.writeInt(n4);
            for (int i = 0; i < n4; ++i) {
                this.mDataPaths.get(i).writeToParcel(parcel, n);
            }
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mPriority);
        int n5 = this.mHasPartialTypes ? 1 : 0;
        parcel.writeInt(n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeToXml(XmlSerializer xmlSerializer) throws IOException {
        int n = this.countActions();
        for (int i = 0; i < n; ++i) {
            xmlSerializer.startTag(null, ACTION_STR);
            xmlSerializer.attribute(null, NAME_STR, this.mActions.get(i));
            xmlSerializer.endTag(null, ACTION_STR);
        }
        int n2 = this.countCategories();
        for (int i = 0; i < n2; ++i) {
            xmlSerializer.startTag(null, CAT_STR);
            xmlSerializer.attribute(null, NAME_STR, this.mCategories.get(i));
            xmlSerializer.endTag(null, CAT_STR);
        }
        int n3 = this.countDataTypes();
        for (int i = 0; i < n3; ++i) {
            xmlSerializer.startTag(null, TYPE_STR);
            String string2 = this.mDataTypes.get(i);
            if (string2.indexOf(47) < 0) {
                string2 = string2 + "/*";
            }
            xmlSerializer.attribute(null, NAME_STR, string2);
            xmlSerializer.endTag(null, TYPE_STR);
        }
        int n4 = this.countDataSchemes();
        for (int i = 0; i < n4; ++i) {
            xmlSerializer.startTag(null, SCHEME_STR);
            xmlSerializer.attribute(null, NAME_STR, this.mDataSchemes.get(i));
            xmlSerializer.endTag(null, SCHEME_STR);
        }
        int n5 = this.countDataSchemeSpecificParts();
        for (int i = 0; i < n5; ++i) {
            xmlSerializer.startTag(null, SSP_STR);
            PatternMatcher patternMatcher = this.mDataSchemeSpecificParts.get(i);
            switch (patternMatcher.getType()) {
                case 0: {
                    xmlSerializer.attribute(null, LITERAL_STR, patternMatcher.getPath());
                    break;
                }
                case 1: {
                    xmlSerializer.attribute(null, PREFIX_STR, patternMatcher.getPath());
                    break;
                }
                case 2: {
                    xmlSerializer.attribute(null, SGLOB_STR, patternMatcher.getPath());
                    break;
                }
            }
            xmlSerializer.endTag(null, SSP_STR);
        }
        int n6 = this.countDataAuthorities();
        for (int i = 0; i < n6; ++i) {
            xmlSerializer.startTag(null, AUTH_STR);
            AuthorityEntry authorityEntry = this.mDataAuthorities.get(i);
            xmlSerializer.attribute(null, HOST_STR, authorityEntry.getHost());
            if (authorityEntry.getPort() >= 0) {
                xmlSerializer.attribute(null, PORT_STR, Integer.toString(authorityEntry.getPort()));
            }
            xmlSerializer.endTag(null, AUTH_STR);
        }
        int n7 = this.countDataPaths();
        int n8 = 0;
        while (n8 < n7) {
            xmlSerializer.startTag(null, PATH_STR);
            PatternMatcher patternMatcher = this.mDataPaths.get(n8);
            switch (patternMatcher.getType()) {
                case 0: {
                    xmlSerializer.attribute(null, LITERAL_STR, patternMatcher.getPath());
                    break;
                }
                case 1: {
                    xmlSerializer.attribute(null, PREFIX_STR, patternMatcher.getPath());
                    break;
                }
                case 2: {
                    xmlSerializer.attribute(null, SGLOB_STR, patternMatcher.getPath());
                    break;
                }
            }
            xmlSerializer.endTag(null, PATH_STR);
            ++n8;
        }
        return;
    }

    public static final class AuthorityEntry {
        private final String mHost;
        private final String mOrigHost;
        private final int mPort;
        private final boolean mWild;

        /*
         * Enabled aggressive block sorting
         */
        AuthorityEntry(Parcel parcel) {
            this.mOrigHost = parcel.readString();
            this.mHost = parcel.readString();
            boolean bl = parcel.readInt() != 0;
            this.mWild = bl;
            this.mPort = parcel.readInt();
        }

        /*
         * Enabled aggressive block sorting
         */
        public AuthorityEntry(String string2, String string3) {
            this.mOrigHost = string2;
            int n = string2.length();
            boolean bl = false;
            if (n > 0) {
                char c = string2.charAt(0);
                bl = false;
                if (c == '*') {
                    bl = true;
                }
            }
            this.mWild = bl;
            if (this.mWild) {
                string2 = string2.substring(1).intern();
            }
            this.mHost = string2;
            int n2 = string3 != null ? Integer.parseInt(string3) : -1;
            this.mPort = n2;
        }

        public String getHost() {
            return this.mOrigHost;
        }

        public int getPort() {
            return this.mPort;
        }

        /*
         * Enabled aggressive block sorting
         */
        public int match(Uri uri) {
            block6: {
                block4: {
                    String string2;
                    block5: {
                        string2 = uri.getHost();
                        if (string2 == null) break block4;
                        if (!this.mWild) break block5;
                        if (string2.length() < this.mHost.length()) break block4;
                        string2 = string2.substring(string2.length() - this.mHost.length());
                    }
                    if (string2.compareToIgnoreCase(this.mHost) != 0) break block4;
                    if (this.mPort < 0) {
                        return 0x300000;
                    }
                    if (this.mPort == uri.getPort()) break block6;
                }
                return -2;
            }
            return 0x400000;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean match(AuthorityEntry authorityEntry) {
            return this.mWild == authorityEntry.mWild && this.mHost.equals(authorityEntry.mHost) && this.mPort == authorityEntry.mPort;
        }

        /*
         * Enabled aggressive block sorting
         */
        void writeToParcel(Parcel parcel) {
            parcel.writeString(this.mOrigHost);
            parcel.writeString(this.mHost);
            int n = this.mWild ? 1 : 0;
            parcel.writeInt(n);
            parcel.writeInt(this.mPort);
        }
    }

    public static class MalformedMimeTypeException
    extends AndroidException {
        public MalformedMimeTypeException() {
        }

        public MalformedMimeTypeException(String string2) {
            super(string2);
        }
    }
}

