/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import dalvik.system.CloseGuard;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class ContentProviderClient {
    private static final String TAG = "ContentProviderClient";
    @GuardedBy(value="ContentProviderClient.class")
    private static Handler sAnrHandler;
    private NotRespondingRunnable mAnrRunnable;
    private long mAnrTimeout;
    private final IContentProvider mContentProvider;
    private final ContentResolver mContentResolver;
    private final CloseGuard mGuard = CloseGuard.get();
    private final String mPackageName;
    private boolean mReleased;
    private final boolean mStable;

    ContentProviderClient(ContentResolver contentResolver, IContentProvider iContentProvider, boolean bl) {
        this.mContentResolver = contentResolver;
        this.mContentProvider = iContentProvider;
        this.mPackageName = contentResolver.mPackageName;
        this.mStable = bl;
        this.mGuard.open("release");
    }

    private void afterRemote() {
        if (this.mAnrRunnable != null) {
            sAnrHandler.removeCallbacks(this.mAnrRunnable);
        }
    }

    private void beforeRemote() {
        if (this.mAnrRunnable != null) {
            sAnrHandler.postDelayed(this.mAnrRunnable, this.mAnrTimeout);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseQuietly(ContentProviderClient contentProviderClient) {
        if (contentProviderClient == null) return;
        try {
            contentProviderClient.release();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> arrayList) throws RemoteException, OperationApplicationException {
        this.beforeRemote();
        try {
            ContentProviderResult[] contentProviderResultArray = this.mContentProvider.applyBatch(this.mPackageName, arrayList);
            return contentProviderResultArray;
        }
        catch (DeadObjectException deadObjectException) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw deadObjectException;
        }
        finally {
            this.afterRemote();
        }
    }

    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) throws RemoteException {
        this.beforeRemote();
        try {
            int n = this.mContentProvider.bulkInsert(this.mPackageName, uri, contentValuesArray);
            return n;
        }
        catch (DeadObjectException deadObjectException) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw deadObjectException;
        }
        finally {
            this.afterRemote();
        }
    }

    public Bundle call(String string2, String string3, Bundle bundle) throws RemoteException {
        this.beforeRemote();
        try {
            Bundle bundle2 = this.mContentProvider.call(this.mPackageName, string2, string3, bundle);
            return bundle2;
        }
        catch (DeadObjectException deadObjectException) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw deadObjectException;
        }
        finally {
            this.afterRemote();
        }
    }

    public final Uri canonicalize(Uri uri) throws RemoteException {
        this.beforeRemote();
        try {
            Uri uri2 = this.mContentProvider.canonicalize(this.mPackageName, uri);
            return uri2;
        }
        catch (DeadObjectException deadObjectException) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw deadObjectException;
        }
        finally {
            this.afterRemote();
        }
    }

    public int delete(Uri uri, String string2, String[] stringArray) throws RemoteException {
        this.beforeRemote();
        try {
            int n = this.mContentProvider.delete(this.mPackageName, uri, string2, stringArray);
            return n;
        }
        catch (DeadObjectException deadObjectException) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw deadObjectException;
        }
        finally {
            this.afterRemote();
        }
    }

    protected void finalize() throws Throwable {
        if (this.mGuard != null) {
            this.mGuard.warnIfOpen();
        }
    }

    public ContentProvider getLocalContentProvider() {
        return ContentProvider.coerceToLocalContentProvider(this.mContentProvider);
    }

    public String[] getStreamTypes(Uri uri, String string2) throws RemoteException {
        this.beforeRemote();
        try {
            String[] stringArray = this.mContentProvider.getStreamTypes(uri, string2);
            return stringArray;
        }
        catch (DeadObjectException deadObjectException) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw deadObjectException;
        }
        finally {
            this.afterRemote();
        }
    }

    public String getType(Uri uri) throws RemoteException {
        this.beforeRemote();
        try {
            String string2 = this.mContentProvider.getType(uri);
            return string2;
        }
        catch (DeadObjectException deadObjectException) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw deadObjectException;
        }
        finally {
            this.afterRemote();
        }
    }

    public Uri insert(Uri uri, ContentValues contentValues) throws RemoteException {
        this.beforeRemote();
        try {
            Uri uri2 = this.mContentProvider.insert(this.mPackageName, uri, contentValues);
            return uri2;
        }
        catch (DeadObjectException deadObjectException) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw deadObjectException;
        }
        finally {
            this.afterRemote();
        }
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String string2) throws RemoteException, FileNotFoundException {
        return this.openAssetFile(uri, string2, null);
    }

    /*
     * Unable to fully structure code
     */
    public AssetFileDescriptor openAssetFile(Uri var1_1, String var2_2, CancellationSignal var3_3) throws RemoteException, FileNotFoundException {
        this.beforeRemote();
        var4_4 = null;
        if (var3_3 == null) ** GOTO lbl8
        try {
            var3_3.throwIfCanceled();
            var4_4 = this.mContentProvider.createCancellationSignal();
            var3_3.setRemote(var4_4);
lbl8:
            // 2 sources

            var7_5 = this.mContentProvider.openAssetFile(this.mPackageName, var1_1, var2_2, var4_4);
            return var7_5;
        }
        catch (DeadObjectException var6_6) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw var6_6;
        }
        finally {
            this.afterRemote();
        }
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2) throws RemoteException, FileNotFoundException {
        return this.openFile(uri, string2, null);
    }

    /*
     * Unable to fully structure code
     */
    public ParcelFileDescriptor openFile(Uri var1_1, String var2_2, CancellationSignal var3_3) throws RemoteException, FileNotFoundException {
        this.beforeRemote();
        var4_4 = null;
        if (var3_3 == null) ** GOTO lbl8
        try {
            var3_3.throwIfCanceled();
            var4_4 = this.mContentProvider.createCancellationSignal();
            var3_3.setRemote(var4_4);
lbl8:
            // 2 sources

            var7_5 = this.mContentProvider.openFile(this.mPackageName, var1_1, var2_2, var4_4);
            return var7_5;
        }
        catch (DeadObjectException var6_6) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw var6_6;
        }
        finally {
            this.afterRemote();
        }
    }

    public final AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String string2, Bundle bundle) throws RemoteException, FileNotFoundException {
        return this.openTypedAssetFileDescriptor(uri, string2, bundle, null);
    }

    /*
     * Unable to fully structure code
     */
    public final AssetFileDescriptor openTypedAssetFileDescriptor(Uri var1_1, String var2_2, Bundle var3_3, CancellationSignal var4_4) throws RemoteException, FileNotFoundException {
        this.beforeRemote();
        var5_5 = null;
        if (var4_4 == null) ** GOTO lbl8
        try {
            var4_4.throwIfCanceled();
            var5_5 = this.mContentProvider.createCancellationSignal();
            var4_4.setRemote(var5_5);
lbl8:
            // 2 sources

            var8_6 = this.mContentProvider.openTypedAssetFile(this.mPackageName, var1_1, var2_2, var3_3, var5_5);
            return var8_6;
        }
        catch (DeadObjectException var7_7) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw var7_7;
        }
        finally {
            this.afterRemote();
        }
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) throws RemoteException {
        return this.query(uri, stringArray, string2, stringArray2, string3, null);
    }

    /*
     * Unable to fully structure code
     */
    public Cursor query(Uri var1_1, String[] var2_2, String var3_3, String[] var4_4, String var5_5, CancellationSignal var6_6) throws RemoteException {
        this.beforeRemote();
        var7_7 = null;
        if (var6_6 == null) ** GOTO lbl8
        try {
            var6_6.throwIfCanceled();
            var7_7 = this.mContentProvider.createCancellationSignal();
            var6_6.setRemote(var7_7);
lbl8:
            // 2 sources

            var10_8 = this.mContentProvider.query(this.mPackageName, var1_1, var2_2, var3_3, var4_4, var5_5, var7_7);
            return var10_8;
        }
        catch (DeadObjectException var9_9) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw var9_9;
        }
        finally {
            this.afterRemote();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean release() {
        synchronized (this) {
            if (this.mReleased) {
                throw new IllegalStateException("Already released");
            }
            this.mReleased = true;
            this.mGuard.close();
            if (!this.mStable) return this.mContentResolver.releaseUnstableProvider(this.mContentProvider);
            return this.mContentResolver.releaseProvider(this.mContentProvider);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDetectNotResponding(long l) {
        synchronized (ContentProviderClient.class) {
            this.mAnrTimeout = l;
            if (l > 0L) {
                if (this.mAnrRunnable == null) {
                    this.mAnrRunnable = new NotRespondingRunnable();
                }
                if (sAnrHandler == null) {
                    sAnrHandler = new Handler(Looper.getMainLooper(), null, true);
                }
            } else {
                this.mAnrRunnable = null;
            }
            return;
        }
    }

    public final Uri uncanonicalize(Uri uri) throws RemoteException {
        this.beforeRemote();
        try {
            Uri uri2 = this.mContentProvider.uncanonicalize(this.mPackageName, uri);
            return uri2;
        }
        catch (DeadObjectException deadObjectException) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw deadObjectException;
        }
        finally {
            this.afterRemote();
        }
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) throws RemoteException {
        this.beforeRemote();
        try {
            int n = this.mContentProvider.update(this.mPackageName, uri, contentValues, string2, stringArray);
            return n;
        }
        catch (DeadObjectException deadObjectException) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw deadObjectException;
        }
        finally {
            this.afterRemote();
        }
    }

    private class NotRespondingRunnable
    implements Runnable {
        private NotRespondingRunnable() {
        }

        @Override
        public void run() {
            Log.w(ContentProviderClient.TAG, "Detected provider not responding: " + ContentProviderClient.this.mContentProvider);
            ContentProviderClient.this.mContentResolver.appNotRespondingViaProvider(ContentProviderClient.this.mContentProvider);
        }
    }
}

