/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ISyncAdapter;
import android.content.ISyncContext;
import android.content.SyncContext;
import android.content.SyncResult;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.Trace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractThreadedSyncAdapter {
    @Deprecated
    public static final int LOG_SYNC_DETAILS = 2743;
    private boolean mAllowParallelSyncs;
    private final boolean mAutoInitialize;
    private final Context mContext;
    private final ISyncAdapterImpl mISyncAdapterImpl;
    private final AtomicInteger mNumSyncStarts;
    private final Object mSyncThreadLock;
    private final HashMap<Account, SyncThread> mSyncThreads = new HashMap();

    public AbstractThreadedSyncAdapter(Context context, boolean bl) {
        this(context, bl, false);
    }

    public AbstractThreadedSyncAdapter(Context context, boolean bl, boolean bl2) {
        this.mSyncThreadLock = new Object();
        this.mContext = context;
        this.mISyncAdapterImpl = new ISyncAdapterImpl();
        this.mNumSyncStarts = new AtomicInteger(0);
        this.mAutoInitialize = bl;
        this.mAllowParallelSyncs = bl2;
    }

    private Account toSyncKey(Account account) {
        if (this.mAllowParallelSyncs) {
            return account;
        }
        return null;
    }

    public Context getContext() {
        return this.mContext;
    }

    public final IBinder getSyncAdapterBinder() {
        return this.mISyncAdapterImpl.asBinder();
    }

    public abstract void onPerformSync(Account var1, Bundle var2, String var3, ContentProviderClient var4, SyncResult var5);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void onSyncCanceled() {
        Object object = this.mSyncThreadLock;
        // MONITORENTER : object
        SyncThread syncThread = this.mSyncThreads.get(null);
        // MONITOREXIT : object
        if (syncThread == null) return;
        syncThread.interrupt();
    }

    public void onSyncCanceled(Thread thread) {
        thread.interrupt();
    }

    private class ISyncAdapterImpl
    extends ISyncAdapter.Stub {
        private ISyncAdapterImpl() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void cancelSync(ISyncContext iSyncContext) {
            SyncThread syncThread;
            block5: {
                SyncThread syncThread2;
                Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
                // MONITORENTER : object
                Iterator iterator = AbstractThreadedSyncAdapter.this.mSyncThreads.values().iterator();
                do {
                    boolean bl = iterator.hasNext();
                    syncThread = null;
                    if (!bl) break block5;
                } while ((syncThread2 = (SyncThread)iterator.next()).mSyncContext.getSyncContextBinder() != iSyncContext.asBinder());
                syncThread = syncThread2;
            }
            // MONITOREXIT : object
            if (syncThread == null) return;
            if (AbstractThreadedSyncAdapter.this.mAllowParallelSyncs) {
                AbstractThreadedSyncAdapter.this.onSyncCanceled(syncThread);
                return;
            }
            AbstractThreadedSyncAdapter.this.onSyncCanceled();
        }

        @Override
        public void initialize(Account account, String string2) throws RemoteException {
            Bundle bundle = new Bundle();
            bundle.putBoolean("initialize", true);
            this.startSync(null, string2, account, bundle);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void startSync(ISyncContext iSyncContext, String string2, Account account, Bundle bundle) {
            boolean bl;
            SyncContext syncContext = new SyncContext(iSyncContext);
            Account account2 = AbstractThreadedSyncAdapter.this.toSyncKey(account);
            Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
            synchronized (object) {
                if (!AbstractThreadedSyncAdapter.this.mSyncThreads.containsKey(account2)) {
                    boolean bl2;
                    if (AbstractThreadedSyncAdapter.this.mAutoInitialize && bundle != null && (bl2 = bundle.getBoolean("initialize", false))) {
                        try {
                            if (ContentResolver.getIsSyncable(account, string2) >= 0) return;
                            ContentResolver.setIsSyncable(account, string2, 1);
                            return;
                        }
                        finally {
                            syncContext.onFinished(new SyncResult());
                        }
                    }
                    SyncThread syncThread = new SyncThread("SyncAdapterThread-" + AbstractThreadedSyncAdapter.this.mNumSyncStarts.incrementAndGet(), syncContext, string2, account, bundle);
                    AbstractThreadedSyncAdapter.this.mSyncThreads.put(account2, syncThread);
                    syncThread.start();
                    return;
                }
                bl = true;
            }
            if (!bl) return;
            syncContext.onFinished(SyncResult.ALREADY_IN_PROGRESS);
        }
    }

    private class SyncThread
    extends Thread {
        private final Account mAccount;
        private final String mAuthority;
        private final Bundle mExtras;
        private final SyncContext mSyncContext;
        private final Account mThreadsKey;

        private SyncThread(String string2, SyncContext syncContext, String string3, Account account, Bundle bundle) {
            super(string2);
            this.mSyncContext = syncContext;
            this.mAuthority = string3;
            this.mAccount = account;
            this.mExtras = bundle;
            this.mThreadsKey = AbstractThreadedSyncAdapter.this.toSyncKey(account);
        }

        private boolean isCanceled() {
            return Thread.currentThread().isInterrupted();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ContentProviderClient contentProviderClient;
            SyncResult syncResult;
            block16: {
                Process.setThreadPriority(10);
                Trace.traceBegin(128L, this.mAuthority);
                syncResult = new SyncResult();
                contentProviderClient = null;
                boolean bl = this.isCanceled();
                if (!bl) break block16;
                Trace.traceEnd(128L);
                if (!this.isCanceled()) {
                    this.mSyncContext.onFinished(syncResult);
                }
                Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
                synchronized (object) {
                    AbstractThreadedSyncAdapter.this.mSyncThreads.remove(this.mThreadsKey);
                    return;
                }
            }
            try {
                contentProviderClient = AbstractThreadedSyncAdapter.this.mContext.getContentResolver().acquireContentProviderClient(this.mAuthority);
                if (contentProviderClient != null) {
                    AbstractThreadedSyncAdapter.this.onPerformSync(this.mAccount, this.mExtras, this.mAuthority, contentProviderClient, syncResult);
                    return;
                }
                syncResult.databaseError = true;
                return;
            }
            finally {
                Trace.traceEnd(128L);
                if (contentProviderClient != null) {
                    contentProviderClient.release();
                }
                if (!this.isCanceled()) {
                    this.mSyncContext.onFinished(syncResult);
                }
                Object object = AbstractThreadedSyncAdapter.this.mSyncThreadLock;
                synchronized (object) {
                    AbstractThreadedSyncAdapter.this.mSyncThreads.remove(this.mThreadsKey);
                }
            }
        }
    }
}

