/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothAdapter;
import android.util.SparseArray;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BluetoothLeUtils {
    static void checkAdapterStateOn(BluetoothAdapter bluetoothAdapter) {
        if (bluetoothAdapter == null || bluetoothAdapter.getState() != 12) {
            throw new IllegalStateException("BT Adapter is not turned ON");
        }
    }

    static boolean equals(SparseArray<byte[]> sparseArray, SparseArray<byte[]> sparseArray2) {
        if (sparseArray == sparseArray2) {
            return true;
        }
        if (sparseArray == null || sparseArray2 == null) {
            return false;
        }
        if (sparseArray.size() != sparseArray2.size()) {
            return false;
        }
        for (int i = 0; i < sparseArray.size(); ++i) {
            if (sparseArray.keyAt(i) == sparseArray2.keyAt(i) && Arrays.equals(sparseArray.valueAt(i), sparseArray2.valueAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    static <T> boolean equals(Map<T, byte[]> map, Map<T, byte[]> map2) {
        T t;
        if (map == map2) {
            return true;
        }
        if (map == null) return false;
        if (map2 == null) {
            return false;
        }
        if (map.size() != map2.size()) {
            return false;
        }
        Set<T> set = map.keySet();
        if (!set.equals(map2.keySet())) {
            return false;
        }
        Iterator<T> iterator = set.iterator();
        do {
            if (!iterator.hasNext()) return true;
        } while (Objects.deepEquals(map.get(t = iterator.next()), map2.get(t)));
        return false;
    }

    static String toString(SparseArray<byte[]> sparseArray) {
        if (sparseArray == null) {
            return "null";
        }
        if (sparseArray.size() == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (int i = 0; i < sparseArray.size(); ++i) {
            stringBuilder.append(sparseArray.keyAt(i)).append("=").append(Arrays.toString(sparseArray.valueAt(i)));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    static <T> String toString(Map<T, byte[]> map) {
        if (map == null) {
            return "null";
        }
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        Iterator<Map.Entry<T, byte[]>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            T t = iterator.next().getKey();
            stringBuilder.append(t).append("=").append(Arrays.toString(map.get(t)));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

