/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothSocket;
import android.os.Handler;
import android.os.ParcelUuid;
import java.io.Closeable;
import java.io.IOException;

public final class BluetoothServerSocket
implements Closeable {
    private final int mChannel;
    private Handler mHandler;
    private int mMessage;
    final BluetoothSocket mSocket;

    BluetoothServerSocket(int n, boolean bl, boolean bl2, int n2) throws IOException {
        this.mChannel = n2;
        this.mSocket = new BluetoothSocket(n, -1, bl, bl2, null, n2, null);
    }

    BluetoothServerSocket(int n, boolean bl, boolean bl2, ParcelUuid parcelUuid) throws IOException {
        this.mSocket = new BluetoothSocket(n, -1, bl, bl2, null, -1, parcelUuid);
        this.mChannel = this.mSocket.getPort();
    }

    public BluetoothSocket accept() throws IOException {
        return this.accept(-1);
    }

    public BluetoothSocket accept(int n) throws IOException {
        return this.mSocket.accept(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        synchronized (this) {
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(this.mMessage).sendToTarget();
            }
        }
        this.mSocket.close();
    }

    public int getChannel() {
        return this.mChannel;
    }

    void setCloseHandler(Handler handler, int n) {
        synchronized (this) {
            this.mHandler = handler;
            this.mMessage = n;
            return;
        }
    }

    void setServiceName(String string2) {
        this.mSocket.setServiceName(string2);
    }
}

