/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHealthAppConfiguration;
import android.bluetooth.BluetoothHealthCallback;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHealth;
import android.bluetooth.IBluetoothHealthCallback;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothHealth
implements BluetoothProfile {
    public static final int APP_CONFIG_REGISTRATION_FAILURE = 1;
    public static final int APP_CONFIG_REGISTRATION_SUCCESS = 0;
    public static final int APP_CONFIG_UNREGISTRATION_FAILURE = 3;
    public static final int APP_CONFIG_UNREGISTRATION_SUCCESS = 2;
    public static final int CHANNEL_TYPE_ANY = 12;
    public static final int CHANNEL_TYPE_RELIABLE = 10;
    public static final int CHANNEL_TYPE_STREAMING = 11;
    private static final boolean DBG = true;
    public static final int HEALTH_OPERATION_ERROR = 6001;
    public static final int HEALTH_OPERATION_GENERIC_FAILURE = 6003;
    public static final int HEALTH_OPERATION_INVALID_ARGS = 6002;
    public static final int HEALTH_OPERATION_NOT_ALLOWED = 6005;
    public static final int HEALTH_OPERATION_NOT_FOUND = 6004;
    public static final int HEALTH_OPERATION_SUCCESS = 6000;
    public static final int SINK_ROLE = 2;
    public static final int SOURCE_ROLE = 1;
    public static final int STATE_CHANNEL_CONNECTED = 2;
    public static final int STATE_CHANNEL_CONNECTING = 1;
    public static final int STATE_CHANNEL_DISCONNECTED = 0;
    public static final int STATE_CHANNEL_DISCONNECTING = 3;
    private static final String TAG = "BluetoothHealth";
    private static final boolean VDBG;
    BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onBluetoothStateChange(boolean bl) {
            Log.d(BluetoothHealth.TAG, "onBluetoothStateChange: up=" + bl);
            if (!bl) {
                ServiceConnection serviceConnection = BluetoothHealth.this.mConnection;
                synchronized (serviceConnection) {
                    try {
                        BluetoothHealth.access$102(BluetoothHealth.this, null);
                        BluetoothHealth.this.mContext.unbindService(BluetoothHealth.this.mConnection);
                    }
                    catch (Exception exception) {
                        Log.e(BluetoothHealth.TAG, "", exception);
                    }
                    return;
                }
            }
            ServiceConnection serviceConnection = BluetoothHealth.this.mConnection;
            synchronized (serviceConnection) {
                try {
                    if (BluetoothHealth.this.mService == null) {
                        BluetoothHealth.this.doBind();
                    }
                }
                catch (Exception exception) {
                    Log.e(BluetoothHealth.TAG, "", exception);
                }
                return;
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.d(BluetoothHealth.TAG, "Proxy object connected");
            BluetoothHealth.access$102(BluetoothHealth.this, IBluetoothHealth.Stub.asInterface(iBinder));
            if (BluetoothHealth.this.mServiceListener != null) {
                BluetoothHealth.this.mServiceListener.onServiceConnected(3, BluetoothHealth.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            Log.d(BluetoothHealth.TAG, "Proxy object disconnected");
            BluetoothHealth.access$102(BluetoothHealth.this, null);
            if (BluetoothHealth.this.mServiceListener != null) {
                BluetoothHealth.this.mServiceListener.onServiceDisconnected(3);
            }
        }
    };
    private Context mContext;
    private IBluetoothHealth mService;
    private BluetoothProfile.ServiceListener mServiceListener;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BluetoothHealth(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.mContext = context;
        this.mServiceListener = serviceListener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
            }
        }
        this.doBind();
    }

    static /* synthetic */ IBluetoothHealth access$102(BluetoothHealth bluetoothHealth, IBluetoothHealth iBluetoothHealth) {
        bluetoothHealth.mService = iBluetoothHealth;
        return iBluetoothHealth;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkAppParam(String string2, int n, int n2, BluetoothHealthCallback bluetoothHealthCallback) {
        return !(string2 == null || n != 1 && n != 2 || n2 != 10 && n2 != 11 && n2 != 12 || bluetoothHealthCallback == null) && (n != 1 || n2 != 12);
    }

    private boolean isEnabled() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter != null && bluetoothAdapter.getState() == 12) {
            return true;
        }
        BluetoothHealth.log("Bluetooth is Not enabled");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return bluetoothDevice != null && BluetoothAdapter.checkBluetoothAddress(bluetoothDevice.getAddress());
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close() {
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception exception) {
                Log.e(TAG, "", exception);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            IBluetoothHealth iBluetoothHealth = this.mService;
            if (iBluetoothHealth != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception exception) {
                    Log.e(TAG, "", exception);
                }
            }
        }
        this.mServiceListener = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connectChannelToSink(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration, int n) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice) && bluetoothHealthAppConfiguration != null) {
            try {
                return this.mService.connectChannelToSink(bluetoothDevice, bluetoothHealthAppConfiguration, n);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connectChannelToSource(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice) && bluetoothHealthAppConfiguration != null) {
            try {
                return this.mService.connectChannelToSource(bluetoothDevice, bluetoothHealthAppConfiguration);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnectChannel(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration, int n) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice) && bluetoothHealthAppConfiguration != null) {
            try {
                return this.mService.disconnectChannel(bluetoothDevice, bluetoothHealthAppConfiguration, n);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothHealth.class.getName());
        ComponentName componentName = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(componentName);
        if (componentName == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth Health Service with " + intent);
            return false;
        }
        return true;
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getConnectedHealthDevices();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                return this.mService.getHealthDeviceConnectionState(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return 0;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return 0;
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getHealthDevicesMatchingConnectionStates(nArray);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParcelFileDescriptor getMainChannelFd(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice) && bluetoothHealthAppConfiguration != null) {
            try {
                return this.mService.getMainChannelFd(bluetoothDevice, bluetoothHealthAppConfiguration);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return null;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean registerAppConfiguration(String string2, int n, int n2, int n3, BluetoothHealthCallback bluetoothHealthCallback) {
        if (!this.isEnabled()) return false;
        if (!this.checkAppParam(string2, n2, n3, bluetoothHealthCallback)) {
            return false;
        }
        BluetoothHealthCallbackWrapper bluetoothHealthCallbackWrapper = new BluetoothHealthCallbackWrapper(bluetoothHealthCallback);
        BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration = new BluetoothHealthAppConfiguration(string2, n, n2, n3);
        if (this.mService != null) {
            try {
                boolean bl = this.mService.registerAppConfiguration(bluetoothHealthAppConfiguration, bluetoothHealthCallbackWrapper);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    public boolean registerSinkAppConfiguration(String string2, int n, BluetoothHealthCallback bluetoothHealthCallback) {
        if (!this.isEnabled() || string2 == null) {
            return false;
        }
        return this.registerAppConfiguration(string2, n, 2, 12, bluetoothHealthCallback);
    }

    public boolean unregisterAppConfiguration(BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration) {
        if (this.mService != null && this.isEnabled() && bluetoothHealthAppConfiguration != null) {
            try {
                boolean bl = this.mService.unregisterAppConfiguration(bluetoothHealthAppConfiguration);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        Log.d(TAG, Log.getStackTraceString(new Throwable()));
        return false;
    }

    private static class BluetoothHealthCallbackWrapper
    extends IBluetoothHealthCallback.Stub {
        private BluetoothHealthCallback mCallback;

        public BluetoothHealthCallbackWrapper(BluetoothHealthCallback bluetoothHealthCallback) {
            this.mCallback = bluetoothHealthCallback;
        }

        @Override
        public void onHealthAppConfigurationStatusChange(BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration, int n) {
            this.mCallback.onHealthAppConfigurationStatusChange(bluetoothHealthAppConfiguration, n);
        }

        @Override
        public void onHealthChannelStateChange(BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration, BluetoothDevice bluetoothDevice, int n, int n2, ParcelFileDescriptor parcelFileDescriptor, int n3) {
            this.mCallback.onHealthChannelStateChange(bluetoothHealthAppConfiguration, bluetoothDevice, n, n2, parcelFileDescriptor, n3);
        }
    }
}

