/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothGattServerCallback;
import android.content.Context;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

public final class BluetoothGattServer
implements BluetoothProfile {
    private static final int CALLBACK_REG_TIMEOUT = 10000;
    private static final boolean DBG = true;
    private static final String TAG = "BluetoothGattServer";
    private static final boolean VDBG;
    private BluetoothAdapter mAdapter;
    private final IBluetoothGattServerCallback mBluetoothGattServerCallback;
    private BluetoothGattServerCallback mCallback;
    private final Context mContext;
    private int mServerIf;
    private Object mServerIfLock = new Object();
    private IBluetoothGatt mService;
    private List<BluetoothGattService> mServices;
    private int mTransport;

    BluetoothGattServer(Context context, IBluetoothGatt iBluetoothGatt, int n) {
        this.mBluetoothGattServerCallback = new IBluetoothGattServerCallback.Stub(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCharacteristicReadRequest(String string2, int n, int n2, boolean bl, int n3, int n4, ParcelUuid parcelUuid, int n5, ParcelUuid parcelUuid2) {
                BluetoothGattCharacteristic bluetoothGattCharacteristic;
                UUID uUID = parcelUuid.getUuid();
                UUID uUID2 = parcelUuid2.getUuid();
                BluetoothDevice bluetoothDevice = BluetoothGattServer.this.mAdapter.getRemoteDevice(string2);
                BluetoothGattService bluetoothGattService = BluetoothGattServer.this.getService(uUID, n4, n3);
                if (bluetoothGattService == null || (bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(uUID2)) == null) {
                    return;
                }
                try {
                    BluetoothGattServer.this.mCallback.onCharacteristicReadRequest(bluetoothDevice, n, n2, bluetoothGattCharacteristic);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCharacteristicWriteRequest(String string2, int n, int n2, int n3, boolean bl, boolean bl2, int n4, int n5, ParcelUuid parcelUuid, int n6, ParcelUuid parcelUuid2, byte[] byArray) {
                BluetoothGattCharacteristic bluetoothGattCharacteristic;
                UUID uUID = parcelUuid.getUuid();
                UUID uUID2 = parcelUuid2.getUuid();
                BluetoothDevice bluetoothDevice = BluetoothGattServer.this.mAdapter.getRemoteDevice(string2);
                BluetoothGattService bluetoothGattService = BluetoothGattServer.this.getService(uUID, n5, n4);
                if (bluetoothGattService == null || (bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(uUID2)) == null) {
                    return;
                }
                try {
                    BluetoothGattServer.this.mCallback.onCharacteristicWriteRequest(bluetoothDevice, n, bluetoothGattCharacteristic, bl, bl2, n2, byArray);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onDescriptorReadRequest(String string2, int n, int n2, boolean bl, int n3, int n4, ParcelUuid parcelUuid, int n5, ParcelUuid parcelUuid2, ParcelUuid parcelUuid3) {
                BluetoothGattDescriptor bluetoothGattDescriptor;
                BluetoothGattCharacteristic bluetoothGattCharacteristic;
                UUID uUID = parcelUuid.getUuid();
                UUID uUID2 = parcelUuid2.getUuid();
                UUID uUID3 = parcelUuid3.getUuid();
                BluetoothDevice bluetoothDevice = BluetoothGattServer.this.mAdapter.getRemoteDevice(string2);
                BluetoothGattService bluetoothGattService = BluetoothGattServer.this.getService(uUID, n4, n3);
                if (bluetoothGattService == null || (bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(uUID2)) == null || (bluetoothGattDescriptor = bluetoothGattCharacteristic.getDescriptor(uUID3)) == null) {
                    return;
                }
                try {
                    BluetoothGattServer.this.mCallback.onDescriptorReadRequest(bluetoothDevice, n, n2, bluetoothGattDescriptor);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onDescriptorWriteRequest(String string2, int n, int n2, int n3, boolean bl, boolean bl2, int n4, int n5, ParcelUuid parcelUuid, int n6, ParcelUuid parcelUuid2, ParcelUuid parcelUuid3, byte[] byArray) {
                BluetoothGattDescriptor bluetoothGattDescriptor;
                BluetoothGattCharacteristic bluetoothGattCharacteristic;
                UUID uUID = parcelUuid.getUuid();
                UUID uUID2 = parcelUuid2.getUuid();
                UUID uUID3 = parcelUuid3.getUuid();
                BluetoothDevice bluetoothDevice = BluetoothGattServer.this.mAdapter.getRemoteDevice(string2);
                BluetoothGattService bluetoothGattService = BluetoothGattServer.this.getService(uUID, n5, n4);
                if (bluetoothGattService == null || (bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(uUID2)) == null || (bluetoothGattDescriptor = bluetoothGattCharacteristic.getDescriptor(uUID3)) == null) {
                    return;
                }
                try {
                    BluetoothGattServer.this.mCallback.onDescriptorWriteRequest(bluetoothDevice, n, bluetoothGattDescriptor, bl, bl2, n2, byArray);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            @Override
            public void onExecuteWrite(String string2, int n, boolean bl) {
                Log.d(BluetoothGattServer.TAG, "onExecuteWrite() - device=" + string2 + ", transId=" + n + "execWrite=" + bl);
                BluetoothDevice bluetoothDevice = BluetoothGattServer.this.mAdapter.getRemoteDevice(string2);
                if (bluetoothDevice == null) {
                    return;
                }
                try {
                    BluetoothGattServer.this.mCallback.onExecuteWrite(bluetoothDevice, n, bl);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            @Override
            public void onNotificationSent(String string2, int n) {
                BluetoothDevice bluetoothDevice = BluetoothGattServer.this.mAdapter.getRemoteDevice(string2);
                if (bluetoothDevice == null) {
                    return;
                }
                try {
                    BluetoothGattServer.this.mCallback.onNotificationSent(bluetoothDevice, n);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGattServer.TAG, "Unhandled exception: " + exception);
                    return;
                }
            }

            @Override
            public void onScanResult(String string2, int n, byte[] byArray) {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onServerConnectionState(int n, int n2, boolean bl, String string2) {
                Log.d(BluetoothGattServer.TAG, "onServerConnectionState() - status=" + n + " serverIf=" + n2 + " device=" + string2);
                try {
                    BluetoothGattServerCallback bluetoothGattServerCallback = BluetoothGattServer.this.mCallback;
                    BluetoothDevice bluetoothDevice = BluetoothGattServer.this.mAdapter.getRemoteDevice(string2);
                    int n3 = bl ? 2 : 0;
                    bluetoothGattServerCallback.onConnectionStateChange(bluetoothDevice, n, n3);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onServerRegistered(int n, int n2) {
                Log.d(BluetoothGattServer.TAG, "onServerRegistered() - status=" + n + " serverIf=" + n2);
                Object object = BluetoothGattServer.this.mServerIfLock;
                synchronized (object) {
                    if (BluetoothGattServer.this.mCallback != null) {
                        BluetoothGattServer.access$202(BluetoothGattServer.this, n2);
                        BluetoothGattServer.this.mServerIfLock.notify();
                    } else {
                        Log.e(BluetoothGattServer.TAG, "onServerRegistered: mCallback is null");
                    }
                    return;
                }
            }

            @Override
            public void onServiceAdded(int n, int n2, int n3, ParcelUuid parcelUuid) {
                UUID uUID = parcelUuid.getUuid();
                Log.d(BluetoothGattServer.TAG, "onServiceAdded() - service=" + uUID + "status=" + n);
                BluetoothGattService bluetoothGattService = BluetoothGattServer.this.getService(uUID, n3, n2);
                if (bluetoothGattService == null) {
                    return;
                }
                try {
                    BluetoothGattServer.this.mCallback.onServiceAdded(n, bluetoothGattService);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGattServer.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }
        };
        this.mContext = context;
        this.mService = iBluetoothGatt;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mCallback = null;
        this.mServerIf = 0;
        this.mTransport = n;
        this.mServices = new ArrayList<BluetoothGattService>();
    }

    static /* synthetic */ int access$202(BluetoothGattServer bluetoothGattServer, int n) {
        bluetoothGattServer.mServerIf = n;
        return n;
    }

    private void unregisterCallback() {
        Log.d(TAG, "unregisterCallback() - mServerIf=" + this.mServerIf);
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mCallback = null;
            this.mService.unregisterServer(this.mServerIf);
            this.mServerIf = 0;
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addService(BluetoothGattService bluetoothGattService) {
        Log.d(TAG, "addService() - service: " + bluetoothGattService.getUuid());
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        this.mServices.add(bluetoothGattService);
        try {
            this.mService.beginServiceDeclaration(this.mServerIf, bluetoothGattService.getType(), bluetoothGattService.getInstanceId(), bluetoothGattService.getHandles(), new ParcelUuid(bluetoothGattService.getUuid()), bluetoothGattService.isAdvertisePreferred());
            for (BluetoothGattService bluetoothGattService2 : bluetoothGattService.getIncludedServices()) {
                this.mService.addIncludedService(this.mServerIf, bluetoothGattService2.getType(), bluetoothGattService2.getInstanceId(), new ParcelUuid(bluetoothGattService2.getUuid()));
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
        {
            Iterator<BluetoothGattCharacteristic> iterator = bluetoothGattService.getCharacteristics().iterator();
            block4: while (true) {
                if (!iterator.hasNext()) {
                    this.mService.endServiceDeclaration(this.mServerIf);
                    return true;
                }
                BluetoothGattCharacteristic bluetoothGattCharacteristic = iterator.next();
                int n = (-7 + bluetoothGattCharacteristic.getKeySize() << 12) + bluetoothGattCharacteristic.getPermissions();
                this.mService.addCharacteristic(this.mServerIf, new ParcelUuid(bluetoothGattCharacteristic.getUuid()), bluetoothGattCharacteristic.getProperties(), n);
                Iterator<BluetoothGattDescriptor> iterator2 = bluetoothGattCharacteristic.getDescriptors().iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block4;
                    BluetoothGattDescriptor bluetoothGattDescriptor = iterator2.next();
                    int n2 = (-7 + bluetoothGattCharacteristic.getKeySize() << 12) + bluetoothGattDescriptor.getPermissions();
                    this.mService.addDescriptor(this.mServerIf, new ParcelUuid(bluetoothGattDescriptor.getUuid()), n2);
                }
                break;
            }
        }
    }

    public void cancelConnection(BluetoothDevice bluetoothDevice) {
        Log.d(TAG, "cancelConnection() - device: " + bluetoothDevice.getAddress());
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mService.serverDisconnect(this.mServerIf, bluetoothDevice.getAddress());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return;
        }
    }

    public void clearServices() {
        Log.d(TAG, "clearServices()");
        if (this.mService == null || this.mServerIf == 0) {
            return;
        }
        try {
            this.mService.clearServices(this.mServerIf);
            this.mServices.clear();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return;
        }
    }

    public void close() {
        Log.d(TAG, "close()");
        this.unregisterCallback();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connect(BluetoothDevice bluetoothDevice, boolean bl) {
        Log.d(TAG, "connect() - device: " + bluetoothDevice.getAddress() + ", auto: " + bl);
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        try {
            IBluetoothGatt iBluetoothGatt = this.mService;
            int n = this.mServerIf;
            String string2 = bluetoothDevice.getAddress();
            boolean bl2 = !bl;
            iBluetoothGatt.serverConnect(n, string2, bl2, this.mTransport);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectedDevices instead.");
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectionState instead.");
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        throw new UnsupportedOperationException("Use BluetoothManager#getDevicesMatchingConnectionStates instead.");
    }

    public BluetoothGattService getService(UUID uUID) {
        for (BluetoothGattService bluetoothGattService : this.mServices) {
            if (!bluetoothGattService.getUuid().equals(uUID)) continue;
            return bluetoothGattService;
        }
        return null;
    }

    BluetoothGattService getService(UUID uUID, int n, int n2) {
        for (BluetoothGattService bluetoothGattService : this.mServices) {
            if (bluetoothGattService.getType() != n2 || bluetoothGattService.getInstanceId() != n || !bluetoothGattService.getUuid().equals(uUID)) continue;
            return bluetoothGattService;
        }
        return null;
    }

    public List<BluetoothGattService> getServices() {
        return this.mServices;
    }

    public boolean notifyCharacteristicChanged(BluetoothDevice bluetoothDevice, BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl) {
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        BluetoothGattService bluetoothGattService = bluetoothGattCharacteristic.getService();
        if (bluetoothGattService == null) {
            return false;
        }
        if (bluetoothGattCharacteristic.getValue() == null) {
            throw new IllegalArgumentException("Chracteristic value is empty. Use BluetoothGattCharacteristic#setvalue to update");
        }
        try {
            this.mService.sendNotification(this.mServerIf, bluetoothDevice.getAddress(), bluetoothGattService.getType(), bluetoothGattService.getInstanceId(), new ParcelUuid(bluetoothGattService.getUuid()), bluetoothGattCharacteristic.getInstanceId(), new ParcelUuid(bluetoothGattCharacteristic.getUuid()), bl, bluetoothGattCharacteristic.getValue());
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean registerCallback(BluetoothGattServerCallback bluetoothGattServerCallback) {
        Log.d(TAG, "registerCallback()");
        if (this.mService == null) {
            Log.e(TAG, "GATT service not available");
            return false;
        }
        UUID uUID = UUID.randomUUID();
        Log.d(TAG, "registerCallback() - UUID=" + uUID);
        Object object = this.mServerIfLock;
        synchronized (object) {
            if (this.mCallback != null) {
                Log.e(TAG, "App can register callback only once");
                return false;
            }
            this.mCallback = bluetoothGattServerCallback;
            try {
                this.mService.registerServer(new ParcelUuid(uUID), this.mBluetoothGattServerCallback);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
                this.mCallback = null;
                return false;
            }
            try {
                this.mServerIfLock.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                Log.e(TAG, "" + interruptedException);
                this.mCallback = null;
            }
            if (this.mServerIf == 0) {
                this.mCallback = null;
                return false;
            }
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeService(BluetoothGattService bluetoothGattService) {
        BluetoothGattService bluetoothGattService2;
        Log.d(TAG, "removeService() - service: " + bluetoothGattService.getUuid());
        if (this.mService == null || this.mServerIf == 0 || (bluetoothGattService2 = this.getService(bluetoothGattService.getUuid(), bluetoothGattService.getInstanceId(), bluetoothGattService.getType())) == null) {
            return false;
        }
        try {
            this.mService.removeService(this.mServerIf, bluetoothGattService.getType(), bluetoothGattService.getInstanceId(), new ParcelUuid(bluetoothGattService.getUuid()));
            this.mServices.remove(bluetoothGattService2);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean sendResponse(BluetoothDevice bluetoothDevice, int n, int n2, int n3, byte[] byArray) {
        if (this.mService == null || this.mServerIf == 0) {
            return false;
        }
        try {
            this.mService.sendResponse(this.mServerIf, bluetoothDevice.getAddress(), n, n2, n3, byArray);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }
}

