/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCallbackWrapper;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothGattCallback;
import android.content.Context;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class BluetoothGatt
implements BluetoothProfile {
    static final int AUTHENTICATION_MITM = 2;
    static final int AUTHENTICATION_NONE = 0;
    static final int AUTHENTICATION_NO_MITM = 1;
    public static final int CONNECTION_PRIORITY_BALANCED = 0;
    public static final int CONNECTION_PRIORITY_HIGH = 1;
    public static final int CONNECTION_PRIORITY_LOW_POWER = 2;
    private static final int CONN_STATE_CLOSED = 4;
    private static final int CONN_STATE_CONNECTED = 2;
    private static final int CONN_STATE_CONNECTING = 1;
    private static final int CONN_STATE_DISCONNECTING = 3;
    private static final int CONN_STATE_IDLE = 0;
    private static final boolean DBG = true;
    public static final int GATT_CONNECTION_CONGESTED = 143;
    public static final int GATT_FAILURE = 257;
    public static final int GATT_INSUFFICIENT_AUTHENTICATION = 5;
    public static final int GATT_INSUFFICIENT_ENCRYPTION = 15;
    public static final int GATT_INVALID_ATTRIBUTE_LENGTH = 13;
    public static final int GATT_INVALID_OFFSET = 7;
    public static final int GATT_READ_NOT_PERMITTED = 2;
    public static final int GATT_REQUEST_NOT_SUPPORTED = 6;
    public static final int GATT_SUCCESS = 0;
    public static final int GATT_WRITE_NOT_PERMITTED = 3;
    private static final String TAG = "BluetoothGatt";
    private static final boolean VDBG;
    private boolean mAuthRetry = false;
    private boolean mAutoConnect;
    private final IBluetoothGattCallback mBluetoothGattCallback;
    private BluetoothGattCallback mCallback;
    private int mClientIf;
    private int mConnState;
    private final Context mContext;
    private BluetoothDevice mDevice;
    private Boolean mDeviceBusy = false;
    private IBluetoothGatt mService;
    private List<BluetoothGattService> mServices;
    private final Object mStateLock = new Object();
    private int mTransport;

    BluetoothGatt(Context context, IBluetoothGatt iBluetoothGatt, BluetoothDevice bluetoothDevice, int n) {
        this.mBluetoothGattCallback = new BluetoothGattCallbackWrapper(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void onCharacteristicRead(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, byte[] byArray) {
                if (!string2.equals(BluetoothGatt.this.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = BluetoothGatt.this.mDeviceBusy;
                // MONITORENTER : bl
                BluetoothGatt.access$802(BluetoothGatt.this, false);
                // MONITOREXIT : bl
                if (!(n != 5 && n != 15 || BluetoothGatt.this.mAuthRetry)) {
                    try {
                        BluetoothGatt.access$1002(BluetoothGatt.this, true);
                        BluetoothGatt.this.mService.readCharacteristic(BluetoothGatt.this.mClientIf, string2, n2, n3, parcelUuid, n4, parcelUuid2, 2);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(BluetoothGatt.TAG, "", remoteException);
                    }
                }
                BluetoothGatt.access$1002(BluetoothGatt.this, false);
                BluetoothGattService bluetoothGattService = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, parcelUuid.getUuid(), n3, n2);
                if (bluetoothGattService == null) return;
                BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(parcelUuid2.getUuid(), n4);
                if (bluetoothGattCharacteristic == null) return;
                if (n == 0) {
                    bluetoothGattCharacteristic.setValue(byArray);
                }
                try {
                    BluetoothGatt.this.mCallback.onCharacteristicRead(BluetoothGatt.this, bluetoothGattCharacteristic, n);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCharacteristicWrite(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2) {
                BluetoothGattCharacteristic bluetoothGattCharacteristic;
                block12: {
                    block11: {
                        if (!string2.equals(BluetoothGatt.this.mDevice.getAddress())) break block11;
                        Boolean bl = BluetoothGatt.this.mDeviceBusy;
                        synchronized (bl) {
                            BluetoothGatt.access$802(BluetoothGatt.this, false);
                        }
                        BluetoothGattService bluetoothGattService = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, parcelUuid.getUuid(), n3, n2);
                        if (bluetoothGattService != null && (bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(parcelUuid2.getUuid(), n4)) != null) break block12;
                    }
                    return;
                }
                if (!(n != 5 && n != 15 || BluetoothGatt.this.mAuthRetry)) {
                    try {
                        BluetoothGatt.access$1002(BluetoothGatt.this, true);
                        BluetoothGatt.this.mService.writeCharacteristic(BluetoothGatt.this.mClientIf, string2, n2, n3, parcelUuid, n4, parcelUuid2, bluetoothGattCharacteristic.getWriteType(), 2, bluetoothGattCharacteristic.getValue());
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(BluetoothGatt.TAG, "", remoteException);
                    }
                }
                BluetoothGatt.access$1002(BluetoothGatt.this, false);
                try {
                    BluetoothGatt.this.mCallback.onCharacteristicWrite(BluetoothGatt.this, bluetoothGattCharacteristic, n);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onClientConnectionState(int n, int n2, boolean bl, String string2) {
                int n3 = 2;
                Log.d(BluetoothGatt.TAG, "onClientConnectionState() - status=" + n + " clientIf=" + n2 + " device=" + string2);
                if (!string2.equals(BluetoothGatt.this.mDevice.getAddress())) {
                    return;
                }
                if (!bl) {
                    n3 = 0;
                }
                try {
                    BluetoothGatt.this.mCallback.onConnectionStateChange(BluetoothGatt.this, n, n3);
                }
                catch (Exception exception) {
                    Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", exception);
                }
                Object object = BluetoothGatt.this.mStateLock;
                synchronized (object) {
                    if (bl) {
                        BluetoothGatt.access$302(BluetoothGatt.this, 2);
                    } else {
                        BluetoothGatt.access$302(BluetoothGatt.this, 0);
                    }
                }
                Boolean bl2 = BluetoothGatt.this.mDeviceBusy;
                synchronized (bl2) {
                    BluetoothGatt.access$802(BluetoothGatt.this, false);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onClientRegistered(int n, int n2) {
                Log.d(BluetoothGatt.TAG, "onClientRegistered() - status=" + n + " clientIf=" + n2);
                BluetoothGatt.access$002(BluetoothGatt.this, n2);
                if (n != 0) {
                    BluetoothGatt.this.mCallback.onConnectionStateChange(BluetoothGatt.this, 257, 0);
                    Object object = BluetoothGatt.this.mStateLock;
                    synchronized (object) {
                        BluetoothGatt.access$302(BluetoothGatt.this, 0);
                        return;
                    }
                }
                try {
                    IBluetoothGatt iBluetoothGatt = BluetoothGatt.this.mService;
                    int n3 = BluetoothGatt.this.mClientIf;
                    String string2 = BluetoothGatt.this.mDevice.getAddress();
                    boolean bl = BluetoothGatt.this.mAutoConnect;
                    boolean bl2 = false;
                    if (!bl) {
                        bl2 = true;
                    }
                    iBluetoothGatt.clientConnect(n3, string2, bl2, BluetoothGatt.this.mTransport);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e(BluetoothGatt.TAG, "", remoteException);
                    return;
                }
            }

            @Override
            public void onConfigureMTU(String string2, int n, int n2) {
                Log.d(BluetoothGatt.TAG, "onConfigureMTU() - Device=" + string2 + " mtu=" + n + " status=" + n2);
                if (!string2.equals(BluetoothGatt.this.mDevice.getAddress())) {
                    return;
                }
                try {
                    BluetoothGatt.this.mCallback.onMtuChanged(BluetoothGatt.this, n, n2);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onDescriptorRead(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, ParcelUuid parcelUuid3, byte[] byArray) {
                BluetoothGattDescriptor bluetoothGattDescriptor;
                block13: {
                    block12: {
                        BluetoothGattCharacteristic bluetoothGattCharacteristic;
                        if (!string2.equals(BluetoothGatt.this.mDevice.getAddress())) break block12;
                        Boolean bl = BluetoothGatt.this.mDeviceBusy;
                        synchronized (bl) {
                            BluetoothGatt.access$802(BluetoothGatt.this, false);
                        }
                        BluetoothGattService bluetoothGattService = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, parcelUuid.getUuid(), n3, n2);
                        if (bluetoothGattService != null && (bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(parcelUuid2.getUuid(), n4)) != null && (bluetoothGattDescriptor = bluetoothGattCharacteristic.getDescriptor(parcelUuid3.getUuid(), n5)) != null) break block13;
                    }
                    return;
                }
                if (n == 0) {
                    bluetoothGattDescriptor.setValue(byArray);
                }
                if (!(n != 5 && n != 15 || BluetoothGatt.this.mAuthRetry)) {
                    try {
                        BluetoothGatt.access$1002(BluetoothGatt.this, true);
                        BluetoothGatt.this.mService.readDescriptor(BluetoothGatt.this.mClientIf, string2, n2, n3, parcelUuid, n4, parcelUuid2, n5, parcelUuid3, 2);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(BluetoothGatt.TAG, "", remoteException);
                    }
                }
                BluetoothGatt.access$1002(BluetoothGatt.this, true);
                try {
                    BluetoothGatt.this.mCallback.onDescriptorRead(BluetoothGatt.this, bluetoothGattDescriptor, n);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onDescriptorWrite(String string2, int n, int n2, int n3, ParcelUuid parcelUuid, int n4, ParcelUuid parcelUuid2, int n5, ParcelUuid parcelUuid3) {
                BluetoothGattDescriptor bluetoothGattDescriptor;
                BluetoothGattCharacteristic bluetoothGattCharacteristic;
                block12: {
                    block11: {
                        if (!string2.equals(BluetoothGatt.this.mDevice.getAddress())) break block11;
                        Boolean bl = BluetoothGatt.this.mDeviceBusy;
                        synchronized (bl) {
                            BluetoothGatt.access$802(BluetoothGatt.this, false);
                        }
                        BluetoothGattService bluetoothGattService = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, parcelUuid.getUuid(), n3, n2);
                        if (bluetoothGattService != null && (bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(parcelUuid2.getUuid(), n4)) != null && (bluetoothGattDescriptor = bluetoothGattCharacteristic.getDescriptor(parcelUuid3.getUuid(), n5)) != null) break block12;
                    }
                    return;
                }
                if (!(n != 5 && n != 15 || BluetoothGatt.this.mAuthRetry)) {
                    try {
                        BluetoothGatt.access$1002(BluetoothGatt.this, true);
                        BluetoothGatt.this.mService.writeDescriptor(BluetoothGatt.this.mClientIf, string2, n2, n3, parcelUuid, n4, parcelUuid2, n5, parcelUuid3, bluetoothGattCharacteristic.getWriteType(), 2, bluetoothGattDescriptor.getValue());
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(BluetoothGatt.TAG, "", remoteException);
                    }
                }
                BluetoothGatt.access$1002(BluetoothGatt.this, false);
                try {
                    BluetoothGatt.this.mCallback.onDescriptorWrite(BluetoothGatt.this, bluetoothGattDescriptor, n);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onExecuteWrite(String string2, int n) {
                if (!string2.equals(BluetoothGatt.this.mDevice.getAddress())) {
                    return;
                }
                Boolean bl = BluetoothGatt.this.mDeviceBusy;
                synchronized (bl) {
                    BluetoothGatt.access$802(BluetoothGatt.this, false);
                }
                try {
                    BluetoothGatt.this.mCallback.onReliableWriteCompleted(BluetoothGatt.this, n);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onGetCharacteristic(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, ParcelUuid parcelUuid2, int n4) {
                BluetoothGattService bluetoothGattService;
                if (!string2.equals(BluetoothGatt.this.mDevice.getAddress()) || (bluetoothGattService = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, parcelUuid.getUuid(), n2, n)) == null) {
                    return;
                }
                bluetoothGattService.addCharacteristic(new BluetoothGattCharacteristic(bluetoothGattService, parcelUuid2.getUuid(), n3, n4, 0));
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onGetDescriptor(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, ParcelUuid parcelUuid2, int n4, ParcelUuid parcelUuid3) {
                BluetoothGattCharacteristic bluetoothGattCharacteristic;
                BluetoothGattService bluetoothGattService;
                if (!string2.equals(BluetoothGatt.this.mDevice.getAddress()) || (bluetoothGattService = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, parcelUuid.getUuid(), n2, n)) == null || (bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(parcelUuid2.getUuid(), n3)) == null) {
                    return;
                }
                bluetoothGattCharacteristic.addDescriptor(new BluetoothGattDescriptor(bluetoothGattCharacteristic, parcelUuid3.getUuid(), n4, 0));
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onGetIncludedService(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, int n4, ParcelUuid parcelUuid2) {
                BluetoothGattService bluetoothGattService;
                BluetoothGattService bluetoothGattService2;
                block3: {
                    block2: {
                        if (!string2.equals(BluetoothGatt.this.mDevice.getAddress())) break block2;
                        bluetoothGattService2 = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, parcelUuid.getUuid(), n2, n);
                        bluetoothGattService = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, parcelUuid2.getUuid(), n4, n3);
                        if (bluetoothGattService2 != null && bluetoothGattService != null) break block3;
                    }
                    return;
                }
                bluetoothGattService2.addIncludedService(bluetoothGattService);
            }

            @Override
            public void onGetService(String string2, int n, int n2, ParcelUuid parcelUuid) {
                if (!string2.equals(BluetoothGatt.this.mDevice.getAddress())) {
                    return;
                }
                BluetoothGatt.this.mServices.add(new BluetoothGattService(BluetoothGatt.this.mDevice, parcelUuid.getUuid(), n2, n));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onNotify(String string2, int n, int n2, ParcelUuid parcelUuid, int n3, ParcelUuid parcelUuid2, byte[] byArray) {
                BluetoothGattCharacteristic bluetoothGattCharacteristic;
                BluetoothGattService bluetoothGattService;
                if (!string2.equals(BluetoothGatt.this.mDevice.getAddress()) || (bluetoothGattService = BluetoothGatt.this.getService(BluetoothGatt.this.mDevice, parcelUuid.getUuid(), n2, n)) == null || (bluetoothGattCharacteristic = bluetoothGattService.getCharacteristic(parcelUuid2.getUuid(), n3)) == null) {
                    return;
                }
                bluetoothGattCharacteristic.setValue(byArray);
                try {
                    BluetoothGatt.this.mCallback.onCharacteristicChanged(BluetoothGatt.this, bluetoothGattCharacteristic);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            @Override
            public void onReadRemoteRssi(String string2, int n, int n2) {
                if (!string2.equals(BluetoothGatt.this.mDevice.getAddress())) {
                    return;
                }
                try {
                    BluetoothGatt.this.mCallback.onReadRemoteRssi(BluetoothGatt.this, n, n2);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }

            @Override
            public void onSearchComplete(String string2, int n) {
                Log.d(BluetoothGatt.TAG, "onSearchComplete() = Device=" + string2 + " Status=" + n);
                if (!string2.equals(BluetoothGatt.this.mDevice.getAddress())) {
                    return;
                }
                try {
                    BluetoothGatt.this.mCallback.onServicesDiscovered(BluetoothGatt.this, n);
                    return;
                }
                catch (Exception exception) {
                    Log.w(BluetoothGatt.TAG, "Unhandled exception in callback", exception);
                    return;
                }
            }
        };
        this.mContext = context;
        this.mService = iBluetoothGatt;
        this.mDevice = bluetoothDevice;
        this.mTransport = n;
        this.mServices = new ArrayList<BluetoothGattService>();
        this.mConnState = 0;
    }

    static /* synthetic */ int access$002(BluetoothGatt bluetoothGatt, int n) {
        bluetoothGatt.mClientIf = n;
        return n;
    }

    static /* synthetic */ boolean access$1002(BluetoothGatt bluetoothGatt, boolean bl) {
        bluetoothGatt.mAuthRetry = bl;
        return bl;
    }

    static /* synthetic */ int access$302(BluetoothGatt bluetoothGatt, int n) {
        bluetoothGatt.mConnState = n;
        return n;
    }

    static /* synthetic */ Boolean access$802(BluetoothGatt bluetoothGatt, Boolean bl) {
        bluetoothGatt.mDeviceBusy = bl;
        return bl;
    }

    private boolean registerApp(BluetoothGattCallback bluetoothGattCallback) {
        Log.d(TAG, "registerApp()");
        if (this.mService == null) {
            return false;
        }
        this.mCallback = bluetoothGattCallback;
        UUID uUID = UUID.randomUUID();
        Log.d(TAG, "registerApp() - UUID=" + uUID);
        try {
            this.mService.registerClient(new ParcelUuid(uUID), this.mBluetoothGattCallback);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    private void unregisterApp() {
        Log.d(TAG, "unregisterApp() - mClientIf=" + this.mClientIf);
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mCallback = null;
            this.mService.unregisterClient(this.mClientIf);
            this.mClientIf = 0;
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return;
        }
    }

    public void abortReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), false);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return;
        }
    }

    public void abortReliableWrite(BluetoothDevice bluetoothDevice) {
        this.abortReliableWrite();
    }

    public boolean beginReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.beginReliableWrite(this.mClientIf, this.mDevice.getAddress());
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public void close() {
        Log.d(TAG, "close()");
        this.unregisterApp();
        this.mConnState = 4;
    }

    public boolean connect() {
        try {
            this.mService.clientConnect(this.mClientIf, this.mDevice.getAddress(), false, this.mTransport);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean connect(Boolean bl, BluetoothGattCallback bluetoothGattCallback) {
        Log.d(TAG, "connect() - device: " + this.mDevice.getAddress() + ", auto: " + bl);
        Object object = this.mStateLock;
        // MONITORENTER : object
        if (this.mConnState != 0) {
            throw new IllegalStateException("Not idle");
        }
        this.mConnState = 1;
        // MONITOREXIT : object
        if (!this.registerApp(bluetoothGattCallback)) {
            Object object2 = this.mStateLock;
            // MONITORENTER : object2
            this.mConnState = 0;
            // MONITOREXIT : object2
            Log.e(TAG, "Failed to register callback");
            return false;
        }
        this.mAutoConnect = bl;
        return true;
    }

    public void disconnect() {
        Log.d(TAG, "cancelOpen() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return;
        }
        try {
            this.mService.clientDisconnect(this.mClientIf, this.mDevice.getAddress());
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return;
        }
    }

    public boolean discoverServices() {
        Log.d(TAG, "discoverServices() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        this.mServices.clear();
        try {
            this.mService.discoverServices(this.mClientIf, this.mDevice.getAddress());
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executeReliableWrite() {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.endReliableWrite(this.mClientIf, this.mDevice.getAddress(), true);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            this.mDeviceBusy = false;
            return false;
        }
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectedDevices instead.");
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        throw new UnsupportedOperationException("Use BluetoothManager#getConnectionState instead.");
    }

    public BluetoothDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        throw new UnsupportedOperationException("Use BluetoothManager#getDevicesMatchingConnectionStates instead.");
    }

    BluetoothGattService getService(BluetoothDevice bluetoothDevice, UUID uUID, int n, int n2) {
        for (BluetoothGattService bluetoothGattService : this.mServices) {
            if (!bluetoothGattService.getDevice().equals(bluetoothDevice) || bluetoothGattService.getType() != n2 || bluetoothGattService.getInstanceId() != n || !bluetoothGattService.getUuid().equals(uUID)) continue;
            return bluetoothGattService;
        }
        return null;
    }

    public BluetoothGattService getService(UUID uUID) {
        for (BluetoothGattService bluetoothGattService : this.mServices) {
            if (!bluetoothGattService.getDevice().equals(this.mDevice) || !bluetoothGattService.getUuid().equals(uUID)) continue;
            return bluetoothGattService;
        }
        return null;
    }

    public List<BluetoothGattService> getServices() {
        ArrayList<BluetoothGattService> arrayList = new ArrayList<BluetoothGattService>();
        for (BluetoothGattService bluetoothGattService : this.mServices) {
            if (!bluetoothGattService.getDevice().equals(this.mDevice)) continue;
            arrayList.add(bluetoothGattService);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        if ((2 & bluetoothGattCharacteristic.getProperties()) == 0) {
            return false;
        }
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService bluetoothGattService = bluetoothGattCharacteristic.getService();
        if (bluetoothGattService == null) {
            return false;
        }
        BluetoothDevice bluetoothDevice = bluetoothGattService.getDevice();
        if (bluetoothDevice == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readCharacteristic(this.mClientIf, bluetoothDevice.getAddress(), bluetoothGattService.getType(), bluetoothGattService.getInstanceId(), new ParcelUuid(bluetoothGattService.getUuid()), bluetoothGattCharacteristic.getInstanceId(), new ParcelUuid(bluetoothGattCharacteristic.getUuid()), 0);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            this.mDeviceBusy = false;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor) {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGattDescriptor.getCharacteristic();
        if (bluetoothGattCharacteristic == null) {
            return false;
        }
        BluetoothGattService bluetoothGattService = bluetoothGattCharacteristic.getService();
        if (bluetoothGattService == null) {
            return false;
        }
        BluetoothDevice bluetoothDevice = bluetoothGattService.getDevice();
        if (bluetoothDevice == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.readDescriptor(this.mClientIf, bluetoothDevice.getAddress(), bluetoothGattService.getType(), bluetoothGattService.getInstanceId(), new ParcelUuid(bluetoothGattService.getUuid()), bluetoothGattCharacteristic.getInstanceId(), new ParcelUuid(bluetoothGattCharacteristic.getUuid()), bluetoothGattDescriptor.getInstanceId(), new ParcelUuid(bluetoothGattDescriptor.getUuid()), 0);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            this.mDeviceBusy = false;
            return false;
        }
    }

    public boolean readRemoteRssi() {
        Log.d(TAG, "readRssi() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.readRemoteRssi(this.mClientIf, this.mDevice.getAddress());
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean refresh() {
        Log.d(TAG, "refresh() - device: " + this.mDevice.getAddress());
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.refreshDevice(this.mClientIf, this.mDevice.getAddress());
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean requestConnectionPriority(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("connectionPriority not within valid range");
        }
        Log.d(TAG, "requestConnectionPriority() - params: " + n);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.connectionParameterUpdate(this.mClientIf, this.mDevice.getAddress(), n);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean requestMtu(int n) {
        Log.d(TAG, "configureMTU() - device: " + this.mDevice.getAddress() + " mtu: " + n);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        try {
            this.mService.configureMTU(this.mClientIf, this.mDevice.getAddress(), n);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean setCharacteristicNotification(BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl) {
        Log.d(TAG, "setCharacteristicNotification() - uuid: " + bluetoothGattCharacteristic.getUuid() + " enable: " + bl);
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService bluetoothGattService = bluetoothGattCharacteristic.getService();
        if (bluetoothGattService == null) {
            return false;
        }
        BluetoothDevice bluetoothDevice = bluetoothGattService.getDevice();
        if (bluetoothDevice == null) {
            return false;
        }
        try {
            this.mService.registerForNotification(this.mClientIf, bluetoothDevice.getAddress(), bluetoothGattService.getType(), bluetoothGattService.getInstanceId(), new ParcelUuid(bluetoothGattService.getUuid()), bluetoothGattCharacteristic.getInstanceId(), new ParcelUuid(bluetoothGattCharacteristic.getUuid()), bl);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        if ((8 & bluetoothGattCharacteristic.getProperties()) == 0 && (4 & bluetoothGattCharacteristic.getProperties()) == 0) {
            return false;
        }
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattService bluetoothGattService = bluetoothGattCharacteristic.getService();
        if (bluetoothGattService == null) {
            return false;
        }
        BluetoothDevice bluetoothDevice = bluetoothGattService.getDevice();
        if (bluetoothDevice == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.writeCharacteristic(this.mClientIf, bluetoothDevice.getAddress(), bluetoothGattService.getType(), bluetoothGattService.getInstanceId(), new ParcelUuid(bluetoothGattService.getUuid()), bluetoothGattCharacteristic.getInstanceId(), new ParcelUuid(bluetoothGattCharacteristic.getUuid()), bluetoothGattCharacteristic.getWriteType(), 0, bluetoothGattCharacteristic.getValue());
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            this.mDeviceBusy = false;
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor) {
        if (this.mService == null || this.mClientIf == 0) {
            return false;
        }
        BluetoothGattCharacteristic bluetoothGattCharacteristic = bluetoothGattDescriptor.getCharacteristic();
        if (bluetoothGattCharacteristic == null) {
            return false;
        }
        BluetoothGattService bluetoothGattService = bluetoothGattCharacteristic.getService();
        if (bluetoothGattService == null) {
            return false;
        }
        BluetoothDevice bluetoothDevice = bluetoothGattService.getDevice();
        if (bluetoothDevice == null) {
            return false;
        }
        Boolean bl = this.mDeviceBusy;
        synchronized (bl) {
            if (this.mDeviceBusy.booleanValue()) {
                return false;
            }
            this.mDeviceBusy = true;
        }
        try {
            this.mService.writeDescriptor(this.mClientIf, bluetoothDevice.getAddress(), bluetoothGattService.getType(), bluetoothGattService.getInstanceId(), new ParcelUuid(bluetoothGattService.getUuid()), bluetoothGattCharacteristic.getInstanceId(), new ParcelUuid(bluetoothGattCharacteristic.getUuid()), bluetoothGattDescriptor.getInstanceId(), new ParcelUuid(bluetoothGattDescriptor.getUuid()), bluetoothGattCharacteristic.getWriteType(), 0, bluetoothGattDescriptor.getValue());
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            this.mDeviceBusy = false;
            return false;
        }
    }
}

