/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothAvrcpController;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothAvrcpController
implements BluetoothProfile {
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.acrcp-controller.profile.action.CONNECTION_STATE_CHANGED";
    private static final boolean DBG = true;
    private static final String TAG = "BluetoothAvrcpController";
    private static final boolean VDBG;
    private BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onBluetoothStateChange(boolean bl) {
            Log.d(BluetoothAvrcpController.TAG, "onBluetoothStateChange: up=" + bl);
            if (!bl) {
                ServiceConnection serviceConnection = BluetoothAvrcpController.this.mConnection;
                synchronized (serviceConnection) {
                    try {
                        BluetoothAvrcpController.access$102(BluetoothAvrcpController.this, null);
                        BluetoothAvrcpController.this.mContext.unbindService(BluetoothAvrcpController.this.mConnection);
                    }
                    catch (Exception exception) {
                        Log.e(BluetoothAvrcpController.TAG, "", exception);
                    }
                    return;
                }
            }
            ServiceConnection serviceConnection = BluetoothAvrcpController.this.mConnection;
            synchronized (serviceConnection) {
                try {
                    if (BluetoothAvrcpController.this.mService == null) {
                        BluetoothAvrcpController.this.doBind();
                    }
                }
                catch (Exception exception) {
                    Log.e(BluetoothAvrcpController.TAG, "", exception);
                }
                return;
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.d(BluetoothAvrcpController.TAG, "Proxy object connected");
            BluetoothAvrcpController.access$102(BluetoothAvrcpController.this, IBluetoothAvrcpController.Stub.asInterface(iBinder));
            if (BluetoothAvrcpController.this.mServiceListener != null) {
                BluetoothAvrcpController.this.mServiceListener.onServiceConnected(11, BluetoothAvrcpController.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            Log.d(BluetoothAvrcpController.TAG, "Proxy object disconnected");
            BluetoothAvrcpController.access$102(BluetoothAvrcpController.this, null);
            if (BluetoothAvrcpController.this.mServiceListener != null) {
                BluetoothAvrcpController.this.mServiceListener.onServiceDisconnected(11);
            }
        }
    };
    private Context mContext;
    private IBluetoothAvrcpController mService;
    private BluetoothProfile.ServiceListener mServiceListener;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BluetoothAvrcpController(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.mContext = context;
        this.mServiceListener = serviceListener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
            }
        }
        this.doBind();
    }

    static /* synthetic */ IBluetoothAvrcpController access$102(BluetoothAvrcpController bluetoothAvrcpController, IBluetoothAvrcpController iBluetoothAvrcpController) {
        bluetoothAvrcpController.mService = iBluetoothAvrcpController;
        return iBluetoothAvrcpController;
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return bluetoothDevice != null && BluetoothAdapter.checkBluetoothAddress(bluetoothDevice.getAddress());
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close() {
        this.mServiceListener = null;
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception exception) {
                Log.e(TAG, "", exception);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            IBluetoothAvrcpController iBluetoothAvrcpController = this.mService;
            if (iBluetoothAvrcpController != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception exception) {
                    Log.e(TAG, "", exception);
                }
            }
            return;
        }
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothAvrcpController.class.getName());
        ComponentName componentName = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(componentName);
        if (componentName == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth AVRCP Controller Service with " + intent);
            return false;
        }
        return true;
    }

    public void finalize() {
        this.close();
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getConnectedDevices();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mService.getConnectionState(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        IBluetoothAvrcpController iBluetoothAvrcpController = this.mService;
        int n = 0;
        if (iBluetoothAvrcpController != null) return n;
        Log.w(TAG, "Proxy not attached to service");
        return 0;
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getDevicesMatchingConnectionStates(nArray);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendPassThroughCmd(BluetoothDevice bluetoothDevice, int n, int n2) {
        Log.d(TAG, "sendPassThroughCmd");
        if (this.mService != null && this.isEnabled()) {
            try {
                this.mService.sendPassThroughCmd(bluetoothDevice, n, n2);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Error talking to BT service in sendPassThroughCmd()", remoteException);
                return;
            }
        } else {
            if (this.mService != null) return;
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
    }
}

