/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProviderInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.RemoteViewsAdapter;
import android.widget.TextView;

public class AppWidgetHostView
extends FrameLayout {
    static final boolean CROSSFADE = false;
    static final int FADE_DURATION = 1000;
    static final boolean LOGD = false;
    static final String TAG = "AppWidgetHostView";
    static final int VIEW_MODE_CONTENT = 1;
    static final int VIEW_MODE_DEFAULT = 3;
    static final int VIEW_MODE_ERROR = 2;
    static final int VIEW_MODE_NOINIT;
    static final LayoutInflater.Filter sInflaterFilter;
    int mAppWidgetId;
    Context mContext;
    long mFadeStartTime = -1L;
    AppWidgetProviderInfo mInfo;
    int mLayoutId = -1;
    Bitmap mOld;
    Paint mOldPaint = new Paint();
    private RemoteViews.OnClickHandler mOnClickHandler;
    Context mRemoteContext;
    View mView;
    int mViewMode = 0;

    static {
        sInflaterFilter = new LayoutInflater.Filter(){

            @Override
            public boolean onLoadClass(Class clazz) {
                return clazz.isAnnotationPresent(RemoteViews.RemoteView.class);
            }
        };
    }

    public AppWidgetHostView(Context context) {
        this(context, 0x10A0000, 0x10A0001);
    }

    public AppWidgetHostView(Context context, int n, int n2) {
        super(context);
        this.mContext = context;
        this.setIsRootNamespace(true);
    }

    public AppWidgetHostView(Context context, RemoteViews.OnClickHandler onClickHandler) {
        this(context, 0x10A0000, 0x10A0001);
        this.mOnClickHandler = onClickHandler;
    }

    private int generateId() {
        int n = this.getId();
        if (n == -1) {
            n = this.mAppWidgetId;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Rect getDefaultPaddingForWidget(Context context, ComponentName componentName, Rect rect) {
        PackageManager packageManager = context.getPackageManager();
        if (rect == null) {
            rect = new Rect(0, 0, 0, 0);
        } else {
            rect.set(0, 0, 0, 0);
        }
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(componentName.getPackageName(), 0);
            if (applicationInfo.targetSdkVersion >= 14) {
                Resources resources = context.getResources();
                rect.left = resources.getDimensionPixelSize(17104971);
                rect.right = resources.getDimensionPixelSize(17104973);
                rect.top = resources.getDimensionPixelSize(17104972);
                rect.bottom = resources.getDimensionPixelSize(17104974);
            }
            return rect;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return rect;
        }
    }

    private Context getRemoteContext() {
        try {
            Context context = this.mContext.createApplicationContext(this.mInfo.providerInfo.applicationInfo, 4);
            return context;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e(TAG, "Package name " + this.mInfo.providerInfo.packageName + " not found");
            return this.mContext;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        Parcelable parcelable = sparseArray.get(this.generateId());
        ParcelableSparseArray parcelableSparseArray = null;
        if (parcelable != null) {
            boolean bl = parcelable instanceof ParcelableSparseArray;
            parcelableSparseArray = null;
            if (bl) {
                parcelableSparseArray = (ParcelableSparseArray)parcelable;
            }
        }
        if (parcelableSparseArray == null) {
            parcelableSparseArray = new ParcelableSparseArray();
        }
        try {
            super.dispatchRestoreInstanceState(parcelableSparseArray);
            return;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder().append("failed to restoreInstanceState for widget id: ").append(this.mAppWidgetId).append(", ");
            Object object = this.mInfo == null ? "null" : this.mInfo.provider;
            Log.e(TAG, stringBuilder.append(object).toString(), exception);
            return;
        }
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        ParcelableSparseArray parcelableSparseArray = new ParcelableSparseArray();
        super.dispatchSaveInstanceState(parcelableSparseArray);
        sparseArray.put(this.generateId(), parcelableSparseArray);
    }

    @Override
    protected boolean drawChild(Canvas canvas, View view, long l) {
        return super.drawChild(canvas, view, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        Context context;
        if (this.mRemoteContext != null) {
            context = this.mRemoteContext;
            return new FrameLayout.LayoutParams(context, attributeSet);
        }
        context = this.mContext;
        return new FrameLayout.LayoutParams(context, attributeSet);
    }

    public int getAppWidgetId() {
        return this.mAppWidgetId;
    }

    public AppWidgetProviderInfo getAppWidgetInfo() {
        return this.mInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected View getDefaultView() {
        View view;
        RuntimeException runtimeException = null;
        try {
            if (this.mInfo != null) {
                View view2;
                int n;
                Context context;
                this.mRemoteContext = context = this.getRemoteContext();
                LayoutInflater layoutInflater = ((LayoutInflater)context.getSystemService("layout_inflater")).cloneInContext(context);
                layoutInflater.setFilter(sInflaterFilter);
                Bundle bundle = AppWidgetManager.getInstance(this.mContext).getAppWidgetOptions(this.mAppWidgetId);
                int n2 = this.mInfo.initialLayout;
                if (bundle.containsKey("appWidgetCategory") && bundle.getInt("appWidgetCategory") == 2 && (n = this.mInfo.initialKeyguardLayout) != 0) {
                    n2 = n;
                }
                view = view2 = layoutInflater.inflate(n2, (ViewGroup)this, false);
            } else {
                Log.w(TAG, "can't inflate defaultView because mInfo is missing");
                view = null;
                runtimeException = null;
            }
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
            view = null;
        }
        if (runtimeException != null) {
            Log.w(TAG, "Error inflating AppWidget " + this.mInfo + ": " + runtimeException.toString());
        }
        if (view != null) return view;
        return this.getErrorView();
    }

    protected View getErrorView() {
        TextView textView = new TextView(this.mContext);
        textView.setText(17040675);
        textView.setBackgroundColor(Color.argb(127, 0, 0, 0));
        return textView;
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(AppWidgetHostView.class.getName());
    }

    protected void prepareView(View view) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new FrameLayout.LayoutParams(-1, -1);
        }
        layoutParams.gravity = 17;
        view.setLayoutParams(layoutParams);
    }

    void resetAppWidget(AppWidgetProviderInfo appWidgetProviderInfo) {
        this.mInfo = appWidgetProviderInfo;
        this.mViewMode = 0;
        this.updateAppWidget(null);
    }

    public void setAppWidget(int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        this.mAppWidgetId = n;
        this.mInfo = appWidgetProviderInfo;
        if (appWidgetProviderInfo != null) {
            Rect rect = AppWidgetHostView.getDefaultPaddingForWidget(this.mContext, appWidgetProviderInfo.provider, null);
            this.setPadding(rect.left, rect.top, rect.right, rect.bottom);
            this.setContentDescription(appWidgetProviderInfo.label);
        }
    }

    public void setOnClickHandler(RemoteViews.OnClickHandler onClickHandler) {
        this.mOnClickHandler = onClickHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateAppWidget(RemoteViews remoteViews) {
        View view;
        block14: {
            block11: {
                boolean bl;
                block13: {
                    RuntimeException runtimeException;
                    block12: {
                        block10: {
                            bl = false;
                            runtimeException = null;
                            if (remoteViews != null) break block10;
                            if (this.mViewMode == 3) break block11;
                            view = this.getDefaultView();
                            this.mLayoutId = -1;
                            this.mViewMode = 3;
                            break block12;
                        }
                        this.mRemoteContext = this.getRemoteContext();
                        int n = remoteViews.getLayoutId();
                        view = null;
                        runtimeException = null;
                        bl = false;
                        int n2 = this.mLayoutId;
                        view = null;
                        runtimeException = null;
                        bl = false;
                        if (n == n2) {
                            try {
                                remoteViews.reapply(this.mContext, this.mView, this.mOnClickHandler);
                                view = this.mView;
                                bl = true;
                            }
                            catch (RuntimeException runtimeException2) {
                                runtimeException = runtimeException2;
                                view = null;
                                bl = false;
                            }
                        }
                        if (view == null) {
                            try {
                                View view2;
                                view = view2 = remoteViews.apply(this.mContext, this, this.mOnClickHandler);
                            }
                            catch (RuntimeException runtimeException3) {
                                runtimeException = runtimeException3;
                            }
                        }
                        this.mLayoutId = n;
                        this.mViewMode = 1;
                    }
                    if (view != null) break block13;
                    if (this.mViewMode == 2) break block11;
                    Log.w(TAG, "updateAppWidget couldn't find any view, using error view", runtimeException);
                    view = this.getErrorView();
                    this.mViewMode = 2;
                }
                if (!bl) {
                    this.prepareView(view);
                    this.addView(view);
                }
                if (this.mView != view) break block14;
            }
            return;
        }
        this.removeView(this.mView);
        this.mView = view;
    }

    public void updateAppWidgetOptions(Bundle bundle) {
        AppWidgetManager.getInstance(this.mContext).updateAppWidgetOptions(this.mAppWidgetId, bundle);
    }

    public void updateAppWidgetSize(Bundle bundle, int n, int n2, int n3, int n4) {
        this.updateAppWidgetSize(bundle, n, n2, n3, n4, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateAppWidgetSize(Bundle bundle, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        int n5;
        int n6;
        int n7;
        int n8;
        block9: {
            block8: {
                if (bundle == null) {
                    bundle = new Bundle();
                }
                Rect rect = new Rect();
                if (this.mInfo != null) {
                    rect = AppWidgetHostView.getDefaultPaddingForWidget(this.mContext, this.mInfo.provider, rect);
                }
                float f = this.getResources().getDisplayMetrics().density;
                int n9 = (int)((float)(rect.left + rect.right) / f);
                int n10 = (int)((float)(rect.top + rect.bottom) / f);
                int n11 = bl ? 0 : n9;
                n8 = n - n11;
                int n12 = bl ? 0 : n10;
                n7 = n2 - n12;
                if (bl) {
                    n9 = 0;
                }
                n6 = n3 - n9;
                if (bl) {
                    n10 = 0;
                }
                n5 = n4 - n10;
                Bundle bundle2 = AppWidgetManager.getInstance(this.mContext).getAppWidgetOptions(this.mAppWidgetId);
                if (n8 != bundle2.getInt("appWidgetMinWidth") || n7 != bundle2.getInt("appWidgetMinHeight") || n6 != bundle2.getInt("appWidgetMaxWidth")) break block8;
                int n13 = bundle2.getInt("appWidgetMaxHeight");
                bl2 = false;
                if (n5 == n13) break block9;
            }
            bl2 = true;
        }
        if (bl2) {
            bundle.putInt("appWidgetMinWidth", n8);
            bundle.putInt("appWidgetMinHeight", n7);
            bundle.putInt("appWidgetMaxWidth", n6);
            bundle.putInt("appWidgetMaxHeight", n5);
            this.updateAppWidgetOptions(bundle);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void viewDataChanged(int n) {
        View view = this.findViewById(n);
        if (view == null || !(view instanceof AdapterView)) return;
        AdapterView adapterView = (AdapterView)view;
        Object t = adapterView.getAdapter();
        if (t instanceof BaseAdapter) {
            ((BaseAdapter)t).notifyDataSetChanged();
            return;
        } else {
            if (t != null || !(adapterView instanceof RemoteViewsAdapter.RemoteAdapterConnectionCallback)) return;
            ((RemoteViewsAdapter.RemoteAdapterConnectionCallback)((Object)adapterView)).deferNotifyDataSetChanged();
            return;
        }
    }

    private static class ParcelableSparseArray
    extends SparseArray<Parcelable>
    implements Parcelable {
        public static final Parcelable.Creator<ParcelableSparseArray> CREATOR = new Parcelable.Creator<ParcelableSparseArray>(){

            @Override
            public ParcelableSparseArray createFromParcel(Parcel parcel) {
                ParcelableSparseArray parcelableSparseArray = new ParcelableSparseArray();
                ClassLoader classLoader = parcelableSparseArray.getClass().getClassLoader();
                int n = parcel.readInt();
                for (int i = 0; i < n; ++i) {
                    parcelableSparseArray.put(parcel.readInt(), parcel.readParcelable(classLoader));
                }
                return parcelableSparseArray;
            }

            public ParcelableSparseArray[] newArray(int n) {
                return new ParcelableSparseArray[n];
            }
        };

        private ParcelableSparseArray() {
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = this.size();
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeInt(this.keyAt(i));
                parcel.writeParcelable((Parcelable)this.valueAt(i), 0);
            }
        }
    }
}

