/*
 * Decompiled with CFR 0.152.
 */
package android.app.trust;

import android.app.trust.ITrustListener;
import android.app.trust.ITrustManager;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;

public class TrustManager {
    private static final String DATA_INITIATED_BY_USER = "initiatedByUser";
    private static final int MSG_TRUST_CHANGED = 1;
    private static final int MSG_TRUST_MANAGED_CHANGED = 2;
    private static final String TAG = "TrustManager";
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            boolean bl = true;
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    boolean bl2 = message.peekData() != null && message.peekData().getBoolean(TrustManager.DATA_INITIATED_BY_USER) ? bl : false;
                    TrustListener trustListener = (TrustListener)message.obj;
                    if (message.arg1 == 0) {
                        bl = false;
                    }
                    trustListener.onTrustChanged(bl, message.arg2, bl2);
                    return;
                }
                case 2: 
            }
            TrustListener trustListener = (TrustListener)message.obj;
            if (message.arg1 == 0) {
                bl = false;
            }
            trustListener.onTrustManagedChanged(bl, message.arg2);
        }
    };
    private final ITrustManager mService;
    private final ArrayMap<TrustListener, ITrustListener> mTrustListeners;

    public TrustManager(IBinder iBinder) {
        this.mService = ITrustManager.Stub.asInterface(iBinder);
        this.mTrustListeners = new ArrayMap();
    }

    private void onError(Exception exception) {
        Log.e(TAG, "Error while calling TrustManagerService", exception);
    }

    public void registerTrustListener(final TrustListener trustListener) {
        try {
            ITrustListener.Stub stub = new ITrustListener.Stub(){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void onTrustChanged(boolean bl, int n, boolean bl2) {
                    Handler handler = TrustManager.this.mHandler;
                    int n2 = bl ? 1 : 0;
                    Message message = handler.obtainMessage(1, n2, n, trustListener);
                    if (bl2) {
                        message.getData().putBoolean(TrustManager.DATA_INITIATED_BY_USER, bl2);
                    }
                    message.sendToTarget();
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void onTrustManagedChanged(boolean bl, int n) {
                    Handler handler = TrustManager.this.mHandler;
                    int n2 = bl ? 1 : 0;
                    handler.obtainMessage(2, n2, n, trustListener).sendToTarget();
                }
            };
            this.mService.registerTrustListener(stub);
            this.mTrustListeners.put(trustListener, stub);
            return;
        }
        catch (RemoteException remoteException) {
            this.onError(remoteException);
            return;
        }
    }

    public void reportEnabledTrustAgentsChanged(int n) {
        try {
            this.mService.reportEnabledTrustAgentsChanged(n);
            return;
        }
        catch (RemoteException remoteException) {
            this.onError(remoteException);
            return;
        }
    }

    public void reportRequireCredentialEntry(int n) {
        try {
            this.mService.reportRequireCredentialEntry(n);
            return;
        }
        catch (RemoteException remoteException) {
            this.onError(remoteException);
            return;
        }
    }

    public void reportUnlockAttempt(boolean bl, int n) {
        try {
            this.mService.reportUnlockAttempt(bl, n);
            return;
        }
        catch (RemoteException remoteException) {
            this.onError(remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unregisterTrustListener(TrustListener trustListener) {
        ITrustListener iTrustListener = this.mTrustListeners.remove(trustListener);
        if (iTrustListener == null) return;
        try {
            this.mService.unregisterTrustListener(iTrustListener);
            return;
        }
        catch (RemoteException remoteException) {
            this.onError(remoteException);
            return;
        }
    }

    public static interface TrustListener {
        public void onTrustChanged(boolean var1, int var2, boolean var3);

        public void onTrustManagedChanged(boolean var1, int var2);
    }
}

