/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class BackupHelperDispatcher {
    private static final String TAG = "BackupHelperDispatcher";
    TreeMap<String, BackupHelper> mHelpers = new TreeMap();

    private static native int allocateHeader_native(Header var0, FileDescriptor var1);

    private void doOneBackup(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2, Header header, BackupHelper backupHelper) throws IOException {
        FileDescriptor fileDescriptor = parcelFileDescriptor2.getFileDescriptor();
        int n = BackupHelperDispatcher.allocateHeader_native(header, fileDescriptor);
        if (n < 0) {
            throw new IOException("allocateHeader_native failed (error " + n + ")");
        }
        backupDataOutput.setKeyPrefix(header.keyPrefix);
        backupHelper.performBackup(parcelFileDescriptor, backupDataOutput, parcelFileDescriptor2);
        int n2 = BackupHelperDispatcher.writeHeader_native(header, fileDescriptor, n);
        if (n2 != 0) {
            throw new IOException("writeHeader_native failed (error " + n2 + ")");
        }
    }

    private static native int readHeader_native(Header var0, FileDescriptor var1);

    private static native int skipChunk_native(FileDescriptor var0, int var1);

    private static native int writeHeader_native(Header var0, FileDescriptor var1, int var2);

    public void addHelper(String string2, BackupHelper backupHelper) {
        this.mHelpers.put(string2, backupHelper);
    }

    public void performBackup(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2) throws IOException {
        Header header = new Header();
        TreeMap treeMap = (TreeMap)this.mHelpers.clone();
        parcelFileDescriptor2.getFileDescriptor();
        if (parcelFileDescriptor != null) {
            int n;
            FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
            while ((n = BackupHelperDispatcher.readHeader_native(header, fileDescriptor)) >= 0) {
                if (n != 0) continue;
                BackupHelper backupHelper = (BackupHelper)treeMap.get(header.keyPrefix);
                Log.d(TAG, "handling existing helper '" + header.keyPrefix + "' " + backupHelper);
                if (backupHelper != null) {
                    this.doOneBackup(parcelFileDescriptor, backupDataOutput, parcelFileDescriptor2, header, backupHelper);
                    treeMap.remove(header.keyPrefix);
                    continue;
                }
                BackupHelperDispatcher.skipChunk_native(fileDescriptor, header.chunkSize);
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            header.keyPrefix = (String)entry.getKey();
            Log.d(TAG, "handling new helper '" + header.keyPrefix + "'");
            this.doOneBackup(parcelFileDescriptor, backupDataOutput, parcelFileDescriptor2, header, (BackupHelper)entry.getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void performRestore(BackupDataInput backupDataInput, int n, ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        boolean bl = false;
        BackupDataInputStream backupDataInputStream = new BackupDataInputStream(backupDataInput);
        while (backupDataInput.readNextHeader()) {
            block8: {
                String string2;
                block7: {
                    string2 = backupDataInput.getKey();
                    int n2 = string2.indexOf(58);
                    if (n2 <= 0) break block7;
                    String string3 = string2.substring(0, n2);
                    BackupHelper backupHelper = this.mHelpers.get(string3);
                    if (backupHelper != null) {
                        backupDataInputStream.dataSize = backupDataInput.getDataSize();
                        backupDataInputStream.key = string2.substring(n2 + 1);
                        backupHelper.restoreEntity(backupDataInputStream);
                        break block8;
                    } else if (!bl) {
                        Log.w(TAG, "Couldn't find helper for: '" + string2 + "'");
                        bl = true;
                    }
                    break block8;
                }
                if (!bl) {
                    Log.w(TAG, "Entity with no prefix: '" + string2 + "'");
                    bl = true;
                }
            }
            backupDataInput.skipEntityData();
        }
        Iterator iterator = this.mHelpers.values().iterator();
        while (iterator.hasNext()) {
            ((BackupHelper)iterator.next()).writeNewStateDescription(parcelFileDescriptor);
        }
        return;
    }

    private static class Header {
        int chunkSize;
        String keyPrefix;

        private Header() {
        }
    }
}

