/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.app.admin.DeviceAdminInfo;
import android.app.admin.IDevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ProxyInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.security.Credentials;
import android.util.Log;
import com.android.org.conscrypt.TrustedCertificateStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class DevicePolicyManager {
    public static final String ACTION_ADD_DEVICE_ADMIN = "android.app.action.ADD_DEVICE_ADMIN";
    public static final String ACTION_DEVICE_POLICY_MANAGER_STATE_CHANGED = "android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED";
    public static final String ACTION_PROVISION_MANAGED_PROFILE = "android.app.action.PROVISION_MANAGED_PROFILE";
    public static final String ACTION_SET_NEW_PASSWORD = "android.app.action.SET_NEW_PASSWORD";
    public static final String ACTION_SET_PROFILE_OWNER = "android.app.action.SET_PROFILE_OWNER";
    public static final String ACTION_START_ENCRYPTION = "android.app.action.START_ENCRYPTION";
    public static final int ENCRYPTION_STATUS_ACTIVATING = 2;
    public static final int ENCRYPTION_STATUS_ACTIVE = 3;
    public static final int ENCRYPTION_STATUS_INACTIVE = 1;
    public static final int ENCRYPTION_STATUS_UNSUPPORTED = 0;
    public static final String EXTRA_ADD_EXPLANATION = "android.app.extra.ADD_EXPLANATION";
    public static final String EXTRA_DEVICE_ADMIN = "android.app.extra.DEVICE_ADMIN";
    public static final String EXTRA_PROFILE_OWNER_NAME = "android.app.extra.PROFILE_OWNER_NAME";
    public static final String EXTRA_PROVISIONING_ADMIN_EXTRAS_BUNDLE = "android.app.extra.PROVISIONING_ADMIN_EXTRAS_BUNDLE";
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_CHECKSUM = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_CHECKSUM";
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_COOKIE_HEADER = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_COOKIE_HEADER";
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_LOCATION = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_DOWNLOAD_LOCATION";
    public static final String EXTRA_PROVISIONING_DEVICE_ADMIN_PACKAGE_NAME = "android.app.extra.PROVISIONING_DEVICE_ADMIN_PACKAGE_NAME";
    public static final String EXTRA_PROVISIONING_EMAIL_ADDRESS = "android.app.extra.PROVISIONING_EMAIL_ADDRESS";
    public static final String EXTRA_PROVISIONING_LOCALE = "android.app.extra.PROVISIONING_LOCALE";
    public static final String EXTRA_PROVISIONING_LOCAL_TIME = "android.app.extra.PROVISIONING_LOCAL_TIME";
    public static final String EXTRA_PROVISIONING_TIME_ZONE = "android.app.extra.PROVISIONING_TIME_ZONE";
    public static final String EXTRA_PROVISIONING_WIFI_HIDDEN = "android.app.extra.PROVISIONING_WIFI_HIDDEN";
    public static final String EXTRA_PROVISIONING_WIFI_PAC_URL = "android.app.extra.PROVISIONING_WIFI_PAC_URL";
    public static final String EXTRA_PROVISIONING_WIFI_PASSWORD = "android.app.extra.PROVISIONING_WIFI_PASSWORD";
    public static final String EXTRA_PROVISIONING_WIFI_PROXY_BYPASS = "android.app.extra.PROVISIONING_WIFI_PROXY_BYPASS";
    public static final String EXTRA_PROVISIONING_WIFI_PROXY_HOST = "android.app.extra.PROVISIONING_WIFI_PROXY_HOST";
    public static final String EXTRA_PROVISIONING_WIFI_PROXY_PORT = "android.app.extra.PROVISIONING_WIFI_PROXY_PORT";
    public static final String EXTRA_PROVISIONING_WIFI_SECURITY_TYPE = "android.app.extra.PROVISIONING_WIFI_SECURITY_TYPE";
    public static final String EXTRA_PROVISIONING_WIFI_SSID = "android.app.extra.PROVISIONING_WIFI_SSID";
    public static final int FLAG_MANAGED_CAN_ACCESS_PARENT = 2;
    public static final int FLAG_PARENT_CAN_ACCESS_MANAGED = 1;
    public static final int KEYGUARD_DISABLE_FEATURES_ALL = Integer.MAX_VALUE;
    public static final int KEYGUARD_DISABLE_FEATURES_NONE = 0;
    public static final int KEYGUARD_DISABLE_FINGERPRINT = 32;
    public static final int KEYGUARD_DISABLE_SECURE_CAMERA = 2;
    public static final int KEYGUARD_DISABLE_SECURE_NOTIFICATIONS = 4;
    public static final int KEYGUARD_DISABLE_TRUST_AGENTS = 16;
    public static final int KEYGUARD_DISABLE_UNREDACTED_NOTIFICATIONS = 8;
    public static final int KEYGUARD_DISABLE_WIDGETS_ALL = 1;
    public static final String MIME_TYPE_PROVISIONING_NFC = "application/com.android.managedprovisioning";
    public static final int PASSWORD_QUALITY_ALPHABETIC = 262144;
    public static final int PASSWORD_QUALITY_ALPHANUMERIC = 327680;
    public static final int PASSWORD_QUALITY_BIOMETRIC_WEAK = 32768;
    public static final int PASSWORD_QUALITY_COMPLEX = 393216;
    public static final int PASSWORD_QUALITY_NUMERIC = 131072;
    public static final int PASSWORD_QUALITY_NUMERIC_COMPLEX = 196608;
    public static final int PASSWORD_QUALITY_SOMETHING = 65536;
    public static final int PASSWORD_QUALITY_UNSPECIFIED = 0;
    public static final int RESET_PASSWORD_REQUIRE_ENTRY = 1;
    private static String TAG = "DevicePolicyManager";
    public static final int WIPE_EXTERNAL_STORAGE = 1;
    private final Context mContext;
    private final IDevicePolicyManager mService;

    private DevicePolicyManager(Context context, Handler handler) {
        this.mContext = context;
        this.mService = IDevicePolicyManager.Stub.asInterface(ServiceManager.getService("device_policy"));
    }

    public static DevicePolicyManager create(Context context, Handler handler) {
        DevicePolicyManager devicePolicyManager = new DevicePolicyManager(context, handler);
        if (devicePolicyManager.mService != null) {
            return devicePolicyManager;
        }
        return null;
    }

    private static String getCaCertAlias(byte[] byArray) throws CertificateException {
        X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(byArray));
        return new TrustedCertificateStore().getCertificateAlias((Certificate)x509Certificate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addCrossProfileIntentFilter(ComponentName componentName, IntentFilter intentFilter, int n) {
        if (this.mService == null) return;
        try {
            this.mService.addCrossProfileIntentFilter(componentName, intentFilter, n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public boolean addCrossProfileWidgetProvider(ComponentName componentName, String string2) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.addCrossProfileWidgetProvider(componentName, string2);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Error calling addCrossProfileWidgetProvider", remoteException);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPersistentPreferredActivity(ComponentName componentName, IntentFilter intentFilter, ComponentName componentName2) {
        if (this.mService == null) return;
        try {
            this.mService.addPersistentPreferredActivity(componentName, intentFilter, componentName2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addUserRestriction(ComponentName componentName, String string2) {
        if (this.mService == null) return;
        try {
            this.mService.setUserRestriction(componentName, string2, true);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearCrossProfileIntentFilters(ComponentName componentName) {
        if (this.mService == null) return;
        try {
            this.mService.clearCrossProfileIntentFilters(componentName);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearDeviceOwnerApp(String string2) {
        if (this.mService == null) return;
        try {
            this.mService.clearDeviceOwner(string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to clear device owner");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearPackagePersistentPreferredActivities(ComponentName componentName, String string2) {
        if (this.mService == null) return;
        try {
            this.mService.clearPackagePersistentPreferredActivities(componentName, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearProfileOwner(ComponentName componentName) {
        if (this.mService == null) return;
        try {
            this.mService.clearProfileOwner(componentName);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to clear profile owner " + componentName + remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void clearUserRestriction(ComponentName componentName, String string2) {
        if (this.mService == null) return;
        try {
            this.mService.setUserRestriction(componentName, string2, false);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public UserHandle createAndInitializeUser(ComponentName componentName, String string2, String string3, ComponentName componentName2, Bundle bundle) {
        try {
            UserHandle userHandle = this.mService.createAndInitializeUser(componentName, string2, string3, componentName2, bundle);
            return userHandle;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not create a user", remoteException);
            return null;
        }
    }

    public UserHandle createUser(ComponentName componentName, String string2) {
        try {
            UserHandle userHandle = this.mService.createUser(componentName, string2);
            return userHandle;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not create a user", remoteException);
            return null;
        }
    }

    public int enableSystemApp(ComponentName componentName, Intent intent) {
        if (this.mService != null) {
            try {
                int n = this.mService.enableSystemAppWithIntent(componentName, intent);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to install packages matching filter: " + intent);
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enableSystemApp(ComponentName componentName, String string2) {
        if (this.mService == null) return;
        try {
            this.mService.enableSystemApp(componentName, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to install package: " + string2);
            return;
        }
    }

    public String[] getAccountTypesWithManagementDisabled() {
        return this.getAccountTypesWithManagementDisabledAsUser(UserHandle.myUserId());
    }

    public String[] getAccountTypesWithManagementDisabledAsUser(int n) {
        if (this.mService != null) {
            try {
                String[] stringArray = this.mService.getAccountTypesWithManagementDisabledAsUser(n);
                return stringArray;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return null;
    }

    public List<ComponentName> getActiveAdmins() {
        return this.getActiveAdminsAsUser(UserHandle.myUserId());
    }

    public List<ComponentName> getActiveAdminsAsUser(int n) {
        if (this.mService != null) {
            try {
                List<ComponentName> list = this.mService.getActiveAdmins(n);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return null;
    }

    public DeviceAdminInfo getAdminInfo(ComponentName componentName) {
        ResolveInfo resolveInfo;
        try {
            ActivityInfo activityInfo = this.mContext.getPackageManager().getReceiverInfo(componentName, 128);
            resolveInfo = new ResolveInfo();
            resolveInfo.activityInfo = activityInfo;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w(TAG, "Unable to retrieve device policy " + componentName, nameNotFoundException);
            return null;
        }
        try {
            DeviceAdminInfo deviceAdminInfo = new DeviceAdminInfo(this.mContext, resolveInfo);
            return deviceAdminInfo;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Log.w(TAG, "Unable to parse device policy " + componentName, xmlPullParserException);
            return null;
        }
        catch (IOException iOException) {
            Log.w(TAG, "Unable to parse device policy " + componentName, iOException);
            return null;
        }
    }

    public Bundle getApplicationRestrictions(ComponentName componentName, String string2) {
        if (this.mService != null) {
            try {
                Bundle bundle = this.mService.getApplicationRestrictions(componentName, string2);
                return bundle;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return null;
    }

    public boolean getAutoTimeRequired() {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.getAutoTimeRequired();
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public boolean getCameraDisabled(ComponentName componentName) {
        return this.getCameraDisabled(componentName, UserHandle.myUserId());
    }

    public boolean getCameraDisabled(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.getCameraDisabled(componentName, n);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public boolean getCrossProfileCallerIdDisabled(ComponentName componentName) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.getCrossProfileCallerIdDisabled(componentName);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public boolean getCrossProfileCallerIdDisabled(UserHandle userHandle) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.getCrossProfileCallerIdDisabledForUser(userHandle.getIdentifier());
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public List<String> getCrossProfileWidgetProviders(ComponentName componentName) {
        if (this.mService != null) {
            try {
                List<String> list = this.mService.getCrossProfileWidgetProviders(componentName);
                if (list != null) {
                    return list;
                }
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Error calling getCrossProfileWidgetProviders", remoteException);
            }
        }
        return Collections.emptyList();
    }

    public int getCurrentFailedPasswordAttempts() {
        if (this.mService != null) {
            try {
                int n = this.mService.getCurrentFailedPasswordAttempts(UserHandle.myUserId());
                return n;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return -1;
    }

    public String getDeviceOwner() {
        if (this.mService != null) {
            try {
                String string2 = this.mService.getDeviceOwner();
                return string2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to get device owner");
            }
        }
        return null;
    }

    public String getDeviceOwnerName() {
        if (this.mService != null) {
            try {
                String string2 = this.mService.getDeviceOwnerName();
                return string2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to get device owner");
            }
        }
        return null;
    }

    public ComponentName getGlobalProxyAdmin() {
        if (this.mService != null) {
            try {
                ComponentName componentName = this.mService.getGlobalProxyAdmin(UserHandle.myUserId());
                return componentName;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return null;
    }

    public List<byte[]> getInstalledCaCerts(ComponentName componentName) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        if (this.mService != null) {
            this.mService.enforceCanManageCaCerts(componentName);
            TrustedCertificateStore trustedCertificateStore = new TrustedCertificateStore();
            for (String string2 : trustedCertificateStore.userAliases()) {
                try {
                    arrayList.add(trustedCertificateStore.getCertificate(string2).getEncoded());
                }
                catch (CertificateException certificateException) {
                    try {
                        Log.w(TAG, "Could not encode certificate: " + string2, certificateException);
                    }
                    catch (RemoteException remoteException) {
                        Log.w(TAG, "Failed talking with device policy service", remoteException);
                        break;
                    }
                }
            }
        }
        return arrayList;
    }

    public int getKeyguardDisabledFeatures(ComponentName componentName) {
        return this.getKeyguardDisabledFeatures(componentName, UserHandle.myUserId());
    }

    public int getKeyguardDisabledFeatures(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getKeyguardDisabledFeatures(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public String[] getLockTaskPackages(ComponentName componentName) {
        if (this.mService != null) {
            try {
                String[] stringArray = this.mService.getLockTaskPackages(componentName);
                return stringArray;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return null;
    }

    public int getMaximumFailedPasswordsForWipe(ComponentName componentName) {
        return this.getMaximumFailedPasswordsForWipe(componentName, UserHandle.myUserId());
    }

    public int getMaximumFailedPasswordsForWipe(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getMaximumFailedPasswordsForWipe(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public long getMaximumTimeToLock(ComponentName componentName) {
        return this.getMaximumTimeToLock(componentName, UserHandle.myUserId());
    }

    public long getMaximumTimeToLock(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                long l = this.mService.getMaximumTimeToLock(componentName, n);
                return l;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0L;
    }

    public long getPasswordExpiration(ComponentName componentName) {
        if (this.mService != null) {
            try {
                long l = this.mService.getPasswordExpiration(componentName, UserHandle.myUserId());
                return l;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0L;
    }

    public long getPasswordExpirationTimeout(ComponentName componentName) {
        if (this.mService != null) {
            try {
                long l = this.mService.getPasswordExpirationTimeout(componentName, UserHandle.myUserId());
                return l;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0L;
    }

    public int getPasswordHistoryLength(ComponentName componentName) {
        return this.getPasswordHistoryLength(componentName, UserHandle.myUserId());
    }

    public int getPasswordHistoryLength(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getPasswordHistoryLength(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public int getPasswordLength(ComponentName componentName) {
        return this.getPasswordLength(componentName, UserHandle.myUserId());
    }

    public int getPasswordLength(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getPasswordLength(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return -1;
    }

    public int getPasswordMaximumLength(int n) {
        return 16;
    }

    public int getPasswordMinimumLength(ComponentName componentName) {
        return this.getPasswordMinimumLength(componentName, UserHandle.myUserId());
    }

    public int getPasswordMinimumLength(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getPasswordMinimumLength(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public int getPasswordMinimumLetters(ComponentName componentName) {
        return this.getPasswordMinimumLetters(componentName, UserHandle.myUserId());
    }

    public int getPasswordMinimumLetters(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getPasswordMinimumLetters(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public int getPasswordMinimumLowerCase(ComponentName componentName) {
        return this.getPasswordMinimumLowerCase(componentName, UserHandle.myUserId());
    }

    public int getPasswordMinimumLowerCase(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getPasswordMinimumLowerCase(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public int getPasswordMinimumNonLetter(ComponentName componentName) {
        return this.getPasswordMinimumNonLetter(componentName, UserHandle.myUserId());
    }

    public int getPasswordMinimumNonLetter(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getPasswordMinimumNonLetter(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public int getPasswordMinimumNumeric(ComponentName componentName) {
        return this.getPasswordMinimumNumeric(componentName, UserHandle.myUserId());
    }

    public int getPasswordMinimumNumeric(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getPasswordMinimumNumeric(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public int getPasswordMinimumSymbols(ComponentName componentName) {
        return this.getPasswordMinimumSymbols(componentName, UserHandle.myUserId());
    }

    public int getPasswordMinimumSymbols(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getPasswordMinimumSymbols(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public int getPasswordMinimumUpperCase(ComponentName componentName) {
        return this.getPasswordMinimumUpperCase(componentName, UserHandle.myUserId());
    }

    public int getPasswordMinimumUpperCase(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getPasswordMinimumUpperCase(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public int getPasswordQuality(ComponentName componentName) {
        return this.getPasswordQuality(componentName, UserHandle.myUserId());
    }

    public int getPasswordQuality(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getPasswordQuality(componentName, n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public List<String> getPermittedAccessibilityServices(int n) {
        if (this.mService != null) {
            try {
                List list = this.mService.getPermittedAccessibilityServicesForUser(n);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return null;
    }

    public List<String> getPermittedAccessibilityServices(ComponentName componentName) {
        if (this.mService != null) {
            try {
                List list = this.mService.getPermittedAccessibilityServices(componentName);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return null;
    }

    public List<String> getPermittedInputMethods(ComponentName componentName) {
        if (this.mService != null) {
            try {
                List list = this.mService.getPermittedInputMethods(componentName);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return null;
    }

    public List<String> getPermittedInputMethodsForCurrentUser() {
        if (this.mService != null) {
            try {
                List list = this.mService.getPermittedInputMethodsForCurrentUser();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return null;
    }

    public ComponentName getProfileOwner() throws IllegalArgumentException {
        return this.getProfileOwnerAsUser(Process.myUserHandle().getIdentifier());
    }

    public ComponentName getProfileOwnerAsUser(int n) throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                ComponentName componentName = this.mService.getProfileOwner(n);
                return componentName;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to get profile owner");
                throw new IllegalArgumentException("Requested profile owner for invalid userId", remoteException);
            }
        }
        return null;
    }

    public String getProfileOwnerName() throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                String string2 = this.mService.getProfileOwnerName(Process.myUserHandle().getIdentifier());
                return string2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to get profile owner");
                throw new IllegalArgumentException("Requested profile owner for invalid userId", remoteException);
            }
        }
        return null;
    }

    public String getProfileOwnerNameAsUser(int n) throws IllegalArgumentException {
        if (this.mService != null) {
            try {
                String string2 = this.mService.getProfileOwnerName(n);
                return string2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to get profile owner");
                throw new IllegalArgumentException("Requested profile owner for invalid userId", remoteException);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getRemoveWarning(ComponentName componentName, RemoteCallback remoteCallback) {
        if (this.mService == null) return;
        try {
            this.mService.getRemoveWarning(componentName, remoteCallback, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public boolean getScreenCaptureDisabled(ComponentName componentName) {
        return this.getScreenCaptureDisabled(componentName, UserHandle.myUserId());
    }

    public boolean getScreenCaptureDisabled(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.getScreenCaptureDisabled(componentName, n);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public boolean getSimplePasswordEnabled(ComponentName componentName) {
        return this.getSimplePasswordEnabled(componentName, UserHandle.myUserId());
    }

    public boolean getSimplePasswordEnabled(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.getSimplePasswordEnabled(componentName, n);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return true;
    }

    public boolean getStorageEncryption(ComponentName componentName) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.getStorageEncryption(componentName, UserHandle.myUserId());
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public int getStorageEncryptionStatus() {
        return this.getStorageEncryptionStatus(UserHandle.myUserId());
    }

    public int getStorageEncryptionStatus(int n) {
        if (this.mService != null) {
            try {
                int n2 = this.mService.getStorageEncryptionStatus(n);
                return n2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    public List<String> getTrustAgentFeaturesEnabled(ComponentName componentName, ComponentName componentName2) {
        if (this.mService != null) {
            try {
                List<String> list = this.mService.getTrustAgentFeaturesEnabled(componentName, componentName2, UserHandle.myUserId());
                return list;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return new ArrayList<String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasCaCertInstalled(ComponentName componentName, byte[] byArray) {
        IDevicePolicyManager iDevicePolicyManager = this.mService;
        boolean bl = false;
        if (iDevicePolicyManager == null) return bl;
        try {
            this.mService.enforceCanManageCaCerts(componentName);
            String string2 = DevicePolicyManager.getCaCertAlias(byArray);
            bl = false;
            if (string2 == null) return bl;
            return true;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return false;
        }
        catch (CertificateException certificateException) {
            Log.w(TAG, "Could not parse certificate", certificateException);
            return false;
        }
    }

    public boolean hasGrantedPolicy(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.hasGrantedPolicy(componentName, n, UserHandle.myUserId());
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public boolean hasUserSetupCompleted() {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.hasUserSetupCompleted();
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to check if user setup has completed");
            }
        }
        return true;
    }

    public boolean installCaCert(ComponentName componentName, byte[] byArray) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.installCaCert(componentName, byArray);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public boolean installKeyPair(ComponentName componentName, PrivateKey privateKey, Certificate certificate, String string2) {
        try {
            byte[] byArray = Credentials.convertToPem(certificate);
            boolean bl = this.mService.installKeyPair(componentName, privateKey.getEncoded(), byArray, string2);
            return bl;
        }
        catch (CertificateException certificateException) {
            Log.w(TAG, "Error encoding certificate", certificateException);
            return false;
        }
        catch (IOException iOException) {
            Log.w(TAG, "Error writing certificate", iOException);
            return false;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return false;
        }
    }

    public boolean isActivePasswordSufficient() {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.isActivePasswordSufficient(UserHandle.myUserId());
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public boolean isAdminActive(ComponentName componentName) {
        return this.isAdminActiveAsUser(componentName, UserHandle.myUserId());
    }

    public boolean isAdminActiveAsUser(ComponentName componentName, int n) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.isAdminActive(componentName, n);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public boolean isApplicationHidden(ComponentName componentName, String string2) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.isApplicationHidden(componentName, string2);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public boolean isDeviceOwner(String string2) {
        return this.isDeviceOwnerApp(string2);
    }

    public boolean isDeviceOwnerApp(String string2) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.isDeviceOwner(string2);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to check device owner");
            }
        }
        return false;
    }

    public boolean isLockTaskPermitted(String string2) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.isLockTaskPermitted(string2);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public boolean isMasterVolumeMuted(ComponentName componentName) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.isMasterVolumeMuted(componentName);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to get isMasterMute on device policy service");
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isProfileOwnerApp(String string2) {
        ComponentName componentName;
        IDevicePolicyManager iDevicePolicyManager = this.mService;
        boolean bl = false;
        if (iDevicePolicyManager == null) return bl;
        try {
            componentName = this.mService.getProfileOwner(Process.myUserHandle().getIdentifier());
            bl = false;
            if (componentName == null) return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to check profile owner");
            return false;
        }
        boolean bl2 = componentName.getPackageName().equals(string2);
        bl = false;
        if (!bl2) return bl;
        return true;
    }

    public boolean isUninstallBlocked(ComponentName componentName, String string2) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.isUninstallBlocked(componentName, string2);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to call block uninstall on device policy service");
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lockNow() {
        if (this.mService == null) return;
        try {
            this.mService.lockNow();
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public boolean packageHasActiveAdmins(String string2) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.packageHasActiveAdmins(string2, UserHandle.myUserId());
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeActiveAdmin(ComponentName componentName) {
        if (this.mService == null) return;
        try {
            this.mService.removeActiveAdmin(componentName, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public boolean removeCrossProfileWidgetProvider(ComponentName componentName, String string2) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.removeCrossProfileWidgetProvider(componentName, string2);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Error calling removeCrossProfileWidgetProvider", remoteException);
            }
        }
        return false;
    }

    public boolean removeUser(ComponentName componentName, UserHandle userHandle) {
        try {
            boolean bl = this.mService.removeUser(componentName, userHandle);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not remove user ", remoteException);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reportFailedPasswordAttempt(int n) {
        if (this.mService == null) return;
        try {
            this.mService.reportFailedPasswordAttempt(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reportSuccessfulPasswordAttempt(int n) {
        if (this.mService == null) return;
        try {
            this.mService.reportSuccessfulPasswordAttempt(n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public boolean resetPassword(String string2, int n) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.resetPassword(string2, n, UserHandle.myUserId());
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAccountManagementDisabled(ComponentName componentName, String string2, boolean bl) {
        if (this.mService == null) return;
        try {
            this.mService.setAccountManagementDisabled(componentName, string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public void setActiveAdmin(ComponentName componentName, boolean bl) {
        this.setActiveAdmin(componentName, bl, UserHandle.myUserId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setActiveAdmin(ComponentName componentName, boolean bl, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setActiveAdmin(componentName, bl, n);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setActivePasswordState(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.mService == null) return;
        try {
            this.mService.setActivePasswordState(n, n2, n3, n4, n5, n6, n7, n8, n9);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setActivePasswordState(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9) {
        if (this.mService == null) return;
        try {
            this.mService.setActivePasswordStateByAsus(n, n2, n3, n4, n5, n6, n7, n8, bl, n9);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setActiveProfileOwner(ComponentName componentName, String string2) throws IllegalArgumentException {
        IDevicePolicyManager iDevicePolicyManager = this.mService;
        boolean bl = false;
        if (iDevicePolicyManager == null) return bl;
        try {
            int n = UserHandle.myUserId();
            this.mService.setActiveAdmin(componentName, false, n);
            boolean bl2 = this.mService.setProfileOwner(componentName, string2, n);
            return bl2;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to set profile owner " + remoteException);
            throw new IllegalArgumentException("Couldn't set profile owner.", remoteException);
        }
    }

    public boolean setApplicationHidden(ComponentName componentName, String string2, boolean bl) {
        if (this.mService != null) {
            try {
                boolean bl2 = this.mService.setApplicationHidden(componentName, string2, bl);
                return bl2;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setApplicationRestrictions(ComponentName componentName, String string2, Bundle bundle) {
        if (this.mService == null) return;
        try {
            this.mService.setApplicationRestrictions(componentName, string2, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAutoTimeRequired(ComponentName componentName, boolean bl) {
        if (this.mService == null) return;
        try {
            this.mService.setAutoTimeRequired(componentName, UserHandle.myUserId(), bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCameraDisabled(ComponentName componentName, boolean bl) {
        if (this.mService == null) return;
        try {
            this.mService.setCameraDisabled(componentName, bl, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCrossProfileCallerIdDisabled(ComponentName componentName, boolean bl) {
        if (this.mService == null) return;
        try {
            this.mService.setCrossProfileCallerIdDisabled(componentName, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public boolean setDeviceOwner(String string2) throws IllegalArgumentException, IllegalStateException {
        return this.setDeviceOwner(string2, null);
    }

    public boolean setDeviceOwner(String string2, String string3) throws IllegalArgumentException, IllegalStateException {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.setDeviceOwner(string2, string3);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to set device owner");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ComponentName setGlobalProxy(ComponentName var1_1, Proxy var2_2, List<String> var3_3) {
        block12: {
            if (var2_2 == null) {
                throw new NullPointerException();
            }
            if (this.mService == null) break block12;
            try {
                block13: {
                    if (var2_2.equals(Proxy.NO_PROXY)) break block13;
                    if (!var2_2.type().equals((Object)Proxy.Type.HTTP)) {
                        throw new IllegalArgumentException();
                    }
                    ** GOTO lbl-1000
                }
                var6_4 = null;
                var7_5 = null;
                return this.mService.setGlobalProxy(var1_1, var6_4, var7_5, UserHandle.myUserId());
            }
            catch (RemoteException var4_6) {
                Log.w(DevicePolicyManager.TAG, "Failed talking with device policy service", var4_6);
            }
        }
        return null;
lbl-1000:
        // 1 sources

        {
            var8_7 = (InetSocketAddress)var2_2.address();
            var9_8 = var8_7.getHostName();
            var10_9 = var8_7.getPort();
            var6_4 = var9_8 + ":" + Integer.toString(var10_9);
            if (var3_3 != null) {
                var11_10 = new StringBuilder();
                var12_11 = true;
                var13_12 = var3_3.iterator();
            } else {
                var7_5 = "";
lbl29:
                // 2 sources

                while (true) {
                    if (android.net.Proxy.validate(var9_8, Integer.toString(var10_9), var7_5) == 0) ** continue;
                    throw new IllegalArgumentException();
                }
            }
            while (var13_12.hasNext()) {
                var15_13 = var13_12.next();
                if (!var12_11) {
                    var11_10 = var11_10.append(",");
                } else {
                    var12_11 = false;
                }
                var11_10 = var11_10.append(var15_13.trim());
            }
            var7_5 = var14_14 = var11_10.toString();
            ** continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setGlobalSetting(ComponentName componentName, String string2, String string3) {
        if (this.mService == null) return;
        try {
            this.mService.setGlobalSetting(componentName, string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setKeyguardDisabledFeatures(ComponentName componentName, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setKeyguardDisabledFeatures(componentName, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setLockTaskPackages(ComponentName componentName, String[] stringArray) throws SecurityException {
        if (this.mService == null) return;
        try {
            this.mService.setLockTaskPackages(componentName, stringArray);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMasterVolumeMuted(ComponentName componentName, boolean bl) {
        if (this.mService == null) return;
        try {
            this.mService.setMasterVolumeMuted(componentName, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to setMasterMute on device policy service");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMaximumFailedPasswordsForWipe(ComponentName componentName, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setMaximumFailedPasswordsForWipe(componentName, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMaximumTimeToLock(ComponentName componentName, long l) {
        if (this.mService == null) return;
        try {
            this.mService.setMaximumTimeToLock(componentName, l, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPasswordExpirationTimeout(ComponentName componentName, long l) {
        if (this.mService == null) return;
        try {
            this.mService.setPasswordExpirationTimeout(componentName, l, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPasswordHistoryLength(ComponentName componentName, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setPasswordHistoryLength(componentName, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPasswordMinimumLength(ComponentName componentName, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setPasswordMinimumLength(componentName, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPasswordMinimumLetters(ComponentName componentName, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setPasswordMinimumLetters(componentName, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPasswordMinimumLowerCase(ComponentName componentName, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setPasswordMinimumLowerCase(componentName, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPasswordMinimumNonLetter(ComponentName componentName, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setPasswordMinimumNonLetter(componentName, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPasswordMinimumNumeric(ComponentName componentName, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setPasswordMinimumNumeric(componentName, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPasswordMinimumSymbols(ComponentName componentName, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setPasswordMinimumSymbols(componentName, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPasswordMinimumUpperCase(ComponentName componentName, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setPasswordMinimumUpperCase(componentName, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPasswordQuality(ComponentName componentName, int n) {
        if (this.mService == null) return;
        try {
            this.mService.setPasswordQuality(componentName, n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public boolean setPermittedAccessibilityServices(ComponentName componentName, List<String> list) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.setPermittedAccessibilityServices(componentName, list);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    public boolean setPermittedInputMethods(ComponentName componentName, List<String> list) {
        if (this.mService != null) {
            try {
                boolean bl = this.mService.setPermittedInputMethods(componentName, list);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProfileEnabled(ComponentName componentName) {
        if (this.mService == null) return;
        try {
            this.mService.setProfileEnabled(componentName);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProfileName(ComponentName componentName, String string2) {
        if (this.mService == null) return;
        try {
            this.mService.setProfileName(componentName, string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public boolean setProfileOwner(ComponentName componentName, String string2, int n) throws IllegalArgumentException {
        if (componentName == null) {
            throw new NullPointerException("admin cannot be null");
        }
        if (this.mService != null) {
            if (string2 == null) {
                string2 = "";
            }
            try {
                boolean bl = this.mService.setProfileOwner(componentName, string2, n);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed to set profile owner", remoteException);
                throw new IllegalArgumentException("Couldn't set profile owner.", remoteException);
            }
        }
        return false;
    }

    public boolean setProfileOwner(String string2, String string3, int n) throws IllegalArgumentException {
        if (string2 == null) {
            throw new NullPointerException("packageName cannot be null");
        }
        return this.setProfileOwner(new ComponentName(string2, ""), string3, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRecommendedGlobalProxy(ComponentName componentName, ProxyInfo proxyInfo) {
        if (this.mService == null) return;
        try {
            this.mService.setRecommendedGlobalProxy(componentName, proxyInfo);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRestrictionsProvider(ComponentName componentName, ComponentName componentName2) {
        if (this.mService == null) return;
        try {
            this.mService.setRestrictionsProvider(componentName, componentName2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to set permission provider on device policy service");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setScreenCaptureDisabled(ComponentName componentName, boolean bl) {
        if (this.mService == null) return;
        try {
            this.mService.setScreenCaptureDisabled(componentName, UserHandle.myUserId(), bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSecureSetting(ComponentName componentName, String string2, String string3) {
        if (this.mService == null) return;
        try {
            this.mService.setSecureSetting(componentName, string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSimplePasswordEnabled(ComponentName componentName, boolean bl) {
        if (this.mService == null) return;
        try {
            this.mService.setSimplePasswordEnabled(componentName, bl, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    public int setStorageEncryption(ComponentName componentName, boolean bl) {
        if (this.mService != null) {
            try {
                int n = this.mService.setStorageEncryption(componentName, bl, UserHandle.myUserId());
                return n;
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Failed talking with device policy service", remoteException);
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTrustAgentFeaturesEnabled(ComponentName componentName, ComponentName componentName2, List<String> list) {
        if (this.mService == null) return;
        try {
            this.mService.setTrustAgentFeaturesEnabled(componentName, componentName2, list, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setUninstallBlocked(ComponentName componentName, String string2, boolean bl) {
        if (this.mService == null) return;
        try {
            this.mService.setUninstallBlocked(componentName, string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed to call block uninstall on device policy service");
            return;
        }
    }

    public boolean switchUser(ComponentName componentName, UserHandle userHandle) {
        try {
            boolean bl = this.mService.switchUser(componentName, userHandle);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Could not switch user ", remoteException);
            return false;
        }
    }

    public void uninstallAllUserCaCerts(ComponentName componentName) {
        if (this.mService != null) {
            for (String string2 : new TrustedCertificateStore().userAliases()) {
                try {
                    this.mService.uninstallCaCert(componentName, string2);
                }
                catch (RemoteException remoteException) {
                    Log.w(TAG, "Failed talking with device policy service", remoteException);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void uninstallCaCert(ComponentName componentName, byte[] byArray) {
        if (this.mService == null) return;
        try {
            String string2 = DevicePolicyManager.getCaCertAlias(byArray);
            this.mService.uninstallCaCert(componentName, string2);
            return;
        }
        catch (CertificateException certificateException) {
            Log.w(TAG, "Unable to parse certificate", certificateException);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void wipeData(int n) {
        if (this.mService == null) return;
        try {
            this.mService.wipeData(n, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Failed talking with device policy service", remoteException);
            return;
        }
    }
}

