/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.app.IVoiceInteractorCallback;
import com.android.internal.app.IVoiceInteractorRequest;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import java.util.ArrayList;

public class VoiceInteractor {
    static final boolean DEBUG = true;
    static final int MSG_ABORT_VOICE_RESULT = 3;
    static final int MSG_CANCEL_RESULT = 5;
    static final int MSG_COMMAND_RESULT = 4;
    static final int MSG_COMPLETE_VOICE_RESULT = 2;
    static final int MSG_CONFIRMATION_RESULT = 1;
    static final String TAG = "VoiceInteractor";
    final ArrayMap<IBinder, Request> mActiveRequests;
    Activity mActivity;
    final IVoiceInteractorCallback.Stub mCallback;
    Context mContext;
    final HandlerCaller mHandlerCaller;
    final HandlerCaller.Callback mHandlerCallerCallback = new HandlerCaller.Callback(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void executeMessage(Message message) {
            boolean bl = true;
            SomeArgs someArgs = (SomeArgs)message.obj;
            switch (message.what) {
                case 1: {
                    Request request = VoiceInteractor.this.pullRequest((IVoiceInteractorRequest)someArgs.arg1, bl);
                    Log.d(VoiceInteractor.TAG, "onConfirmResult: req=" + ((IVoiceInteractorRequest)someArgs.arg1).asBinder() + "/" + request + " confirmed=" + message.arg1 + " result=" + someArgs.arg2);
                    if (request == null) return;
                    ConfirmationRequest confirmationRequest = (ConfirmationRequest)request;
                    int n = message.arg1;
                    boolean bl2 = false;
                    if (n != 0) {
                        bl2 = bl;
                    }
                    confirmationRequest.onConfirmationResult(bl2, (Bundle)someArgs.arg2);
                    request.clear();
                    return;
                }
                case 2: {
                    Request request = VoiceInteractor.this.pullRequest((IVoiceInteractorRequest)someArgs.arg1, bl);
                    Log.d(VoiceInteractor.TAG, "onCompleteVoice: req=" + ((IVoiceInteractorRequest)someArgs.arg1).asBinder() + "/" + request + " result=" + someArgs.arg1);
                    if (request == null) return;
                    ((CompleteVoiceRequest)request).onCompleteResult((Bundle)someArgs.arg2);
                    request.clear();
                    return;
                }
                case 3: {
                    Request request = VoiceInteractor.this.pullRequest((IVoiceInteractorRequest)someArgs.arg1, bl);
                    Log.d(VoiceInteractor.TAG, "onAbortVoice: req=" + ((IVoiceInteractorRequest)someArgs.arg1).asBinder() + "/" + request + " result=" + someArgs.arg1);
                    if (request == null) return;
                    ((AbortVoiceRequest)request).onAbortResult((Bundle)someArgs.arg2);
                    request.clear();
                    return;
                }
                case 4: {
                    VoiceInteractor voiceInteractor = VoiceInteractor.this;
                    IVoiceInteractorRequest iVoiceInteractorRequest = (IVoiceInteractorRequest)someArgs.arg1;
                    if (message.arg1 == 0) {
                        bl = false;
                    }
                    Request request = voiceInteractor.pullRequest(iVoiceInteractorRequest, bl);
                    Log.d(VoiceInteractor.TAG, "onCommandResult: req=" + ((IVoiceInteractorRequest)someArgs.arg1).asBinder() + "/" + request + " result=" + someArgs.arg2);
                    if (request == null) return;
                    ((CommandRequest)request).onCommandResult((Bundle)someArgs.arg2);
                    if (message.arg1 == 0) return;
                    request.clear();
                    return;
                }
                default: {
                    return;
                }
                case 5: 
            }
            Request request = VoiceInteractor.this.pullRequest((IVoiceInteractorRequest)someArgs.arg1, bl);
            Log.d(VoiceInteractor.TAG, "onCancelResult: req=" + ((IVoiceInteractorRequest)someArgs.arg1).asBinder() + "/" + request);
            if (request == null) return;
            request.onCancel();
            request.clear();
        }
    };
    final IVoiceInteractor mInteractor;

    VoiceInteractor(IVoiceInteractor iVoiceInteractor, Context context, Activity activity, Looper looper) {
        this.mCallback = new IVoiceInteractorCallback.Stub(){

            @Override
            public void deliverAbortVoiceResult(IVoiceInteractorRequest iVoiceInteractorRequest, Bundle bundle) {
                VoiceInteractor.this.mHandlerCaller.sendMessage(VoiceInteractor.this.mHandlerCaller.obtainMessageOO(3, iVoiceInteractorRequest, bundle));
            }

            @Override
            public void deliverCancel(IVoiceInteractorRequest iVoiceInteractorRequest) throws RemoteException {
                VoiceInteractor.this.mHandlerCaller.sendMessage(VoiceInteractor.this.mHandlerCaller.obtainMessageO(5, iVoiceInteractorRequest));
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void deliverCommandResult(IVoiceInteractorRequest iVoiceInteractorRequest, boolean bl, Bundle bundle) {
                HandlerCaller handlerCaller = VoiceInteractor.this.mHandlerCaller;
                HandlerCaller handlerCaller2 = VoiceInteractor.this.mHandlerCaller;
                int n = bl ? 1 : 0;
                handlerCaller.sendMessage(handlerCaller2.obtainMessageIOO(4, n, iVoiceInteractorRequest, bundle));
            }

            @Override
            public void deliverCompleteVoiceResult(IVoiceInteractorRequest iVoiceInteractorRequest, Bundle bundle) {
                VoiceInteractor.this.mHandlerCaller.sendMessage(VoiceInteractor.this.mHandlerCaller.obtainMessageOO(2, iVoiceInteractorRequest, bundle));
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void deliverConfirmationResult(IVoiceInteractorRequest iVoiceInteractorRequest, boolean bl, Bundle bundle) {
                HandlerCaller handlerCaller = VoiceInteractor.this.mHandlerCaller;
                HandlerCaller handlerCaller2 = VoiceInteractor.this.mHandlerCaller;
                int n = bl ? 1 : 0;
                handlerCaller.sendMessage(handlerCaller2.obtainMessageIOO(1, n, iVoiceInteractorRequest, bundle));
            }
        };
        this.mActiveRequests = new ArrayMap();
        this.mInteractor = iVoiceInteractor;
        this.mContext = context;
        this.mActivity = activity;
        this.mHandlerCaller = new HandlerCaller(context, looper, this.mHandlerCallerCallback, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ArrayList<Request> makeRequestList() {
        int n = this.mActiveRequests.size();
        if (n < 1) {
            return null;
        }
        ArrayList<Request> arrayList = new ArrayList<Request>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.mActiveRequests.valueAt(n2));
            ++n2;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    void attachActivity(Activity activity) {
        if (this.mActivity != activity) {
            this.mContext = activity;
            this.mActivity = activity;
            ArrayList<Request> arrayList = this.makeRequestList();
            if (arrayList != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Request request = arrayList.get(i);
                    request.mContext = activity;
                    request.mActivity = activity;
                    request.onAttached(activity);
                }
            }
        }
    }

    void detachActivity() {
        ArrayList<Request> arrayList = this.makeRequestList();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Request request = arrayList.get(i);
                request.onDetached();
                request.mActivity = null;
                request.mContext = null;
            }
        }
        this.mContext = null;
        this.mActivity = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Request pullRequest(IVoiceInteractorRequest iVoiceInteractorRequest, boolean bl) {
        ArrayMap<IBinder, Request> arrayMap = this.mActiveRequests;
        synchronized (arrayMap) {
            Request request = this.mActiveRequests.get(iVoiceInteractorRequest.asBinder());
            if (request != null && bl) {
                this.mActiveRequests.remove(iVoiceInteractorRequest.asBinder());
            }
            return request;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean submitRequest(Request request) {
        try {
            IVoiceInteractorRequest iVoiceInteractorRequest;
            request.mRequestInterface = iVoiceInteractorRequest = request.submit(this.mInteractor, this.mContext.getOpPackageName(), this.mCallback);
            request.mContext = this.mContext;
            request.mActivity = this.mActivity;
            ArrayMap<IBinder, Request> arrayMap = this.mActiveRequests;
            synchronized (arrayMap) {
                this.mActiveRequests.put(iVoiceInteractorRequest.asBinder(), request);
            }
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Remove voice interactor service died", remoteException);
            return false;
        }
        return true;
    }

    public boolean[] supportsCommands(String[] stringArray) {
        try {
            boolean[] blArray = this.mInteractor.supportsCommands(this.mContext.getOpPackageName(), stringArray);
            Log.d(TAG, "supportsCommands: cmds=" + stringArray + " res=" + blArray);
            return blArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Voice interactor has died", remoteException);
        }
    }

    public static class AbortVoiceRequest
    extends Request {
        final Bundle mExtras;
        final CharSequence mMessage;

        public AbortVoiceRequest(CharSequence charSequence, Bundle bundle) {
            this.mMessage = charSequence;
            this.mExtras = bundle;
        }

        public void onAbortResult(Bundle bundle) {
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor iVoiceInteractor, String string2, IVoiceInteractorCallback iVoiceInteractorCallback) throws RemoteException {
            return iVoiceInteractor.startAbortVoice(string2, iVoiceInteractorCallback, this.mMessage, this.mExtras);
        }
    }

    public static class CommandRequest
    extends Request {
        final Bundle mArgs;
        final String mCommand;

        public CommandRequest(String string2, Bundle bundle) {
            this.mCommand = string2;
            this.mArgs = bundle;
        }

        public void onCommandResult(Bundle bundle) {
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor iVoiceInteractor, String string2, IVoiceInteractorCallback iVoiceInteractorCallback) throws RemoteException {
            return iVoiceInteractor.startCommand(string2, iVoiceInteractorCallback, this.mCommand, this.mArgs);
        }
    }

    public static class CompleteVoiceRequest
    extends Request {
        final Bundle mExtras;
        final CharSequence mMessage;

        public CompleteVoiceRequest(CharSequence charSequence, Bundle bundle) {
            this.mMessage = charSequence;
            this.mExtras = bundle;
        }

        public void onCompleteResult(Bundle bundle) {
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor iVoiceInteractor, String string2, IVoiceInteractorCallback iVoiceInteractorCallback) throws RemoteException {
            return iVoiceInteractor.startCompleteVoice(string2, iVoiceInteractorCallback, this.mMessage, this.mExtras);
        }
    }

    public static class ConfirmationRequest
    extends Request {
        final Bundle mExtras;
        final CharSequence mPrompt;

        public ConfirmationRequest(CharSequence charSequence, Bundle bundle) {
            this.mPrompt = charSequence;
            this.mExtras = bundle;
        }

        public void onConfirmationResult(boolean bl, Bundle bundle) {
        }

        @Override
        IVoiceInteractorRequest submit(IVoiceInteractor iVoiceInteractor, String string2, IVoiceInteractorCallback iVoiceInteractorCallback) throws RemoteException {
            return iVoiceInteractor.startConfirmation(string2, iVoiceInteractorCallback, this.mPrompt, this.mExtras);
        }
    }

    public static abstract class Request {
        Activity mActivity;
        Context mContext;
        IVoiceInteractorRequest mRequestInterface;

        public void cancel() {
            try {
                this.mRequestInterface.cancel();
                return;
            }
            catch (RemoteException remoteException) {
                Log.w(VoiceInteractor.TAG, "Voice interactor has died", remoteException);
                return;
            }
        }

        void clear() {
            this.mRequestInterface = null;
            this.mContext = null;
            this.mActivity = null;
        }

        public Activity getActivity() {
            return this.mActivity;
        }

        public Context getContext() {
            return this.mContext;
        }

        public void onAttached(Activity activity) {
        }

        public void onCancel() {
        }

        public void onDetached() {
        }

        abstract IVoiceInteractorRequest submit(IVoiceInteractor var1, String var2, IVoiceInteractorCallback var3) throws RemoteException;
    }
}

