/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.app.IUiAutomationConnection;
import android.graphics.Bitmap;
import android.hardware.input.InputManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.IWindowManager;
import android.view.InputEvent;
import android.view.SurfaceControl;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import android.view.accessibility.IAccessibilityManager;
import java.io.FileOutputStream;
import java.io.IOException;
import libcore.io.IoUtils;

public final class UiAutomationConnection
extends IUiAutomationConnection.Stub {
    private static final int INITIAL_FROZEN_ROTATION_UNSPECIFIED = -1;
    private final IAccessibilityManager mAccessibilityManager;
    private IAccessibilityServiceClient mClient;
    private int mInitialFrozenRotation = -1;
    private boolean mIsShutdown;
    private final Object mLock;
    private int mOwningUid;
    private final Binder mToken;
    private final IWindowManager mWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));

    public UiAutomationConnection() {
        this.mAccessibilityManager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        this.mLock = new Object();
        this.mToken = new Binder();
    }

    private boolean isConnectedLocked() {
        return this.mClient != null;
    }

    private void registerUiTestAutomationServiceLocked(IAccessibilityServiceClient iAccessibilityServiceClient) {
        IAccessibilityManager iAccessibilityManager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        AccessibilityServiceInfo accessibilityServiceInfo = new AccessibilityServiceInfo();
        accessibilityServiceInfo.eventTypes = -1;
        accessibilityServiceInfo.feedbackType = 16;
        accessibilityServiceInfo.flags = 0x12 | accessibilityServiceInfo.flags;
        accessibilityServiceInfo.setCapabilities(15);
        try {
            iAccessibilityManager.registerUiTestAutomationService(this.mToken, iAccessibilityServiceClient, accessibilityServiceInfo);
            this.mClient = iAccessibilityServiceClient;
            return;
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException("Error while registering UiTestAutomationService.", remoteException);
        }
    }

    private void restoreRotationStateLocked() {
        try {
            if (this.mInitialFrozenRotation != -1) {
                this.mWindowManager.freezeRotation(this.mInitialFrozenRotation);
                return;
            }
            this.mWindowManager.thawRotation();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private void storeRotationStateLocked() {
        try {
            if (this.mWindowManager.isRotationFrozen()) {
                this.mInitialFrozenRotation = this.mWindowManager.getRotation();
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private void throwIfCalledByNotTrustedUidLocked() {
        int n = Binder.getCallingUid();
        if (n != this.mOwningUid && this.mOwningUid != 1000 && n != 0) {
            throw new SecurityException("Calling from not trusted UID!");
        }
    }

    private void throwIfNotConnectedLocked() {
        if (!this.isConnectedLocked()) {
            throw new IllegalStateException("Not connected!");
        }
    }

    private void throwIfShutdownLocked() {
        if (this.mIsShutdown) {
            throw new IllegalStateException("Connection shutdown!");
        }
    }

    private void unregisterUiTestAutomationServiceLocked() {
        IAccessibilityManager iAccessibilityManager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        try {
            iAccessibilityManager.unregisterUiTestAutomationService(this.mClient);
            this.mClient = null;
            return;
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException("Error while unregistering UiTestAutomationService", remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clearWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long l = Binder.clearCallingIdentity();
        try {
            SurfaceControl.clearAnimationFrameStats();
            return;
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean clearWindowContentFrameStats(int n) throws RemoteException {
        IBinder iBinder;
        long l;
        block7: {
            Object object = this.mLock;
            synchronized (object) {
                this.throwIfCalledByNotTrustedUidLocked();
                this.throwIfShutdownLocked();
                this.throwIfNotConnectedLocked();
            }
            l = Binder.clearCallingIdentity();
            iBinder = this.mAccessibilityManager.getWindowToken(n);
            if (iBinder != null) break block7;
            Binder.restoreCallingIdentity(l);
            return false;
        }
        try {
            boolean bl = this.mWindowManager.clearWindowContentFrameStats(iBinder);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void connect(IAccessibilityServiceClient iAccessibilityServiceClient) {
        if (iAccessibilityServiceClient == null) {
            throw new IllegalArgumentException("Client cannot be null!");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfShutdownLocked();
            if (this.isConnectedLocked()) {
                throw new IllegalStateException("Already connected.");
            }
            this.mOwningUid = Binder.getCallingUid();
            this.registerUiTestAutomationServiceLocked(iAccessibilityServiceClient);
            this.storeRotationStateLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            if (!this.isConnectedLocked()) {
                throw new IllegalStateException("Already disconnected.");
            }
            this.mOwningUid = -1;
            this.unregisterUiTestAutomationServiceLocked();
            this.restoreRotationStateLocked();
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeShellCommand(String var1_1, ParcelFileDescriptor var2_2) throws RemoteException {
        var3_3 = this.mLock;
        synchronized (var3_3) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        var5_4 = null;
        var6_5 = null;
        var5_4 = Runtime.getRuntime().exec(var1_1).getInputStream();
        var9_6 = new FileOutputStream(var2_2.getFileDescriptor());
        try {
            var10_7 = new byte[8192];
            while ((var11_8 = var5_4.read(var10_7)) >= 0) {
                var9_6.write(var10_7, 0, var11_8);
            }
            ** GOTO lbl23
        }
        catch (IOException var7_9) {
            block13: {
                var6_5 = var9_6;
                break block13;
                catch (Throwable var8_14) {
                    var6_5 = var9_6;
                    ** GOTO lbl-1000
                }
lbl23:
                // 1 sources

                IoUtils.closeQuietly((AutoCloseable)var5_4);
                IoUtils.closeQuietly((AutoCloseable)var9_6);
                IoUtils.closeQuietly((AutoCloseable)var2_2);
                return;
            }
lbl28:
            // 2 sources

            while (true) {
                try {
                    throw new RuntimeException("Error running shell command", (Throwable)var7_10);
                }
                catch (Throwable var8_12) {}
                ** GOTO lbl-1000
                break;
            }
            catch (IOException var7_11) {
                var6_5 = null;
                ** continue;
            }
lbl-1000:
            // 2 sources

            {
                IoUtils.closeQuietly(var5_4);
                IoUtils.closeQuietly(var6_5);
                IoUtils.closeQuietly((AutoCloseable)var2_2);
                throw var8_13;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WindowAnimationFrameStats getWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long l = Binder.clearCallingIdentity();
        try {
            WindowAnimationFrameStats windowAnimationFrameStats = new WindowAnimationFrameStats();
            SurfaceControl.getAnimationFrameStats(windowAnimationFrameStats);
            return windowAnimationFrameStats;
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public WindowContentFrameStats getWindowContentFrameStats(int n) throws RemoteException {
        IBinder iBinder;
        long l;
        block7: {
            Object object = this.mLock;
            synchronized (object) {
                this.throwIfCalledByNotTrustedUidLocked();
                this.throwIfShutdownLocked();
                this.throwIfNotConnectedLocked();
            }
            l = Binder.clearCallingIdentity();
            iBinder = this.mAccessibilityManager.getWindowToken(n);
            if (iBinder != null) break block7;
            Binder.restoreCallingIdentity(l);
            return null;
        }
        try {
            WindowContentFrameStats windowContentFrameStats = this.mWindowManager.getWindowContentFrameStats(iBinder);
            return windowContentFrameStats;
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean injectInputEvent(InputEvent inputEvent, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        int n = bl ? 2 : 0;
        long l = Binder.clearCallingIdentity();
        try {
            boolean bl2 = InputManager.getInstance().injectInputEvent(inputEvent, n);
            return bl2;
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setRotation(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long l = Binder.clearCallingIdentity();
        if (n == -2) {
            try {
                this.mWindowManager.thawRotation();
                return true;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        try {
            this.mWindowManager.freezeRotation(n);
            return true;
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void shutdown() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isConnectedLocked()) {
                this.throwIfCalledByNotTrustedUidLocked();
            }
            this.throwIfShutdownLocked();
            this.mIsShutdown = true;
            if (this.isConnectedLocked()) {
                this.disconnect();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Bitmap takeScreenshot(int n, int n2) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long l = Binder.clearCallingIdentity();
        try {
            Bitmap bitmap = SurfaceControl.screenshot(n, n2);
            return bitmap;
        }
        finally {
            Binder.restoreCallingIdentity(l);
        }
    }
}

