/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.app.ActivityManagerNative;
import android.app.IUiAutomationConnection;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.view.Display;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import libcore.io.IoUtils;

public final class UiAutomation {
    private static final int CONNECTION_ID_UNDEFINED = -1;
    private static final long CONNECT_TIMEOUT_MILLIS = 5000L;
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = UiAutomation.class.getSimpleName();
    public static final int ROTATION_FREEZE_0 = 0;
    public static final int ROTATION_FREEZE_180 = 2;
    public static final int ROTATION_FREEZE_270 = 3;
    public static final int ROTATION_FREEZE_90 = 1;
    public static final int ROTATION_FREEZE_CURRENT = -1;
    public static final int ROTATION_UNFREEZE = -2;
    private final IAccessibilityServiceClient mClient;
    private int mConnectionId = -1;
    private final ArrayList<AccessibilityEvent> mEventQueue;
    private boolean mIsConnecting;
    private long mLastEventTimeMillis;
    private final Object mLock = new Object();
    private OnAccessibilityEventListener mOnAccessibilityEventListener;
    private final IUiAutomationConnection mUiAutomationConnection;
    private boolean mWaitingForEventDelivery;

    public UiAutomation(Looper looper, IUiAutomationConnection iUiAutomationConnection) {
        this.mEventQueue = new ArrayList();
        if (looper == null) {
            throw new IllegalArgumentException("Looper cannot be null!");
        }
        if (iUiAutomationConnection == null) {
            throw new IllegalArgumentException("Connection cannot be null!");
        }
        this.mUiAutomationConnection = iUiAutomationConnection;
        this.mClient = new IAccessibilityServiceClientImpl(looper);
    }

    static /* synthetic */ int access$102(UiAutomation uiAutomation, int n) {
        uiAutomation.mConnectionId = n;
        return n;
    }

    static /* synthetic */ long access$202(UiAutomation uiAutomation, long l) {
        uiAutomation.mLastEventTimeMillis = l;
        return l;
    }

    private static float getDegreesForRotation(int n) {
        switch (n) {
            default: {
                return 0.0f;
            }
            case 1: {
                return 270.0f;
            }
            case 2: {
                return 180.0f;
            }
            case 3: 
        }
        return 90.0f;
    }

    private boolean isConnectedLocked() {
        return this.mConnectionId != -1;
    }

    private void throwIfConnectedLocked() {
        if (this.mConnectionId != -1) {
            throw new IllegalStateException("UiAutomation not connected!");
        }
    }

    private void throwIfNotConnectedLocked() {
        if (!this.isConnectedLocked()) {
            throw new IllegalStateException("UiAutomation not connected!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.clearWindowAnimationFrameStats();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error clearing window animation frame stats!", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean clearWindowContentFrameStats(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.clearWindowContentFrameStats(n);
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error clearing window content frame stats!", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void connect() {
        Object object = this.mLock;
        // MONITORENTER : object
        this.throwIfConnectedLocked();
        if (this.mIsConnecting) {
            // MONITOREXIT : object
            return;
        }
        this.mIsConnecting = true;
        // MONITOREXIT : object
        try {
            this.mUiAutomationConnection.connect(this.mClient);
            Object object2 = this.mLock;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Error while connecting UiAutomation", remoteException);
        }
        long l = SystemClock.uptimeMillis();
        while (true) {
            long l2;
            block17: {
                block16: {
                    try {
                        boolean bl = this.isConnectedLocked();
                        if (!bl) break block16;
                        this.mIsConnecting = false;
                    }
                    catch (Throwable throwable) {
                        this.mIsConnecting = false;
                        throw throwable;
                    }
                    return;
                }
                l2 = 5000L - (SystemClock.uptimeMillis() - l);
                if (l2 > 0L) break block17;
                throw new RuntimeException("Error while connecting UiAutomation");
            }
            try {
                this.mLock.wait(l2);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsConnecting) {
                throw new IllegalStateException("Cannot call disconnect() while connecting!");
            }
            this.throwIfNotConnectedLocked();
            this.mConnectionId = -1;
        }
        try {
            this.mUiAutomationConnection.disconnect();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Error while disconnecting UiAutomation", remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessibilityEvent executeAndWaitForEvent(Runnable runnable, AccessibilityEventFilter accessibilityEventFilter, long l) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            this.mEventQueue.clear();
            this.mWaitingForEventDelivery = true;
        }
        long l2 = SystemClock.uptimeMillis();
        runnable.run();
        Object object2 = this.mLock;
        synchronized (object2) {
            AccessibilityEvent accessibilityEvent;
            try {
                long l3 = SystemClock.uptimeMillis();
                while (true) {
                    if (!this.mEventQueue.isEmpty()) {
                        accessibilityEvent = this.mEventQueue.remove(0);
                        if (accessibilityEvent.getEventTime() < l2) continue;
                        boolean bl = accessibilityEventFilter.accept(accessibilityEvent);
                        if (bl) {
                            this.mWaitingForEventDelivery = false;
                            this.mEventQueue.clear();
                            this.mLock.notifyAll();
                            break;
                        } else {
                            accessibilityEvent.recycle();
                            continue;
                        }
                    }
                    long l4 = l - (SystemClock.uptimeMillis() - l3);
                    if (l4 <= 0L) {
                        throw new TimeoutException("Expected event not received within: " + l + " ms.");
                    }
                    try {
                        this.mLock.wait(l4);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable throwable) {
                this.mWaitingForEventDelivery = false;
                this.mEventQueue.clear();
                this.mLock.notifyAll();
                throw throwable;
            }
            return accessibilityEvent;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParcelFileDescriptor executeShellCommand(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        ParcelFileDescriptor parcelFileDescriptor = null;
        ParcelFileDescriptor parcelFileDescriptor2 = null;
        try {
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            parcelFileDescriptor = parcelFileDescriptorArray[0];
            parcelFileDescriptor2 = parcelFileDescriptorArray[1];
            this.mUiAutomationConnection.executeShellCommand(string2, parcelFileDescriptor2);
        }
        catch (IOException iOException) {
            Log.e(LOG_TAG, "Error executing shell command!", iOException);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(parcelFileDescriptor2);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly((AutoCloseable)parcelFileDescriptor2);
            return parcelFileDescriptor;
            catch (RemoteException remoteException) {
                Log.e(LOG_TAG, "Error executing shell command!", remoteException);
                IoUtils.closeQuietly((AutoCloseable)parcelFileDescriptor2);
                return parcelFileDescriptor;
            }
        }
        IoUtils.closeQuietly((AutoCloseable)parcelFileDescriptor2);
        return parcelFileDescriptor;
    }

    public AccessibilityNodeInfo findFocus(int n) {
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, -2, AccessibilityNodeInfo.ROOT_NODE_ID, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getConnectionId() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            return this.mConnectionId;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessibilityNodeInfo getRootInActiveWindow() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            int n = this.mConnectionId;
            return AccessibilityInteractionClient.getInstance().getRootInActiveWindow(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final AccessibilityServiceInfo getServiceInfo() {
        IAccessibilityServiceConnection iAccessibilityServiceConnection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            iAccessibilityServiceConnection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        }
        if (iAccessibilityServiceConnection == null) return null;
        try {
            return iAccessibilityServiceConnection.getServiceInfo();
        }
        catch (RemoteException remoteException) {
            Log.w(LOG_TAG, "Error while getting AccessibilityServiceInfo", remoteException);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WindowAnimationFrameStats getWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.getWindowAnimationFrameStats();
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error getting window animation frame stats!", remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WindowContentFrameStats getWindowContentFrameStats(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.getWindowContentFrameStats(n);
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error getting window content frame stats!", remoteException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AccessibilityWindowInfo> getWindows() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            int n = this.mConnectionId;
            return AccessibilityInteractionClient.getInstance().getWindows(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean injectInputEvent(InputEvent inputEvent, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.injectInputEvent(inputEvent, bl);
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error while injecting input event!", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean performGlobalAction(int n) {
        IAccessibilityServiceConnection iAccessibilityServiceConnection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            iAccessibilityServiceConnection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        }
        if (iAccessibilityServiceConnection == null) return false;
        try {
            return iAccessibilityServiceConnection.performGlobalAction(n);
        }
        catch (RemoteException remoteException) {
            Log.w(LOG_TAG, "Error while calling performGlobalAction", remoteException);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOnAccessibilityEventListener(OnAccessibilityEventListener onAccessibilityEventListener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnAccessibilityEventListener = onAccessibilityEventListener;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setRotation(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        switch (n) {
            default: {
                throw new IllegalArgumentException("Invalid rotation.");
            }
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
        }
        try {
            this.mUiAutomationConnection.setRotation(n);
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error while setting rotation!", remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRunAsMonkey(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            ActivityManagerNative.getDefault().setUserIsMonkey(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error while setting run as monkey!", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void setServiceInfo(AccessibilityServiceInfo accessibilityServiceInfo) {
        Object object = this.mLock;
        // MONITORENTER : object
        this.throwIfNotConnectedLocked();
        AccessibilityInteractionClient.getInstance().clearCache();
        IAccessibilityServiceConnection iAccessibilityServiceConnection = AccessibilityInteractionClient.getInstance().getConnection(this.mConnectionId);
        // MONITOREXIT : object
        if (iAccessibilityServiceConnection == null) return;
        try {
            iAccessibilityServiceConnection.setServiceInfo(accessibilityServiceInfo);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(LOG_TAG, "Error while setting AccessibilityServiceInfo", remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap takeScreenshot() {
        Bitmap bitmap;
        float f;
        float f2;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        Display display = DisplayManagerGlobal.getInstance().getRealDisplay(0);
        Point point = new Point();
        display.getRealSize(point);
        int n = point.x;
        int n2 = point.y;
        int n3 = display.getRotation();
        switch (n3) {
            default: {
                throw new IllegalArgumentException("Invalid rotation: " + n3);
            }
            case 0: {
                f2 = n;
                f = n2;
                break;
            }
            case 1: {
                f2 = n2;
                f = n;
                break;
            }
            case 2: {
                f2 = n;
                f = n2;
                break;
            }
            case 3: {
                f2 = n2;
                f = n;
                break;
            }
        }
        try {
            Bitmap bitmap2;
            bitmap = bitmap2 = this.mUiAutomationConnection.takeScreenshot((int)f2, (int)f);
            if (bitmap == null) {
                return null;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(LOG_TAG, "Error while taking screnshot!", remoteException);
            return null;
        }
        if (n3 != 0) {
            Bitmap bitmap3 = Bitmap.createBitmap(n, n2, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap3);
            canvas.translate(bitmap3.getWidth() / 2, bitmap3.getHeight() / 2);
            canvas.rotate(UiAutomation.getDegreesForRotation(n3));
            canvas.translate(-f2 / 2.0f, -f / 2.0f);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
            canvas.setBitmap(null);
            bitmap.recycle();
            bitmap = bitmap3;
        }
        bitmap.setHasAlpha(false);
        return bitmap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForIdle(long l, long l2) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            long l3 = SystemClock.uptimeMillis();
            if (this.mLastEventTimeMillis <= 0L) {
                this.mLastEventTimeMillis = l3;
            }
            while (true) {
                long l4;
                if (l2 - ((l4 = SystemClock.uptimeMillis()) - l3) <= 0L) {
                    TimeoutException timeoutException = new TimeoutException("No idle state with idle timeout: " + l + " within global timeout: " + l2);
                    throw timeoutException;
                }
                long l5 = l - (l4 - this.mLastEventTimeMillis);
                if (l5 <= 0L) {
                    return;
                }
                try {
                    this.mLock.wait(l5);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public static interface AccessibilityEventFilter {
        public boolean accept(AccessibilityEvent var1);
    }

    private class IAccessibilityServiceClientImpl
    extends AccessibilityService.IAccessibilityServiceClientWrapper {
        public IAccessibilityServiceClientImpl(Looper looper) {
            super(null, looper, new AccessibilityService.Callbacks(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
                    Object object = UiAutomation.this.mLock;
                    synchronized (object) {
                        UiAutomation.access$202(UiAutomation.this, accessibilityEvent.getEventTime());
                        if (UiAutomation.this.mWaitingForEventDelivery) {
                            UiAutomation.this.mEventQueue.add(AccessibilityEvent.obtain(accessibilityEvent));
                        }
                        UiAutomation.this.mLock.notifyAll();
                    }
                    OnAccessibilityEventListener onAccessibilityEventListener = UiAutomation.this.mOnAccessibilityEventListener;
                    if (onAccessibilityEventListener != null) {
                        onAccessibilityEventListener.onAccessibilityEvent(AccessibilityEvent.obtain(accessibilityEvent));
                    }
                }

                @Override
                public boolean onGesture(int n) {
                    return false;
                }

                @Override
                public void onInterrupt() {
                }

                @Override
                public boolean onKeyEvent(KeyEvent keyEvent) {
                    return false;
                }

                @Override
                public void onServiceConnected() {
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onSetConnectionId(int n) {
                    Object object = UiAutomation.this.mLock;
                    synchronized (object) {
                        UiAutomation.access$102(UiAutomation.this, n);
                        UiAutomation.this.mLock.notifyAll();
                        return;
                    }
                }
            });
        }
    }

    public static interface OnAccessibilityEventListener {
        public void onAccessibilityEvent(AccessibilityEvent var1);
    }
}

