/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;
import com.android.internal.statusbar.IStatusBarService;

public class StatusBarManager {
    public static final int DISABLE_BACK = 0x400000;
    public static final int DISABLE_CLOCK = 0x800000;
    public static final int DISABLE_EXPAND = 65536;
    public static final int DISABLE_HOME = 0x200000;
    public static final int DISABLE_MASK = 0x3FF0000;
    @Deprecated
    public static final int DISABLE_NAVIGATION = 0x1200000;
    public static final int DISABLE_NONE = 0;
    public static final int DISABLE_NOTIFICATION_ALERTS = 262144;
    public static final int DISABLE_NOTIFICATION_ICONS = 131072;
    @Deprecated
    public static final int DISABLE_NOTIFICATION_TICKER = 524288;
    public static final int DISABLE_RECENT = 0x1000000;
    public static final int DISABLE_SEARCH = 0x2000000;
    public static final int DISABLE_SYSTEM_INFO = 0x100000;
    public static final int NAVIGATION_HINT_BACK_ALT = 1;
    public static final int NAVIGATION_HINT_IME_SHOWN = 2;
    public static final int WINDOW_NAVIGATION_BAR = 2;
    public static final int WINDOW_STATE_HIDDEN = 2;
    public static final int WINDOW_STATE_HIDING = 1;
    public static final int WINDOW_STATE_SHOWING = 0;
    public static final int WINDOW_STATUS_BAR = 1;
    private Context mContext;
    private IStatusBarService mService;
    private IBinder mToken = new Binder();

    StatusBarManager(Context context) {
        this.mContext = context;
    }

    private IStatusBarService getService() {
        synchronized (this) {
            if (this.mService == null) {
                this.mService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
                if (this.mService == null) {
                    Slog.w("StatusBarManager", "warning: no STATUS_BAR_SERVICE");
                }
            }
            IStatusBarService iStatusBarService = this.mService;
            return iStatusBarService;
        }
    }

    public static String windowStateToString(int n) {
        if (n == 1) {
            return "WINDOW_STATE_HIDING";
        }
        if (n == 2) {
            return "WINDOW_STATE_HIDDEN";
        }
        if (n == 0) {
            return "WINDOW_STATE_SHOWING";
        }
        return "WINDOW_STATE_UNKNOWN";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void collapsePanels() {
        IStatusBarService iStatusBarService;
        try {
            iStatusBarService = this.getService();
            if (iStatusBarService == null) return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        iStatusBarService.collapsePanels();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void disable(int n) {
        IStatusBarService iStatusBarService;
        try {
            iStatusBarService = this.getService();
            if (iStatusBarService == null) return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        iStatusBarService.disable(n, this.mToken, this.mContext.getPackageName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void expandNotificationsPanel() {
        IStatusBarService iStatusBarService;
        try {
            iStatusBarService = this.getService();
            if (iStatusBarService == null) return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        iStatusBarService.expandNotificationsPanel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void expandSettingsPanel() {
        IStatusBarService iStatusBarService;
        try {
            iStatusBarService = this.getService();
            if (iStatusBarService == null) return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        iStatusBarService.expandSettingsPanel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeIcon(String string2) {
        IStatusBarService iStatusBarService;
        try {
            iStatusBarService = this.getService();
            if (iStatusBarService == null) return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        iStatusBarService.removeIcon(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIcon(String string2, int n, int n2, String string3) {
        IStatusBarService iStatusBarService;
        try {
            iStatusBarService = this.getService();
            if (iStatusBarService == null) return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        iStatusBarService.setIcon(string2, this.mContext.getPackageName(), n, n2, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIconVisibility(String string2, boolean bl) {
        IStatusBarService iStatusBarService;
        try {
            iStatusBarService = this.getService();
            if (iStatusBarService == null) return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        iStatusBarService.setIconVisibility(string2, bl);
    }
}

