/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.ContextImpl;
import android.app.QueuedWork;
import android.content.SharedPreferences;
import android.os.FileUtils;
import android.os.Looper;
import android.system.ErrnoException;
import android.system.Os;
import android.system.StructStat;
import android.util.Log;
import com.android.internal.util.XmlUtils;
import com.google.android.collect.Maps;
import dalvik.system.BlockGuard;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import org.xmlpull.v1.XmlPullParserException;

final class SharedPreferencesImpl
implements SharedPreferences {
    private static final boolean DEBUG = false;
    private static final String TAG = "SharedPreferencesImpl";
    private static final Object mContent = new Object();
    private final File mBackupFile;
    private int mDiskWritesInFlight = 0;
    private final File mFile;
    private final WeakHashMap<SharedPreferences.OnSharedPreferenceChangeListener, Object> mListeners;
    private boolean mLoaded = false;
    private Map<String, Object> mMap;
    private final int mMode;
    private long mStatSize;
    private long mStatTimestamp;
    private final Object mWritingToDiskLock = new Object();

    SharedPreferencesImpl(File file, int n) {
        this.mListeners = new WeakHashMap();
        this.mFile = file;
        this.mBackupFile = SharedPreferencesImpl.makeBackupFile(file);
        this.mMode = n;
        this.mLoaded = false;
        this.mMap = null;
        this.startLoadFromDisk();
    }

    static /* synthetic */ int access$308(SharedPreferencesImpl sharedPreferencesImpl) {
        int n = sharedPreferencesImpl.mDiskWritesInFlight;
        sharedPreferencesImpl.mDiskWritesInFlight = n + 1;
        return n;
    }

    static /* synthetic */ int access$310(SharedPreferencesImpl sharedPreferencesImpl) {
        int n = sharedPreferencesImpl.mDiskWritesInFlight;
        sharedPreferencesImpl.mDiskWritesInFlight = n - 1;
        return n;
    }

    static /* synthetic */ Map access$402(SharedPreferencesImpl sharedPreferencesImpl, Map map) {
        sharedPreferencesImpl.mMap = map;
        return map;
    }

    private void awaitLoadedLocked() {
        if (!this.mLoaded) {
            BlockGuard.getThreadPolicy().onReadFromDisk();
        }
        while (!this.mLoaded) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FileOutputStream createFileOutputStream(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file2 = file.getParentFile();
            if (!file2.mkdir()) {
                Log.e(TAG, "Couldn't create directory for SharedPreferences file " + file);
                return null;
            }
            FileUtils.setPermissions(file2.getPath(), 505, -1, -1);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                return fileOutputStream;
            }
            catch (FileNotFoundException fileNotFoundException2) {
                Log.e(TAG, "Couldn't create SharedPreferences file " + file, fileNotFoundException2);
                return null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void enqueueDiskWrite(final MemoryCommitResult memoryCommitResult, final Runnable runnable) {
        Runnable runnable2 = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object object = SharedPreferencesImpl.this.mWritingToDiskLock;
                // MONITORENTER : object
                SharedPreferencesImpl.this.writeToFile(memoryCommitResult);
                // MONITOREXIT : object
                SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
                // MONITORENTER : sharedPreferencesImpl
                SharedPreferencesImpl.access$310(SharedPreferencesImpl.this);
                // MONITOREXIT : sharedPreferencesImpl
                if (runnable == null) return;
                runnable.run();
            }
        };
        boolean bl = runnable == null;
        if (bl) {
            // MONITORENTER : this
            boolean bl2 = this.mDiskWritesInFlight == 1;
            // MONITOREXIT : this
            if (bl2) {
                runnable2.run();
                return;
            }
        }
        QueuedWork.singleThreadExecutor().execute(runnable2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasFileChangedUnexpectedly() {
        StructStat structStat;
        synchronized (this) {
            if (this.mDiskWritesInFlight > 0) {
                return false;
            }
        }
        try {
            BlockGuard.getThreadPolicy().onReadFromDisk();
            structStat = Os.stat(this.mFile.getPath());
        }
        catch (ErrnoException errnoException) {
            return true;
        }
        synchronized (this) {
            if (this.mStatTimestamp != structStat.st_mtime) return true;
            long l = this.mStatSize - structStat.st_size;
            long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
            boolean bl = false;
            if (l2 == false) return bl;
            return true;
        }
    }

    /*
     * Exception decompiling
     */
    private void loadFromDiskLocked() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [13 : 238->243)] android.system.ErrnoException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File makeBackupFile(File file) {
        return new File(file.getPath() + ".bak");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startLoadFromDisk() {
        synchronized (this) {
            this.mLoaded = false;
        }
        new Thread("SharedPreferencesImpl-load"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
                synchronized (sharedPreferencesImpl) {
                    SharedPreferencesImpl.this.loadFromDiskLocked();
                    return;
                }
            }
        }.start();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeToFile(MemoryCommitResult memoryCommitResult) {
        if (this.mFile.exists()) {
            if (!memoryCommitResult.changesMade) {
                memoryCommitResult.setDiskWriteResult(true);
                return;
            }
            if (!this.mBackupFile.exists()) {
                if (!this.mFile.renameTo(this.mBackupFile)) {
                    Log.e(TAG, "Couldn't rename file " + this.mFile + " to backup file " + this.mBackupFile);
                    memoryCommitResult.setDiskWriteResult(false);
                    return;
                }
            } else {
                this.mFile.delete();
            }
        }
        try {
            FileOutputStream fileOutputStream = SharedPreferencesImpl.createFileOutputStream(this.mFile);
            if (fileOutputStream == null) {
                memoryCommitResult.setDiskWriteResult(false);
                return;
            }
            XmlUtils.writeMapXml(memoryCommitResult.mapToWriteToDisk, fileOutputStream);
            FileUtils.sync(fileOutputStream);
            fileOutputStream.close();
            ContextImpl.setFilePermissionsFromMode(this.mFile.getPath(), this.mMode, 0);
            try {
                StructStat structStat = Os.stat(this.mFile.getPath());
                synchronized (this) {
                    this.mStatTimestamp = structStat.st_mtime;
                    this.mStatSize = structStat.st_size;
                }
            }
            catch (ErrnoException errnoException) {}
            {
            }
            this.mBackupFile.delete();
            memoryCommitResult.setDiskWriteResult(true);
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            block18: {
                Log.w(TAG, "writeToFile: Got exception:", xmlPullParserException);
                break block18;
                catch (IOException iOException) {
                    Log.w(TAG, "writeToFile: Got exception:", iOException);
                }
            }
            if (this.mFile.exists() && !this.mFile.delete()) {
                Log.e(TAG, "Couldn't clean up partially-written file " + this.mFile);
            }
            memoryCommitResult.setDiskWriteResult(false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(String string2) {
        synchronized (this) {
            this.awaitLoadedLocked();
            return this.mMap.containsKey(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SharedPreferences.Editor edit() {
        synchronized (this) {
            this.awaitLoadedLocked();
            return new EditorImpl();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, ?> getAll() {
        synchronized (this) {
            this.awaitLoadedLocked();
            return new HashMap<String, Object>(this.mMap);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getBoolean(String string2, boolean bl) {
        synchronized (this) {
            this.awaitLoadedLocked();
            Boolean bl2 = (Boolean)this.mMap.get(string2);
            if (bl2 == null) return bl;
            return bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float getFloat(String string2, float f) {
        synchronized (this) {
            this.awaitLoadedLocked();
            Float f2 = (Float)this.mMap.get(string2);
            if (f2 == null) return f;
            return f2.floatValue();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getInt(String string2, int n) {
        synchronized (this) {
            this.awaitLoadedLocked();
            Integer n2 = (Integer)this.mMap.get(string2);
            if (n2 == null) return n;
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLong(String string2, long l) {
        synchronized (this) {
            this.awaitLoadedLocked();
            Long l2 = (Long)this.mMap.get(string2);
            if (l2 == null) return l;
            return l2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getString(String string2, String string3) {
        synchronized (this) {
            this.awaitLoadedLocked();
            String string4 = (String)this.mMap.get(string2);
            if (string4 != null) return string4;
            return string3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<String> getStringSet(String string2, Set<String> set) {
        synchronized (this) {
            this.awaitLoadedLocked();
            Set<String> set2 = (Set<String>)this.mMap.get(string2);
            if (set2 != null) return set2;
            return set;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        synchronized (this) {
            this.mListeners.put(onSharedPreferenceChangeListener, mContent);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void startReloadIfChangedUnexpectedly() {
        synchronized (this) {
            if (!this.hasFileChangedUnexpectedly()) {
                return;
            }
            this.startLoadFromDisk();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        synchronized (this) {
            this.mListeners.remove(onSharedPreferenceChangeListener);
            return;
        }
    }

    public final class EditorImpl
    implements SharedPreferences.Editor {
        private boolean mClear = false;
        private final Map<String, Object> mModified = Maps.newHashMap();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private MemoryCommitResult commitToMemory() {
            boolean bl = true;
            MemoryCommitResult memoryCommitResult = new MemoryCommitResult();
            SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
            synchronized (sharedPreferencesImpl) {
                if (SharedPreferencesImpl.this.mDiskWritesInFlight > 0) {
                    SharedPreferencesImpl.access$402(SharedPreferencesImpl.this, new HashMap(SharedPreferencesImpl.this.mMap));
                }
                memoryCommitResult.mapToWriteToDisk = SharedPreferencesImpl.this.mMap;
                SharedPreferencesImpl.access$308(SharedPreferencesImpl.this);
                if (SharedPreferencesImpl.this.mListeners.size() <= 0) {
                    bl = false;
                }
                if (bl) {
                    memoryCommitResult.keysModified = new ArrayList<String>();
                    memoryCommitResult.listeners = new HashSet(SharedPreferencesImpl.this.mListeners.keySet());
                }
                synchronized (this) {
                    if (this.mClear) {
                        if (!SharedPreferencesImpl.this.mMap.isEmpty()) {
                            memoryCommitResult.changesMade = true;
                            SharedPreferencesImpl.this.mMap.clear();
                        }
                        this.mClear = false;
                    }
                    Iterator<Map.Entry<String, Object>> iterator = this.mModified.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.mModified.clear();
                            return memoryCommitResult;
                        }
                        Map.Entry<String, Object> entry = iterator.next();
                        String string2 = entry.getKey();
                        Object object = entry.getValue();
                        if (object == this || object == null) {
                            if (!SharedPreferencesImpl.this.mMap.containsKey(string2)) continue;
                            SharedPreferencesImpl.this.mMap.remove(string2);
                        } else {
                            Object v;
                            if (SharedPreferencesImpl.this.mMap.containsKey(string2) && (v = SharedPreferencesImpl.this.mMap.get(string2)) != null && v.equals(object)) continue;
                            SharedPreferencesImpl.this.mMap.put(string2, object);
                        }
                        memoryCommitResult.changesMade = true;
                        if (!bl) continue;
                        memoryCommitResult.keysModified.add(string2);
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void notifyListeners(final MemoryCommitResult memoryCommitResult) {
            if (memoryCommitResult.listeners != null && memoryCommitResult.keysModified != null && memoryCommitResult.keysModified.size() != 0) {
                if (Looper.myLooper() != Looper.getMainLooper()) {
                    ActivityThread.sMainThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            EditorImpl.this.notifyListeners(memoryCommitResult);
                        }
                    });
                    return;
                }
                for (int i = -1 + memoryCommitResult.keysModified.size(); i >= 0; --i) {
                    String string2 = memoryCommitResult.keysModified.get(i);
                    for (SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener : memoryCommitResult.listeners) {
                        if (onSharedPreferenceChangeListener == null) continue;
                        onSharedPreferenceChangeListener.onSharedPreferenceChanged(SharedPreferencesImpl.this, string2);
                    }
                }
            }
        }

        @Override
        public void apply() {
            final MemoryCommitResult memoryCommitResult = this.commitToMemory();
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        memoryCommitResult.writtenToDiskLatch.await();
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            };
            QueuedWork.add(runnable);
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    QueuedWork.remove(runnable);
                }
            };
            SharedPreferencesImpl.this.enqueueDiskWrite(memoryCommitResult, runnable2);
            this.notifyListeners(memoryCommitResult);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SharedPreferences.Editor clear() {
            synchronized (this) {
                this.mClear = true;
                return this;
            }
        }

        @Override
        public boolean commit() {
            MemoryCommitResult memoryCommitResult = this.commitToMemory();
            SharedPreferencesImpl.this.enqueueDiskWrite(memoryCommitResult, null);
            try {
                memoryCommitResult.writtenToDiskLatch.await();
                this.notifyListeners(memoryCommitResult);
                return memoryCommitResult.writeToDiskResult;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SharedPreferences.Editor putBoolean(String string2, boolean bl) {
            synchronized (this) {
                this.mModified.put(string2, bl);
                return this;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SharedPreferences.Editor putFloat(String string2, float f) {
            synchronized (this) {
                this.mModified.put(string2, Float.valueOf(f));
                return this;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SharedPreferences.Editor putInt(String string2, int n) {
            synchronized (this) {
                this.mModified.put(string2, n);
                return this;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SharedPreferences.Editor putLong(String string2, long l) {
            synchronized (this) {
                this.mModified.put(string2, l);
                return this;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SharedPreferences.Editor putString(String string2, String string3) {
            synchronized (this) {
                this.mModified.put(string2, string3);
                return this;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SharedPreferences.Editor putStringSet(String string2, Set<String> set) {
            synchronized (this) {
                Map<String, Object> map = this.mModified;
                HashSet<String> hashSet = set == null ? null : new HashSet<String>(set);
                map.put(string2, hashSet);
                return this;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public SharedPreferences.Editor remove(String string2) {
            synchronized (this) {
                this.mModified.put(string2, this);
                return this;
            }
        }
    }

    private static class MemoryCommitResult {
        public boolean changesMade;
        public List<String> keysModified;
        public Set<SharedPreferences.OnSharedPreferenceChangeListener> listeners;
        public Map<?, ?> mapToWriteToDisk;
        public volatile boolean writeToDiskResult = false;
        public final CountDownLatch writtenToDiskLatch = new CountDownLatch(1);

        private MemoryCommitResult() {
        }

        public void setDiskWriteResult(boolean bl) {
            this.writeToDiskResult = bl;
            this.writtenToDiskLatch.countDown();
        }
    }
}

