/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ApplicationPackageManager;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesKey;
import android.content.res.ThemePack;
import android.hardware.display.DisplayManagerGlobal;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayAdjustments;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Locale;

public class ResourcesManager {
    static final boolean DEBUG_CACHE = false;
    static final boolean DEBUG_STATS = true;
    static final String TAG = "ResourcesManager";
    private static IPackageManager sPackageManager;
    private static ResourcesManager sResourcesManager;
    final ArrayMap<ResourcesKey, WeakReference<Resources>> mActiveResources = new ArrayMap();
    final ArrayMap<DisplayAdjustments, DisplayMetrics> mDefaultDisplayMetrics = new ArrayMap();
    CompatibilityInfo mResCompatibilityInfo;
    Configuration mResConfiguration;
    final Configuration mTmpConfig = new Configuration();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean attachThemePack(AssetManager assetManager, ThemePack themePack) {
        String string2;
        String string3;
        int n;
        ThemePack.ThemeModule themeModule;
        String string4;
        String string5;
        int n2;
        PackageInfo packageInfo;
        String string6 = assetManager.getAppPackageName();
        if ("android".equals(string6)) {
            return true;
        }
        PackageInfo packageInfo2 = null;
        int n3 = UserHandle.getCallingUserId();
        try {
            PackageInfo packageInfo3;
            packageInfo2 = ResourcesManager.getPackageManager().getPackageInfo(string6, 0, n3);
            packageInfo = packageInfo3 = ResourcesManager.getPackageManager().getPackageInfo("android", 0, n3);
        }
        catch (RemoteException remoteException) {
            packageInfo = null;
        }
        if (packageInfo2 == null || packageInfo2.applicationInfo == null || packageInfo2.isThemePack || packageInfo == null || packageInfo.applicationInfo == null) {
            return false;
        }
        ThemePack.ThemeModule themeModule2 = themePack.getThemeModuleForApp(string6);
        if (themeModule2 != null && !TextUtils.isEmpty(themeModule2.getArchiveSrcPath()) && !TextUtils.isEmpty(packageInfo2.applicationInfo.sourceDir) && (n2 = assetManager.addOverlayPath(string5 = packageInfo2.applicationInfo.sourceDir, string4 = themeModule2.getArchiveSrcPath())) > 0) {
            assetManager.addThemeCookie(n2, string4);
        }
        if ((themeModule = themePack.getThemeModuleForApp("android")) != null && !TextUtils.isEmpty(themeModule.getArchiveSrcPath()) && !TextUtils.isEmpty(packageInfo.applicationInfo.sourceDir) && (n = assetManager.addOverlayPath(string3 = packageInfo.applicationInfo.sourceDir, string2 = themeModule.getArchiveSrcPath())) > 0) {
            assetManager.addThemeCookie(n, string2);
        }
        return true;
    }

    private void detachThemePack(AssetManager assetManager) {
        String string2 = assetManager.getAppPackageName();
        HashMap<Integer, String> hashMap = assetManager.getThemeCookies();
        if (!TextUtils.isEmpty(string2) && !hashMap.isEmpty()) {
            for (Integer n : hashMap.keySet()) {
                assetManager.removeOverlayPath(hashMap.get(n), n);
            }
        }
        hashMap.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResourcesManager getInstance() {
        synchronized (ResourcesManager.class) {
            if (sResourcesManager != null) return sResourcesManager;
            sResourcesManager = new ResourcesManager();
            return sResourcesManager;
        }
    }

    public static IPackageManager getPackageManager() {
        if (sPackageManager != null) {
            return sPackageManager;
        }
        sPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        return sPackageManager;
    }

    public boolean applyCompatConfiguration(int n, Configuration configuration) {
        if (this.mResCompatibilityInfo != null && !this.mResCompatibilityInfo.supportsScreen()) {
            this.mResCompatibilityInfo.applyToConfiguration(n, configuration);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean applyConfigurationToResourcesLocked(Configuration configuration, CompatibilityInfo compatibilityInfo) {
        if (this.mResConfiguration == null) {
            this.mResConfiguration = new Configuration();
        }
        if (!this.mResConfiguration.isOtherSeqNewer(configuration) && compatibilityInfo == null) {
            return false;
        }
        int n = this.mResConfiguration.updateFrom(configuration);
        this.flushDisplayMetricsLocked();
        DisplayMetrics displayMetrics = this.getDisplayMetricsLocked(0);
        if (!(compatibilityInfo == null || this.mResCompatibilityInfo != null && this.mResCompatibilityInfo.equals(compatibilityInfo))) {
            this.mResCompatibilityInfo = compatibilityInfo;
            n |= 0xD00;
        }
        if (configuration.locale != null) {
            Locale.setDefault(configuration.locale);
        }
        Resources.updateSystemConfiguration(configuration, displayMetrics, compatibilityInfo);
        ApplicationPackageManager.configurationChanged();
        Configuration configuration2 = null;
        for (int i = -1 + this.mActiveResources.size(); i >= 0; --i) {
            ResourcesKey resourcesKey = this.mActiveResources.keyAt(i);
            Resources resources = (Resources)this.mActiveResources.valueAt(i).get();
            if (resources != null) {
                AssetManager assetManager;
                int n2 = resourcesKey.mDisplayId;
                boolean bl = n2 == 0;
                DisplayMetrics displayMetrics2 = displayMetrics;
                boolean bl2 = resourcesKey.hasOverrideConfiguration();
                boolean bl3 = (0x8000 & n) != 0;
                if (bl3 && (assetManager = resources.getAssets()).isThemeEnabled()) {
                    this.detachThemePack(assetManager);
                    if (configuration.themePack != null) {
                        this.attachThemePack(assetManager, configuration.themePack);
                    }
                }
                if (!bl || bl2) {
                    if (configuration2 == null) {
                        configuration2 = new Configuration();
                    }
                    configuration2.setTo(configuration);
                    if (!bl) {
                        displayMetrics2 = this.getDisplayMetricsLocked(n2);
                        this.applyNonDefaultDisplayMetricsToConfigurationLocked(displayMetrics2, configuration2);
                    }
                    if (bl2) {
                        configuration2.updateFrom(resourcesKey.mOverrideConfiguration);
                    }
                    resources.updateConfiguration(configuration2, displayMetrics2, compatibilityInfo);
                } else {
                    resources.updateConfiguration(configuration, displayMetrics2, compatibilityInfo);
                }
                if (!bl3) continue;
                resources.recreateStringBlocks();
                continue;
            }
            this.mActiveResources.removeAt(i);
        }
        return n != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void applyNonDefaultDisplayMetricsToConfigurationLocked(DisplayMetrics displayMetrics, Configuration configuration) {
        configuration.touchscreen = 1;
        configuration.densityDpi = displayMetrics.densityDpi;
        configuration.screenWidthDp = (int)((float)displayMetrics.widthPixels / displayMetrics.density);
        configuration.screenHeightDp = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        int n = Configuration.resetScreenLayout(configuration.screenLayout);
        if (displayMetrics.widthPixels > displayMetrics.heightPixels) {
            configuration.orientation = 2;
            configuration.screenLayout = Configuration.reduceScreenLayout(n, configuration.screenWidthDp, configuration.screenHeightDp);
        } else {
            configuration.orientation = 1;
            configuration.screenLayout = Configuration.reduceScreenLayout(n, configuration.screenHeightDp, configuration.screenWidthDp);
        }
        configuration.smallestScreenWidthDp = configuration.screenWidthDp;
        configuration.compatScreenWidthDp = configuration.screenWidthDp;
        configuration.compatScreenHeightDp = configuration.screenHeightDp;
        configuration.compatSmallestScreenWidthDp = configuration.smallestScreenWidthDp;
    }

    public void flushDisplayMetricsLocked() {
        this.mDefaultDisplayMetrics.clear();
    }

    public Configuration getConfiguration() {
        return this.mResConfiguration;
    }

    public DisplayMetrics getDisplayMetricsLocked(int n) {
        return this.getDisplayMetricsLocked(n, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    /*
     * Enabled aggressive block sorting
     */
    public DisplayMetrics getDisplayMetricsLocked(int n, DisplayAdjustments displayAdjustments) {
        Display display;
        boolean bl = n == 0;
        DisplayMetrics displayMetrics = bl ? this.mDefaultDisplayMetrics.get(displayAdjustments) : null;
        if (displayMetrics != null) {
            return displayMetrics;
        }
        DisplayMetrics displayMetrics2 = new DisplayMetrics();
        DisplayManagerGlobal displayManagerGlobal = DisplayManagerGlobal.getInstance();
        if (displayManagerGlobal == null) {
            displayMetrics2.setToDefaults();
            return displayMetrics2;
        }
        if (bl) {
            this.mDefaultDisplayMetrics.put(displayAdjustments, displayMetrics2);
        }
        if ((display = displayManagerGlobal.getCompatibleDisplay(n, displayAdjustments)) != null) {
            display.getMetrics(displayMetrics2);
            return displayMetrics2;
        }
        displayMetrics2.setToDefaults();
        return displayMetrics2;
    }

    /*
     * Exception decompiling
     */
    public Resources getTopLevelResources(String var1_1, String[] var2_2, String[] var3_3, String[] var4_4, int var5_5, Configuration var6_6, CompatibilityInfo var7_7, IBinder var8_8, String var9_9) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 123->125)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

