/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.AndroidException;

public final class PendingIntent
implements Parcelable {
    public static final Parcelable.Creator<PendingIntent> CREATOR = new Parcelable.Creator<PendingIntent>(){

        @Override
        public PendingIntent createFromParcel(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            if (iBinder != null) {
                return new PendingIntent(iBinder);
            }
            return null;
        }

        public PendingIntent[] newArray(int n) {
            return new PendingIntent[n];
        }
    };
    public static final int FLAG_CANCEL_CURRENT = 0x10000000;
    public static final int FLAG_NO_CREATE = 0x20000000;
    public static final int FLAG_ONE_SHOT = 0x40000000;
    public static final int FLAG_UPDATE_CURRENT = 0x8000000;
    private final IIntentSender mTarget;

    PendingIntent(IIntentSender iIntentSender) {
        this.mTarget = iIntentSender;
    }

    PendingIntent(IBinder iBinder) {
        this.mTarget = IIntentSender.Stub.asInterface(iBinder);
    }

    public static PendingIntent getActivities(Context context, int n, Intent[] intentArray, int n2) {
        return PendingIntent.getActivities(context, n, intentArray, n2, null);
    }

    public static PendingIntent getActivities(Context context, int n, Intent[] intentArray, int n2, Bundle bundle) {
        block4: {
            IIntentSender iIntentSender;
            String string2 = context.getPackageName();
            String[] stringArray = new String[intentArray.length];
            for (int i = 0; i < intentArray.length; ++i) {
                intentArray[i].migrateExtraStreamToClipData();
                intentArray[i].prepareToLeaveProcess();
                stringArray[i] = intentArray[i].resolveTypeIfNeeded(context.getContentResolver());
            }
            try {
                iIntentSender = ActivityManagerNative.getDefault().getIntentSender(2, string2, null, null, n, intentArray, stringArray, n2, bundle, UserHandle.myUserId());
                if (iIntentSender == null) break block4;
            }
            catch (RemoteException remoteException) {
                return null;
            }
            PendingIntent pendingIntent = new PendingIntent(iIntentSender);
            return pendingIntent;
        }
        return null;
    }

    public static PendingIntent getActivitiesAsUser(Context context, int n, Intent[] intentArray, int n2, Bundle bundle, UserHandle userHandle) {
        block4: {
            IIntentSender iIntentSender;
            String string2 = context.getPackageName();
            String[] stringArray = new String[intentArray.length];
            for (int i = 0; i < intentArray.length; ++i) {
                intentArray[i].migrateExtraStreamToClipData();
                intentArray[i].prepareToLeaveProcess();
                stringArray[i] = intentArray[i].resolveTypeIfNeeded(context.getContentResolver());
            }
            try {
                iIntentSender = ActivityManagerNative.getDefault().getIntentSender(2, string2, null, null, n, intentArray, stringArray, n2, bundle, userHandle.getIdentifier());
                if (iIntentSender == null) break block4;
            }
            catch (RemoteException remoteException) {
                return null;
            }
            PendingIntent pendingIntent = new PendingIntent(iIntentSender);
            return pendingIntent;
        }
        return null;
    }

    public static PendingIntent getActivity(Context context, int n, Intent intent, int n2) {
        return PendingIntent.getActivity(context, n, intent, n2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PendingIntent getActivity(Context context, int n, Intent intent, int n2, Bundle bundle) {
        String string2 = context.getPackageName();
        String string3 = intent != null ? intent.resolveTypeIfNeeded(context.getContentResolver()) : null;
        try {
            intent.migrateExtraStreamToClipData();
            intent.prepareToLeaveProcess();
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            Intent[] intentArray = new Intent[]{intent};
            String[] stringArray = string3 != null ? new String[]{string3} : null;
            IIntentSender iIntentSender = iActivityManager.getIntentSender(2, string2, null, null, n, intentArray, stringArray, n2, bundle, UserHandle.myUserId());
            if (iIntentSender == null) return null;
            return new PendingIntent(iIntentSender);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PendingIntent getActivityAsUser(Context context, int n, Intent intent, int n2, Bundle bundle, UserHandle userHandle) {
        String string2 = context.getPackageName();
        String string3 = intent != null ? intent.resolveTypeIfNeeded(context.getContentResolver()) : null;
        try {
            intent.migrateExtraStreamToClipData();
            intent.prepareToLeaveProcess();
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            Intent[] intentArray = new Intent[]{intent};
            String[] stringArray = string3 != null ? new String[]{string3} : null;
            IIntentSender iIntentSender = iActivityManager.getIntentSender(2, string2, null, null, n, intentArray, stringArray, n2, bundle, userHandle.getIdentifier());
            if (iIntentSender == null) return null;
            return new PendingIntent(iIntentSender);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public static PendingIntent getBroadcast(Context context, int n, Intent intent, int n2) {
        return PendingIntent.getBroadcastAsUser(context, n, intent, n2, new UserHandle(UserHandle.myUserId()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PendingIntent getBroadcastAsUser(Context context, int n, Intent intent, int n2, UserHandle userHandle) {
        String string2 = context.getPackageName();
        String string3 = intent != null ? intent.resolveTypeIfNeeded(context.getContentResolver()) : null;
        try {
            intent.prepareToLeaveProcess();
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            Intent[] intentArray = new Intent[]{intent};
            String[] stringArray = string3 != null ? new String[]{string3} : null;
            IIntentSender iIntentSender = iActivityManager.getIntentSender(1, string2, null, null, n, intentArray, stringArray, n2, null, userHandle.getIdentifier());
            if (iIntentSender == null) return null;
            return new PendingIntent(iIntentSender);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PendingIntent getService(Context context, int n, Intent intent, int n2) {
        String string2 = context.getPackageName();
        String string3 = intent != null ? intent.resolveTypeIfNeeded(context.getContentResolver()) : null;
        try {
            intent.prepareToLeaveProcess();
            IActivityManager iActivityManager = ActivityManagerNative.getDefault();
            Intent[] intentArray = new Intent[]{intent};
            String[] stringArray = string3 != null ? new String[]{string3} : null;
            IIntentSender iIntentSender = iActivityManager.getIntentSender(4, string2, null, null, n, intentArray, stringArray, n2, null, UserHandle.myUserId());
            if (iIntentSender == null) return null;
            return new PendingIntent(iIntentSender);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public static PendingIntent readPendingIntentOrNullFromParcel(Parcel parcel) {
        IBinder iBinder = parcel.readStrongBinder();
        if (iBinder != null) {
            return new PendingIntent(iBinder);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writePendingIntentOrNullToParcel(PendingIntent pendingIntent, Parcel parcel) {
        IBinder iBinder = pendingIntent != null ? pendingIntent.mTarget.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
    }

    public void cancel() {
        try {
            ActivityManagerNative.getDefault().cancelIntentSender(this.mTarget);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof PendingIntent) {
            return this.mTarget.asBinder().equals(((PendingIntent)object).mTarget.asBinder());
        }
        return false;
    }

    public String getCreatorPackage() {
        try {
            String string2 = ActivityManagerNative.getDefault().getPackageForIntentSender(this.mTarget);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int getCreatorUid() {
        try {
            int n = ActivityManagerNative.getDefault().getUidForIntentSender(this.mTarget);
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    public UserHandle getCreatorUserHandle() {
        block3: {
            int n;
            try {
                n = ActivityManagerNative.getDefault().getUidForIntentSender(this.mTarget);
                if (n <= 0) break block3;
            }
            catch (RemoteException remoteException) {
                return null;
            }
            UserHandle userHandle = new UserHandle(UserHandle.getUserId(n));
            return userHandle;
        }
        return null;
    }

    public Intent getIntent() {
        try {
            Intent intent = ActivityManagerNative.getDefault().getIntentForIntentSender(this.mTarget);
            return intent;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public IntentSender getIntentSender() {
        return new IntentSender(this.mTarget);
    }

    public String getTag(String string2) {
        try {
            String string3 = ActivityManagerNative.getDefault().getTagForIntentSender(this.mTarget, string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public IIntentSender getTarget() {
        return this.mTarget;
    }

    @Deprecated
    public String getTargetPackage() {
        try {
            String string2 = ActivityManagerNative.getDefault().getPackageForIntentSender(this.mTarget);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int hashCode() {
        return this.mTarget.asBinder().hashCode();
    }

    public boolean isActivity() {
        try {
            boolean bl = ActivityManagerNative.getDefault().isIntentSenderAnActivity(this.mTarget);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isTargetedToPackage() {
        try {
            boolean bl = ActivityManagerNative.getDefault().isIntentSenderTargetedToPackage(this.mTarget);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void send() throws CanceledException {
        this.send(null, 0, null, null, null, null);
    }

    public void send(int n) throws CanceledException {
        this.send(null, n, null, null, null, null);
    }

    public void send(int n, OnFinished onFinished, Handler handler) throws CanceledException {
        this.send(null, n, null, onFinished, handler, null);
    }

    public void send(Context context, int n, Intent intent) throws CanceledException {
        this.send(context, n, intent, null, null, null);
    }

    public void send(Context context, int n, Intent intent, OnFinished onFinished, Handler handler) throws CanceledException {
        this.send(context, n, intent, onFinished, handler, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(Context context, int n, Intent intent, OnFinished onFinished, Handler handler, String string2) throws CanceledException {
        String string3;
        if (intent != null) {
            try {
                string3 = intent.resolveTypeIfNeeded(context.getContentResolver());
            }
            catch (RemoteException remoteException) {
                throw new CanceledException(remoteException);
            }
        } else {
            string3 = null;
        }
        IIntentSender iIntentSender = this.mTarget;
        FinishedDispatcher finishedDispatcher = null;
        if (onFinished != null) {
            finishedDispatcher = new FinishedDispatcher(this, onFinished, handler);
        }
        if (iIntentSender.send(n, intent, string3, finishedDispatcher, string2) >= 0) return;
        throw new CanceledException();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("PendingIntent{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(": ");
        IBinder iBinder = this.mTarget != null ? this.mTarget.asBinder() : null;
        stringBuilder.append(iBinder);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeStrongBinder(this.mTarget.asBinder());
    }

    public static class CanceledException
    extends AndroidException {
        public CanceledException() {
        }

        public CanceledException(Exception exception) {
            super(exception);
        }

        public CanceledException(String string2) {
            super(string2);
        }
    }

    private static class FinishedDispatcher
    extends IIntentReceiver.Stub
    implements Runnable {
        private final Handler mHandler;
        private Intent mIntent;
        private final PendingIntent mPendingIntent;
        private int mResultCode;
        private String mResultData;
        private Bundle mResultExtras;
        private final OnFinished mWho;

        FinishedDispatcher(PendingIntent pendingIntent, OnFinished onFinished, Handler handler) {
            this.mPendingIntent = pendingIntent;
            this.mWho = onFinished;
            this.mHandler = handler;
        }

        @Override
        public void performReceive(Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2, int n2) {
            this.mIntent = intent;
            this.mResultCode = n;
            this.mResultData = string2;
            this.mResultExtras = bundle;
            if (this.mHandler == null) {
                this.run();
                return;
            }
            this.mHandler.post(this);
        }

        @Override
        public void run() {
            this.mWho.onSendFinished(this.mPendingIntent, this.mIntent, this.mResultCode, this.mResultData, this.mResultExtras);
        }
    }

    public static interface OnFinished {
        public void onSendFinished(PendingIntent var1, Intent var2, int var3, String var4, Bundle var5);
    }
}

