/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.AttributeSet;
import android.view.InputQueue;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import java.io.File;

public class NativeActivity
extends Activity
implements SurfaceHolder.Callback2,
InputQueue.Callback,
ViewTreeObserver.OnGlobalLayoutListener {
    private static final String KEY_NATIVE_SAVED_STATE = "android:native_state";
    public static final String META_DATA_FUNC_NAME = "android.app.func_name";
    public static final String META_DATA_LIB_NAME = "android.app.lib_name";
    private InputQueue mCurInputQueue;
    private SurfaceHolder mCurSurfaceHolder;
    private boolean mDestroyed;
    private boolean mDispatchingUnhandledKey;
    private InputMethodManager mIMM;
    int mLastContentHeight;
    int mLastContentWidth;
    int mLastContentX;
    int mLastContentY;
    final int[] mLocation = new int[2];
    private NativeContentView mNativeContentView;
    private long mNativeHandle;

    private static String getAbsolutePath(File file) {
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private native long loadNativeCode(String var1, String var2, MessageQueue var3, String var4, String var5, String var6, int var7, AssetManager var8, byte[] var9);

    private native void onConfigurationChangedNative(long var1);

    private native void onContentRectChangedNative(long var1, int var3, int var4, int var5, int var6);

    private native void onInputQueueCreatedNative(long var1, long var3);

    private native void onInputQueueDestroyedNative(long var1, long var3);

    private native void onLowMemoryNative(long var1);

    private native void onPauseNative(long var1);

    private native void onResumeNative(long var1);

    private native byte[] onSaveInstanceStateNative(long var1);

    private native void onStartNative(long var1);

    private native void onStopNative(long var1);

    private native void onSurfaceChangedNative(long var1, Surface var3, int var4, int var5, int var6);

    private native void onSurfaceCreatedNative(long var1, Surface var3);

    private native void onSurfaceDestroyedNative(long var1);

    private native void onSurfaceRedrawNeededNative(long var1, Surface var3);

    private native void onWindowFocusChangedNative(long var1, boolean var3);

    private native void unloadNativeCode(long var1);

    void hideIme(int n) {
        this.mIMM.hideSoftInputFromWindow(this.mNativeContentView.getWindowToken(), n);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (!this.mDestroyed) {
            this.onConfigurationChangedNative(this.mNativeHandle);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onCreate(Bundle bundle) {
        String string2;
        String string3 = "main";
        String string4 = "ANativeActivity_onCreate";
        this.mIMM = (InputMethodManager)this.getSystemService("input_method");
        this.getWindow().takeSurface(this);
        this.getWindow().takeInputQueue(this);
        this.getWindow().setFormat(4);
        this.getWindow().setSoftInputMode(16);
        this.mNativeContentView = new NativeContentView(this);
        this.mNativeContentView.mActivity = this;
        this.setContentView(this.mNativeContentView);
        this.mNativeContentView.requestFocus();
        this.mNativeContentView.getViewTreeObserver().addOnGlobalLayoutListener(this);
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getIntent().getComponent(), 128);
            if (activityInfo.metaData != null) {
                String string5;
                String string6 = activityInfo.metaData.getString(META_DATA_LIB_NAME);
                if (string6 != null) {
                    string3 = string6;
                }
                if ((string5 = activityInfo.metaData.getString(META_DATA_FUNC_NAME)) != null) {
                    string4 = string5;
                }
            }
            File file = new File(activityInfo.applicationInfo.nativeLibraryDir, System.mapLibraryName(string3));
            boolean bl = file.exists();
            string2 = null;
            if (bl) {
                string2 = file.getPath();
            }
            if (string2 == null) {
                throw new IllegalArgumentException("Unable to find native library: " + string3);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new RuntimeException("Error getting activity info", nameNotFoundException);
        }
        byte[] byArray = bundle != null ? bundle.getByteArray(KEY_NATIVE_SAVED_STATE) : null;
        this.mNativeHandle = this.loadNativeCode(string2, string4, Looper.myQueue(), NativeActivity.getAbsolutePath(this.getFilesDir()), NativeActivity.getAbsolutePath(this.getObbDir()), NativeActivity.getAbsolutePath(this.getExternalFilesDir(null)), Build.VERSION.SDK_INT, this.getAssets(), byArray);
        if (this.mNativeHandle == 0L) {
            throw new IllegalArgumentException("Unable to load native library: " + string2);
        }
        super.onCreate(bundle);
    }

    @Override
    protected void onDestroy() {
        this.mDestroyed = true;
        if (this.mCurSurfaceHolder != null) {
            this.onSurfaceDestroyedNative(this.mNativeHandle);
            this.mCurSurfaceHolder = null;
        }
        if (this.mCurInputQueue != null) {
            this.onInputQueueDestroyedNative(this.mNativeHandle, this.mCurInputQueue.getNativePtr());
            this.mCurInputQueue = null;
        }
        this.unloadNativeCode(this.mNativeHandle);
        super.onDestroy();
    }

    @Override
    public void onGlobalLayout() {
        this.mNativeContentView.getLocationInWindow(this.mLocation);
        int n = this.mNativeContentView.getWidth();
        int n2 = this.mNativeContentView.getHeight();
        if (this.mLocation[0] != this.mLastContentX || this.mLocation[1] != this.mLastContentY || n != this.mLastContentWidth || n2 != this.mLastContentHeight) {
            this.mLastContentX = this.mLocation[0];
            this.mLastContentY = this.mLocation[1];
            this.mLastContentWidth = n;
            this.mLastContentHeight = n2;
            if (!this.mDestroyed) {
                this.onContentRectChangedNative(this.mNativeHandle, this.mLastContentX, this.mLastContentY, this.mLastContentWidth, this.mLastContentHeight);
            }
        }
    }

    @Override
    public void onInputQueueCreated(InputQueue inputQueue) {
        if (!this.mDestroyed) {
            this.mCurInputQueue = inputQueue;
            this.onInputQueueCreatedNative(this.mNativeHandle, inputQueue.getNativePtr());
        }
    }

    @Override
    public void onInputQueueDestroyed(InputQueue inputQueue) {
        if (!this.mDestroyed) {
            this.onInputQueueDestroyedNative(this.mNativeHandle, inputQueue.getNativePtr());
            this.mCurInputQueue = null;
        }
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        if (!this.mDestroyed) {
            this.onLowMemoryNative(this.mNativeHandle);
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.onPauseNative(this.mNativeHandle);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.onResumeNative(this.mNativeHandle);
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        byte[] byArray = this.onSaveInstanceStateNative(this.mNativeHandle);
        if (byArray != null) {
            bundle.putByteArray(KEY_NATIVE_SAVED_STATE, byArray);
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.onStartNative(this.mNativeHandle);
    }

    @Override
    protected void onStop() {
        super.onStop();
        this.onStopNative(this.mNativeHandle);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (!this.mDestroyed) {
            this.onWindowFocusChangedNative(this.mNativeHandle, bl);
        }
    }

    void setWindowFlags(int n, int n2) {
        this.getWindow().setFlags(n, n2);
    }

    void setWindowFormat(int n) {
        this.getWindow().setFormat(n);
    }

    void showIme(int n) {
        this.mIMM.showSoftInput(this.mNativeContentView, n);
    }

    @Override
    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        if (!this.mDestroyed) {
            this.mCurSurfaceHolder = surfaceHolder;
            this.onSurfaceChangedNative(this.mNativeHandle, surfaceHolder.getSurface(), n, n2, n3);
        }
    }

    @Override
    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        if (!this.mDestroyed) {
            this.mCurSurfaceHolder = surfaceHolder;
            this.onSurfaceCreatedNative(this.mNativeHandle, surfaceHolder.getSurface());
        }
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mCurSurfaceHolder = null;
        if (!this.mDestroyed) {
            this.onSurfaceDestroyedNative(this.mNativeHandle);
        }
    }

    @Override
    public void surfaceRedrawNeeded(SurfaceHolder surfaceHolder) {
        if (!this.mDestroyed) {
            this.mCurSurfaceHolder = surfaceHolder;
            this.onSurfaceRedrawNeededNative(this.mNativeHandle, surfaceHolder.getSurface());
        }
    }

    static class NativeContentView
    extends View {
        NativeActivity mActivity;

        public NativeContentView(Context context) {
            super(context);
        }

        public NativeContentView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }
    }
}

