/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.ActivityTransitionCoordinator;
import android.app.SharedElementCallback;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.ResultReceiver;
import android.text.TextUtils;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.util.ArrayMap;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.view.ViewTreeObserver;
import android.view.Window;
import java.util.ArrayList;

class EnterTransitionCoordinator
extends ActivityTransitionCoordinator {
    private static final int MIN_ANIMATION_FRAMES = 2;
    private static final String TAG = "EnterTransitionCoordinator";
    private Activity mActivity;
    private boolean mAreViewsReady;
    private ObjectAnimator mBackgroundAnimator;
    private Transition mEnterViewsTransition;
    private boolean mHasStopped;
    private boolean mIsCanceled;
    private boolean mIsExitTransitionComplete;
    private boolean mIsReadyForTransition;
    private boolean mIsSharedElementTransitionComplete;
    private boolean mIsViewsTransitionComplete;
    private boolean mIsViewsTransitionStarted;
    private ArrayList<Matrix> mSharedElementParentMatrices;
    private boolean mSharedElementTransitionStarted;
    private Bundle mSharedElementsBundle;
    private boolean mWasOpaque;

    public EnterTransitionCoordinator(Activity activity, ResultReceiver resultReceiver, ArrayList<String> arrayList, boolean bl) {
        super(activity.getWindow(), arrayList, EnterTransitionCoordinator.getListener(activity, bl), bl);
        this.mActivity = activity;
        this.setResultReceiver(resultReceiver);
        this.prepareEnter();
        Bundle bundle = new Bundle();
        bundle.putParcelable("android:remoteReceiver", this);
        this.mResultReceiver.send(100, bundle);
        final ViewGroup viewGroup = this.getDecor();
        if (viewGroup != null) {
            viewGroup.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    if (EnterTransitionCoordinator.this.mIsReadyForTransition) {
                        viewGroup.getViewTreeObserver().removeOnPreDrawListener(this);
                    }
                    return EnterTransitionCoordinator.this.mIsReadyForTransition;
                }
            });
        }
    }

    static /* synthetic */ Transition access$502(EnterTransitionCoordinator enterTransitionCoordinator, Transition transition2) {
        enterTransitionCoordinator.mEnterViewsTransition = transition2;
        return transition2;
    }

    private boolean allowOverlappingTransitions() {
        if (this.mIsReturning) {
            return this.getWindow().getAllowExitTransitionOverlap();
        }
        return this.getWindow().getAllowEnterTransitionOverlap();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Transition beginTransition(ViewGroup viewGroup, boolean bl, boolean bl2) {
        Transition transition2;
        Transition transition3 = null;
        if (bl2) {
            boolean bl3 = this.mSharedElementNames.isEmpty();
            transition3 = null;
            if (!bl3) {
                transition3 = this.configureTransition(this.getSharedElementTransition(), false);
            }
            if (transition3 == null) {
                this.sharedElementTransitionStarted();
                this.sharedElementTransitionComplete();
            } else {
                transition3.addListener(new Transition.TransitionListenerAdapter(){

                    @Override
                    public void onTransitionEnd(Transition transition2) {
                        transition2.removeListener(this);
                        EnterTransitionCoordinator.this.sharedElementTransitionComplete();
                    }

                    @Override
                    public void onTransitionStart(Transition transition2) {
                        EnterTransitionCoordinator.this.sharedElementTransitionStarted();
                    }
                });
            }
        }
        Transition transition4 = null;
        if (bl) {
            this.mIsViewsTransitionStarted = true;
            ArrayList arrayList = this.mTransitioningViews;
            transition4 = null;
            if (arrayList != null) {
                boolean bl4 = this.mTransitioningViews.isEmpty();
                transition4 = null;
                if (!bl4 && (transition4 = this.configureTransition(this.getViewsTransition(), true)) != null && !this.mIsReturning) {
                    this.stripOffscreenViews();
                }
            }
            if (transition4 == null) {
                this.viewTransitionComplete();
            } else {
                transition4.forceVisibility(4, true);
                transition4.addListener(new ActivityTransitionCoordinator.ContinueTransitionListener(){

                    @Override
                    public void onTransitionEnd(Transition transition2) {
                        EnterTransitionCoordinator.access$502(EnterTransitionCoordinator.this, null);
                        transition2.removeListener(this);
                        EnterTransitionCoordinator.this.viewTransitionComplete();
                        super.onTransitionEnd(transition2);
                    }

                    @Override
                    public void onTransitionStart(Transition transition2) {
                        EnterTransitionCoordinator.access$502(EnterTransitionCoordinator.this, transition2);
                        if (mTransitioningViews != null) {
                            EnterTransitionCoordinator.this.showViews(mTransitioningViews, false);
                        }
                        super.onTransitionStart(transition2);
                    }
                });
            }
        }
        if ((transition2 = EnterTransitionCoordinator.mergeTransitions(transition3, transition4)) == null) {
            this.transitionStarted();
            return transition2;
        }
        transition2.addListener(new ActivityTransitionCoordinator.ContinueTransitionListener());
        TransitionManager.beginDelayedTransition(viewGroup, transition2);
        if (bl2 && !this.mSharedElementNames.isEmpty()) {
            ((View)this.mSharedElements.get(0)).invalidate();
            return transition2;
        } else {
            if (!bl || this.mTransitioningViews == null || this.mTransitioningViews.isEmpty()) return transition2;
            ((View)this.mTransitioningViews.get(0)).invalidate();
            return transition2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void cancel() {
        if (!this.mIsCanceled) {
            this.mIsCanceled = true;
            if (this.getViewsTransition() == null || this.mIsViewsTransitionStarted) {
                this.showViews(this.mSharedElements, true);
            } else if (this.mTransitioningViews != null) {
                this.mTransitioningViews.addAll(this.mSharedElements);
            }
            this.mSharedElementNames.clear();
            this.mSharedElements.clear();
            this.mAllSharedElementNames.clear();
            this.startSharedElementTransition(null);
            this.onRemoteExitTransitionComplete();
        }
    }

    private static SharedElementCallback getListener(Activity activity, boolean bl) {
        if (bl) {
            return activity.mExitTransitionListener;
        }
        return activity.mEnterTransitionListener;
    }

    private void makeOpaque() {
        if (!this.mHasStopped && this.mActivity != null) {
            if (this.mWasOpaque) {
                this.mActivity.convertFromTranslucent();
            }
            this.mActivity = null;
        }
    }

    private ArrayMap<String, View> mapNamedElements(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ArrayMap<String, View> arrayMap = new ArrayMap<String, View>();
        ViewGroup viewGroup = this.getDecor();
        if (viewGroup != null) {
            viewGroup.findNamedViews(arrayMap);
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                View view;
                String string2 = arrayList2.get(i);
                String string3 = arrayList.get(i);
                if (string2 == null || string2.equals(string3) || (view = arrayMap.remove(string2)) == null) continue;
                arrayMap.put(string3, view);
            }
        }
        return arrayMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onTakeSharedElements() {
        ViewGroup viewGroup;
        Bundle bundle;
        block3: {
            block2: {
                if (!this.mIsReadyForTransition || this.mSharedElementsBundle == null) break block2;
                bundle = this.mSharedElementsBundle;
                this.mSharedElementsBundle = null;
                viewGroup = this.getDecor();
                if (viewGroup != null) break block3;
            }
            return;
        }
        viewGroup.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            @Override
            public boolean onPreDraw() {
                viewGroup.getViewTreeObserver().removeOnPreDrawListener(this);
                EnterTransitionCoordinator.this.startTransition(new Runnable(){

                    @Override
                    public void run() {
                        EnterTransitionCoordinator.this.startSharedElementTransition(bundle);
                    }
                });
                return false;
            }
        });
        viewGroup.invalidate();
    }

    private void requestLayoutForSharedElements() {
        int n = this.mSharedElements.size();
        for (int i = 0; i < n; ++i) {
            ((View)this.mSharedElements.get(i)).requestLayout();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void sendSharedElementDestination() {
        block7: {
            block5: {
                block9: {
                    block8: {
                        block6: {
                            var1_1 = this.getDecor();
                            if (!this.allowOverlappingTransitions() || this.getEnterViewsTransition() == null) break block6;
                            var2_2 = false;
lbl4:
                            // 5 sources

                            while (var2_2) {
                                var4_3 = this.captureSharedElementState();
                                this.setSharedElementMatrices();
                                this.moveSharedElementsToOverlay();
                                this.mResultReceiver.send(107, var4_3);
lbl9:
                                // 3 sources

                                while (true) {
                                    if (this.allowOverlappingTransitions()) {
                                        this.startEnterTransitionOnly();
                                    }
                                    return;
                                }
                            }
                            break block7;
                        }
                        if (var1_1 != null) break block8;
                        var2_2 = true;
                        ** GOTO lbl4
                    }
                    if (var1_1.isLayoutRequested()) break block9;
                    var2_2 = true;
lbl21:
                    // 2 sources

                    while (var2_2) {
                        var3_4 = 0;
lbl23:
                        // 2 sources

                        while (var3_4 < this.mSharedElements.size()) {
                            if (!((View)this.mSharedElements.get(var3_4)).isLayoutRequested()) break block5;
                            var2_2 = false;
                            ** GOTO lbl4
                        }
                        ** GOTO lbl4
                    }
                    ** GOTO lbl4
                }
                var2_2 = false;
                ** GOTO lbl21
            }
            ++var3_4;
            ** GOTO lbl23
        }
        if (var1_1 == null) ** GOTO lbl9
        var1_1.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            @Override
            public boolean onPreDraw() {
                var1_1.getViewTreeObserver().removeOnPreDrawListener(this);
                if (EnterTransitionCoordinator.this.mResultReceiver != null) {
                    Bundle bundle = EnterTransitionCoordinator.this.captureSharedElementState();
                    EnterTransitionCoordinator.this.setSharedElementMatrices();
                    EnterTransitionCoordinator.this.moveSharedElementsToOverlay();
                    EnterTransitionCoordinator.this.mResultReceiver.send(107, bundle);
                }
                return true;
            }
        });
        ** while (true)
    }

    private void setSharedElementMatrices() {
        int n = this.mSharedElements.size();
        if (n > 0) {
            this.mSharedElementParentMatrices = new ArrayList(n);
        }
        for (int i = 0; i < n; ++i) {
            ViewGroup viewGroup = (ViewGroup)((View)this.mSharedElements.get(i)).getParent();
            Matrix matrix = new Matrix();
            viewGroup.transformMatrixToLocal(matrix);
            this.mSharedElementParentMatrices.add(matrix);
        }
    }

    private void sharedElementTransitionComplete() {
        this.mIsSharedElementTransitionComplete = true;
        if (this.mIsViewsTransitionComplete) {
            this.moveSharedElementsFromOverlay();
        }
    }

    private void sharedElementTransitionStarted() {
        this.mSharedElementTransitionStarted = true;
        if (this.mIsExitTransitionComplete) {
            this.send(104, null);
        }
    }

    private void startEnterTransition(Transition transition2) {
        block5: {
            block4: {
                ViewGroup viewGroup = this.getDecor();
                if (this.mIsReturning || viewGroup == null) break block4;
                Drawable drawable2 = viewGroup.getBackground();
                if (drawable2 == null) break block5;
                Drawable drawable3 = drawable2.mutate();
                this.getWindow().setBackgroundDrawable(drawable3);
                this.mBackgroundAnimator = ObjectAnimator.ofInt((Object)drawable3, "alpha", 255);
                this.mBackgroundAnimator.setDuration(this.getFadeDuration());
                this.mBackgroundAnimator.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animator2) {
                        EnterTransitionCoordinator.this.makeOpaque();
                    }
                });
                this.mBackgroundAnimator.start();
            }
            return;
        }
        if (transition2 != null) {
            transition2.addListener(new Transition.TransitionListenerAdapter(){

                @Override
                public void onTransitionEnd(Transition transition2) {
                    transition2.removeListener(this);
                    EnterTransitionCoordinator.this.makeOpaque();
                }
            });
            return;
        }
        this.makeOpaque();
    }

    private void startEnterTransitionOnly() {
        this.startTransition(new Runnable(){

            @Override
            public void run() {
                ViewGroup viewGroup = EnterTransitionCoordinator.this.getDecor();
                if (viewGroup != null) {
                    Transition transition2 = EnterTransitionCoordinator.this.beginTransition(viewGroup, true, false);
                    EnterTransitionCoordinator.this.startEnterTransition(transition2);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void startRejectedAnimations(final ArrayList<View> arrayList) {
        ViewGroup viewGroup;
        if (arrayList == null || arrayList.isEmpty() || (viewGroup = this.getDecor()) == null) {
            return;
        }
        ViewGroupOverlay viewGroupOverlay = viewGroup.getOverlay();
        Animator animator2 = null;
        int n = arrayList.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                animator2.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(Animator animator2) {
                        ViewGroupOverlay viewGroupOverlay = viewGroup.getOverlay();
                        int n = arrayList.size();
                        for (int i = 0; i < n; ++i) {
                            viewGroupOverlay.remove((View)arrayList.get(i));
                        }
                    }
                });
                return;
            }
            View view = arrayList.get(n2);
            viewGroupOverlay.add(view);
            animator2 = ObjectAnimator.ofFloat(view, View.ALPHA, 1.0f, 0.0f);
            ((ObjectAnimator)animator2).start();
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void startSharedElementTransition(Bundle bundle) {
        ViewGroup viewGroup;
        block7: {
            block6: {
                boolean bl = true;
                viewGroup = this.getDecor();
                if (viewGroup == null) break block6;
                ArrayList<String> arrayList = new ArrayList<String>(this.mAllSharedElementNames);
                arrayList.removeAll(this.mSharedElementNames);
                ArrayList<View> arrayList2 = this.createSnapshots(bundle, arrayList);
                if (this.mListener != null) {
                    this.mListener.onRejectSharedElements(arrayList2);
                }
                this.startRejectedAnimations(arrayList2);
                ArrayList<View> arrayList3 = this.createSnapshots(bundle, this.mSharedElementNames);
                this.showViews(this.mSharedElements, bl);
                this.scheduleSetSharedElementEnd(arrayList3);
                ArrayList<ActivityTransitionCoordinator.SharedElementOriginalState> arrayList4 = this.setSharedElementState(bundle, arrayList3);
                this.requestLayoutForSharedElements();
                if (!this.allowOverlappingTransitions() || this.mIsReturning) {
                    bl = false;
                }
                this.setGhostVisibility(4);
                this.scheduleGhostVisibilityChange(4);
                Transition transition2 = this.beginTransition(viewGroup, bl, true);
                this.scheduleGhostVisibilityChange(0);
                this.setGhostVisibility(0);
                if (bl) {
                    this.startEnterTransition(transition2);
                }
                EnterTransitionCoordinator.setOriginalSharedElementState(this.mSharedElements, arrayList4);
                if (this.mResultReceiver != null) break block7;
            }
            return;
        }
        viewGroup.postOnAnimation(new Runnable(){
            int mAnimations;

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                int n = this.mAnimations;
                this.mAnimations = n + 1;
                if (n < 2) {
                    ViewGroup viewGroup = EnterTransitionCoordinator.this.getDecor();
                    if (viewGroup == null) return;
                    viewGroup.postOnAnimation(this);
                    return;
                }
                if (EnterTransitionCoordinator.this.mResultReceiver == null) return;
                EnterTransitionCoordinator.this.mResultReceiver.send(101, null);
                EnterTransitionCoordinator.this.mResultReceiver = null;
            }
        });
    }

    private void triggerViewsReady(final ArrayMap<String, View> arrayMap) {
        if (this.mAreViewsReady) {
            return;
        }
        this.mAreViewsReady = true;
        if (arrayMap.isEmpty() || !arrayMap.valueAt(0).isLayoutRequested()) {
            this.viewsReady(arrayMap);
            return;
        }
        final View view = arrayMap.valueAt(0);
        view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            @Override
            public boolean onPreDraw() {
                view.getViewTreeObserver().removeOnPreDrawListener(this);
                EnterTransitionCoordinator.this.viewsReady(arrayMap);
                return true;
            }
        });
    }

    private void viewTransitionComplete() {
        this.mIsViewsTransitionComplete = true;
        if (this.mIsSharedElementTransitionComplete) {
            this.moveSharedElementsFromOverlay();
        }
    }

    public void cancelEnter() {
        this.setGhostVisibility(4);
        this.mHasStopped = true;
        this.mIsCanceled = true;
        this.mResultReceiver = null;
        if (this.mBackgroundAnimator != null) {
            this.mBackgroundAnimator.cancel();
            this.mBackgroundAnimator = null;
        }
        this.mActivity = null;
        this.clearState();
    }

    public Transition getEnterViewsTransition() {
        return this.mEnterViewsTransition;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void getSharedElementParentMatrix(View view, Matrix matrix) {
        int n = this.mSharedElementParentMatrices == null ? -1 : this.mSharedElements.indexOf(view);
        if (n < 0) {
            super.getSharedElementParentMatrix(view, matrix);
            return;
        }
        matrix.set(this.mSharedElementParentMatrices.get(n));
    }

    protected Transition getSharedElementTransition() {
        Window window = this.getWindow();
        if (window == null) {
            return null;
        }
        if (this.mIsReturning) {
            return window.getSharedElementReenterTransition();
        }
        return window.getSharedElementEnterTransition();
    }

    @Override
    protected Transition getViewsTransition() {
        Window window = this.getWindow();
        if (window == null) {
            return null;
        }
        if (this.mIsReturning) {
            return window.getReenterTransition();
        }
        return window.getEnterTransition();
    }

    public boolean isReturning() {
        return this.mIsReturning;
    }

    public void namedViewsReady(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        this.triggerViewsReady(this.mapNamedElements(arrayList, arrayList2));
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    protected void onReceiveResult(int n, Bundle bundle) {
        switch (n) {
            default: {
                return;
            }
            case 103: {
                if (this.mIsCanceled) return;
                this.mSharedElementsBundle = bundle;
                this.onTakeSharedElements();
                return;
            }
            case 104: {
                if (this.mIsCanceled) return;
                this.mIsExitTransitionComplete = true;
                if (!this.mSharedElementTransitionStarted) return;
                this.onRemoteExitTransitionComplete();
                return;
            }
            case 106: 
        }
        this.cancel();
    }

    protected void onRemoteExitTransitionComplete() {
        if (!this.allowOverlappingTransitions()) {
            this.startEnterTransitionOnly();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void prepareEnter() {
        Drawable drawable2;
        block5: {
            block4: {
                ViewGroup viewGroup = this.getDecor();
                if (this.mActivity == null || viewGroup == null) break block4;
                this.mActivity.overridePendingTransition(0, 0);
                if (this.mIsReturning) {
                    this.mActivity = null;
                    return;
                }
                this.mWasOpaque = this.mActivity.convertToTranslucent(null, null);
                drawable2 = viewGroup.getBackground();
                if (drawable2 != null) break block5;
            }
            return;
        }
        this.getWindow().setBackgroundDrawable(null);
        Drawable drawable3 = drawable2.mutate();
        drawable3.setAlpha(0);
        this.getWindow().setBackgroundDrawable(drawable3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void stop() {
        Drawable drawable2;
        ViewGroup viewGroup;
        if (this.mBackgroundAnimator != null) {
            this.mBackgroundAnimator.end();
            this.mBackgroundAnimator = null;
        } else if (this.mWasOpaque && (viewGroup = this.getDecor()) != null && (drawable2 = viewGroup.getBackground()) != null) {
            drawable2.setAlpha(1);
        }
        this.makeOpaque();
        this.mIsCanceled = true;
        this.mResultReceiver = null;
        this.mActivity = null;
        this.moveSharedElementsFromOverlay();
        if (this.mTransitioningViews != null) {
            this.showViews(this.mTransitioningViews, true);
        }
        this.showViews(this.mSharedElements, true);
        this.clearState();
    }

    public void viewInstancesReady(ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<View> arrayList3) {
        int n = 0;
        while (true) {
            block4: {
                boolean bl;
                block3: {
                    int n2 = arrayList3.size();
                    bl = false;
                    if (n >= n2) break block3;
                    View view = arrayList3.get(n);
                    if (TextUtils.equals(view.getTransitionName(), arrayList2.get(n)) && view.isAttachedToWindow()) break block4;
                    bl = true;
                }
                if (!bl) break;
                this.triggerViewsReady(this.mapNamedElements(arrayList, arrayList2));
                return;
            }
            ++n;
        }
        this.triggerViewsReady(this.mapSharedElements(arrayList, arrayList3));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void viewsReady(ArrayMap<String, View> arrayMap) {
        super.viewsReady(arrayMap);
        this.mIsReadyForTransition = true;
        this.hideViews(this.mSharedElements);
        if (this.getViewsTransition() != null && this.mTransitioningViews != null) {
            this.hideViews(this.mTransitioningViews);
        }
        if (this.mIsReturning) {
            this.sendSharedElementDestination();
        } else {
            this.setSharedElementMatrices();
            this.moveSharedElementsToOverlay();
        }
        if (this.mSharedElementsBundle != null) {
            this.onTakeSharedElements();
        }
    }
}

