/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.SystemProperties;
import android.provider.Downloads;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class DownloadManager {
    public static final String ACTION_DOWNLOAD_CHANGESTORAGE = "android.intent.action.DOWNLOAD_CHANGESTORAGE";
    public static final String ACTION_DOWNLOAD_COMPLETE = "android.intent.action.DOWNLOAD_COMPLETE";
    public static final String ACTION_NOTIFICATION_CLICKED = "android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED";
    public static final String ACTION_VIEW_DOWNLOADS = "android.intent.action.VIEW_DOWNLOADS";
    public static final String COLUMN_ALLOW_WRITE = "allow_write";
    public static final String COLUMN_BYTES_DOWNLOADED_SO_FAR = "bytes_so_far";
    public static final String COLUMN_DESCRIPTION = "description";
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_LAST_MODIFIED_TIMESTAMP = "last_modified_timestamp";
    public static final String COLUMN_LOCAL_FILENAME = "local_filename";
    public static final String COLUMN_LOCAL_URI = "local_uri";
    public static final String COLUMN_MEDIAPROVIDER_URI = "mediaprovider_uri";
    public static final String COLUMN_MEDIA_TYPE = "media_type";
    public static final String COLUMN_REASON = "reason";
    public static final String COLUMN_STATUS = "status";
    public static final String COLUMN_TITLE = "title";
    public static final String COLUMN_TOTAL_SIZE_BYTES = "total_size";
    public static final String COLUMN_URI = "uri";
    public static final int ERROR_BLOCKED = 1010;
    public static final int ERROR_CANNOT_RESUME = 1008;
    public static final int ERROR_DEVICE_NOT_FOUND = 1007;
    public static final int ERROR_FILE_ALREADY_EXISTS = 1009;
    public static final int ERROR_FILE_ERROR = 1001;
    public static final int ERROR_HTTP_DATA_ERROR = 1004;
    public static final int ERROR_INSUFFICIENT_SPACE = 1006;
    public static final int ERROR_TOO_MANY_REDIRECTS = 1005;
    public static final int ERROR_UNHANDLED_HTTP_CODE = 1002;
    public static final int ERROR_UNKNOWN = 1000;
    public static final String EXTRA_DOWNLOAD_ID = "extra_download_id";
    public static final String EXTRA_NOTIFICATION_CLICK_DOWNLOAD_IDS = "extra_click_download_ids";
    public static final String INTENT_EXTRAS_SORT_BY_SIZE = "android.app.DownloadManager.extra_sortBySize";
    private static final String NON_DOWNLOADMANAGER_DOWNLOAD = "non-dwnldmngr-download-dont-retry2download";
    public static final int PAUSED_QUEUED_FOR_WIFI = 3;
    public static final int PAUSED_UNKNOWN = 4;
    public static final int PAUSED_WAITING_FOR_NETWORK = 2;
    public static final int PAUSED_WAITING_TO_RETRY = 1;
    public static final int STATUS_FAILED = 16;
    public static final int STATUS_PAUSED = 4;
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_SUCCESSFUL = 8;
    public static final String[] UNDERLYING_COLUMNS = new String[]{"_id", "_data AS local_filename", "mediaprovider_uri", "destination", "title", "description", "uri", "status", "hint", "mimetype AS media_type", "total_bytes AS total_size", "lastmod AS last_modified_timestamp", "current_bytes AS bytes_so_far", "allow_write", "'placeholder' AS local_uri", "'placeholder' AS reason"};
    private Uri mBaseUri = Downloads.Impl.CONTENT_URI;
    private String mPackageName;
    private ContentResolver mResolver;

    public DownloadManager(ContentResolver contentResolver, String string2) {
        this.mResolver = contentResolver;
        this.mPackageName = string2;
    }

    public static long getActiveNetworkWarningBytes(Context context) {
        return -1L;
    }

    public static Long getMaxBytesOverMobile(Context context) {
        try {
            Long l = Settings.Global.getLong(context.getContentResolver(), "download_manager_max_bytes_over_mobile");
            return l;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return null;
        }
    }

    public static Long getRecommendedMaxBytesOverMobile(Context context) {
        try {
            Long l = Settings.Global.getLong(context.getContentResolver(), "download_manager_recommended_max_bytes_over_mobile");
            return l;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return null;
        }
    }

    static String[] getWhereArgsForIds(long[] lArray) {
        String[] stringArray = new String[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            stringArray[i] = Long.toString(lArray[i]);
        }
        return stringArray;
    }

    static String getWhereClauseForIds(long[] lArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append("OR ");
            }
            stringBuilder.append(COLUMN_ID);
            stringBuilder.append(" = ? ");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static boolean isActiveNetworkExpensive(Context context) {
        return false;
    }

    private static void validateArgumentIsNonEmpty(String string2, String string3) {
        if (TextUtils.isEmpty(string3)) {
            throw new IllegalArgumentException(string2 + " can't be null");
        }
    }

    public long addCompletedDownload(String string2, String string3, boolean bl, String string4, String string5, long l, boolean bl2) {
        return this.addCompletedDownload(string2, string3, bl, string4, string5, l, bl2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public long addCompletedDownload(String string2, String string3, boolean bl, String string4, String string5, long l, boolean bl2, boolean bl3) {
        DownloadManager.validateArgumentIsNonEmpty(COLUMN_TITLE, string2);
        DownloadManager.validateArgumentIsNonEmpty(COLUMN_DESCRIPTION, string3);
        DownloadManager.validateArgumentIsNonEmpty("path", string5);
        DownloadManager.validateArgumentIsNonEmpty("mimeType", string4);
        if (l < 0L) {
            throw new IllegalArgumentException(" invalid value for param: totalBytes");
        }
        ContentValues contentValues = new Request(NON_DOWNLOADMANAGER_DOWNLOAD).setTitle(string2).setDescription(string3).setMimeType(string4).toContentValues(null);
        contentValues.put("destination", 6);
        contentValues.put("_data", string5);
        contentValues.put(COLUMN_STATUS, 200);
        contentValues.put("total_bytes", l);
        int n = bl ? 0 : 2;
        contentValues.put("scanned", n);
        int n2 = bl2 ? 3 : 2;
        contentValues.put("visibility", n2);
        int n3 = bl3 ? 1 : 0;
        contentValues.put(COLUMN_ALLOW_WRITE, n3);
        Uri uri = this.mResolver.insert(Downloads.Impl.CONTENT_URI, contentValues);
        if (uri == null) {
            return -1L;
        }
        return Long.parseLong(uri.getLastPathSegment());
    }

    public long enqueue(Request request) {
        ContentValues contentValues = request.toContentValues(this.mPackageName);
        return Long.parseLong(this.mResolver.insert(Downloads.Impl.CONTENT_URI, contentValues).getLastPathSegment());
    }

    public Uri getDownloadUri(long l) {
        return ContentUris.withAppendedId(this.mBaseUri, l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMimeTypeForDownloadedFile(long l) {
        Query query = new Query().setFilterById(l);
        Cursor cursor = null;
        try {
            String string2;
            Cursor cursor2;
            cursor = cursor2 = this.query(query);
            if (cursor == null) {
                string2 = null;
                if (cursor == null) return string2;
                cursor.close();
                return string2;
            }
            if (cursor.moveToFirst()) {
                String string3;
                string2 = string3 = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_MEDIA_TYPE));
                if (cursor == null) return string2;
                cursor.close();
                return string2;
            } else {
                string2 = null;
                if (cursor == null) return string2;
                cursor.close();
                return null;
            }
        }
        catch (Throwable throwable) {
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Uri getUriForDownloadedFile(long l) {
        Uri uri;
        Cursor cursor;
        block12: {
            Query query = new Query().setFilterById(l);
            cursor = null;
            try {
                Cursor cursor2;
                cursor = cursor2 = this.query(query);
                if (cursor == null) {
                    uri = null;
                    if (cursor == null) return uri;
                    cursor.close();
                    return uri;
                }
                if (!cursor.moveToFirst() || 8 != cursor.getInt(cursor.getColumnIndexOrThrow(COLUMN_STATUS))) break block12;
                int n = cursor.getInt(cursor.getColumnIndexOrThrow("destination"));
                if (n == 1 || n == 5 || n == 3 || n == 2) {
                    Uri uri2;
                    uri = uri2 = ContentUris.withAppendedId(Downloads.Impl.CONTENT_URI, l);
                    if (cursor == null) return uri;
                    cursor.close();
                    return uri;
                } else {
                    Uri uri3;
                    uri = uri3 = Uri.fromFile(new File(cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_LOCAL_FILENAME))));
                    if (cursor == null) return uri;
                    cursor.close();
                    return uri;
                }
            }
            catch (Throwable throwable) {
                if (cursor == null) throw throwable;
                cursor.close();
                throw throwable;
            }
        }
        uri = null;
        if (cursor == null) return uri;
        cursor.close();
        return null;
    }

    public int markRowDeleted(long ... lArray) {
        if (lArray == null || lArray.length == 0) {
            throw new IllegalArgumentException("input param 'ids' can't be null");
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("deleted", 1);
        if (lArray.length == 1) {
            return this.mResolver.update(ContentUris.withAppendedId(this.mBaseUri, lArray[0]), contentValues, null, null);
        }
        return this.mResolver.update(this.mBaseUri, contentValues, DownloadManager.getWhereClauseForIds(lArray), DownloadManager.getWhereArgsForIds(lArray));
    }

    public ParcelFileDescriptor openDownloadedFile(long l) throws FileNotFoundException {
        return this.mResolver.openFileDescriptor(this.getDownloadUri(l), "r");
    }

    public Cursor query(Query query) {
        Cursor cursor = query.runQuery(this.mResolver, UNDERLYING_COLUMNS, this.mBaseUri);
        if (cursor == null) {
            return null;
        }
        return new CursorTranslator(cursor, this.mBaseUri);
    }

    public int remove(long ... lArray) {
        return this.markRowDeleted(lArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restartDownload(long ... lArray) {
        Cursor cursor = this.query(new Query().setFilterById(lArray));
        try {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                int n = cursor.getInt(cursor.getColumnIndex(COLUMN_STATUS));
                if (n != 8 && n != 16) {
                    throw new IllegalArgumentException("Cannot restart incomplete download: " + cursor.getLong(cursor.getColumnIndex(COLUMN_ID)));
                }
                cursor.moveToNext();
            }
        }
        finally {
            cursor.close();
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("current_bytes", 0);
        contentValues.put("total_bytes", -1);
        contentValues.putNull("_data");
        contentValues.put(COLUMN_STATUS, 190);
        contentValues.put("numfailed", 0);
        this.mResolver.update(this.mBaseUri, contentValues, DownloadManager.getWhereClauseForIds(lArray), DownloadManager.getWhereArgsForIds(lArray));
    }

    public void setAccessAllDownloads(boolean bl) {
        if (bl) {
            this.mBaseUri = Downloads.Impl.ALL_DOWNLOADS_CONTENT_URI;
            return;
        }
        this.mBaseUri = Downloads.Impl.CONTENT_URI;
    }

    private static class CursorTranslator
    extends CursorWrapper {
        static final /* synthetic */ boolean $assertionsDisabled;
        private Uri mBaseUri;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl = !DownloadManager.class.desiredAssertionStatus();
            $assertionsDisabled = bl;
        }

        public CursorTranslator(Cursor cursor, Uri uri) {
            super(cursor);
            this.mBaseUri = uri;
        }

        private long getErrorCode(int n) {
            if (400 <= n && n < 488 || 500 <= n && n < 600) {
                return n;
            }
            switch (n) {
                default: {
                    return 1000L;
                }
                case 492: {
                    return 1001L;
                }
                case 493: 
                case 494: {
                    return 1002L;
                }
                case 495: {
                    return 1004L;
                }
                case 497: {
                    return 1005L;
                }
                case 198: {
                    return 1006L;
                }
                case 199: {
                    return 1007L;
                }
                case 489: {
                    return 1008L;
                }
                case 488: 
            }
            return 1009L;
        }

        private String getLocalUri() {
            long l = this.getLong(this.getColumnIndex("destination"));
            if (l == 4L || l == 0L || l == 6L) {
                String string2 = this.getString(this.getColumnIndex(DownloadManager.COLUMN_LOCAL_FILENAME));
                if (string2 == null) {
                    return null;
                }
                return Uri.fromFile(new File(string2)).toString();
            }
            long l2 = this.getLong(this.getColumnIndex(DownloadManager.COLUMN_ID));
            return ContentUris.withAppendedId(this.mBaseUri, l2).toString();
        }

        private long getPausedReason(int n) {
            switch (n) {
                default: {
                    return 4L;
                }
                case 194: {
                    return 1L;
                }
                case 195: {
                    return 2L;
                }
                case 196: 
            }
            return 3L;
        }

        private long getReason(int n) {
            switch (this.translateStatus(n)) {
                default: {
                    return 0L;
                }
                case 16: {
                    return this.getErrorCode(n);
                }
                case 4: 
            }
            return this.getPausedReason(n);
        }

        private int translateStatus(int n) {
            switch (n) {
                default: {
                    if (!$assertionsDisabled && !Downloads.Impl.isStatusError(n)) {
                        throw new AssertionError();
                    }
                    break;
                }
                case 190: {
                    return 1;
                }
                case 192: {
                    return 2;
                }
                case 193: 
                case 194: 
                case 195: 
                case 196: {
                    return 4;
                }
                case 200: {
                    return 8;
                }
            }
            return 16;
        }

        @Override
        public int getInt(int n) {
            return (int)this.getLong(n);
        }

        @Override
        public long getLong(int n) {
            if (this.getColumnName(n).equals(DownloadManager.COLUMN_REASON)) {
                return this.getReason(super.getInt(this.getColumnIndex(DownloadManager.COLUMN_STATUS)));
            }
            if (this.getColumnName(n).equals(DownloadManager.COLUMN_STATUS)) {
                return this.translateStatus(super.getInt(this.getColumnIndex(DownloadManager.COLUMN_STATUS)));
            }
            return super.getLong(n);
        }

        @Override
        public String getString(int n) {
            if (this.getColumnName(n).equals(DownloadManager.COLUMN_LOCAL_URI)) {
                return this.getLocalUri();
            }
            return super.getString(n);
        }
    }

    public static class Query {
        public static final int ORDER_ASCENDING = 1;
        public static final int ORDER_DESCENDING = 2;
        private long[] mIds = null;
        private boolean mOnlyIncludeVisibleInDownloadsUi = false;
        private String mOrderByColumn = "lastmod";
        private int mOrderDirection = 2;
        private Integer mStatusFlags = null;

        private String joinStrings(String string2, Iterable<String> iterable) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (String string3 : iterable) {
                if (!bl) {
                    stringBuilder.append(string2);
                }
                stringBuilder.append(string3);
                bl = false;
            }
            return stringBuilder.toString();
        }

        private String statusClause(String string2, int n) {
            return DownloadManager.COLUMN_STATUS + string2 + "'" + n + "'";
        }

        /*
         * Enabled aggressive block sorting
         */
        public Query orderBy(String string2, int n) {
            if (n != 1 && n != 2) {
                throw new IllegalArgumentException("Invalid direction: " + n);
            }
            if (string2.equals(DownloadManager.COLUMN_LAST_MODIFIED_TIMESTAMP)) {
                this.mOrderByColumn = "lastmod";
            } else {
                if (!string2.equals(DownloadManager.COLUMN_TOTAL_SIZE_BYTES)) {
                    throw new IllegalArgumentException("Cannot order by " + string2);
                }
                this.mOrderByColumn = "total_bytes";
            }
            this.mOrderDirection = n;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Cursor runQuery(ContentResolver contentResolver, String[] stringArray, Uri uri) {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            long[] lArray = this.mIds;
            String[] stringArray2 = null;
            if (lArray != null) {
                arrayList.add(DownloadManager.getWhereClauseForIds(this.mIds));
                stringArray2 = DownloadManager.getWhereArgsForIds(this.mIds);
            }
            if (this.mStatusFlags != null) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if ((1 & this.mStatusFlags) != 0) {
                    arrayList2.add(this.statusClause("=", 190));
                }
                if ((2 & this.mStatusFlags) != 0) {
                    arrayList2.add(this.statusClause("=", 192));
                }
                if ((4 & this.mStatusFlags) != 0) {
                    arrayList2.add(this.statusClause("=", 193));
                    arrayList2.add(this.statusClause("=", 194));
                    arrayList2.add(this.statusClause("=", 195));
                    arrayList2.add(this.statusClause("=", 196));
                }
                if ((8 & this.mStatusFlags) != 0) {
                    arrayList2.add(this.statusClause("=", 200));
                }
                if ((0x10 & this.mStatusFlags) != 0) {
                    arrayList2.add("(" + this.statusClause(">=", 400) + " AND " + this.statusClause("<", 600) + ")");
                }
                arrayList.add(this.joinStrings(" OR ", arrayList2));
            }
            if (this.mOnlyIncludeVisibleInDownloadsUi) {
                arrayList.add("is_visible_in_downloads_ui != '0'");
            }
            arrayList.add("deleted != '1'");
            String string3 = this.joinStrings(" AND ", arrayList);
            if (this.mOrderDirection == 1) {
                string2 = "ASC";
                return contentResolver.query(uri, stringArray, string3, stringArray2, this.mOrderByColumn + " " + string2);
            }
            string2 = "DESC";
            return contentResolver.query(uri, stringArray, string3, stringArray2, this.mOrderByColumn + " " + string2);
        }

        public Query setFilterById(long ... lArray) {
            this.mIds = lArray;
            return this;
        }

        public Query setFilterByStatus(int n) {
            this.mStatusFlags = n;
            return this;
        }

        public Query setOnlyIncludeVisibleInDownloadsUi(boolean bl) {
            this.mOnlyIncludeVisibleInDownloadsUi = bl;
            return this;
        }
    }

    public static class Request {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        public static final int NETWORK_BLUETOOTH = 4;
        public static final int NETWORK_MOBILE = 1;
        public static final int NETWORK_WIFI = 2;
        private static final int SCANNABLE_VALUE_NO = 2;
        private static final int SCANNABLE_VALUE_YES = 0;
        public static final int VISIBILITY_HIDDEN = 2;
        public static final int VISIBILITY_VISIBLE = 0;
        public static final int VISIBILITY_VISIBLE_NOTIFY_COMPLETED = 1;
        public static final int VISIBILITY_VISIBLE_NOTIFY_ONLY_COMPLETION = 3;
        private int mAllowedNetworkTypes = -1;
        private CharSequence mDescription;
        private Uri mDestinationUri;
        private boolean mIsVisibleInDownloadsUi = true;
        private boolean mMeteredAllowed = true;
        private String mMimeType;
        private int mNotificationVisibility = 0;
        private List<Pair<String, String>> mRequestHeaders = new ArrayList<Pair<String, String>>();
        private boolean mRoamingAllowed = true;
        private boolean mScannable = false;
        private CharSequence mTitle;
        private Uri mUri;
        private boolean mUseSystemCache = false;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl = !DownloadManager.class.desiredAssertionStatus();
            $assertionsDisabled = bl;
        }

        public Request(Uri uri) {
            if (uri == null) {
                throw new NullPointerException();
            }
            String string2 = uri.getScheme();
            if (string2 == null || !string2.equals("http") && !string2.equals("https")) {
                throw new IllegalArgumentException("Can only download HTTP/HTTPS URIs: " + uri);
            }
            this.mUri = uri;
        }

        Request(String string2) {
            this.mUri = Uri.parse(string2);
        }

        private void encodeHttpHeaders(ContentValues contentValues) {
            int n = 0;
            for (Pair<String, String> pair : this.mRequestHeaders) {
                String string2 = (String)pair.first + ": " + (String)pair.second;
                contentValues.put("http_header_" + n, string2);
                ++n;
            }
        }

        private void putIfNonNull(ContentValues contentValues, String string2, Object object) {
            if (object != null) {
                contentValues.put(string2, object.toString());
            }
        }

        private void setDestinationFromBase(File file, String string2) {
            if (string2 == null) {
                throw new NullPointerException("subPath cannot be null");
            }
            this.mDestinationUri = Uri.withAppendedPath(Uri.fromFile(file), string2);
        }

        public Request addRequestHeader(String string2, String string3) {
            if (string2 == null) {
                throw new NullPointerException("header cannot be null");
            }
            if (string2.contains(":")) {
                throw new IllegalArgumentException("header may not contain ':'");
            }
            if (string3 == null) {
                string3 = "";
            }
            this.mRequestHeaders.add(Pair.create(string2, string3));
            return this;
        }

        public void allowScanningByMediaScanner() {
            this.mScannable = true;
        }

        public Request setAllowedNetworkTypes(int n) {
            this.mAllowedNetworkTypes = n;
            return this;
        }

        public Request setAllowedOverMetered(boolean bl) {
            this.mMeteredAllowed = bl;
            return this;
        }

        public Request setAllowedOverRoaming(boolean bl) {
            this.mRoamingAllowed = bl;
            return this;
        }

        public Request setDescription(CharSequence charSequence) {
            this.mDescription = charSequence;
            return this;
        }

        public Request setDestinationInExternalFilesDir(Context context, String string2, String string3) {
            File file = context.getExternalFilesDir(string2);
            if (file == null) {
                throw new IllegalStateException("Failed to get external storage files directory");
            }
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IllegalStateException(file.getAbsolutePath() + " already exists and is not a directory");
                }
            } else if (!file.mkdirs()) {
                throw new IllegalStateException("Unable to create directory: " + file.getAbsolutePath());
            }
            this.setDestinationFromBase(file, string3);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Request setDestinationInExternalPublicDir(String string2, String string3) {
            String string4 = SystemProperties.get("ro.epad.mount_point.microsd", "/storage/MicroSD");
            File file = string2.startsWith(string4) ? new File(string2) : (string2.startsWith("/Removable/MicroSD") ? new File(string2.replaceFirst("/Removable/MicroSD", string4)) : (string2.startsWith("/storage/sdcard1") ? new File(string2.replaceFirst("/storage/sdcard1", string4)) : Environment.getExternalStoragePublicDirectory(string2)));
            if (file == null) {
                throw new IllegalStateException("Failed to get external storage public directory");
            }
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IllegalStateException(file.getAbsolutePath() + " already exists and is not a directory");
                }
            } else if (!file.mkdirs()) {
                throw new IllegalStateException("Unable to create directory: " + file.getAbsolutePath());
            }
            this.setDestinationFromBase(file, string3);
            return this;
        }

        public Request setDestinationToSystemCache() {
            this.mUseSystemCache = true;
            return this;
        }

        public Request setDestinationUri(Uri uri) {
            this.mDestinationUri = uri;
            return this;
        }

        public Request setMimeType(String string2) {
            this.mMimeType = string2;
            return this;
        }

        public Request setNotificationVisibility(int n) {
            this.mNotificationVisibility = n;
            return this;
        }

        @Deprecated
        public Request setShowRunningNotification(boolean bl) {
            if (bl) {
                return this.setNotificationVisibility(0);
            }
            return this.setNotificationVisibility(2);
        }

        public Request setTitle(CharSequence charSequence) {
            this.mTitle = charSequence;
            return this;
        }

        public Request setVisibleInDownloadsUi(boolean bl) {
            this.mIsVisibleInDownloadsUi = bl;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        ContentValues toContentValues(String string2) {
            int n = 2;
            ContentValues contentValues = new ContentValues();
            if (!$assertionsDisabled && this.mUri == null) {
                throw new AssertionError();
            }
            contentValues.put(DownloadManager.COLUMN_URI, this.mUri.toString());
            contentValues.put("is_public_api", true);
            contentValues.put("notificationpackage", string2);
            if (this.mDestinationUri != null) {
                contentValues.put("destination", 4);
                contentValues.put("hint", this.mDestinationUri.toString());
            } else {
                int n2 = this.mUseSystemCache ? 5 : n;
                contentValues.put("destination", n2);
            }
            if (this.mScannable) {
                n = 0;
            }
            contentValues.put("scanned", n);
            if (!this.mRequestHeaders.isEmpty()) {
                this.encodeHttpHeaders(contentValues);
            }
            this.putIfNonNull(contentValues, DownloadManager.COLUMN_TITLE, this.mTitle);
            this.putIfNonNull(contentValues, DownloadManager.COLUMN_DESCRIPTION, this.mDescription);
            this.putIfNonNull(contentValues, "mimetype", this.mMimeType);
            contentValues.put("visibility", this.mNotificationVisibility);
            contentValues.put("allowed_network_types", this.mAllowedNetworkTypes);
            contentValues.put("allow_roaming", this.mRoamingAllowed);
            contentValues.put("allow_metered", this.mMeteredAllowed);
            contentValues.put("is_visible_in_downloads_ui", this.mIsVisibleInDownloadsUi);
            return contentValues;
        }
    }
}

