/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Context;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.util.ArrayMap;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AppOpsManager {
    public static final int MODE_ALLOWED = 0;
    public static final int MODE_DEFAULT = 3;
    public static final int MODE_ERRORED = 2;
    public static final int MODE_IGNORED = 1;
    public static final String OPSTR_ACTIVATE_VPN = "android:activate_vpn";
    public static final String OPSTR_COARSE_LOCATION = "android:coarse_location";
    public static final String OPSTR_FINE_LOCATION = "android:fine_location";
    public static final String OPSTR_GET_USAGE_STATS = "android:get_usage_stats";
    public static final String OPSTR_MONITOR_HIGH_POWER_LOCATION = "android:monitor_location_high_power";
    public static final String OPSTR_MONITOR_LOCATION = "android:monitor_location";
    public static final int OP_ACCESS_NOTIFICATIONS = 25;
    public static final int OP_ACTIVATE_VPN = 48;
    public static final int OP_AUDIO_ALARM_VOLUME = 37;
    public static final int OP_AUDIO_BLUETOOTH_VOLUME = 39;
    public static final int OP_AUDIO_MASTER_VOLUME = 33;
    public static final int OP_AUDIO_MEDIA_VOLUME = 36;
    public static final int OP_AUDIO_NOTIFICATION_VOLUME = 38;
    public static final int OP_AUDIO_RING_VOLUME = 35;
    public static final int OP_AUDIO_VOICE_VOLUME = 34;
    public static final int OP_AUTO_RUN = 43;
    public static final int OP_CALL_PHONE = 13;
    public static final int OP_CAMERA = 26;
    public static final int OP_COARSE_LOCATION = 0;
    public static final int OP_FINE_LOCATION = 1;
    public static final int OP_GET_USAGE_STATS = 44;
    public static final int OP_GPS = 2;
    public static final int OP_MONITOR_HIGH_POWER_LOCATION = 42;
    public static final int OP_MONITOR_LOCATION = 41;
    public static final int OP_MUTE_MICROPHONE = 45;
    public static final int OP_NEIGHBORING_CELLS = 12;
    public static final int OP_NONE = -1;
    public static final int OP_PLAY_AUDIO = 28;
    public static final int OP_POST_NOTIFICATION = 11;
    public static final int OP_PROJECT_MEDIA = 47;
    public static final int OP_READ_CALENDAR = 8;
    public static final int OP_READ_CALL_LOG = 6;
    public static final int OP_READ_CLIPBOARD = 29;
    public static final int OP_READ_CONTACTS = 4;
    public static final int OP_READ_ICC_SMS = 21;
    public static final int OP_READ_SMS = 14;
    public static final int OP_RECEIVE_EMERGECY_SMS = 17;
    public static final int OP_RECEIVE_MMS = 18;
    public static final int OP_RECEIVE_SMS = 16;
    public static final int OP_RECEIVE_WAP_PUSH = 19;
    public static final int OP_RECORD_AUDIO = 27;
    public static final int OP_SEND_SMS = 20;
    public static final int OP_SYSTEM_ALERT_WINDOW = 24;
    public static final int OP_TAKE_AUDIO_FOCUS = 32;
    public static final int OP_TAKE_MEDIA_BUTTONS = 31;
    public static final int OP_TOAST_WINDOW = 46;
    public static final int OP_VIBRATE = 3;
    public static final int OP_WAKE_LOCK = 40;
    public static final int OP_WIFI_SCAN = 10;
    public static final int OP_WRITE_CALENDAR = 9;
    public static final int OP_WRITE_CALL_LOG = 7;
    public static final int OP_WRITE_CLIPBOARD = 30;
    public static final int OP_WRITE_CONTACTS = 5;
    public static final int OP_WRITE_ICC_SMS = 22;
    public static final int OP_WRITE_SETTINGS = 23;
    public static final int OP_WRITE_SMS = 15;
    public static final int _NUM_OP = 49;
    private static boolean[] sOpAllowSystemRestrictionBypass;
    private static int[] sOpDefaultMode;
    private static boolean[] sOpDisableReset;
    private static String[] sOpNames;
    private static String[] sOpPerms;
    private static String[] sOpRestrictions;
    private static HashMap<String, Integer> sOpStrToOp;
    private static String[] sOpToString;
    private static int[] sOpToSwitch;
    static IBinder sToken;
    final Context mContext;
    final ArrayMap<OnOpChangedListener, IAppOpsCallback> mModeWatchers = new ArrayMap();
    final IAppOpsService mService;

    static {
        sOpToSwitch = new int[]{0, 0, 0, 3, 4, 5, 6, 7, 8, 9, 0, 11, 0, 13, 14, 15, 16, 16, 16, 16, 20, 14, 15, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 0, 0, 43, 44, 45, 46, 47, 48};
        sOpToString = new String[]{OPSTR_COARSE_LOCATION, OPSTR_FINE_LOCATION, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, OPSTR_MONITOR_LOCATION, OPSTR_MONITOR_HIGH_POWER_LOCATION, null, OPSTR_GET_USAGE_STATS, null, null, null, OPSTR_ACTIVATE_VPN};
        sOpNames = new String[]{"COARSE_LOCATION", "FINE_LOCATION", "GPS", "VIBRATE", "READ_CONTACTS", "WRITE_CONTACTS", "READ_CALL_LOG", "WRITE_CALL_LOG", "READ_CALENDAR", "WRITE_CALENDAR", "WIFI_SCAN", "POST_NOTIFICATION", "NEIGHBORING_CELLS", "CALL_PHONE", "READ_SMS", "WRITE_SMS", "RECEIVE_SMS", "RECEIVE_EMERGECY_SMS", "RECEIVE_MMS", "RECEIVE_WAP_PUSH", "SEND_SMS", "READ_ICC_SMS", "WRITE_ICC_SMS", "WRITE_SETTINGS", "SYSTEM_ALERT_WINDOW", "ACCESS_NOTIFICATIONS", "CAMERA", "RECORD_AUDIO", "PLAY_AUDIO", "READ_CLIPBOARD", "WRITE_CLIPBOARD", "TAKE_MEDIA_BUTTONS", "TAKE_AUDIO_FOCUS", "AUDIO_MASTER_VOLUME", "AUDIO_VOICE_VOLUME", "AUDIO_RING_VOLUME", "AUDIO_MEDIA_VOLUME", "AUDIO_ALARM_VOLUME", "AUDIO_NOTIFICATION_VOLUME", "AUDIO_BLUETOOTH_VOLUME", "WAKE_LOCK", "MONITOR_LOCATION", "MONITOR_HIGH_POWER_LOCATION", "AUTO_RUN", "GET_USAGE_STATS", "MUTE_MICROPHONE", "TOAST_WINDOW", "PROJECT_MEDIA", "ACTIVATE_VPN"};
        sOpPerms = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", null, "android.permission.VIBRATE", "android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS", "android.permission.READ_CALL_LOG", "android.permission.WRITE_CALL_LOG", "android.permission.READ_CALENDAR", "android.permission.WRITE_CALENDAR", "android.permission.ACCESS_WIFI_STATE", null, null, "android.permission.CALL_PHONE", "android.permission.READ_SMS", "android.permission.WRITE_SMS", "android.permission.RECEIVE_SMS", "android.permission.RECEIVE_EMERGENCY_BROADCAST", "android.permission.RECEIVE_MMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.SEND_SMS", "android.permission.READ_SMS", "android.permission.WRITE_SMS", "android.permission.WRITE_SETTINGS", "android.permission.SYSTEM_ALERT_WINDOW", "android.permission.ACCESS_NOTIFICATIONS", "android.permission.CAMERA", "android.permission.RECORD_AUDIO", null, null, null, null, null, null, null, null, null, null, null, null, "android.permission.WAKE_LOCK", null, null, null, "android.permission.PACKAGE_USAGE_STATS", null, null, null, null};
        sOpRestrictions = new String[]{"no_share_location", "no_share_location", "no_share_location", null, null, null, "no_outgoing_calls", "no_outgoing_calls", null, null, "no_share_location", null, null, null, "no_sms", "no_sms", "no_sms", null, "no_sms", null, "no_sms", "no_sms", "no_sms", null, "no_create_windows", null, null, null, null, null, null, null, null, "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", null, "no_share_location", "no_share_location", null, null, "no_unmute_microphone", "no_create_windows", null, "no_config_vpn"};
        sOpAllowSystemRestrictionBypass = new boolean[]{false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true, false, false};
        sOpDefaultMode = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 1, 1};
        sOpDisableReset = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        sOpStrToOp = new HashMap();
        if (sOpToSwitch.length != 49) {
            throw new IllegalStateException("sOpToSwitch length " + sOpToSwitch.length + " should be " + 49);
        }
        if (sOpToString.length != 49) {
            throw new IllegalStateException("sOpToString length " + sOpToString.length + " should be " + 49);
        }
        if (sOpNames.length != 49) {
            throw new IllegalStateException("sOpNames length " + sOpNames.length + " should be " + 49);
        }
        if (sOpPerms.length != 49) {
            throw new IllegalStateException("sOpPerms length " + sOpPerms.length + " should be " + 49);
        }
        if (sOpDefaultMode.length != 49) {
            throw new IllegalStateException("sOpDefaultMode length " + sOpDefaultMode.length + " should be " + 49);
        }
        if (sOpDisableReset.length != 49) {
            throw new IllegalStateException("sOpDisableReset length " + sOpDisableReset.length + " should be " + 49);
        }
        if (sOpRestrictions.length != 49) {
            throw new IllegalStateException("sOpRestrictions length " + sOpRestrictions.length + " should be " + 49);
        }
        if (sOpAllowSystemRestrictionBypass.length != 49) {
            throw new IllegalStateException("sOpAllowSYstemRestrictionsBypass length " + sOpRestrictions.length + " should be " + 49);
        }
        for (int i = 0; i < 49; ++i) {
            if (sOpToString[i] == null) continue;
            sOpStrToOp.put(sOpToString[i], i);
        }
    }

    AppOpsManager(Context context, IAppOpsService iAppOpsService) {
        this.mContext = context;
        this.mService = iAppOpsService;
    }

    private String buildSecurityExceptionMsg(int n, int n2, String string2) {
        return string2 + " from uid " + n2 + " not allowed to perform " + sOpNames[n];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IBinder getToken(IAppOpsService iAppOpsService) {
        synchronized (AppOpsManager.class) {
            if (sToken != null) {
                return sToken;
            }
            try {
                sToken = iAppOpsService.getToken(new Binder());
                return sToken;
            }
            catch (RemoteException remoteException) {}
            return sToken;
        }
    }

    public static boolean opAllowSystemBypassRestriction(int n) {
        return sOpAllowSystemRestrictionBypass[n];
    }

    public static boolean opAllowsReset(int n) {
        return !sOpDisableReset[n];
    }

    public static int opToDefaultMode(int n) {
        return sOpDefaultMode[n];
    }

    public static String opToName(int n) {
        if (n == -1) {
            return "NONE";
        }
        if (n < sOpNames.length) {
            return sOpNames[n];
        }
        return "Unknown(" + n + ")";
    }

    public static String opToPermission(int n) {
        return sOpPerms[n];
    }

    public static String opToRestriction(int n) {
        return sOpRestrictions[n];
    }

    public static int opToSwitch(int n) {
        return sOpToSwitch[n];
    }

    public static int strOpToOp(String string2) {
        Integer n = sOpStrToOp.get(string2);
        if (n == null) {
            throw new IllegalArgumentException("Unknown operation string: " + string2);
        }
        return n;
    }

    public int checkAudioOp(int n, int n2, int n3, String string2) {
        int n4;
        block3: {
            n4 = this.mService.checkAudioOperation(n, n2, n3, string2);
            if (n4 != 2) break block3;
            try {
                throw new SecurityException(this.buildSecurityExceptionMsg(n, n3, string2));
            }
            catch (RemoteException remoteException) {
                n4 = 1;
            }
        }
        return n4;
    }

    public int checkAudioOpNoThrow(int n, int n2, int n3, String string2) {
        try {
            int n4 = this.mService.checkAudioOperation(n, n2, n3, string2);
            return n4;
        }
        catch (RemoteException remoteException) {
            return 1;
        }
    }

    public int checkOp(int n, int n2, String string2) {
        int n3;
        block3: {
            n3 = this.mService.checkOperation(n, n2, string2);
            if (n3 != 2) break block3;
            try {
                throw new SecurityException(this.buildSecurityExceptionMsg(n, n2, string2));
            }
            catch (RemoteException remoteException) {
                n3 = 1;
            }
        }
        return n3;
    }

    public int checkOp(String string2, int n, String string3) {
        return this.checkOp(AppOpsManager.strOpToOp(string2), n, string3);
    }

    public int checkOpNoThrow(int n, int n2, String string2) {
        try {
            int n3 = this.mService.checkOperation(n, n2, string2);
            return n3;
        }
        catch (RemoteException remoteException) {
            return 1;
        }
    }

    public int checkOpNoThrow(String string2, int n, String string3) {
        return this.checkOpNoThrow(AppOpsManager.strOpToOp(string2), n, string3);
    }

    public void checkPackage(int n, String string2) {
        try {
            if (this.mService.checkPackage(n, string2) != 0) {
                throw new SecurityException("Package " + string2 + " does not belong to " + n);
            }
        }
        catch (RemoteException remoteException) {
            throw new SecurityException("Unable to verify package ownership", remoteException);
        }
    }

    public void finishOp(int n) {
        this.finishOp(n, Process.myUid(), this.mContext.getOpPackageName());
    }

    public void finishOp(int n, int n2, String string2) {
        try {
            this.mService.finishOperation(AppOpsManager.getToken(this.mService), n, n2, string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void finishOp(String string2, int n, String string3) {
        this.finishOp(AppOpsManager.strOpToOp(string2), n, string3);
    }

    public List<PackageOps> getOpsForPackage(int n, String string2, int[] nArray) {
        try {
            List<PackageOps> list = this.mService.getOpsForPackage(n, string2, nArray);
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public List<PackageOps> getPackagesForOps(int[] nArray) {
        try {
            List<PackageOps> list = this.mService.getPackagesForOps(nArray);
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int noteOp(int n) {
        return this.noteOp(n, Process.myUid(), this.mContext.getOpPackageName());
    }

    public int noteOp(int n, int n2, String string2) {
        int n3;
        block3: {
            n3 = this.mService.noteOperation(n, n2, string2);
            if (n3 != 2) break block3;
            try {
                throw new SecurityException(this.buildSecurityExceptionMsg(n, n2, string2));
            }
            catch (RemoteException remoteException) {
                n3 = 1;
            }
        }
        return n3;
    }

    public int noteOp(String string2, int n, String string3) {
        return this.noteOp(AppOpsManager.strOpToOp(string2), n, string3);
    }

    public int noteOpNoThrow(int n, int n2, String string2) {
        try {
            int n3 = this.mService.noteOperation(n, n2, string2);
            return n3;
        }
        catch (RemoteException remoteException) {
            return 1;
        }
    }

    public int noteOpNoThrow(String string2, int n, String string3) {
        return this.noteOpNoThrow(AppOpsManager.strOpToOp(string2), n, string3);
    }

    public void resetAllModes() {
        try {
            this.mService.resetAllModes();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setMode(int n, int n2, String string2, int n3) {
        try {
            this.mService.setMode(n, n2, string2, n3);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setRestriction(int n, int n2, int n3, String[] stringArray) {
        try {
            int n4 = Binder.getCallingUid();
            this.mService.setAudioRestriction(n, n2, n4, n3, stringArray);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public int startOp(int n) {
        return this.startOp(n, Process.myUid(), this.mContext.getOpPackageName());
    }

    public int startOp(int n, int n2, String string2) {
        int n3;
        block3: {
            n3 = this.mService.startOperation(AppOpsManager.getToken(this.mService), n, n2, string2);
            if (n3 != 2) break block3;
            try {
                throw new SecurityException(this.buildSecurityExceptionMsg(n, n2, string2));
            }
            catch (RemoteException remoteException) {
                n3 = 1;
            }
        }
        return n3;
    }

    public int startOp(String string2, int n, String string3) {
        return this.startOp(AppOpsManager.strOpToOp(string2), n, string3);
    }

    public int startOpNoThrow(int n, int n2, String string2) {
        try {
            int n3 = this.mService.startOperation(AppOpsManager.getToken(this.mService), n, n2, string2);
            return n3;
        }
        catch (RemoteException remoteException) {
            return 1;
        }
    }

    public int startOpNoThrow(String string2, int n, String string3) {
        return this.startOpNoThrow(AppOpsManager.strOpToOp(string2), n, string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startWatchingMode(int n, String string2, final OnOpChangedListener onOpChangedListener) {
        ArrayMap<OnOpChangedListener, IAppOpsCallback> arrayMap = this.mModeWatchers;
        synchronized (arrayMap) {
            IAppOpsCallback iAppOpsCallback = this.mModeWatchers.get(onOpChangedListener);
            if (iAppOpsCallback == null) {
                iAppOpsCallback = new IAppOpsCallback.Stub(){

                    @Override
                    public void opChanged(int n, String string2) {
                        if (onOpChangedListener instanceof OnOpChangedInternalListener) {
                            ((OnOpChangedInternalListener)onOpChangedListener).onOpChanged(n, string2);
                        }
                        if (sOpToString[n] != null) {
                            onOpChangedListener.onOpChanged(sOpToString[n], string2);
                        }
                    }
                };
                this.mModeWatchers.put(onOpChangedListener, iAppOpsCallback);
            }
            try {
                this.mService.startWatchingMode(n, string2, iAppOpsCallback);
            }
            catch (RemoteException remoteException) {}
            return;
        }
    }

    public void startWatchingMode(String string2, String string3, OnOpChangedListener onOpChangedListener) {
        this.startWatchingMode(AppOpsManager.strOpToOp(string2), string3, onOpChangedListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopWatchingMode(OnOpChangedListener onOpChangedListener) {
        ArrayMap<OnOpChangedListener, IAppOpsCallback> arrayMap = this.mModeWatchers;
        synchronized (arrayMap) {
            IAppOpsCallback iAppOpsCallback = this.mModeWatchers.get(onOpChangedListener);
            if (iAppOpsCallback != null) {
                try {
                    this.mService.stopWatchingMode(iAppOpsCallback);
                }
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    public static class OnOpChangedInternalListener
    implements OnOpChangedListener {
        public void onOpChanged(int n, String string2) {
        }

        @Override
        public void onOpChanged(String string2, String string3) {
        }
    }

    public static interface OnOpChangedListener {
        public void onOpChanged(String var1, String var2);
    }

    public static class OpEntry
    implements Parcelable {
        public static final Parcelable.Creator<OpEntry> CREATOR = new Parcelable.Creator<OpEntry>(){

            @Override
            public OpEntry createFromParcel(Parcel parcel) {
                return new OpEntry(parcel);
            }

            public OpEntry[] newArray(int n) {
                return new OpEntry[n];
            }
        };
        private final int mDuration;
        private final int mMode;
        private final int mOp;
        private final long mRejectTime;
        private final long mTime;

        public OpEntry(int n, int n2, long l, long l2, int n3) {
            this.mOp = n;
            this.mMode = n2;
            this.mTime = l;
            this.mRejectTime = l2;
            this.mDuration = n3;
        }

        OpEntry(Parcel parcel) {
            this.mOp = parcel.readInt();
            this.mMode = parcel.readInt();
            this.mTime = parcel.readLong();
            this.mRejectTime = parcel.readLong();
            this.mDuration = parcel.readInt();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public int getDuration() {
            if (this.mDuration == -1) {
                return (int)(System.currentTimeMillis() - this.mTime);
            }
            return this.mDuration;
        }

        public int getMode() {
            return this.mMode;
        }

        public int getOp() {
            return this.mOp;
        }

        public long getRejectTime() {
            return this.mRejectTime;
        }

        public long getTime() {
            return this.mTime;
        }

        public boolean isRunning() {
            return this.mDuration == -1;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.mOp);
            parcel.writeInt(this.mMode);
            parcel.writeLong(this.mTime);
            parcel.writeLong(this.mRejectTime);
            parcel.writeInt(this.mDuration);
        }
    }

    public static class PackageOps
    implements Parcelable {
        public static final Parcelable.Creator<PackageOps> CREATOR = new Parcelable.Creator<PackageOps>(){

            @Override
            public PackageOps createFromParcel(Parcel parcel) {
                return new PackageOps(parcel);
            }

            public PackageOps[] newArray(int n) {
                return new PackageOps[n];
            }
        };
        private final List<OpEntry> mEntries;
        private final String mPackageName;
        private final int mUid;

        PackageOps(Parcel parcel) {
            this.mPackageName = parcel.readString();
            this.mUid = parcel.readInt();
            this.mEntries = new ArrayList<OpEntry>();
            int n = parcel.readInt();
            for (int i = 0; i < n; ++i) {
                this.mEntries.add(OpEntry.CREATOR.createFromParcel(parcel));
            }
        }

        public PackageOps(String string2, int n, List<OpEntry> list) {
            this.mPackageName = string2;
            this.mUid = n;
            this.mEntries = list;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public List<OpEntry> getOps() {
            return this.mEntries;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public int getUid() {
            return this.mUid;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.mPackageName);
            parcel.writeInt(this.mUid);
            parcel.writeInt(this.mEntries.size());
            for (int i = 0; i < this.mEntries.size(); ++i) {
                this.mEntries.get(i).writeToParcel(parcel, n);
            }
        }
    }
}

