/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.SharedElementCallback;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.transition.Transition;
import android.transition.TransitionSet;
import android.util.ArrayMap;
import android.view.GhostView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

abstract class ActivityTransitionCoordinator
extends ResultReceiver {
    protected static final String KEY_ELEVATION = "shared_element:elevation";
    protected static final String KEY_IMAGE_MATRIX = "shared_element:imageMatrix";
    static final String KEY_REMOTE_RECEIVER = "android:remoteReceiver";
    protected static final String KEY_SCALE_TYPE = "shared_element:scaleType";
    protected static final String KEY_SCREEN_BOTTOM = "shared_element:screenBottom";
    protected static final String KEY_SCREEN_LEFT = "shared_element:screenLeft";
    protected static final String KEY_SCREEN_RIGHT = "shared_element:screenRight";
    protected static final String KEY_SCREEN_TOP = "shared_element:screenTop";
    protected static final String KEY_SNAPSHOT = "shared_element:bitmap";
    protected static final String KEY_TRANSLATION_Z = "shared_element:translationZ";
    public static final int MSG_CANCEL = 106;
    public static final int MSG_EXIT_TRANSITION_COMPLETE = 104;
    public static final int MSG_HIDE_SHARED_ELEMENTS = 101;
    public static final int MSG_SEND_SHARED_ELEMENT_DESTINATION = 108;
    public static final int MSG_SET_REMOTE_RECEIVER = 100;
    public static final int MSG_SHARED_ELEMENT_DESTINATION = 107;
    public static final int MSG_START_EXIT_TRANSITION = 105;
    public static final int MSG_TAKE_SHARED_ELEMENTS = 103;
    protected static final ImageView.ScaleType[] SCALE_TYPE_VALUES = ImageView.ScaleType.values();
    private static final String TAG = "ActivityTransitionCoordinator";
    protected final ArrayList<String> mAllSharedElementNames;
    private final FixedEpicenterCallback mEpicenterCallback;
    private ArrayList<GhostViewListeners> mGhostViewListeners;
    protected final boolean mIsReturning;
    private boolean mIsStartingTransition;
    protected SharedElementCallback mListener;
    private ArrayMap<View, Float> mOriginalAlphas;
    private Runnable mPendingTransition;
    protected ResultReceiver mResultReceiver;
    protected final ArrayList<String> mSharedElementNames;
    protected final ArrayList<View> mSharedElements = new ArrayList();
    protected ArrayList<View> mTransitioningViews;
    private Window mWindow;

    public ActivityTransitionCoordinator(Window window, ArrayList<String> arrayList, SharedElementCallback sharedElementCallback, boolean bl) {
        super(new Handler());
        this.mSharedElementNames = new ArrayList();
        this.mTransitioningViews = new ArrayList();
        this.mEpicenterCallback = new FixedEpicenterCallback();
        this.mGhostViewListeners = new ArrayList();
        this.mOriginalAlphas = new ArrayMap();
        this.mWindow = window;
        this.mListener = sharedElementCallback;
        this.mAllSharedElementNames = arrayList;
        this.mIsReturning = bl;
    }

    static /* synthetic */ boolean access$102(ActivityTransitionCoordinator activityTransitionCoordinator, boolean bl) {
        activityTransitionCoordinator.mIsStartingTransition = bl;
        return bl;
    }

    static /* synthetic */ Runnable access$202(ActivityTransitionCoordinator activityTransitionCoordinator, Runnable runnable) {
        activityTransitionCoordinator.mPendingTransition = runnable;
        return runnable;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static SharedElementOriginalState getOldSharedElementState(View view, String string2, Bundle bundle) {
        ImageView imageView;
        SharedElementOriginalState sharedElementOriginalState;
        block3: {
            block2: {
                Bundle bundle2;
                sharedElementOriginalState = new SharedElementOriginalState();
                sharedElementOriginalState.mLeft = view.getLeft();
                sharedElementOriginalState.mTop = view.getTop();
                sharedElementOriginalState.mRight = view.getRight();
                sharedElementOriginalState.mBottom = view.getBottom();
                sharedElementOriginalState.mMeasuredWidth = view.getMeasuredWidth();
                sharedElementOriginalState.mMeasuredHeight = view.getMeasuredHeight();
                sharedElementOriginalState.mTranslationZ = view.getTranslationZ();
                sharedElementOriginalState.mElevation = view.getElevation();
                if (!(view instanceof ImageView) || (bundle2 = bundle.getBundle(string2)) == null || bundle2.getInt(KEY_SCALE_TYPE, -1) < 0) break block2;
                imageView = (ImageView)view;
                sharedElementOriginalState.mScaleType = imageView.getScaleType();
                if (sharedElementOriginalState.mScaleType == ImageView.ScaleType.MATRIX) break block3;
            }
            return sharedElementOriginalState;
        }
        sharedElementOriginalState.mMatrix = new Matrix(imageView.getImageMatrix());
        return sharedElementOriginalState;
    }

    public static boolean isInTransitionGroup(ViewParent viewParent, ViewGroup viewGroup) {
        if (viewParent == viewGroup || !(viewParent instanceof ViewGroup)) {
            return false;
        }
        ViewGroup viewGroup2 = (ViewGroup)viewParent;
        if (viewGroup2.isTransitionGroup()) {
            return true;
        }
        return ActivityTransitionCoordinator.isInTransitionGroup(viewGroup2.getParent(), viewGroup);
    }

    protected static Transition mergeTransitions(Transition transition2, Transition transition3) {
        if (transition2 == null) {
            return transition3;
        }
        if (transition3 == null) {
            return transition2;
        }
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition(transition2);
        transitionSet.addTransition(transition3);
        return transitionSet;
    }

    private static int scaleTypeToInt(ImageView.ScaleType scaleType) {
        for (int i = 0; i < SCALE_TYPE_VALUES.length; ++i) {
            if (scaleType != SCALE_TYPE_VALUES[i]) continue;
            return i;
        }
        return -1;
    }

    private void setEpicenter(View view) {
        if (view == null) {
            this.mEpicenterCallback.setEpicenter(null);
            return;
        }
        Rect rect = new Rect();
        view.getBoundsOnScreen(rect);
        this.mEpicenterCallback.setEpicenter(rect);
    }

    protected static void setOriginalSharedElementState(ArrayList<View> arrayList, ArrayList<SharedElementOriginalState> arrayList2) {
        for (int i = 0; i < arrayList2.size(); ++i) {
            View view = arrayList.get(i);
            SharedElementOriginalState sharedElementOriginalState = arrayList2.get(i);
            if (view instanceof ImageView && sharedElementOriginalState.mScaleType != null) {
                ImageView imageView = (ImageView)view;
                imageView.setScaleType(sharedElementOriginalState.mScaleType);
                if (sharedElementOriginalState.mScaleType == ImageView.ScaleType.MATRIX) {
                    imageView.setImageMatrix(sharedElementOriginalState.mMatrix);
                }
            }
            view.setElevation(sharedElementOriginalState.mElevation);
            view.setTranslationZ(sharedElementOriginalState.mTranslationZ);
            view.measure(View.MeasureSpec.makeMeasureSpec(sharedElementOriginalState.mMeasuredWidth, 0x40000000), View.MeasureSpec.makeMeasureSpec(sharedElementOriginalState.mMeasuredHeight, 0x40000000));
            view.layout(sharedElementOriginalState.mLeft, sharedElementOriginalState.mTop, sharedElementOriginalState.mRight, sharedElementOriginalState.mBottom);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setSharedElementState(View view, String string2, Bundle bundle, Matrix matrix, RectF rectF, int[] nArray) {
        float f;
        float f2;
        float f3;
        float f4;
        int n;
        Bundle bundle2 = bundle.getBundle(string2);
        if (bundle2 == null) {
            return;
        }
        if (view instanceof ImageView && (n = bundle2.getInt(KEY_SCALE_TYPE, -1)) >= 0) {
            ImageView imageView = (ImageView)view;
            ImageView.ScaleType scaleType = SCALE_TYPE_VALUES[n];
            imageView.setScaleType(scaleType);
            if (scaleType == ImageView.ScaleType.MATRIX) {
                matrix.setValues(bundle2.getFloatArray(KEY_IMAGE_MATRIX));
                imageView.setImageMatrix(matrix);
            }
        }
        view.setTranslationZ(bundle2.getFloat(KEY_TRANSLATION_Z));
        view.setElevation(bundle2.getFloat(KEY_ELEVATION));
        float f5 = bundle2.getFloat(KEY_SCREEN_LEFT);
        float f6 = bundle2.getFloat(KEY_SCREEN_TOP);
        float f7 = bundle2.getFloat(KEY_SCREEN_RIGHT);
        float f8 = bundle2.getFloat(KEY_SCREEN_BOTTOM);
        if (nArray != null) {
            f4 = f5 - (float)nArray[0];
            f3 = f6 - (float)nArray[1];
            f2 = f7 - (float)nArray[0];
            f = f8 - (float)nArray[1];
        } else {
            this.getSharedElementParentMatrix(view, matrix);
            rectF.set(f5, f6, f7, f8);
            matrix.mapRect(rectF);
            float f9 = rectF.left;
            float f10 = rectF.top;
            view.getInverseMatrix().mapRect(rectF);
            float f11 = rectF.width();
            float f12 = rectF.height();
            view.setLeft(0);
            view.setTop(0);
            view.setRight(Math.round(f11));
            view.setBottom(Math.round(f12));
            rectF.set(0.0f, 0.0f, f11, f12);
            view.getMatrix().mapRect(rectF);
            ViewGroup viewGroup = (ViewGroup)view.getParent();
            f4 = f9 - rectF.left + (float)viewGroup.getScrollX();
            f3 = f10 - rectF.top + (float)viewGroup.getScrollY();
            f2 = f4 + f11;
            f = f3 + f12;
        }
        int n2 = Math.round(f4);
        int n3 = Math.round(f3);
        int n4 = Math.round(f2) - n2;
        int n5 = Math.round(f) - n3;
        view.measure(View.MeasureSpec.makeMeasureSpec(n4, 0x40000000), View.MeasureSpec.makeMeasureSpec(n5, 0x40000000));
        view.layout(n2, n3, n2 + n4, n3 + n5);
    }

    private void showView(View view, boolean bl) {
        Float f = this.mOriginalAlphas.remove(view);
        if (f != null) {
            view.setAlpha(f.floatValue());
        }
        if (bl) {
            view.setTransitionAlpha(1.0f);
        }
    }

    protected Bundle captureSharedElementState() {
        Bundle bundle = new Bundle();
        RectF rectF = new RectF();
        Matrix matrix = new Matrix();
        for (int i = 0; i < this.mSharedElements.size(); ++i) {
            this.captureSharedElementState(this.mSharedElements.get(i), this.mSharedElementNames.get(i), bundle, matrix, rectF);
        }
        return bundle;
    }

    protected void captureSharedElementState(View view, String string2, Bundle bundle, Matrix matrix, RectF rectF) {
        Bundle bundle2 = new Bundle();
        matrix.reset();
        view.transformMatrixToGlobal(matrix);
        rectF.set(0.0f, 0.0f, view.getWidth(), view.getHeight());
        matrix.mapRect(rectF);
        bundle2.putFloat(KEY_SCREEN_LEFT, rectF.left);
        bundle2.putFloat(KEY_SCREEN_RIGHT, rectF.right);
        bundle2.putFloat(KEY_SCREEN_TOP, rectF.top);
        bundle2.putFloat(KEY_SCREEN_BOTTOM, rectF.bottom);
        bundle2.putFloat(KEY_TRANSLATION_Z, view.getTranslationZ());
        bundle2.putFloat(KEY_ELEVATION, view.getElevation());
        SharedElementCallback sharedElementCallback = this.mListener;
        Parcelable parcelable = null;
        if (sharedElementCallback != null) {
            parcelable = this.mListener.onCaptureSharedElementSnapshot(view, matrix, rectF);
        }
        if (parcelable != null) {
            bundle2.putParcelable(KEY_SNAPSHOT, parcelable);
        }
        if (view instanceof ImageView) {
            ImageView imageView = (ImageView)view;
            bundle2.putInt(KEY_SCALE_TYPE, ActivityTransitionCoordinator.scaleTypeToInt(imageView.getScaleType()));
            if (imageView.getScaleType() == ImageView.ScaleType.MATRIX) {
                float[] fArray = new float[9];
                imageView.getImageMatrix().getValues(fArray);
                bundle2.putFloatArray(KEY_IMAGE_MATRIX, fArray);
            }
        }
        bundle.putBundle(string2, bundle2);
    }

    protected void clearState() {
        this.mWindow = null;
        this.mSharedElements.clear();
        this.mTransitioningViews = null;
        this.mOriginalAlphas.clear();
        this.mResultReceiver = null;
        this.mPendingTransition = null;
        this.mListener = null;
    }

    protected Transition configureTransition(Transition transition2, boolean bl) {
        if (transition2 != null) {
            Transition transition3 = transition2.clone();
            transition3.setEpicenterCallback(this.mEpicenterCallback);
            transition2 = this.setTargets(transition3, bl);
        }
        return transition2;
    }

    public ArrayList<View> copyMappedViews() {
        return new ArrayList<View>(this.mSharedElements);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ArrayList<View> createSnapshots(Bundle bundle, Collection<String> collection) {
        int n = collection.size();
        if (n == 0) {
            return null;
        }
        ArrayList<View> arrayList = new ArrayList<View>(n);
        Context context = this.getWindow().getContext();
        int[] nArray = new int[2];
        ViewGroup viewGroup = this.getDecor();
        if (viewGroup != null) {
            viewGroup.getLocationOnScreen(nArray);
        }
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            Bundle bundle2 = bundle.getBundle(string2);
            if (bundle2 == null) continue;
            Object t = bundle2.getParcelable(KEY_SNAPSHOT);
            View view = null;
            if (t != null) {
                SharedElementCallback sharedElementCallback = this.mListener;
                view = null;
                if (sharedElementCallback != null) {
                    view = this.mListener.onCreateSnapshotView(context, (Parcelable)t);
                }
            }
            if (view != null) {
                this.setSharedElementState(view, string2, bundle, null, null, nArray);
            }
            arrayList.add(view);
        }
        return arrayList;
    }

    public ArrayList<String> getAcceptedNames() {
        return this.mSharedElementNames;
    }

    public ArrayList<String> getAllSharedElementNames() {
        return this.mAllSharedElementNames;
    }

    public ViewGroup getDecor() {
        if (this.mWindow == null) {
            return null;
        }
        return (ViewGroup)this.mWindow.getDecorView();
    }

    protected long getFadeDuration() {
        return this.getWindow().getTransitionBackgroundFadeDuration();
    }

    public ArrayList<String> getMappedNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.mSharedElements.size());
        for (int i = 0; i < this.mSharedElements.size(); ++i) {
            arrayList.add(this.mSharedElements.get(i).getTransitionName());
        }
        return arrayList;
    }

    protected void getSharedElementParentMatrix(View view, Matrix matrix) {
        ViewGroup viewGroup = (ViewGroup)view.getParent();
        matrix.reset();
        viewGroup.transformMatrixToLocal(matrix);
    }

    protected abstract Transition getViewsTransition();

    protected Window getWindow() {
        return this.mWindow;
    }

    protected void hideViews(ArrayList<View> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            View view = arrayList.get(i);
            if (!this.mOriginalAlphas.containsKey(view)) {
                this.mOriginalAlphas.put(view, Float.valueOf(view.getAlpha()));
            }
            view.setAlpha(0.0f);
        }
    }

    protected ArrayMap<String, View> mapSharedElements(ArrayList<String> arrayList, ArrayList<View> arrayList2) {
        ArrayMap<String, View> arrayMap = new ArrayMap<String, View>();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayMap.put(arrayList.get(i), arrayList2.get(i));
            }
        } else {
            ViewGroup viewGroup = this.getDecor();
            if (viewGroup != null) {
                viewGroup.findNamedViews(arrayMap);
            }
        }
        return arrayMap;
    }

    protected boolean moveSharedElementWithParent() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void moveSharedElementsFromOverlay() {
        ViewGroup viewGroup;
        int n = this.mGhostViewListeners.size();
        for (int i = 0; i < n; ++i) {
            GhostViewListeners ghostViewListeners = this.mGhostViewListeners.get(i);
            ((ViewGroup)ghostViewListeners.getView().getParent()).getViewTreeObserver().removeOnPreDrawListener(ghostViewListeners);
        }
        this.mGhostViewListeners.clear();
        if (this.mWindow != null && this.mWindow.getSharedElementsUseOverlay() && (viewGroup = this.getDecor()) != null) {
            viewGroup.getOverlay();
            int n2 = this.mSharedElements.size();
            for (int i = 0; i < n2; ++i) {
                GhostView.removeGhost(this.mSharedElements.get(i));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void moveSharedElementsToOverlay() {
        if (this.mWindow.getSharedElementsUseOverlay()) {
            int n = this.mSharedElements.size();
            ViewGroup viewGroup = this.getDecor();
            if (viewGroup != null) {
                boolean bl = this.moveSharedElementWithParent();
                for (int i = 0; i < n; ++i) {
                    View view = this.mSharedElements.get(i);
                    GhostView.addGhost(view, viewGroup);
                    ViewGroup viewGroup2 = (ViewGroup)view.getParent();
                    if (!bl || ActivityTransitionCoordinator.isInTransitionGroup(viewGroup2, viewGroup)) continue;
                    GhostViewListeners ghostViewListeners = new GhostViewListeners(view, viewGroup2, viewGroup);
                    viewGroup2.getViewTreeObserver().addOnPreDrawListener(ghostViewListeners);
                    this.mGhostViewListeners.add(ghostViewListeners);
                }
            }
        }
    }

    protected void notifySharedElementEnd(ArrayList<View> arrayList) {
        if (this.mListener != null) {
            this.mListener.onSharedElementEnd(this.mSharedElementNames, this.mSharedElements, arrayList);
        }
    }

    protected void scheduleGhostVisibilityChange(final int n) {
        final ViewGroup viewGroup = this.getDecor();
        if (viewGroup != null) {
            viewGroup.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    viewGroup.getViewTreeObserver().removeOnPreDrawListener(this);
                    ActivityTransitionCoordinator.this.setGhostVisibility(n);
                    return true;
                }
            });
        }
    }

    protected void scheduleSetSharedElementEnd(final ArrayList<View> arrayList) {
        final ViewGroup viewGroup = this.getDecor();
        if (viewGroup != null) {
            viewGroup.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    viewGroup.getViewTreeObserver().removeOnPreDrawListener(this);
                    ActivityTransitionCoordinator.this.notifySharedElementEnd(arrayList);
                    return true;
                }
            });
        }
    }

    protected void setEpicenter() {
        boolean bl = this.mAllSharedElementNames.isEmpty();
        View view = null;
        if (!bl) {
            boolean bl2 = this.mSharedElementNames.isEmpty();
            view = null;
            if (!bl2) {
                int n = this.mSharedElementNames.indexOf(this.mAllSharedElementNames.get(0));
                view = null;
                if (n >= 0) {
                    view = this.mSharedElements.get(n);
                }
            }
        }
        this.setEpicenter(view);
    }

    protected void setGhostVisibility(int n) {
        int n2 = this.mSharedElements.size();
        for (int i = 0; i < n2; ++i) {
            GhostView ghostView = GhostView.getGhost(this.mSharedElements.get(i));
            if (ghostView == null) continue;
            ghostView.setVisibility(n);
        }
    }

    protected void setResultReceiver(ResultReceiver resultReceiver) {
        this.mResultReceiver = resultReceiver;
    }

    protected ArrayList<SharedElementOriginalState> setSharedElementState(Bundle bundle, ArrayList<View> arrayList) {
        ArrayList<SharedElementOriginalState> arrayList2 = new ArrayList<SharedElementOriginalState>();
        if (bundle != null) {
            Matrix matrix = new Matrix();
            RectF rectF = new RectF();
            int n = this.mSharedElements.size();
            for (int i = 0; i < n; ++i) {
                View view = this.mSharedElements.get(i);
                String string2 = this.mSharedElementNames.get(i);
                arrayList2.add(ActivityTransitionCoordinator.getOldSharedElementState(view, string2, bundle));
                this.setSharedElementState(view, string2, bundle, matrix, rectF, null);
            }
        }
        if (this.mListener != null) {
            this.mListener.onSharedElementStart(this.mSharedElementNames, this.mSharedElements, arrayList);
        }
        return arrayList2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Transition setTargets(Transition transition2, boolean bl) {
        if (transition2 == null) return null;
        if (bl) {
            if (this.mTransitioningViews == null) return null;
            if (this.mTransitioningViews.isEmpty()) {
                return null;
            }
        }
        TransitionSet transitionSet = new TransitionSet();
        if (this.mTransitioningViews != null) {
            for (int i = -1 + this.mTransitioningViews.size(); i >= 0; --i) {
                View view = this.mTransitioningViews.get(i);
                if (bl) {
                    transitionSet.addTarget(view);
                    continue;
                }
                transitionSet.excludeTarget(view, true);
            }
        }
        transitionSet.addTransition(transition2);
        if (bl) return transitionSet;
        if (this.mTransitioningViews == null) return transitionSet;
        if (this.mTransitioningViews.isEmpty()) return transitionSet;
        return new TransitionSet().addTransition(transitionSet);
    }

    protected void showViews(ArrayList<View> arrayList, boolean bl) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.showView(arrayList.get(i), bl);
        }
    }

    protected void startTransition(Runnable runnable) {
        if (this.mIsStartingTransition) {
            this.mPendingTransition = runnable;
            return;
        }
        this.mIsStartingTransition = true;
        runnable.run();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void stripOffscreenViews() {
        if (this.mTransitioningViews != null) {
            Rect rect = new Rect();
            for (int i = -1 + this.mTransitioningViews.size(); i >= 0; --i) {
                View view = this.mTransitioningViews.get(i);
                if (view.getGlobalVisibleRect(rect)) continue;
                this.mTransitioningViews.remove(i);
                this.showView(view, true);
            }
        }
    }

    protected void transitionStarted() {
        this.mIsStartingTransition = false;
    }

    protected void viewsReady(ArrayMap<String, View> arrayMap) {
        arrayMap.retainAll(this.mAllSharedElementNames);
        if (this.mListener != null) {
            this.mListener.onMapSharedElements(this.mAllSharedElementNames, arrayMap);
        }
        this.mSharedElementNames.addAll(arrayMap.keySet());
        this.mSharedElements.addAll(arrayMap.values());
        if (this.getViewsTransition() != null && this.mTransitioningViews != null) {
            ViewGroup viewGroup = this.getDecor();
            if (viewGroup != null) {
                viewGroup.captureTransitioningViews(this.mTransitioningViews);
            }
            this.mTransitioningViews.removeAll(this.mSharedElements);
        }
        this.setEpicenter();
    }

    protected class ContinueTransitionListener
    extends Transition.TransitionListenerAdapter {
        protected ContinueTransitionListener() {
        }

        @Override
        public void onTransitionStart(Transition transition2) {
            ActivityTransitionCoordinator.access$102(ActivityTransitionCoordinator.this, false);
            Runnable runnable = ActivityTransitionCoordinator.this.mPendingTransition;
            ActivityTransitionCoordinator.access$202(ActivityTransitionCoordinator.this, null);
            if (runnable != null) {
                ActivityTransitionCoordinator.this.startTransition(runnable);
            }
        }
    }

    private static class FixedEpicenterCallback
    extends Transition.EpicenterCallback {
        private Rect mEpicenter;

        private FixedEpicenterCallback() {
        }

        @Override
        public Rect onGetEpicenter(Transition transition2) {
            return this.mEpicenter;
        }

        public void setEpicenter(Rect rect) {
            this.mEpicenter = rect;
        }
    }

    private static class GhostViewListeners
    implements ViewTreeObserver.OnPreDrawListener {
        private ViewGroup mDecor;
        private Matrix mMatrix = new Matrix();
        private View mParent;
        private View mView;

        public GhostViewListeners(View view, View view2, ViewGroup viewGroup) {
            this.mView = view;
            this.mParent = view2;
            this.mDecor = viewGroup;
        }

        public View getView() {
            return this.mView;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onPreDraw() {
            GhostView ghostView = GhostView.getGhost(this.mView);
            if (ghostView == null) {
                this.mParent.getViewTreeObserver().removeOnPreDrawListener(this);
                return true;
            }
            GhostView.calculateMatrix(this.mView, this.mDecor, this.mMatrix);
            ghostView.setMatrix(this.mMatrix);
            return true;
        }
    }

    static class SharedElementOriginalState {
        int mBottom;
        float mElevation;
        int mLeft;
        Matrix mMatrix;
        int mMeasuredHeight;
        int mMeasuredWidth;
        int mRight;
        ImageView.ScaleType mScaleType;
        int mTop;
        float mTranslationZ;

        SharedElementOriginalState() {
        }
    }
}

