/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ExitTransitionCoordinator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Pair;
import android.view.View;
import java.util.ArrayList;

public class ActivityOptions {
    public static final int ANIM_CUSTOM = 1;
    public static final int ANIM_DEFAULT = 6;
    public static final int ANIM_LAUNCH_TASK_BEHIND = 7;
    public static final int ANIM_NONE = 0;
    public static final int ANIM_SCALE_UP = 2;
    public static final int ANIM_SCENE_TRANSITION = 5;
    public static final int ANIM_THUMBNAIL_ASPECT_SCALE_DOWN = 9;
    public static final int ANIM_THUMBNAIL_ASPECT_SCALE_UP = 8;
    public static final int ANIM_THUMBNAIL_SCALE_DOWN = 4;
    public static final int ANIM_THUMBNAIL_SCALE_UP = 3;
    public static final String KEY_ANIM_ENTER_RES_ID = "android:animEnterRes";
    public static final String KEY_ANIM_EXIT_RES_ID = "android:animExitRes";
    public static final String KEY_ANIM_HEIGHT = "android:animHeight";
    public static final String KEY_ANIM_START_LISTENER = "android:animStartListener";
    public static final String KEY_ANIM_START_X = "android:animStartX";
    public static final String KEY_ANIM_START_Y = "android:animStartY";
    public static final String KEY_ANIM_THUMBNAIL = "android:animThumbnail";
    public static final String KEY_ANIM_TYPE = "android:animType";
    public static final String KEY_ANIM_WIDTH = "android:animWidth";
    private static final String KEY_EXIT_COORDINATOR_INDEX = "android:exitCoordinatorIndex";
    public static final String KEY_PACKAGE_NAME = "android:packageName";
    private static final String KEY_RESULT_CODE = "android:resultCode";
    private static final String KEY_RESULT_DATA = "android:resultData";
    private static final String KEY_TRANSITION_COMPLETE_LISTENER = "android:transitionCompleteListener";
    private static final String KEY_TRANSITION_IS_RETURNING = "android:transitionIsReturning";
    private static final String KEY_TRANSITION_SHARED_ELEMENTS = "android:sharedElementNames";
    private static final String TAG = "ActivityOptions";
    private IRemoteCallback mAnimationStartedListener;
    private int mAnimationType = 0;
    private int mCustomEnterResId;
    private int mCustomExitResId;
    private int mExitCoordinatorIndex;
    private int mHeight;
    private boolean mIsReturning;
    private String mPackageName;
    private int mResultCode;
    private Intent mResultData;
    private ArrayList<String> mSharedElementNames;
    private int mStartX;
    private int mStartY;
    private Bitmap mThumbnail;
    private ResultReceiver mTransitionReceiver;
    private int mWidth;

    private ActivityOptions() {
    }

    public ActivityOptions(Bundle bundle) {
        this.mPackageName = bundle.getString(KEY_PACKAGE_NAME);
        this.mAnimationType = bundle.getInt(KEY_ANIM_TYPE);
        switch (this.mAnimationType) {
            default: {
                return;
            }
            case 1: {
                this.mCustomEnterResId = bundle.getInt(KEY_ANIM_ENTER_RES_ID, 0);
                this.mCustomExitResId = bundle.getInt(KEY_ANIM_EXIT_RES_ID, 0);
                this.mAnimationStartedListener = IRemoteCallback.Stub.asInterface(bundle.getBinder(KEY_ANIM_START_LISTENER));
                return;
            }
            case 2: {
                this.mStartX = bundle.getInt(KEY_ANIM_START_X, 0);
                this.mStartY = bundle.getInt(KEY_ANIM_START_Y, 0);
                this.mWidth = bundle.getInt(KEY_ANIM_WIDTH, 0);
                this.mHeight = bundle.getInt(KEY_ANIM_HEIGHT, 0);
                return;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                this.mThumbnail = (Bitmap)bundle.getParcelable(KEY_ANIM_THUMBNAIL);
                this.mStartX = bundle.getInt(KEY_ANIM_START_X, 0);
                this.mStartY = bundle.getInt(KEY_ANIM_START_Y, 0);
                this.mWidth = bundle.getInt(KEY_ANIM_WIDTH, 0);
                this.mHeight = bundle.getInt(KEY_ANIM_HEIGHT, 0);
                this.mAnimationStartedListener = IRemoteCallback.Stub.asInterface(bundle.getBinder(KEY_ANIM_START_LISTENER));
                return;
            }
            case 5: 
        }
        this.mTransitionReceiver = (ResultReceiver)bundle.getParcelable(KEY_TRANSITION_COMPLETE_LISTENER);
        this.mIsReturning = bundle.getBoolean(KEY_TRANSITION_IS_RETURNING, false);
        this.mSharedElementNames = bundle.getStringArrayList(KEY_TRANSITION_SHARED_ELEMENTS);
        this.mResultData = (Intent)bundle.getParcelable(KEY_RESULT_DATA);
        this.mResultCode = bundle.getInt(KEY_RESULT_CODE);
        this.mExitCoordinatorIndex = bundle.getInt(KEY_EXIT_COORDINATOR_INDEX);
    }

    public static void abort(Bundle bundle) {
        if (bundle != null) {
            new ActivityOptions(bundle).abort();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ActivityOptions makeAspectScaledThumbnailAnimation(View view, Bitmap bitmap, int n, int n2, int n3, int n4, OnAnimationStartedListener onAnimationStartedListener, boolean bl) {
        ActivityOptions activityOptions = new ActivityOptions();
        activityOptions.mPackageName = view.getContext().getPackageName();
        int n5 = bl ? 8 : 9;
        activityOptions.mAnimationType = n5;
        activityOptions.mThumbnail = bitmap;
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        activityOptions.mStartX = n + nArray[0];
        activityOptions.mStartY = n2 + nArray[1];
        activityOptions.mWidth = n3;
        activityOptions.mHeight = n4;
        activityOptions.setOnAnimationStartedListener(view.getHandler(), onAnimationStartedListener);
        return activityOptions;
    }

    public static ActivityOptions makeCustomAnimation(Context context, int n, int n2) {
        return ActivityOptions.makeCustomAnimation(context, n, n2, null, null);
    }

    public static ActivityOptions makeCustomAnimation(Context context, int n, int n2, Handler handler, OnAnimationStartedListener onAnimationStartedListener) {
        ActivityOptions activityOptions = new ActivityOptions();
        activityOptions.mPackageName = context.getPackageName();
        activityOptions.mAnimationType = 1;
        activityOptions.mCustomEnterResId = n;
        activityOptions.mCustomExitResId = n2;
        activityOptions.setOnAnimationStartedListener(handler, onAnimationStartedListener);
        return activityOptions;
    }

    public static ActivityOptions makeScaleUpAnimation(View view, int n, int n2, int n3, int n4) {
        ActivityOptions activityOptions = new ActivityOptions();
        activityOptions.mPackageName = view.getContext().getPackageName();
        activityOptions.mAnimationType = 2;
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        activityOptions.mStartX = n + nArray[0];
        activityOptions.mStartY = n2 + nArray[1];
        activityOptions.mWidth = n3;
        activityOptions.mHeight = n4;
        return activityOptions;
    }

    public static ActivityOptions makeSceneTransitionAnimation(Activity activity, ExitTransitionCoordinator exitTransitionCoordinator, ArrayList<String> arrayList, int n, Intent intent) {
        ActivityOptions activityOptions = new ActivityOptions();
        activityOptions.mAnimationType = 5;
        activityOptions.mSharedElementNames = arrayList;
        activityOptions.mTransitionReceiver = exitTransitionCoordinator;
        activityOptions.mIsReturning = true;
        activityOptions.mResultCode = n;
        activityOptions.mResultData = intent;
        activityOptions.mExitCoordinatorIndex = activity.mActivityTransitionState.addExitTransitionCoordinator(exitTransitionCoordinator);
        return activityOptions;
    }

    public static ActivityOptions makeSceneTransitionAnimation(Activity activity, View view, String string2) {
        Pair[] pairArray = new Pair[]{Pair.create(view, string2)};
        return ActivityOptions.makeSceneTransitionAnimation(activity, pairArray);
    }

    public static ActivityOptions makeSceneTransitionAnimation(Activity activity, Pair<View, String> ... pairArray) {
        ActivityOptions activityOptions = new ActivityOptions();
        if (!activity.getWindow().hasFeature(13)) {
            activityOptions.mAnimationType = 6;
            return activityOptions;
        }
        activityOptions.mAnimationType = 5;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<View> arrayList2 = new ArrayList<View>();
        if (pairArray != null) {
            for (int i = 0; i < pairArray.length; ++i) {
                Pair<View, String> pair = pairArray[i];
                String string2 = (String)pair.second;
                if (string2 == null) {
                    throw new IllegalArgumentException("Shared element name must not be null");
                }
                arrayList.add(string2);
                if ((View)pair.first == null) {
                    throw new IllegalArgumentException("Shared element must not be null");
                }
                arrayList2.add((View)pair.first);
            }
        }
        ExitTransitionCoordinator exitTransitionCoordinator = new ExitTransitionCoordinator(activity, arrayList, arrayList, arrayList2, false);
        activityOptions.mTransitionReceiver = exitTransitionCoordinator;
        activityOptions.mSharedElementNames = arrayList;
        activityOptions.mIsReturning = false;
        activityOptions.mExitCoordinatorIndex = activity.mActivityTransitionState.addExitTransitionCoordinator(exitTransitionCoordinator);
        return activityOptions;
    }

    public static ActivityOptions makeTaskLaunchBehind() {
        ActivityOptions activityOptions = new ActivityOptions();
        activityOptions.mAnimationType = 7;
        return activityOptions;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ActivityOptions makeThumbnailAnimation(View view, Bitmap bitmap, int n, int n2, OnAnimationStartedListener onAnimationStartedListener, boolean bl) {
        ActivityOptions activityOptions = new ActivityOptions();
        activityOptions.mPackageName = view.getContext().getPackageName();
        int n3 = bl ? 3 : 4;
        activityOptions.mAnimationType = n3;
        activityOptions.mThumbnail = bitmap;
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        activityOptions.mStartX = n + nArray[0];
        activityOptions.mStartY = n2 + nArray[1];
        activityOptions.setOnAnimationStartedListener(view.getHandler(), onAnimationStartedListener);
        return activityOptions;
    }

    public static ActivityOptions makeThumbnailAspectScaleDownAnimation(View view, Bitmap bitmap, int n, int n2, int n3, int n4, OnAnimationStartedListener onAnimationStartedListener) {
        return ActivityOptions.makeAspectScaledThumbnailAnimation(view, bitmap, n, n2, n3, n4, onAnimationStartedListener, false);
    }

    public static ActivityOptions makeThumbnailAspectScaleUpAnimation(View view, Bitmap bitmap, int n, int n2, int n3, int n4, OnAnimationStartedListener onAnimationStartedListener) {
        return ActivityOptions.makeAspectScaledThumbnailAnimation(view, bitmap, n, n2, n3, n4, onAnimationStartedListener, true);
    }

    public static ActivityOptions makeThumbnailScaleDownAnimation(View view, Bitmap bitmap, int n, int n2, OnAnimationStartedListener onAnimationStartedListener) {
        return ActivityOptions.makeThumbnailAnimation(view, bitmap, n, n2, onAnimationStartedListener, false);
    }

    public static ActivityOptions makeThumbnailScaleUpAnimation(View view, Bitmap bitmap, int n, int n2) {
        return ActivityOptions.makeThumbnailScaleUpAnimation(view, bitmap, n, n2, null);
    }

    public static ActivityOptions makeThumbnailScaleUpAnimation(View view, Bitmap bitmap, int n, int n2, OnAnimationStartedListener onAnimationStartedListener) {
        return ActivityOptions.makeThumbnailAnimation(view, bitmap, n, n2, onAnimationStartedListener, true);
    }

    private void setOnAnimationStartedListener(final Handler handler, final OnAnimationStartedListener onAnimationStartedListener) {
        if (onAnimationStartedListener != null) {
            this.mAnimationStartedListener = new IRemoteCallback.Stub(){

                @Override
                public void sendResult(Bundle bundle) throws RemoteException {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            onAnimationStartedListener.onAnimationStarted();
                        }
                    });
                }
            };
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void abort() {
        if (this.mAnimationStartedListener == null) return;
        try {
            this.mAnimationStartedListener.sendResult(null);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public ActivityOptions forTargetActivity() {
        if (this.mAnimationType == 5) {
            ActivityOptions activityOptions = new ActivityOptions();
            activityOptions.update(this);
            return activityOptions;
        }
        return null;
    }

    public int getAnimationType() {
        return this.mAnimationType;
    }

    public int getCustomEnterResId() {
        return this.mCustomEnterResId;
    }

    public int getCustomExitResId() {
        return this.mCustomExitResId;
    }

    public int getExitCoordinatorKey() {
        return this.mExitCoordinatorIndex;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public boolean getLaunchTaskBehind() {
        return this.mAnimationType == 7;
    }

    public IRemoteCallback getOnAnimationStartListener() {
        return this.mAnimationStartedListener;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public int getResultCode() {
        return this.mResultCode;
    }

    public Intent getResultData() {
        return this.mResultData;
    }

    public ResultReceiver getResultReceiver() {
        return this.mTransitionReceiver;
    }

    public ArrayList<String> getSharedElementNames() {
        return this.mSharedElementNames;
    }

    public int getStartX() {
        return this.mStartX;
    }

    public int getStartY() {
        return this.mStartY;
    }

    public Bitmap getThumbnail() {
        return this.mThumbnail;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public boolean isReturning() {
        return this.mIsReturning;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Bundle toBundle() {
        if (this.mAnimationType == 6) {
            return null;
        }
        Bundle bundle = new Bundle();
        if (this.mPackageName != null) {
            bundle.putString(KEY_PACKAGE_NAME, this.mPackageName);
        }
        bundle.putInt(KEY_ANIM_TYPE, this.mAnimationType);
        switch (this.mAnimationType) {
            case 1: {
                bundle.putInt(KEY_ANIM_ENTER_RES_ID, this.mCustomEnterResId);
                bundle.putInt(KEY_ANIM_EXIT_RES_ID, this.mCustomExitResId);
                IRemoteCallback iRemoteCallback = this.mAnimationStartedListener;
                IBinder iBinder = null;
                if (iRemoteCallback != null) {
                    iBinder = this.mAnimationStartedListener.asBinder();
                }
                bundle.putBinder(KEY_ANIM_START_LISTENER, iBinder);
                return bundle;
            }
            case 2: {
                bundle.putInt(KEY_ANIM_START_X, this.mStartX);
                bundle.putInt(KEY_ANIM_START_Y, this.mStartY);
                bundle.putInt(KEY_ANIM_WIDTH, this.mWidth);
                bundle.putInt(KEY_ANIM_HEIGHT, this.mHeight);
                return bundle;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                bundle.putParcelable(KEY_ANIM_THUMBNAIL, this.mThumbnail);
                bundle.putInt(KEY_ANIM_START_X, this.mStartX);
                bundle.putInt(KEY_ANIM_START_Y, this.mStartY);
                bundle.putInt(KEY_ANIM_WIDTH, this.mWidth);
                bundle.putInt(KEY_ANIM_HEIGHT, this.mHeight);
                IRemoteCallback iRemoteCallback = this.mAnimationStartedListener;
                IBinder iBinder = null;
                if (iRemoteCallback != null) {
                    iBinder = this.mAnimationStartedListener.asBinder();
                }
                bundle.putBinder(KEY_ANIM_START_LISTENER, iBinder);
                return bundle;
            }
            case 5: {
                if (this.mTransitionReceiver != null) {
                    bundle.putParcelable(KEY_TRANSITION_COMPLETE_LISTENER, this.mTransitionReceiver);
                }
                bundle.putBoolean(KEY_TRANSITION_IS_RETURNING, this.mIsReturning);
                bundle.putStringArrayList(KEY_TRANSITION_SHARED_ELEMENTS, this.mSharedElementNames);
                bundle.putParcelable(KEY_RESULT_DATA, this.mResultData);
                bundle.putInt(KEY_RESULT_CODE, this.mResultCode);
                bundle.putInt(KEY_EXIT_COORDINATOR_INDEX, this.mExitCoordinatorIndex);
                return bundle;
            }
        }
        return bundle;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(ActivityOptions activityOptions) {
        block13: {
            block14: {
                block15: {
                    if (activityOptions.mPackageName != null) {
                        this.mPackageName = activityOptions.mPackageName;
                    }
                    this.mTransitionReceiver = null;
                    this.mSharedElementNames = null;
                    this.mIsReturning = false;
                    this.mResultData = null;
                    this.mResultCode = 0;
                    this.mExitCoordinatorIndex = 0;
                    this.mAnimationType = activityOptions.mAnimationType;
                    switch (activityOptions.mAnimationType) {
                        default: {
                            return;
                        }
                        case 1: {
                            this.mCustomEnterResId = activityOptions.mCustomEnterResId;
                            this.mCustomExitResId = activityOptions.mCustomExitResId;
                            this.mThumbnail = null;
                            if (this.mAnimationStartedListener == null) break block13;
                            this.mAnimationStartedListener.sendResult(null);
                            break block13;
                        }
                        case 2: {
                            this.mStartX = activityOptions.mStartX;
                            this.mStartY = activityOptions.mStartY;
                            this.mWidth = activityOptions.mWidth;
                            this.mHeight = activityOptions.mHeight;
                            if (this.mAnimationStartedListener == null) break block14;
                            this.mAnimationStartedListener.sendResult(null);
                            break block14;
                        }
                        case 3: 
                        case 4: 
                        case 8: 
                        case 9: {
                            this.mThumbnail = activityOptions.mThumbnail;
                            this.mStartX = activityOptions.mStartX;
                            this.mStartY = activityOptions.mStartY;
                            this.mWidth = activityOptions.mWidth;
                            this.mHeight = activityOptions.mHeight;
                            if (this.mAnimationStartedListener == null) break block15;
                            this.mAnimationStartedListener.sendResult(null);
                            break block15;
                        }
                        case 5: {
                            this.mTransitionReceiver = activityOptions.mTransitionReceiver;
                            this.mSharedElementNames = activityOptions.mSharedElementNames;
                            this.mIsReturning = activityOptions.mIsReturning;
                            this.mThumbnail = null;
                            this.mAnimationStartedListener = null;
                            this.mResultData = activityOptions.mResultData;
                            this.mResultCode = activityOptions.mResultCode;
                            this.mExitCoordinatorIndex = activityOptions.mExitCoordinatorIndex;
                            return;
                        }
                    }
                    catch (RemoteException remoteException) {}
                }
                this.mAnimationStartedListener = activityOptions.mAnimationStartedListener;
                return;
                catch (RemoteException remoteException) {}
            }
            this.mAnimationStartedListener = null;
            return;
            catch (RemoteException remoteException) {}
        }
        this.mAnimationStartedListener = activityOptions.mAnimationStartedListener;
    }

    public static interface OnAnimationStartedListener {
        public void onAnimationStarted();
    }
}

