/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.IAppTask;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Size;
import android.util.Slog;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.FastPrintWriter;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class ActivityManager {
    public static final int BROADCAST_STICKY_CANT_HAVE_PERMISSION = -1;
    public static final int BROADCAST_SUCCESS = 0;
    public static final int COMPAT_MODE_ALWAYS = -1;
    public static final int COMPAT_MODE_DISABLED = 0;
    public static final int COMPAT_MODE_ENABLED = 1;
    public static final int COMPAT_MODE_NEVER = -2;
    public static final int COMPAT_MODE_TOGGLE = 2;
    public static final int COMPAT_MODE_UNKNOWN = -3;
    public static final int INTENT_SENDER_ACTIVITY = 2;
    public static final int INTENT_SENDER_ACTIVITY_RESULT = 3;
    public static final int INTENT_SENDER_BROADCAST = 1;
    public static final int INTENT_SENDER_SERVICE = 4;
    public static final String META_HOME_ALTERNATE = "android.app.home.alternate";
    public static final int MOVE_TASK_NO_USER_ACTION = 2;
    public static final int MOVE_TASK_WITH_HOME = 1;
    public static final int PROCESS_STATE_BACKUP = 5;
    public static final int PROCESS_STATE_CACHED_ACTIVITY = 11;
    public static final int PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 12;
    public static final int PROCESS_STATE_CACHED_EMPTY = 13;
    public static final int PROCESS_STATE_HEAVY_WEIGHT = 6;
    public static final int PROCESS_STATE_HOME = 9;
    public static final int PROCESS_STATE_IMPORTANT_BACKGROUND = 4;
    public static final int PROCESS_STATE_IMPORTANT_FOREGROUND = 3;
    public static final int PROCESS_STATE_LAST_ACTIVITY = 10;
    public static final int PROCESS_STATE_PERSISTENT = 0;
    public static final int PROCESS_STATE_PERSISTENT_UI = 1;
    public static final int PROCESS_STATE_RECEIVER = 8;
    public static final int PROCESS_STATE_SERVICE = 7;
    public static final int PROCESS_STATE_TOP = 2;
    public static final int RECENT_IGNORE_HOME_STACK_TASKS = 8;
    public static final int RECENT_IGNORE_UNAVAILABLE = 2;
    public static final int RECENT_INCLUDE_PROFILES = 4;
    public static final int RECENT_WITH_EXCLUDED = 1;
    public static final int REMOVE_TASK_KILL_PROCESS = 1;
    public static final int START_CANCELED = -6;
    public static final int START_CLASS_NOT_FOUND = -2;
    public static final int START_DELIVERED_TO_TOP = 3;
    public static final int START_FLAG_DEBUG = 2;
    public static final int START_FLAG_ONLY_IF_NEEDED = 1;
    public static final int START_FLAG_OPENGL_TRACES = 4;
    public static final int START_FORWARD_AND_REQUEST_CONFLICT = -3;
    public static final int START_INTENT_NOT_RESOLVED = -1;
    public static final int START_NOT_ACTIVITY = -5;
    public static final int START_NOT_VOICE_COMPATIBLE = -7;
    public static final int START_PERMISSION_DENIED = -4;
    public static final int START_RETURN_INTENT_TO_CALLER = 1;
    public static final int START_RETURN_LOCK_TASK_MODE_VIOLATION = 5;
    public static final int START_SUCCESS = 0;
    public static final int START_SWITCHES_CANCELED = 4;
    public static final int START_TASK_TO_FRONT = 2;
    private static String TAG = "ActivityManager";
    public static final int USER_OP_IS_CURRENT = -2;
    public static final int USER_OP_SUCCESS = 0;
    public static final int USER_OP_UNKNOWN_USER = -1;
    public static int gIsOneGigaByteDevice;
    private static int gMaxRecentTasks;
    private static boolean localLOGV;
    Point mAppTaskThumbnailSize;
    private final Context mContext;
    private final Handler mHandler;

    static {
        localLOGV = false;
        gMaxRecentTasks = -1;
        gIsOneGigaByteDevice = -1;
    }

    ActivityManager(Context context, Handler handler) {
        this.mContext = context;
        this.mHandler = handler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkComponentPermission(String string2, int n, int n2, boolean bl) {
        int n3 = -1;
        if (n == 0) return 0;
        if (n == 1000) {
            return 0;
        }
        if (UserHandle.isIsolated(n)) return n3;
        if (n2 >= 0 && UserHandle.isSameApp(n, n2)) {
            return 0;
        }
        if (!bl) return n3;
        if (string2 == null) {
            return 0;
        }
        try {
            return AppGlobals.getPackageManager().checkUidPermission(string2, n);
        }
        catch (RemoteException remoteException) {
            Slog.e(TAG, "PackageManager is dead?!?", remoteException);
            return n3;
        }
    }

    public static int checkUidPermission(String string2, int n) {
        try {
            int n2 = AppGlobals.getPackageManager().checkUidPermission(string2, n);
            return n2;
        }
        catch (RemoteException remoteException) {
            Slog.e(TAG, "PackageManager is dead?!?", remoteException);
            return -1;
        }
    }

    public static void dumpPackageStateStatic(FileDescriptor fileDescriptor, String string2) {
        FastPrintWriter fastPrintWriter = new FastPrintWriter(new FileOutputStream(fileDescriptor));
        ActivityManager.dumpService(fastPrintWriter, fileDescriptor, "package", new String[]{string2});
        ((PrintWriter)fastPrintWriter).println();
        ActivityManager.dumpService(fastPrintWriter, fileDescriptor, "activity", new String[]{"-a", "package", string2});
        ((PrintWriter)fastPrintWriter).println();
        ActivityManager.dumpService(fastPrintWriter, fileDescriptor, "meminfo", new String[]{"--local", "--package", string2});
        ((PrintWriter)fastPrintWriter).println();
        ActivityManager.dumpService(fastPrintWriter, fileDescriptor, "procstats", new String[]{string2});
        ((PrintWriter)fastPrintWriter).println();
        ActivityManager.dumpService(fastPrintWriter, fileDescriptor, "usagestats", new String[]{"--packages", string2});
        ((PrintWriter)fastPrintWriter).println();
        ActivityManager.dumpService(fastPrintWriter, fileDescriptor, "batterystats", new String[]{string2});
        ((PrintWriter)fastPrintWriter).flush();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void dumpService(PrintWriter printWriter, FileDescriptor fileDescriptor, String string2, String[] stringArray) {
        TransferPipe transferPipe;
        printWriter.print("DUMP OF SERVICE ");
        printWriter.print(string2);
        printWriter.println(":");
        IBinder iBinder = ServiceManager.checkService(string2);
        if (iBinder == null) {
            printWriter.println("  (Service not found)");
            return;
        }
        TransferPipe transferPipe2 = null;
        try {
            printWriter.flush();
            transferPipe = new TransferPipe();
        }
        catch (Throwable throwable) {}
        try {
            transferPipe.setBufferPrefix("  ");
            iBinder.dumpAsync(transferPipe.getWriteFd().getFileDescriptor(), stringArray);
            transferPipe.go(fileDescriptor, 10000L);
            return;
        }
        catch (Throwable throwable) {
            transferPipe2 = transferPipe;
        }
        {
            void var6_8;
            if (transferPipe2 != null) {
                transferPipe2.kill();
            }
            printWriter.println("Failure dumping service:");
            var6_8.printStackTrace(printWriter);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureAppTaskThumbnailSizeLocked() {
        if (this.mAppTaskThumbnailSize != null) return;
        try {
            this.mAppTaskThumbnailSize = ActivityManagerNative.getDefault().getAppTaskThumbnailSize();
            return;
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException("System dead?", remoteException);
        }
    }

    public static int getCurrentUser() {
        int n;
        block3: {
            UserInfo userInfo;
            try {
                userInfo = ActivityManagerNative.getDefault().getCurrentUser();
                n = 0;
                if (userInfo == null) break block3;
            }
            catch (RemoteException remoteException) {
                return 0;
            }
            n = userInfo.id;
        }
        return n;
    }

    public static int getDefaultAppRecentsLimitStatic() {
        return ActivityManager.getMaxRecentTasksStatic() / 6;
    }

    static int getLauncherLargeIconSizeInner(Context context) {
        Resources resources = context.getResources();
        int n = resources.getDimensionPixelSize(0x1050000);
        if (resources.getConfiguration().smallestScreenWidthDp < 600) {
            return n;
        }
        switch (resources.getDisplayMetrics().densityDpi) {
            default: {
                return (int)(0.5f + 1.5f * (float)n);
            }
            case 120: {
                return n * 160 / 120;
            }
            case 160: {
                return n * 240 / 160;
            }
            case 213: {
                return n * 320 / 240;
            }
            case 240: {
                return n * 320 / 240;
            }
            case 320: {
                return n * 480 / 320;
            }
            case 480: 
        }
        return 2 * (n * 320) / 480;
    }

    public static int getMaxAppRecentsLimitStatic() {
        return ActivityManager.getMaxRecentTasksStatic() / 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getMaxRecentTasksStatic() {
        if (gMaxRecentTasks >= 0) {
            return gMaxRecentTasks;
        }
        int n = ActivityManager.isLowRamDeviceStatic() || ActivityManager.isOneGigaByteDevice() ? 50 : 100;
        gMaxRecentTasks = n;
        return n;
    }

    public static void getMyMemoryState(RunningAppProcessInfo runningAppProcessInfo) {
        try {
            ActivityManagerNative.getDefault().getMyMemoryState(runningAppProcessInfo);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static int handleIncomingUser(int n, int n2, int n3, boolean bl, boolean bl2, String string2, String string3) {
        if (UserHandle.getUserId(n2) == n3) {
            return n3;
        }
        try {
            int n4 = ActivityManagerNative.getDefault().handleIncomingUser(n, n2, n3, bl, bl2, string2, string3);
            return n4;
        }
        catch (RemoteException remoteException) {
            throw new SecurityException("Failed calling activity manager", remoteException);
        }
    }

    public static boolean isHighEndGfx() {
        return !ActivityManager.isLowRamDeviceStatic() && !Resources.getSystem().getBoolean(17956885);
    }

    public static boolean isLowRamDeviceStatic() {
        return "true".equals(SystemProperties.get("ro.config.low_ram", "false"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOneGigaByteDevice() {
        block4: {
            block3: {
                if (!Build.FEATURES.SAVE_MORE_RAM_ON_1G_DEVICE || gIsOneGigaByteDevice >= 0) break block3;
                if (Process.getTotalMemory() >= 0x40000000L) break block4;
                Slog.i(TAG, "1G Ram Device.");
                gIsOneGigaByteDevice = 1;
            }
            return gIsOneGigaByteDevice == 1;
        }
        gIsOneGigaByteDevice = 0;
        return gIsOneGigaByteDevice == 1;
    }

    public static boolean isRunningInTestHarness() {
        return SystemProperties.getBoolean("ro.test_harness", false);
    }

    public static boolean isUserAMonkey() {
        try {
            boolean bl = ActivityManagerNative.getDefault().isUserAMonkey();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public static int staticGetLargeMemoryClass() {
        String string2 = SystemProperties.get("dalvik.vm.heapsize", "16m");
        return Integer.parseInt(string2.substring(0, -1 + string2.length()));
    }

    public static int staticGetMemoryClass() {
        String string2 = SystemProperties.get("dalvik.vm.heapgrowthlimit", "");
        if (string2 != null && !"".equals(string2)) {
            return Integer.parseInt(string2.substring(0, -1 + string2.length()));
        }
        return ActivityManager.staticGetLargeMemoryClass();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addAppTask(Activity activity, Intent intent, TaskDescription taskDescription, Bitmap bitmap) {
        Point point;
        synchronized (this) {
            this.ensureAppTaskThumbnailSizeLocked();
            point = this.mAppTaskThumbnailSize;
        }
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        if (n != point.x || n2 != point.y) {
            float f;
            float f2;
            Bitmap bitmap2 = Bitmap.createBitmap(point.x, point.y, bitmap.getConfig());
            if (n * point.x > n2 * point.y) {
                f2 = (float)point.x / (float)n2;
                f = 0.5f * ((float)point.y - f2 * (float)n);
            } else {
                f2 = (float)point.y / (float)n;
                float cfr_ignored_0 = 0.5f * ((float)point.x - f2 * (float)n2);
                f = 0.0f;
            }
            Matrix matrix = new Matrix();
            matrix.setScale(f2, f2);
            matrix.postTranslate((int)(0.5f + f), 0.0f);
            Canvas canvas = new Canvas(bitmap2);
            canvas.drawBitmap(bitmap, matrix, null);
            canvas.setBitmap(null);
            bitmap = bitmap2;
        }
        if (taskDescription == null) {
            taskDescription = new TaskDescription();
        }
        try {
            return ActivityManagerNative.getDefault().addAppTask(activity.getActivityToken(), intent, taskDescription, bitmap);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException("System dead?", remoteException);
        }
    }

    public boolean clearApplicationUserData() {
        return this.clearApplicationUserData(this.mContext.getPackageName(), null);
    }

    public boolean clearApplicationUserData(String string2, IPackageDataObserver iPackageDataObserver) {
        try {
            boolean bl = ActivityManagerNative.getDefault().clearApplicationUserData(string2, iPackageDataObserver, UserHandle.myUserId());
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void dumpPackageState(FileDescriptor fileDescriptor, String string2) {
        ActivityManager.dumpPackageStateStatic(fileDescriptor, string2);
    }

    public void forceStopPackage(String string2) {
        this.forceStopPackageAsUser(string2, UserHandle.myUserId());
    }

    public void forceStopPackageAsUser(String string2, int n) {
        try {
            ActivityManagerNative.getDefault().forceStopPackage(string2, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Size getAppTaskThumbnailSize() {
        synchronized (this) {
            this.ensureAppTaskThumbnailSizeLocked();
            return new Size(this.mAppTaskThumbnailSize.x, this.mAppTaskThumbnailSize.y);
        }
    }

    public List<AppTask> getAppTasks() {
        int n;
        List<IAppTask> list;
        ArrayList<AppTask> arrayList = new ArrayList<AppTask>();
        try {
            list = ActivityManagerNative.getDefault().getAppTasks(this.mContext.getPackageName());
            n = list.size();
        }
        catch (RemoteException remoteException) {
            arrayList = null;
        }
        for (int i = 0; i < n; ++i) {
            arrayList.add(new AppTask(list.get(i)));
        }
        return arrayList;
    }

    public ConfigurationInfo getDeviceConfigurationInfo() {
        try {
            ConfigurationInfo configurationInfo = ActivityManagerNative.getDefault().getDeviceConfigurationInfo();
            return configurationInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int getFrontActivityScreenCompatMode() {
        try {
            int n = ActivityManagerNative.getDefault().getFrontActivityScreenCompatMode();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public int getLargeMemoryClass() {
        return ActivityManager.staticGetLargeMemoryClass();
    }

    public int getLauncherLargeIconDensity() {
        Resources resources = this.mContext.getResources();
        int n = resources.getDisplayMetrics().densityDpi;
        if (resources.getConfiguration().smallestScreenWidthDp < 600) {
            return n;
        }
        switch (n) {
            default: {
                return (int)(0.5f + 1.5f * (float)n);
            }
            case 120: {
                return 160;
            }
            case 160: {
                return 240;
            }
            case 213: {
                return 320;
            }
            case 240: {
                return 320;
            }
            case 320: {
                return 480;
            }
            case 480: 
        }
        return 640;
    }

    public int getLauncherLargeIconSize() {
        return ActivityManager.getLauncherLargeIconSizeInner(this.mContext);
    }

    public int getMemoryClass() {
        return ActivityManager.staticGetMemoryClass();
    }

    public void getMemoryInfo(MemoryInfo memoryInfo) {
        try {
            ActivityManagerNative.getDefault().getMemoryInfo(memoryInfo);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean getPackageAskScreenCompat(String string2) {
        try {
            boolean bl = ActivityManagerNative.getDefault().getPackageAskScreenCompat(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public int getPackageScreenCompatMode(String string2) {
        try {
            int n = ActivityManagerNative.getDefault().getPackageScreenCompatMode(string2);
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] nArray) {
        try {
            Debug.MemoryInfo[] memoryInfoArray = ActivityManagerNative.getDefault().getProcessMemoryInfo(nArray);
            return memoryInfoArray;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public List<ProcessErrorStateInfo> getProcessesInErrorState() {
        try {
            List<ProcessErrorStateInfo> list = ActivityManagerNative.getDefault().getProcessesInErrorState();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Deprecated
    public List<RecentTaskInfo> getRecentTasks(int n, int n2) throws SecurityException {
        try {
            List<RecentTaskInfo> list = ActivityManagerNative.getDefault().getRecentTasks(n, n2, UserHandle.myUserId());
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public List<RecentTaskInfo> getRecentTasksForUser(int n, int n2, int n3) throws SecurityException {
        try {
            List<RecentTaskInfo> list = ActivityManagerNative.getDefault().getRecentTasks(n, n2, n3);
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public List<RunningAppProcessInfo> getRunningAppProcesses() {
        try {
            List<RunningAppProcessInfo> list = ActivityManagerNative.getDefault().getRunningAppProcesses();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public List<ApplicationInfo> getRunningExternalApplications() {
        try {
            List<ApplicationInfo> list = ActivityManagerNative.getDefault().getRunningExternalApplications();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public PendingIntent getRunningServiceControlPanel(ComponentName componentName) throws SecurityException {
        try {
            PendingIntent pendingIntent = ActivityManagerNative.getDefault().getRunningServiceControlPanel(componentName);
            return pendingIntent;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public List<RunningServiceInfo> getRunningServices(int n) throws SecurityException {
        try {
            List<RunningServiceInfo> list = ActivityManagerNative.getDefault().getServices(n, 0);
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Deprecated
    public List<RunningTaskInfo> getRunningTasks(int n) throws SecurityException {
        try {
            List<RunningTaskInfo> list = ActivityManagerNative.getDefault().getTasks(n, 0);
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public TaskThumbnail getTaskThumbnail(int n) throws SecurityException {
        try {
            TaskThumbnail taskThumbnail = ActivityManagerNative.getDefault().getTaskThumbnail(n);
            return taskThumbnail;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public boolean isInHomeStack(int n) {
        try {
            boolean bl = ActivityManagerNative.getDefault().isInHomeStack(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isInLockTaskMode() {
        try {
            boolean bl = ActivityManagerNative.getDefault().isInLockTaskMode();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isLowRamDevice() {
        return ActivityManager.isLowRamDeviceStatic();
    }

    public boolean isUserRunning(int n) {
        try {
            boolean bl = ActivityManagerNative.getDefault().isUserRunning(n, false);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void killBackgroundProcesses(String string2) {
        try {
            ActivityManagerNative.getDefault().killBackgroundProcesses(string2, UserHandle.myUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void moveTaskToFront(int n, int n2) {
        this.moveTaskToFront(n, n2, null);
    }

    public void moveTaskToFront(int n, int n2, Bundle bundle) {
        try {
            ActivityManagerNative.getDefault().moveTaskToFront(n, n2, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean removeTask(int n, int n2) throws SecurityException {
        try {
            boolean bl = ActivityManagerNative.getDefault().removeTask(n, n2);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Deprecated
    public void restartPackage(String string2) {
        this.killBackgroundProcesses(string2);
    }

    public void setFrontActivityScreenCompatMode(int n) {
        try {
            ActivityManagerNative.getDefault().setFrontActivityScreenCompatMode(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setPackageAskScreenCompat(String string2, boolean bl) {
        try {
            ActivityManagerNative.getDefault().setPackageAskScreenCompat(string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setPackageScreenCompatMode(String string2, int n) {
        try {
            ActivityManagerNative.getDefault().setPackageScreenCompatMode(string2, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void startLockTaskMode(int n) {
        try {
            ActivityManagerNative.getDefault().startLockTaskMode(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void stopLockTaskMode() {
        try {
            ActivityManagerNative.getDefault().stopLockTaskMode();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean switchUser(int n) {
        try {
            boolean bl = ActivityManagerNative.getDefault().switchUser(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public static class AppTask {
        private IAppTask mAppTaskImpl;

        public AppTask(IAppTask iAppTask) {
            this.mAppTaskImpl = iAppTask;
        }

        public void finishAndRemoveTask() {
            try {
                this.mAppTaskImpl.finishAndRemoveTask();
                return;
            }
            catch (RemoteException remoteException) {
                Slog.e(TAG, "Invalid AppTask", remoteException);
                return;
            }
        }

        public RecentTaskInfo getTaskInfo() {
            try {
                RecentTaskInfo recentTaskInfo = this.mAppTaskImpl.getTaskInfo();
                return recentTaskInfo;
            }
            catch (RemoteException remoteException) {
                Slog.e(TAG, "Invalid AppTask", remoteException);
                return null;
            }
        }

        public void moveToFront() {
            try {
                this.mAppTaskImpl.moveToFront();
                return;
            }
            catch (RemoteException remoteException) {
                Slog.e(TAG, "Invalid AppTask", remoteException);
                return;
            }
        }

        public void setExcludeFromRecents(boolean bl) {
            try {
                this.mAppTaskImpl.setExcludeFromRecents(bl);
                return;
            }
            catch (RemoteException remoteException) {
                Slog.e(TAG, "Invalid AppTask", remoteException);
                return;
            }
        }

        public void startActivity(Context context, Intent intent, Bundle bundle) {
            ActivityThread activityThread = ActivityThread.currentActivityThread();
            activityThread.getInstrumentation().execStartActivityFromAppTask(context, activityThread.getApplicationThread(), this.mAppTaskImpl, intent, bundle);
        }
    }

    public static class MemoryInfo
    implements Parcelable {
        public static final Parcelable.Creator<MemoryInfo> CREATOR = new Parcelable.Creator<MemoryInfo>(){

            @Override
            public MemoryInfo createFromParcel(Parcel parcel) {
                return new MemoryInfo(parcel);
            }

            public MemoryInfo[] newArray(int n) {
                return new MemoryInfo[n];
            }
        };
        public long availMem;
        public long foregroundAppThreshold;
        public long hiddenAppThreshold;
        public boolean lowMemory;
        public long secondaryServerThreshold;
        public long threshold;
        public long totalMem;
        public long visibleAppThreshold;

        public MemoryInfo() {
        }

        private MemoryInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readFromParcel(Parcel parcel) {
            this.availMem = parcel.readLong();
            this.totalMem = parcel.readLong();
            this.threshold = parcel.readLong();
            boolean bl = parcel.readInt() != 0;
            this.lowMemory = bl;
            this.hiddenAppThreshold = parcel.readLong();
            this.secondaryServerThreshold = parcel.readLong();
            this.visibleAppThreshold = parcel.readLong();
            this.foregroundAppThreshold = parcel.readLong();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeLong(this.availMem);
            parcel.writeLong(this.totalMem);
            parcel.writeLong(this.threshold);
            int n2 = this.lowMemory ? 1 : 0;
            parcel.writeInt(n2);
            parcel.writeLong(this.hiddenAppThreshold);
            parcel.writeLong(this.secondaryServerThreshold);
            parcel.writeLong(this.visibleAppThreshold);
            parcel.writeLong(this.foregroundAppThreshold);
        }
    }

    public static class ProcessErrorStateInfo
    implements Parcelable {
        public static final int CRASHED = 1;
        public static final Parcelable.Creator<ProcessErrorStateInfo> CREATOR = new Parcelable.Creator<ProcessErrorStateInfo>(){

            @Override
            public ProcessErrorStateInfo createFromParcel(Parcel parcel) {
                return new ProcessErrorStateInfo(parcel);
            }

            public ProcessErrorStateInfo[] newArray(int n) {
                return new ProcessErrorStateInfo[n];
            }
        };
        public static final int NOT_RESPONDING = 2;
        public static final int NO_ERROR;
        public int condition;
        public byte[] crashData = null;
        public String longMsg;
        public int pid;
        public String processName;
        public String shortMsg;
        public String stackTrace;
        public String tag;
        public int uid;

        public ProcessErrorStateInfo() {
        }

        private ProcessErrorStateInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public void readFromParcel(Parcel parcel) {
            this.condition = parcel.readInt();
            this.processName = parcel.readString();
            this.pid = parcel.readInt();
            this.uid = parcel.readInt();
            this.tag = parcel.readString();
            this.shortMsg = parcel.readString();
            this.longMsg = parcel.readString();
            this.stackTrace = parcel.readString();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.condition);
            parcel.writeString(this.processName);
            parcel.writeInt(this.pid);
            parcel.writeInt(this.uid);
            parcel.writeString(this.tag);
            parcel.writeString(this.shortMsg);
            parcel.writeString(this.longMsg);
            parcel.writeString(this.stackTrace);
        }
    }

    public static class RecentTaskInfo
    implements Parcelable {
        public static final Parcelable.Creator<RecentTaskInfo> CREATOR = new Parcelable.Creator<RecentTaskInfo>(){

            @Override
            public RecentTaskInfo createFromParcel(Parcel parcel) {
                return new RecentTaskInfo(parcel);
            }

            public RecentTaskInfo[] newArray(int n) {
                return new RecentTaskInfo[n];
            }
        };
        public int affiliatedTaskColor;
        public int affiliatedTaskId;
        public Intent baseIntent;
        public CharSequence description;
        public long firstActiveTime;
        public int id;
        public long lastActiveTime;
        public ComponentName origActivity;
        public int persistentId;
        public int stackId;
        public TaskDescription taskDescription;
        public int userId;

        public RecentTaskInfo() {
        }

        private RecentTaskInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readFromParcel(Parcel parcel) {
            this.id = parcel.readInt();
            this.persistentId = parcel.readInt();
            Intent intent = parcel.readInt() > 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
            this.baseIntent = intent;
            this.origActivity = ComponentName.readFromParcel(parcel);
            this.description = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            TaskDescription taskDescription = parcel.readInt() > 0 ? TaskDescription.CREATOR.createFromParcel(parcel) : null;
            this.taskDescription = taskDescription;
            this.stackId = parcel.readInt();
            this.userId = parcel.readInt();
            this.firstActiveTime = parcel.readLong();
            this.lastActiveTime = parcel.readLong();
            this.affiliatedTaskId = parcel.readInt();
            this.affiliatedTaskColor = parcel.readInt();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.id);
            parcel.writeInt(this.persistentId);
            if (this.baseIntent != null) {
                parcel.writeInt(1);
                this.baseIntent.writeToParcel(parcel, 0);
            } else {
                parcel.writeInt(0);
            }
            ComponentName.writeToParcel(this.origActivity, parcel);
            TextUtils.writeToParcel(this.description, parcel, 1);
            if (this.taskDescription != null) {
                parcel.writeInt(1);
                this.taskDescription.writeToParcel(parcel, 0);
            } else {
                parcel.writeInt(0);
            }
            parcel.writeInt(this.stackId);
            parcel.writeInt(this.userId);
            parcel.writeLong(this.firstActiveTime);
            parcel.writeLong(this.lastActiveTime);
            parcel.writeInt(this.affiliatedTaskId);
            parcel.writeInt(this.affiliatedTaskColor);
        }
    }

    public static class RunningAppProcessInfo
    implements Parcelable {
        public static final Parcelable.Creator<RunningAppProcessInfo> CREATOR = new Parcelable.Creator<RunningAppProcessInfo>(){

            @Override
            public RunningAppProcessInfo createFromParcel(Parcel parcel) {
                return new RunningAppProcessInfo(parcel);
            }

            public RunningAppProcessInfo[] newArray(int n) {
                return new RunningAppProcessInfo[n];
            }
        };
        public static final int FLAG_CANT_SAVE_STATE = 1;
        public static final int FLAG_HAS_ACTIVITIES = 4;
        public static final int FLAG_PERSISTENT = 2;
        public static final int IMPORTANCE_BACKGROUND = 400;
        public static final int IMPORTANCE_CANT_SAVE_STATE = 170;
        public static final int IMPORTANCE_EMPTY = 500;
        public static final int IMPORTANCE_FOREGROUND = 100;
        public static final int IMPORTANCE_GONE = 1000;
        public static final int IMPORTANCE_PERCEPTIBLE = 130;
        public static final int IMPORTANCE_SERVICE = 300;
        public static final int IMPORTANCE_VISIBLE = 200;
        public static final int REASON_PROVIDER_IN_USE = 1;
        public static final int REASON_SERVICE_IN_USE = 2;
        public static final int REASON_UNKNOWN;
        public int flags;
        public int importance;
        public int importanceReasonCode;
        public ComponentName importanceReasonComponent;
        public int importanceReasonImportance;
        public int importanceReasonPid;
        public int lastTrimLevel;
        public int lru;
        public int pid;
        public String[] pkgList;
        public String processName;
        public int processState;
        public int uid;

        public RunningAppProcessInfo() {
            this.importance = 100;
            this.importanceReasonCode = 0;
            this.processState = 3;
        }

        private RunningAppProcessInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        public RunningAppProcessInfo(String string2, int n, String[] stringArray) {
            this.processName = string2;
            this.pid = n;
            this.pkgList = stringArray;
        }

        public static int procStateToImportance(int n) {
            if (n >= 9) {
                return 400;
            }
            if (n >= 7) {
                return 300;
            }
            if (n > 6) {
                return 170;
            }
            if (n >= 4) {
                return 130;
            }
            if (n >= 3) {
                return 200;
            }
            return 100;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public void readFromParcel(Parcel parcel) {
            this.processName = parcel.readString();
            this.pid = parcel.readInt();
            this.uid = parcel.readInt();
            this.pkgList = parcel.readStringArray();
            this.flags = parcel.readInt();
            this.lastTrimLevel = parcel.readInt();
            this.importance = parcel.readInt();
            this.lru = parcel.readInt();
            this.importanceReasonCode = parcel.readInt();
            this.importanceReasonPid = parcel.readInt();
            this.importanceReasonComponent = ComponentName.readFromParcel(parcel);
            this.importanceReasonImportance = parcel.readInt();
            this.processState = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.processName);
            parcel.writeInt(this.pid);
            parcel.writeInt(this.uid);
            parcel.writeStringArray(this.pkgList);
            parcel.writeInt(this.flags);
            parcel.writeInt(this.lastTrimLevel);
            parcel.writeInt(this.importance);
            parcel.writeInt(this.lru);
            parcel.writeInt(this.importanceReasonCode);
            parcel.writeInt(this.importanceReasonPid);
            ComponentName.writeToParcel(this.importanceReasonComponent, parcel);
            parcel.writeInt(this.importanceReasonImportance);
            parcel.writeInt(this.processState);
        }
    }

    public static class RunningServiceInfo
    implements Parcelable {
        public static final Parcelable.Creator<RunningServiceInfo> CREATOR = new Parcelable.Creator<RunningServiceInfo>(){

            @Override
            public RunningServiceInfo createFromParcel(Parcel parcel) {
                return new RunningServiceInfo(parcel);
            }

            public RunningServiceInfo[] newArray(int n) {
                return new RunningServiceInfo[n];
            }
        };
        public static final int FLAG_FOREGROUND = 2;
        public static final int FLAG_PERSISTENT_PROCESS = 8;
        public static final int FLAG_STARTED = 1;
        public static final int FLAG_SYSTEM_PROCESS = 4;
        public long activeSince;
        public int clientCount;
        public int clientLabel;
        public String clientPackage;
        public int crashCount;
        public int flags;
        public boolean foreground;
        public long lastActivityTime;
        public int pid;
        public String process;
        public long restarting;
        public ComponentName service;
        public boolean started;
        public int uid;

        public RunningServiceInfo() {
        }

        private RunningServiceInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readFromParcel(Parcel parcel) {
            boolean bl = true;
            this.service = ComponentName.readFromParcel(parcel);
            this.pid = parcel.readInt();
            this.uid = parcel.readInt();
            this.process = parcel.readString();
            boolean bl2 = parcel.readInt() != 0 ? bl : false;
            this.foreground = bl2;
            this.activeSince = parcel.readLong();
            if (parcel.readInt() == 0) {
                bl = false;
            }
            this.started = bl;
            this.clientCount = parcel.readInt();
            this.crashCount = parcel.readInt();
            this.lastActivityTime = parcel.readLong();
            this.restarting = parcel.readLong();
            this.flags = parcel.readInt();
            this.clientPackage = parcel.readString();
            this.clientLabel = parcel.readInt();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = 1;
            ComponentName.writeToParcel(this.service, parcel);
            parcel.writeInt(this.pid);
            parcel.writeInt(this.uid);
            parcel.writeString(this.process);
            int n3 = this.foreground ? n2 : 0;
            parcel.writeInt(n3);
            parcel.writeLong(this.activeSince);
            if (!this.started) {
                n2 = 0;
            }
            parcel.writeInt(n2);
            parcel.writeInt(this.clientCount);
            parcel.writeInt(this.crashCount);
            parcel.writeLong(this.lastActivityTime);
            parcel.writeLong(this.restarting);
            parcel.writeInt(this.flags);
            parcel.writeString(this.clientPackage);
            parcel.writeInt(this.clientLabel);
        }
    }

    public static class RunningTaskInfo
    implements Parcelable {
        public static final Parcelable.Creator<RunningTaskInfo> CREATOR = new Parcelable.Creator<RunningTaskInfo>(){

            @Override
            public RunningTaskInfo createFromParcel(Parcel parcel) {
                return new RunningTaskInfo(parcel);
            }

            public RunningTaskInfo[] newArray(int n) {
                return new RunningTaskInfo[n];
            }
        };
        public ComponentName baseActivity;
        public CharSequence description;
        public int id;
        public long lastActiveTime;
        public int numActivities;
        public int numRunning;
        public Bitmap thumbnail;
        public ComponentName topActivity;

        public RunningTaskInfo() {
        }

        private RunningTaskInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readFromParcel(Parcel parcel) {
            this.id = parcel.readInt();
            this.baseActivity = ComponentName.readFromParcel(parcel);
            this.topActivity = ComponentName.readFromParcel(parcel);
            this.thumbnail = parcel.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(parcel) : null;
            this.description = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            this.numActivities = parcel.readInt();
            this.numRunning = parcel.readInt();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.id);
            ComponentName.writeToParcel(this.baseActivity, parcel);
            ComponentName.writeToParcel(this.topActivity, parcel);
            if (this.thumbnail != null) {
                parcel.writeInt(1);
                this.thumbnail.writeToParcel(parcel, 0);
            } else {
                parcel.writeInt(0);
            }
            TextUtils.writeToParcel(this.description, parcel, 1);
            parcel.writeInt(this.numActivities);
            parcel.writeInt(this.numRunning);
        }
    }

    public static class StackInfo
    implements Parcelable {
        public static final Parcelable.Creator<StackInfo> CREATOR = new Parcelable.Creator<StackInfo>(){

            @Override
            public StackInfo createFromParcel(Parcel parcel) {
                return new StackInfo(parcel);
            }

            public StackInfo[] newArray(int n) {
                return new StackInfo[n];
            }
        };
        public Rect bounds = new Rect();
        public int displayId;
        public int stackId;
        public int[] taskIds;
        public String[] taskNames;

        public StackInfo() {
        }

        private StackInfo(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public void readFromParcel(Parcel parcel) {
            this.stackId = parcel.readInt();
            this.bounds = new Rect(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
            this.taskIds = parcel.createIntArray();
            this.taskNames = parcel.createStringArray();
            this.displayId = parcel.readInt();
        }

        public String toString() {
            return this.toString("");
        }

        public String toString(String string2) {
            StringBuilder stringBuilder = new StringBuilder(256);
            stringBuilder.append(string2);
            stringBuilder.append("Stack id=");
            stringBuilder.append(this.stackId);
            stringBuilder.append(" bounds=");
            stringBuilder.append(this.bounds.toShortString());
            stringBuilder.append(" displayId=");
            stringBuilder.append(this.displayId);
            stringBuilder.append("\n");
            String string3 = string2 + "  ";
            for (int i = 0; i < this.taskIds.length; ++i) {
                stringBuilder.append(string3);
                stringBuilder.append("taskId=");
                stringBuilder.append(this.taskIds[i]);
                stringBuilder.append(": ");
                stringBuilder.append(this.taskNames[i]);
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.stackId);
            parcel.writeInt(this.bounds.left);
            parcel.writeInt(this.bounds.top);
            parcel.writeInt(this.bounds.right);
            parcel.writeInt(this.bounds.bottom);
            parcel.writeIntArray(this.taskIds);
            parcel.writeStringArray(this.taskNames);
            parcel.writeInt(this.displayId);
        }
    }

    public static class TaskDescription
    implements Parcelable {
        private static final String ATTR_TASKDESCRIPTIONCOLOR = "task_description_color";
        private static final String ATTR_TASKDESCRIPTIONICONFILENAME = "task_description_icon_filename";
        private static final String ATTR_TASKDESCRIPTIONLABEL = "task_description_label";
        public static final String ATTR_TASKDESCRIPTION_PREFIX = "task_description_";
        public static final Parcelable.Creator<TaskDescription> CREATOR = new Parcelable.Creator<TaskDescription>(){

            @Override
            public TaskDescription createFromParcel(Parcel parcel) {
                return new TaskDescription(parcel);
            }

            public TaskDescription[] newArray(int n) {
                return new TaskDescription[n];
            }
        };
        private int mColorPrimary;
        private Bitmap mIcon;
        private String mIconFilename;
        private String mLabel;

        public TaskDescription() {
            this(null, null, 0);
        }

        public TaskDescription(TaskDescription taskDescription) {
            this.mLabel = taskDescription.mLabel;
            this.mIcon = taskDescription.mIcon;
            this.mColorPrimary = taskDescription.mColorPrimary;
            this.mIconFilename = taskDescription.mIconFilename;
        }

        private TaskDescription(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        public TaskDescription(String string2) {
            this(string2, null, 0);
        }

        public TaskDescription(String string2, int n, String string3) {
            this(string2, null, n);
            this.mIconFilename = string3;
        }

        public TaskDescription(String string2, Bitmap bitmap) {
            this(string2, bitmap, 0);
        }

        public TaskDescription(String string2, Bitmap bitmap, int n) {
            if (n != 0 && Color.alpha(n) != 255) {
                throw new RuntimeException("A TaskDescription's primary color should be opaque");
            }
            this.mLabel = string2;
            this.mIcon = bitmap;
            this.mColorPrimary = n;
        }

        public static Bitmap loadTaskDescriptionIcon(String string2) {
            if (string2 != null) {
                try {
                    Bitmap bitmap = ActivityManagerNative.getDefault().getTaskDescriptionIcon(string2);
                    return bitmap;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public Bitmap getIcon() {
            if (this.mIcon != null) {
                return this.mIcon;
            }
            return TaskDescription.loadTaskDescriptionIcon(this.mIconFilename);
        }

        public String getIconFilename() {
            return this.mIconFilename;
        }

        public Bitmap getInMemoryIcon() {
            return this.mIcon;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public int getPrimaryColor() {
            return this.mColorPrimary;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readFromParcel(Parcel parcel) {
            String string2 = parcel.readInt() > 0 ? parcel.readString() : null;
            this.mLabel = string2;
            Bitmap bitmap = parcel.readInt() > 0 ? Bitmap.CREATOR.createFromParcel(parcel) : null;
            this.mIcon = bitmap;
            this.mColorPrimary = parcel.readInt();
            int n = parcel.readInt();
            String string3 = null;
            if (n > 0) {
                string3 = parcel.readString();
            }
            this.mIconFilename = string3;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void restoreFromXml(String string2, String string3) {
            if (ATTR_TASKDESCRIPTIONLABEL.equals(string2)) {
                this.setLabel(string3);
                return;
            } else {
                if (ATTR_TASKDESCRIPTIONCOLOR.equals(string2)) {
                    this.setPrimaryColor((int)Long.parseLong(string3, 16));
                    return;
                }
                if (!ATTR_TASKDESCRIPTIONICONFILENAME.equals(string2)) return;
                this.setIconFilename(string3);
                return;
            }
        }

        public void saveToXml(XmlSerializer xmlSerializer) throws IOException {
            if (this.mLabel != null) {
                xmlSerializer.attribute(null, ATTR_TASKDESCRIPTIONLABEL, this.mLabel);
            }
            if (this.mColorPrimary != 0) {
                xmlSerializer.attribute(null, ATTR_TASKDESCRIPTIONCOLOR, Integer.toHexString(this.mColorPrimary));
            }
            if (this.mIconFilename != null) {
                xmlSerializer.attribute(null, ATTR_TASKDESCRIPTIONICONFILENAME, this.mIconFilename);
            }
        }

        public void setIcon(Bitmap bitmap) {
            this.mIcon = bitmap;
        }

        public void setIconFilename(String string2) {
            this.mIconFilename = string2;
            this.mIcon = null;
        }

        public void setLabel(String string2) {
            this.mLabel = string2;
        }

        public void setPrimaryColor(int n) {
            if (n != 0 && Color.alpha(n) != 255) {
                throw new RuntimeException("A TaskDescription's primary color should be opaque");
            }
            this.mColorPrimary = n;
        }

        public String toString() {
            return "TaskDescription Label: " + this.mLabel + " Icon: " + this.mIcon + " colorPrimary: " + this.mColorPrimary;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            if (this.mLabel == null) {
                parcel.writeInt(0);
            } else {
                parcel.writeInt(1);
                parcel.writeString(this.mLabel);
            }
            if (this.mIcon == null) {
                parcel.writeInt(0);
            } else {
                parcel.writeInt(1);
                this.mIcon.writeToParcel(parcel, 0);
            }
            parcel.writeInt(this.mColorPrimary);
            if (this.mIconFilename == null) {
                parcel.writeInt(0);
                return;
            }
            parcel.writeInt(1);
            parcel.writeString(this.mIconFilename);
        }
    }

    public static class TaskThumbnail
    implements Parcelable {
        public static final Parcelable.Creator<TaskThumbnail> CREATOR = new Parcelable.Creator<TaskThumbnail>(){

            @Override
            public TaskThumbnail createFromParcel(Parcel parcel) {
                return new TaskThumbnail(parcel);
            }

            public TaskThumbnail[] newArray(int n) {
                return new TaskThumbnail[n];
            }
        };
        public Bitmap mainThumbnail;
        public ParcelFileDescriptor thumbnailFileDescriptor;

        public TaskThumbnail() {
        }

        private TaskThumbnail(Parcel parcel) {
            this.readFromParcel(parcel);
        }

        @Override
        public int describeContents() {
            if (this.thumbnailFileDescriptor != null) {
                return this.thumbnailFileDescriptor.describeContents();
            }
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void readFromParcel(Parcel parcel) {
            this.mainThumbnail = parcel.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(parcel) : null;
            if (parcel.readInt() != 0) {
                this.thumbnailFileDescriptor = ParcelFileDescriptor.CREATOR.createFromParcel(parcel);
                return;
            }
            this.thumbnailFileDescriptor = null;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            if (this.mainThumbnail != null) {
                parcel.writeInt(1);
                this.mainThumbnail.writeToParcel(parcel, n);
            } else {
                parcel.writeInt(0);
            }
            if (this.thumbnailFileDescriptor != null) {
                parcel.writeInt(1);
                this.thumbnailFileDescriptor.writeToParcel(parcel, n);
                return;
            }
            parcel.writeInt(0);
        }
    }
}

