/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.util.StateSet;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class StateListAnimator {
    private AnimatorListenerAdapter mAnimatorListener;
    private Tuple mLastMatch = null;
    private Animator mRunningAnimator = null;
    private final ArrayList<Tuple> mTuples = new ArrayList();
    private WeakReference<View> mViewRef;

    public StateListAnimator() {
        this.mAnimatorListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                animator2.setTarget(null);
                if (StateListAnimator.this.mRunningAnimator == animator2) {
                    StateListAnimator.access$002(StateListAnimator.this, null);
                }
            }
        };
    }

    static /* synthetic */ Animator access$002(StateListAnimator stateListAnimator, Animator animator2) {
        stateListAnimator.mRunningAnimator = animator2;
        return animator2;
    }

    private void cancel() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.cancel();
            this.mRunningAnimator = null;
        }
    }

    private void clearTarget() {
        int n = this.mTuples.size();
        for (int i = 0; i < n; ++i) {
            this.mTuples.get((int)i).mAnimator.setTarget(null);
        }
        this.mViewRef = null;
        this.mLastMatch = null;
        this.mRunningAnimator = null;
    }

    private void start(Tuple tuple) {
        tuple.mAnimator.setTarget(this.getTarget());
        this.mRunningAnimator = tuple.mAnimator;
        this.mRunningAnimator.start();
    }

    public void addState(int[] nArray, Animator animator2) {
        Tuple tuple = new Tuple(nArray, animator2);
        tuple.mAnimator.addListener(this.mAnimatorListener);
        this.mTuples.add(tuple);
    }

    public Animator getRunningAnimator() {
        return this.mRunningAnimator;
    }

    public View getTarget() {
        if (this.mViewRef == null) {
            return null;
        }
        return (View)this.mViewRef.get();
    }

    public ArrayList<Tuple> getTuples() {
        return this.mTuples;
    }

    public void jumpToCurrentState() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.end();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setState(int[] nArray) {
        Tuple tuple;
        int n = this.mTuples.size();
        int n2 = 0;
        while (true) {
            block8: {
                block7: {
                    tuple = null;
                    if (n2 >= n) break block7;
                    Tuple tuple2 = this.mTuples.get(n2);
                    if (!StateSet.stateSetMatches(tuple2.mSpecs, nArray)) break block8;
                    tuple = tuple2;
                }
                if (tuple != this.mLastMatch) break;
                return;
            }
            ++n2;
        }
        if (this.mLastMatch != null) {
            this.cancel();
        }
        this.mLastMatch = tuple;
        if (tuple == null) {
            return;
        }
        this.start(tuple);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTarget(View view) {
        block5: {
            block4: {
                View view2 = this.getTarget();
                if (view2 == view) break block4;
                if (view2 != null) {
                    this.clearTarget();
                }
                if (view != null) break block5;
            }
            return;
        }
        this.mViewRef = new WeakReference<View>(view);
    }

    public static class Tuple {
        final Animator mAnimator;
        final int[] mSpecs;

        private Tuple(int[] nArray, Animator animator2) {
            this.mSpecs = nArray;
            this.mAnimator = animator2;
        }

        public Animator getAnimator() {
            return this.mAnimator;
        }

        public int[] getSpecs() {
            return this.mSpecs;
        }
    }
}

