/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.FloatKeyframeSet;
import android.animation.IntKeyframeSet;
import android.animation.Keyframe;
import android.animation.Keyframes;
import android.animation.PathKeyframes;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.graphics.Path;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;

class KeyframeSet
implements Keyframes {
    TypeEvaluator mEvaluator;
    Keyframe mFirstKeyframe;
    TimeInterpolator mInterpolator;
    ArrayList<Keyframe> mKeyframes;
    Keyframe mLastKeyframe;
    int mNumKeyframes;

    public KeyframeSet(Keyframe ... keyframeArray) {
        this.mNumKeyframes = keyframeArray.length;
        this.mKeyframes = new ArrayList();
        this.mKeyframes.addAll(Arrays.asList(keyframeArray));
        this.mFirstKeyframe = this.mKeyframes.get(0);
        this.mLastKeyframe = this.mKeyframes.get(-1 + this.mNumKeyframes);
        this.mInterpolator = this.mLastKeyframe.getInterpolator();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static KeyframeSet ofFloat(float ... fArray) {
        boolean bl = false;
        int n = fArray.length;
        Keyframe.FloatKeyframe[] floatKeyframeArray = new Keyframe.FloatKeyframe[Math.max(n, 2)];
        if (n == 1) {
            floatKeyframeArray[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f);
            floatKeyframeArray[1] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(1.0f, fArray[0]);
            boolean bl2 = Float.isNaN(fArray[0]);
            bl = false;
            if (bl2) {
                bl = true;
            }
        } else {
            floatKeyframeArray[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f, fArray[0]);
            for (int i = 1; i < n; ++i) {
                floatKeyframeArray[i] = (Keyframe.FloatKeyframe)Keyframe.ofFloat((float)i / (float)(n - 1), fArray[i]);
                if (!Float.isNaN(fArray[i])) continue;
                bl = true;
            }
        }
        if (bl) {
            Log.w("Animator", "Bad value (NaN) in float animator");
        }
        return new FloatKeyframeSet(floatKeyframeArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static KeyframeSet ofInt(int ... nArray) {
        int n = nArray.length;
        Keyframe.IntKeyframe[] intKeyframeArray = new Keyframe.IntKeyframe[Math.max(n, 2)];
        if (n == 1) {
            intKeyframeArray[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f);
            intKeyframeArray[1] = (Keyframe.IntKeyframe)Keyframe.ofInt(1.0f, nArray[0]);
            return new IntKeyframeSet(intKeyframeArray);
        } else {
            intKeyframeArray[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f, nArray[0]);
            for (int i = 1; i < n; ++i) {
                intKeyframeArray[i] = (Keyframe.IntKeyframe)Keyframe.ofInt((float)i / (float)(n - 1), nArray[i]);
            }
        }
        return new IntKeyframeSet(intKeyframeArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static KeyframeSet ofKeyframe(Keyframe ... keyframeArray) {
        int n = keyframeArray.length;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < n; ++i) {
            if (keyframeArray[i] instanceof Keyframe.FloatKeyframe) {
                bl = true;
                continue;
            }
            if (keyframeArray[i] instanceof Keyframe.IntKeyframe) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        if (bl && !bl2 && !bl3) {
            Keyframe.FloatKeyframe[] floatKeyframeArray = new Keyframe.FloatKeyframe[n];
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return new FloatKeyframeSet(floatKeyframeArray);
                }
                floatKeyframeArray[n2] = (Keyframe.FloatKeyframe)keyframeArray[n2];
                ++n2;
            }
        }
        if (bl2 && !bl && !bl3) {
            Keyframe.IntKeyframe[] intKeyframeArray = new Keyframe.IntKeyframe[n];
            int n3 = 0;
            while (true) {
                if (n3 >= n) {
                    return new IntKeyframeSet(intKeyframeArray);
                }
                intKeyframeArray[n3] = (Keyframe.IntKeyframe)keyframeArray[n3];
                ++n3;
            }
        }
        return new KeyframeSet(keyframeArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static KeyframeSet ofObject(Object ... objectArray) {
        int n = objectArray.length;
        Keyframe[] keyframeArray = new Keyframe.ObjectKeyframe[Math.max(n, 2)];
        if (n == 1) {
            keyframeArray[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f);
            keyframeArray[1] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(1.0f, objectArray[0]);
            return new KeyframeSet(keyframeArray);
        } else {
            keyframeArray[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f, objectArray[0]);
            for (int i = 1; i < n; ++i) {
                keyframeArray[i] = (Keyframe.ObjectKeyframe)Keyframe.ofObject((float)i / (float)(n - 1), objectArray[i]);
            }
        }
        return new KeyframeSet(keyframeArray);
    }

    public static PathKeyframes ofPath(Path path) {
        return new PathKeyframes(path);
    }

    public static PathKeyframes ofPath(Path path, float f) {
        return new PathKeyframes(path, f);
    }

    @Override
    public KeyframeSet clone() {
        ArrayList<Keyframe> arrayList = this.mKeyframes;
        int n = this.mKeyframes.size();
        Keyframe[] keyframeArray = new Keyframe[n];
        for (int i = 0; i < n; ++i) {
            keyframeArray[i] = arrayList.get(i).clone();
        }
        return new KeyframeSet(keyframeArray);
    }

    @Override
    public ArrayList<Keyframe> getKeyframes() {
        return this.mKeyframes;
    }

    @Override
    public Class getType() {
        return this.mFirstKeyframe.getType();
    }

    @Override
    public Object getValue(float f) {
        if (this.mNumKeyframes == 2) {
            if (this.mInterpolator != null) {
                f = this.mInterpolator.getInterpolation(f);
            }
            return this.mEvaluator.evaluate(f, this.mFirstKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        if (f <= 0.0f) {
            Keyframe keyframe = this.mKeyframes.get(1);
            TimeInterpolator timeInterpolator = keyframe.getInterpolator();
            if (timeInterpolator != null) {
                f = timeInterpolator.getInterpolation(f);
            }
            float f2 = this.mFirstKeyframe.getFraction();
            float f3 = (f - f2) / (keyframe.getFraction() - f2);
            return this.mEvaluator.evaluate(f3, this.mFirstKeyframe.getValue(), keyframe.getValue());
        }
        if (f >= 1.0f) {
            Keyframe keyframe = this.mKeyframes.get(-2 + this.mNumKeyframes);
            TimeInterpolator timeInterpolator = this.mLastKeyframe.getInterpolator();
            if (timeInterpolator != null) {
                f = timeInterpolator.getInterpolation(f);
            }
            float f4 = keyframe.getFraction();
            float f5 = (f - f4) / (this.mLastKeyframe.getFraction() - f4);
            return this.mEvaluator.evaluate(f5, keyframe.getValue(), this.mLastKeyframe.getValue());
        }
        Keyframe keyframe = this.mFirstKeyframe;
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe keyframe2 = this.mKeyframes.get(i);
            if (f < keyframe2.getFraction()) {
                TimeInterpolator timeInterpolator = keyframe2.getInterpolator();
                if (timeInterpolator != null) {
                    f = timeInterpolator.getInterpolation(f);
                }
                float f6 = keyframe.getFraction();
                float f7 = (f - f6) / (keyframe2.getFraction() - f6);
                return this.mEvaluator.evaluate(f7, keyframe.getValue(), keyframe2.getValue());
            }
            keyframe = keyframe2;
        }
        return this.mLastKeyframe.getValue();
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public void setEvaluator(TypeEvaluator typeEvaluator) {
        this.mEvaluator = typeEvaluator;
    }

    public String toString() {
        String string2 = " ";
        for (int i = 0; i < this.mNumKeyframes; ++i) {
            string2 = string2 + this.mKeyframes.get(i).getValue() + "  ";
        }
        return string2;
    }
}

