/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AccountManagerResponse;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.IAccountManager;
import android.accounts.IAccountManagerResponse;
import android.accounts.OnAccountsUpdateListener;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.SQLException;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AccountManager {
    public static final String ACTION_AUTHENTICATOR_INTENT = "android.accounts.AccountAuthenticator";
    public static final String AUTHENTICATOR_ATTRIBUTES_NAME = "account-authenticator";
    public static final String AUTHENTICATOR_META_DATA_NAME = "android.accounts.AccountAuthenticator";
    public static final int ERROR_CODE_BAD_ARGUMENTS = 7;
    public static final int ERROR_CODE_BAD_AUTHENTICATION = 9;
    public static final int ERROR_CODE_BAD_REQUEST = 8;
    public static final int ERROR_CODE_CANCELED = 4;
    public static final int ERROR_CODE_INVALID_RESPONSE = 5;
    public static final int ERROR_CODE_MANAGEMENT_DISABLED_FOR_ACCOUNT_TYPE = 101;
    public static final int ERROR_CODE_NETWORK_ERROR = 3;
    public static final int ERROR_CODE_REMOTE_EXCEPTION = 1;
    public static final int ERROR_CODE_UNSUPPORTED_OPERATION = 6;
    public static final int ERROR_CODE_USER_RESTRICTED = 100;
    public static final String KEY_ACCOUNTS = "accounts";
    public static final String KEY_ACCOUNT_AUTHENTICATOR_RESPONSE = "accountAuthenticatorResponse";
    public static final String KEY_ACCOUNT_MANAGER_RESPONSE = "accountManagerResponse";
    public static final String KEY_ACCOUNT_NAME = "authAccount";
    public static final String KEY_ACCOUNT_TYPE = "accountType";
    public static final String KEY_ANDROID_PACKAGE_NAME = "androidPackageName";
    public static final String KEY_AUTHENTICATOR_TYPES = "authenticator_types";
    public static final String KEY_AUTHTOKEN = "authtoken";
    public static final String KEY_AUTH_FAILED_MESSAGE = "authFailedMessage";
    public static final String KEY_AUTH_TOKEN_LABEL = "authTokenLabelKey";
    public static final String KEY_BOOLEAN_RESULT = "booleanResult";
    public static final String KEY_CALLER_PID = "callerPid";
    public static final String KEY_CALLER_UID = "callerUid";
    public static final String KEY_ERROR_CODE = "errorCode";
    public static final String KEY_ERROR_MESSAGE = "errorMessage";
    public static final String KEY_INTENT = "intent";
    public static final String KEY_NOTIFY_ON_FAILURE = "notifyOnAuthFailure";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_USERDATA = "userdata";
    public static final String LOGIN_ACCOUNTS_CHANGED_ACTION = "android.accounts.LOGIN_ACCOUNTS_CHANGED";
    private static final String TAG = "AccountManager";
    private final BroadcastReceiver mAccountsChangedBroadcastReceiver;
    private final HashMap<OnAccountsUpdateListener, Handler> mAccountsUpdatedListeners = Maps.newHashMap();
    private final Context mContext;
    private final Handler mMainHandler;
    private final IAccountManager mService;

    public AccountManager(Context context, IAccountManager iAccountManager) {
        this.mAccountsChangedBroadcastReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                Account[] accountArray = AccountManager.this.getAccounts();
                HashMap hashMap = AccountManager.this.mAccountsUpdatedListeners;
                synchronized (hashMap) {
                    Iterator iterator = AccountManager.this.mAccountsUpdatedListeners.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        AccountManager.this.postToHandler((Handler)entry.getValue(), (OnAccountsUpdateListener)entry.getKey(), accountArray);
                    }
                    return;
                }
            }
        };
        this.mContext = context;
        this.mService = iAccountManager;
        this.mMainHandler = new Handler(this.mContext.getMainLooper());
    }

    public AccountManager(Context context, IAccountManager iAccountManager, Handler handler) {
        this.mAccountsChangedBroadcastReceiver = new /* invalid duplicate definition of identical inner class */;
        this.mContext = context;
        this.mService = iAccountManager;
        this.mMainHandler = handler;
    }

    private Exception convertErrorToException(int n, String string2) {
        if (n == 3) {
            return new IOException(string2);
        }
        if (n == 6) {
            return new UnsupportedOperationException(string2);
        }
        if (n == 5) {
            return new AuthenticatorException(string2);
        }
        if (n == 7) {
            return new IllegalArgumentException(string2);
        }
        return new AuthenticatorException(string2);
    }

    private void ensureNotOnMainThread() {
        Looper looper = Looper.myLooper();
        if (looper != null && looper == this.mContext.getMainLooper()) {
            IllegalStateException illegalStateException = new IllegalStateException("calling this from your main thread can lead to deadlock");
            Log.e(TAG, "calling this from your main thread can lead to deadlock and/or ANRs", illegalStateException);
            if (this.mContext.getApplicationInfo().targetSdkVersion >= 8) {
                throw illegalStateException;
            }
        }
    }

    public static AccountManager get(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        return (AccountManager)context.getSystemService("account");
    }

    public static Intent newChooseAccountIntent(Account account, ArrayList<Account> arrayList, String[] stringArray, boolean bl, String string2, String string3, String[] stringArray2, Bundle bundle) {
        Intent intent = new Intent();
        ComponentName componentName = ComponentName.unflattenFromString(Resources.getSystem().getString(17039427));
        intent.setClassName(componentName.getPackageName(), componentName.getClassName());
        intent.putExtra("allowableAccounts", arrayList);
        intent.putExtra("allowableAccountTypes", stringArray);
        intent.putExtra("addAccountOptions", bundle);
        intent.putExtra("selectedAccount", account);
        intent.putExtra("alwaysPromptForAccount", bl);
        intent.putExtra("descriptionTextOverride", string2);
        intent.putExtra("authTokenType", string3);
        intent.putExtra("addAccountRequiredFeatures", stringArray2);
        return intent;
    }

    private void postToHandler(Handler handler, final AccountManagerCallback<Bundle> accountManagerCallback, final AccountManagerFuture<Bundle> accountManagerFuture) {
        if (handler == null) {
            handler = this.mMainHandler;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                accountManagerCallback.run(accountManagerFuture);
            }
        });
    }

    private void postToHandler(Handler handler, final OnAccountsUpdateListener onAccountsUpdateListener, Account[] accountArray) {
        final Account[] accountArray2 = new Account[accountArray.length];
        System.arraycopy(accountArray, 0, accountArray2, 0, accountArray2.length);
        if (handler == null) {
            handler = this.mMainHandler;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    onAccountsUpdateListener.onAccountsUpdated(accountArray2);
                    return;
                }
                catch (SQLException sQLException) {
                    Log.e(AccountManager.TAG, "Can't update accounts", sQLException);
                    return;
                }
            }
        });
    }

    public static Bundle sanitizeResult(Bundle bundle) {
        if (bundle != null && bundle.containsKey(KEY_AUTHTOKEN) && !TextUtils.isEmpty(bundle.getString(KEY_AUTHTOKEN))) {
            Bundle bundle2 = new Bundle(bundle);
            bundle2.putString(KEY_AUTHTOKEN, "<omitted for logging purposes>");
            return bundle2;
        }
        return bundle;
    }

    public AccountManagerFuture<Bundle> addAccount(final String string2, final String string3, final String[] stringArray, Bundle bundle, final Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        final Bundle bundle2 = new Bundle();
        if (bundle != null) {
            bundle2.putAll(bundle);
        }
        bundle2.putString(KEY_ANDROID_PACKAGE_NAME, this.mContext.getPackageName());
        return new AmsTask(activity, handler, accountManagerCallback){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                String string22 = string2;
                String string32 = string3;
                String[] stringArray2 = stringArray;
                boolean bl = activity != null;
                iAccountManager.addAccount(iAccountManagerResponse, string22, string32, stringArray2, bl, bundle2);
            }
        }.start();
    }

    public AccountManagerFuture<Bundle> addAccountAsUser(final String string2, final String string3, final String[] stringArray, Bundle bundle, final Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler, final UserHandle userHandle) {
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (userHandle == null) {
            throw new IllegalArgumentException("userHandle is null");
        }
        final Bundle bundle2 = new Bundle();
        if (bundle != null) {
            bundle2.putAll(bundle);
        }
        bundle2.putString(KEY_ANDROID_PACKAGE_NAME, this.mContext.getPackageName());
        return new AmsTask(activity, handler, accountManagerCallback){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                String string22 = string2;
                String string32 = string3;
                String[] stringArray2 = stringArray;
                boolean bl = activity != null;
                iAccountManager.addAccountAsUser(iAccountManagerResponse, string22, string32, stringArray2, bl, bundle2, userHandle.getIdentifier());
            }
        }.start();
    }

    public boolean addAccountExplicitly(Account account, String string2, Bundle bundle) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            boolean bl = this.mService.addAccountExplicitly(account, string2, bundle);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addOnAccountsUpdatedListener(OnAccountsUpdateListener onAccountsUpdateListener, Handler handler, boolean bl) {
        if (onAccountsUpdateListener == null) {
            throw new IllegalArgumentException("the listener is null");
        }
        HashMap<OnAccountsUpdateListener, Handler> hashMap = this.mAccountsUpdatedListeners;
        // MONITORENTER : hashMap
        if (this.mAccountsUpdatedListeners.containsKey(onAccountsUpdateListener)) {
            throw new IllegalStateException("this listener is already added");
        }
        boolean bl2 = this.mAccountsUpdatedListeners.isEmpty();
        this.mAccountsUpdatedListeners.put(onAccountsUpdateListener, handler);
        if (bl2) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction(LOGIN_ACCOUNTS_CHANGED_ACTION);
            intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
            this.mContext.registerReceiver(this.mAccountsChangedBroadcastReceiver, intentFilter);
        }
        // MONITOREXIT : hashMap
        if (!bl) return;
        this.postToHandler(handler, onAccountsUpdateListener, this.getAccounts());
    }

    public boolean addSharedAccount(Account account, UserHandle userHandle) {
        try {
            boolean bl = this.mService.addSharedAccountAsUser(account, userHandle.getIdentifier());
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public String blockingGetAuthToken(Account account, String string2, boolean bl) throws OperationCanceledException, IOException, AuthenticatorException {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        Bundle bundle = this.getAuthToken(account, string2, bl, null, null).getResult();
        if (bundle == null) {
            Log.e(TAG, "blockingGetAuthToken: null was returned from getResult() for " + account + ", authTokenType " + string2);
            return null;
        }
        return bundle.getString(KEY_AUTHTOKEN);
    }

    public void clearPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            this.mService.clearPassword(account);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AccountManagerFuture<Bundle> confirmCredentials(Account account, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        return this.confirmCredentialsAsUser(account, bundle, activity, accountManagerCallback, handler, Process.myUserHandle());
    }

    public AccountManagerFuture<Bundle> confirmCredentialsAsUser(final Account account, final Bundle bundle, final Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler, UserHandle userHandle) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        return new AmsTask(activity, handler, accountManagerCallback, userHandle.getIdentifier()){
            final /* synthetic */ int val$userId;
            {
                this.val$userId = n;
                super(activity3, handler, accountManagerCallback);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                Account account2 = account;
                Bundle bundle2 = bundle;
                boolean bl = activity != null;
                iAccountManager.confirmCredentialsAsUser(iAccountManagerResponse, account2, bundle2, bl, this.val$userId);
            }
        }.start();
    }

    public AccountManagerFuture<Bundle> editProperties(final String string2, final Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        return new AmsTask(activity, handler, accountManagerCallback){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                String string22 = string2;
                boolean bl = activity != null;
                iAccountManager.editProperties(iAccountManagerResponse, string22, bl);
            }
        }.start();
    }

    public Account[] getAccounts() {
        try {
            Account[] accountArray = this.mService.getAccounts(null);
            return accountArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public Account[] getAccountsAsUser(int n) {
        try {
            Account[] accountArray = this.mService.getAccountsAsUser(null, n);
            return accountArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public Account[] getAccountsByType(String string2) {
        return this.getAccountsByTypeAsUser(string2, Process.myUserHandle());
    }

    public AccountManagerFuture<Account[]> getAccountsByTypeAndFeatures(final String string2, final String[] stringArray, AccountManagerCallback<Account[]> accountManagerCallback, Handler handler) {
        if (string2 == null) {
            throw new IllegalArgumentException("type is null");
        }
        return new Future2Task<Account[]>(handler, accountManagerCallback){

            @Override
            public Account[] bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey(AccountManager.KEY_ACCOUNTS)) {
                    throw new AuthenticatorException("no result in response");
                }
                Parcelable[] parcelableArray = bundle.getParcelableArray(AccountManager.KEY_ACCOUNTS);
                Account[] accountArray = new Account[parcelableArray.length];
                for (int i = 0; i < parcelableArray.length; ++i) {
                    accountArray[i] = (Account)parcelableArray[i];
                }
                return accountArray;
            }

            @Override
            public void doWork() throws RemoteException {
                AccountManager.this.mService.getAccountsByFeatures(this.mResponse, string2, stringArray);
            }
        }.start();
    }

    public Account[] getAccountsByTypeAsUser(String string2, UserHandle userHandle) {
        try {
            Account[] accountArray = this.mService.getAccountsAsUser(string2, userHandle.getIdentifier());
            return accountArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public Account[] getAccountsByTypeForPackage(String string2, String string3) {
        try {
            Account[] accountArray = this.mService.getAccountsByTypeForPackage(string2, string3);
            return accountArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public Account[] getAccountsForPackage(String string2, int n) {
        try {
            Account[] accountArray = this.mService.getAccountsForPackage(string2, n);
            return accountArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AccountManagerFuture<Bundle> getAuthToken(final Account account, final String string2, Bundle bundle, Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        final Bundle bundle2 = new Bundle();
        if (bundle != null) {
            bundle2.putAll(bundle);
        }
        bundle2.putString(KEY_ANDROID_PACKAGE_NAME, this.mContext.getPackageName());
        return new AmsTask(activity, handler, accountManagerCallback){

            @Override
            public void doWork() throws RemoteException {
                AccountManager.this.mService.getAuthToken(this.mResponse, account, string2, false, true, bundle2);
            }
        }.start();
    }

    public AccountManagerFuture<Bundle> getAuthToken(final Account account, final String string2, Bundle bundle, final boolean bl, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        final Bundle bundle2 = new Bundle();
        if (bundle != null) {
            bundle2.putAll(bundle);
        }
        bundle2.putString(KEY_ANDROID_PACKAGE_NAME, this.mContext.getPackageName());
        return new AmsTask(null, handler, accountManagerCallback){

            @Override
            public void doWork() throws RemoteException {
                AccountManager.this.mService.getAuthToken(this.mResponse, account, string2, bl, false, bundle2);
            }
        }.start();
    }

    @Deprecated
    public AccountManagerFuture<Bundle> getAuthToken(Account account, String string2, boolean bl, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        return this.getAuthToken(account, string2, null, bl, accountManagerCallback, handler);
    }

    public AccountManagerFuture<Bundle> getAuthTokenByFeatures(String string2, String string3, String[] stringArray, Activity activity, Bundle bundle, Bundle bundle2, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (string2 == null) {
            throw new IllegalArgumentException("account type is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        GetAuthTokenByTypeAndFeaturesTask getAuthTokenByTypeAndFeaturesTask = new GetAuthTokenByTypeAndFeaturesTask(string2, string3, stringArray, activity, bundle, bundle2, accountManagerCallback, handler);
        getAuthTokenByTypeAndFeaturesTask.start();
        return getAuthTokenByTypeAndFeaturesTask;
    }

    public AccountManagerFuture<String> getAuthTokenLabel(final String string2, final String string3, AccountManagerCallback<String> accountManagerCallback, Handler handler) {
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        return new Future2Task<String>(handler, accountManagerCallback){

            @Override
            public String bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey(AccountManager.KEY_AUTH_TOKEN_LABEL)) {
                    throw new AuthenticatorException("no result in response");
                }
                return bundle.getString(AccountManager.KEY_AUTH_TOKEN_LABEL);
            }

            @Override
            public void doWork() throws RemoteException {
                AccountManager.this.mService.getAuthTokenLabel(this.mResponse, string2, string3);
            }
        }.start();
    }

    public AuthenticatorDescription[] getAuthenticatorTypes() {
        try {
            AuthenticatorDescription[] authenticatorDescriptionArray = this.mService.getAuthenticatorTypes(UserHandle.getCallingUserId());
            return authenticatorDescriptionArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AuthenticatorDescription[] getAuthenticatorTypesAsUser(int n) {
        try {
            AuthenticatorDescription[] authenticatorDescriptionArray = this.mService.getAuthenticatorTypes(n);
            return authenticatorDescriptionArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public String getPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            String string2 = this.mService.getPassword(account);
            return string2;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public String getPreviousName(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            String string2 = this.mService.getPreviousName(account);
            return string2;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public Account[] getSharedAccounts(UserHandle userHandle) {
        try {
            Account[] accountArray = this.mService.getSharedAccountsAsUser(userHandle.getIdentifier());
            return accountArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public String getUserData(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key is null");
        }
        try {
            String string3 = this.mService.getUserData(account, string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AccountManagerFuture<Boolean> hasFeatures(final Account account, final String[] stringArray, AccountManagerCallback<Boolean> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("features is null");
        }
        return new Future2Task<Boolean>(handler, accountManagerCallback){

            @Override
            public Boolean bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey(AccountManager.KEY_BOOLEAN_RESULT)) {
                    throw new AuthenticatorException("no result in response");
                }
                return bundle.getBoolean(AccountManager.KEY_BOOLEAN_RESULT);
            }

            @Override
            public void doWork() throws RemoteException {
                AccountManager.this.mService.hasFeatures(this.mResponse, account, stringArray);
            }
        }.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invalidateAuthToken(String string2, String string3) {
        if (string2 == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (string3 == null) return;
        try {
            this.mService.invalidateAuthToken(string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public String peekAuthToken(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        try {
            String string3 = this.mService.peekAuthToken(account, string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AccountManagerFuture<Boolean> removeAccount(final Account account, AccountManagerCallback<Boolean> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        return new Future2Task<Boolean>(handler, accountManagerCallback){

            @Override
            public Boolean bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey(AccountManager.KEY_BOOLEAN_RESULT)) {
                    throw new AuthenticatorException("no result in response");
                }
                return bundle.getBoolean(AccountManager.KEY_BOOLEAN_RESULT);
            }

            @Override
            public void doWork() throws RemoteException {
                AccountManager.this.mService.removeAccount(this.mResponse, account);
            }
        }.start();
    }

    public AccountManagerFuture<Boolean> removeAccountAsUser(final Account account, AccountManagerCallback<Boolean> accountManagerCallback, Handler handler, final UserHandle userHandle) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (userHandle == null) {
            throw new IllegalArgumentException("userHandle is null");
        }
        return new Future2Task<Boolean>(handler, accountManagerCallback){

            @Override
            public Boolean bundleToResult(Bundle bundle) throws AuthenticatorException {
                if (!bundle.containsKey(AccountManager.KEY_BOOLEAN_RESULT)) {
                    throw new AuthenticatorException("no result in response");
                }
                return bundle.getBoolean(AccountManager.KEY_BOOLEAN_RESULT);
            }

            @Override
            public void doWork() throws RemoteException {
                AccountManager.this.mService.removeAccountAsUser(this.mResponse, account, userHandle.getIdentifier());
            }
        }.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeOnAccountsUpdatedListener(OnAccountsUpdateListener onAccountsUpdateListener) {
        if (onAccountsUpdateListener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        HashMap<OnAccountsUpdateListener, Handler> hashMap = this.mAccountsUpdatedListeners;
        synchronized (hashMap) {
            if (!this.mAccountsUpdatedListeners.containsKey(onAccountsUpdateListener)) {
                Log.e(TAG, "Listener was not previously added");
                return;
            }
            this.mAccountsUpdatedListeners.remove(onAccountsUpdateListener);
            if (this.mAccountsUpdatedListeners.isEmpty()) {
                this.mContext.unregisterReceiver(this.mAccountsChangedBroadcastReceiver);
            }
            return;
        }
    }

    public boolean removeSharedAccount(Account account, UserHandle userHandle) {
        try {
            boolean bl = this.mService.removeSharedAccountAsUser(account, userHandle.getIdentifier());
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AccountManagerFuture<Account> renameAccount(final Account account, final String string2, AccountManagerCallback<Account> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null.");
        }
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException("newName is empty or null.");
        }
        return new Future2Task<Account>(handler, accountManagerCallback){

            @Override
            public Account bundleToResult(Bundle bundle) throws AuthenticatorException {
                return new Account(bundle.getString(AccountManager.KEY_ACCOUNT_NAME), bundle.getString(AccountManager.KEY_ACCOUNT_TYPE));
            }

            @Override
            public void doWork() throws RemoteException {
                AccountManager.this.mService.renameAccount(this.mResponse, account, string2);
            }
        }.start();
    }

    public void setAuthToken(Account account, String string2, String string3) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        try {
            this.mService.setAuthToken(account, string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setPassword(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        try {
            this.mService.setPassword(account, string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setUserData(Account account, String string2, String string3) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("key is null");
        }
        try {
            this.mService.setUserData(account, string2, string3);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void updateAppPermission(Account account, String string2, int n, boolean bl) {
        try {
            this.mService.updateAppPermission(account, string2, n, bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public AccountManagerFuture<Bundle> updateCredentials(final Account account, final String string2, final Bundle bundle, final Activity activity, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        return new AmsTask(activity, handler, accountManagerCallback){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void doWork() throws RemoteException {
                IAccountManager iAccountManager = AccountManager.this.mService;
                IAccountManagerResponse iAccountManagerResponse = this.mResponse;
                Account account2 = account;
                String string22 = string2;
                boolean bl = activity != null;
                iAccountManager.updateCredentials(iAccountManagerResponse, account2, string22, bl, bundle);
            }
        }.start();
    }

    private abstract class AmsTask
    extends FutureTask<Bundle>
    implements AccountManagerFuture<Bundle> {
        final Activity mActivity;
        final AccountManagerCallback<Bundle> mCallback;
        final Handler mHandler;
        final IAccountManagerResponse mResponse;

        public AmsTask(Activity activity, Handler handler, AccountManagerCallback<Bundle> accountManagerCallback) {
            super(new Callable<Bundle>(){

                @Override
                public Bundle call() throws Exception {
                    throw new IllegalStateException("this should never be called");
                }
            });
            this.mHandler = handler;
            this.mCallback = accountManagerCallback;
            this.mActivity = activity;
            this.mResponse = new Response();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Bundle internalGetResult(Long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            if (!this.isDone()) {
                AccountManager.this.ensureNotOnMainThread();
            }
            if (l == null) {
                try {
                    Bundle bundle = (Bundle)this.get();
                    return bundle;
                }
                catch (CancellationException cancellationException) {
                    throw new OperationCanceledException();
                }
                catch (TimeoutException timeoutException) {
                    throw new OperationCanceledException();
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationCanceledException();
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    if (throwable instanceof UnsupportedOperationException) {
                        throw new AuthenticatorException(throwable);
                    }
                    if (throwable instanceof AuthenticatorException) {
                        throw (AuthenticatorException)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    if (!(throwable instanceof Error)) throw new IllegalStateException(throwable);
                    throw (Error)throwable;
                }
            }
            Bundle bundle = (Bundle)this.get(l, timeUnit);
            this.cancel(true);
            return bundle;
            finally {
                this.cancel(true);
                throw new OperationCanceledException();
            }
        }

        public abstract void doWork() throws RemoteException;

        @Override
        protected void done() {
            if (this.mCallback != null) {
                AccountManager.this.postToHandler(this.mHandler, this.mCallback, this);
            }
        }

        @Override
        public Bundle getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(null, null);
        }

        @Override
        public Bundle getResult(long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(l, timeUnit);
        }

        @Override
        protected void set(Bundle bundle) {
            if (bundle == null) {
                Log.e(AccountManager.TAG, "the bundle must not be null", new Exception());
            }
            super.set(bundle);
        }

        public final AccountManagerFuture<Bundle> start() {
            try {
                this.doWork();
                return this;
            }
            catch (RemoteException remoteException) {
                this.setException(remoteException);
                return this;
            }
        }

        private class Response
        extends IAccountManagerResponse.Stub {
            private Response() {
            }

            @Override
            public void onError(int n, String string2) {
                if (n == 4 || n == 100 || n == 101) {
                    AmsTask.this.cancel(true);
                    return;
                }
                AmsTask.this.setException(AccountManager.this.convertErrorToException(n, string2));
            }

            @Override
            public void onResult(Bundle bundle) {
                Intent intent = (Intent)bundle.getParcelable(AccountManager.KEY_INTENT);
                if (intent != null && AmsTask.this.mActivity != null) {
                    AmsTask.this.mActivity.startActivity(intent);
                    return;
                }
                if (bundle.getBoolean("retry")) {
                    try {
                        AmsTask.this.doWork();
                        return;
                    }
                    catch (RemoteException remoteException) {
                        return;
                    }
                }
                AmsTask.this.set(bundle);
            }
        }
    }

    private abstract class BaseFutureTask<T>
    extends FutureTask<T> {
        final Handler mHandler;
        public final IAccountManagerResponse mResponse;

        public BaseFutureTask(Handler handler) {
            super(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    throw new IllegalStateException("this should never be called");
                }
            });
            this.mHandler = handler;
            this.mResponse = new Response();
        }

        static /* synthetic */ void access$700(BaseFutureTask baseFutureTask, Object object) {
            baseFutureTask.set(object);
        }

        public abstract T bundleToResult(Bundle var1) throws AuthenticatorException;

        public abstract void doWork() throws RemoteException;

        /*
         * Enabled aggressive block sorting
         */
        protected void postRunnableToHandler(Runnable runnable) {
            Handler handler = this.mHandler == null ? AccountManager.this.mMainHandler : this.mHandler;
            handler.post(runnable);
        }

        protected void startTask() {
            try {
                this.doWork();
                return;
            }
            catch (RemoteException remoteException) {
                this.setException(remoteException);
                return;
            }
        }

        protected class Response
        extends IAccountManagerResponse.Stub {
            protected Response() {
            }

            @Override
            public void onError(int n, String string2) {
                if (n == 4 || n == 100 || n == 101) {
                    BaseFutureTask.this.cancel(true);
                    return;
                }
                BaseFutureTask.this.setException(AccountManager.this.convertErrorToException(n, string2));
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void onResult(Bundle var1_1) {
                block5: {
                    var4_2 = BaseFutureTask.this.bundleToResult(var1_1);
                    if (var4_2 != null) break block5;
                    return;
                }
                try {
                    BaseFutureTask.access$700(BaseFutureTask.this, var4_2);
                    return;
                }
                catch (ClassCastException var3_3) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        this.onError(5, "no result in response");
                        return;
                    }
                }
                catch (AuthenticatorException var2_4) {
                    ** continue;
                }
            }
        }
    }

    private abstract class Future2Task<T>
    extends BaseFutureTask<T>
    implements AccountManagerFuture<T> {
        final AccountManagerCallback<T> mCallback;

        public Future2Task(Handler handler, AccountManagerCallback<T> accountManagerCallback) {
            super(handler);
            this.mCallback = accountManagerCallback;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private T internalGetResult(Long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            Throwable throwable;
            block16: {
                if (!this.isDone()) {
                    AccountManager.this.ensureNotOnMainThread();
                }
                if (l == null) {
                    try {
                        Object v = this.get();
                        return (T)v;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new OperationCanceledException();
                    }
                    catch (TimeoutException timeoutException) {
                        throw new OperationCanceledException();
                    }
                    catch (CancellationException cancellationException) {
                        throw new OperationCanceledException();
                    }
                    catch (ExecutionException executionException) {
                        throwable = executionException.getCause();
                        if (throwable instanceof IOException) {
                            throw (IOException)throwable;
                        }
                        break block16;
                    }
                }
                Object v = this.get(l, timeUnit);
                this.cancel(true);
                return (T)v;
                finally {
                    this.cancel(true);
                    throw new OperationCanceledException();
                }
            }
            if (throwable instanceof UnsupportedOperationException) {
                throw new AuthenticatorException(throwable);
            }
            if (throwable instanceof AuthenticatorException) {
                throw (AuthenticatorException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (!(throwable instanceof Error)) throw new IllegalStateException(throwable);
            throw (Error)throwable;
        }

        @Override
        protected void done() {
            if (this.mCallback != null) {
                this.postRunnableToHandler(new Runnable(){

                    @Override
                    public void run() {
                        Future2Task.this.mCallback.run(Future2Task.this);
                    }
                });
            }
        }

        @Override
        public T getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(null, null);
        }

        @Override
        public T getResult(long l, TimeUnit timeUnit) throws OperationCanceledException, IOException, AuthenticatorException {
            return this.internalGetResult(l, timeUnit);
        }

        public Future2Task<T> start() {
            this.startTask();
            return this;
        }
    }

    private class GetAuthTokenByTypeAndFeaturesTask
    extends AmsTask
    implements AccountManagerCallback<Bundle> {
        final String mAccountType;
        final Bundle mAddAccountOptions;
        final String mAuthTokenType;
        final String[] mFeatures;
        volatile AccountManagerFuture<Bundle> mFuture;
        final Bundle mLoginOptions;
        final AccountManagerCallback<Bundle> mMyCallback;
        private volatile int mNumAccounts;

        GetAuthTokenByTypeAndFeaturesTask(String string2, String string3, String[] stringArray, Activity activity, Bundle bundle, Bundle bundle2, AccountManagerCallback<Bundle> accountManagerCallback, Handler handler) {
            super(activity, handler, accountManagerCallback);
            this.mFuture = null;
            this.mNumAccounts = 0;
            if (string2 == null) {
                throw new IllegalArgumentException("account type is null");
            }
            this.mAccountType = string2;
            this.mAuthTokenType = string3;
            this.mFeatures = stringArray;
            this.mAddAccountOptions = bundle;
            this.mLoginOptions = bundle2;
            this.mMyCallback = this;
        }

        static /* synthetic */ int access$1202(GetAuthTokenByTypeAndFeaturesTask getAuthTokenByTypeAndFeaturesTask, int n) {
            getAuthTokenByTypeAndFeaturesTask.mNumAccounts = n;
            return n;
        }

        @Override
        public void doWork() throws RemoteException {
            AccountManager.this.getAccountsByTypeAndFeatures(this.mAccountType, this.mFeatures, new AccountManagerCallback<Account[]>(){

                @Override
                public void run(AccountManagerFuture<Account[]> accountManagerFuture) {
                    Parcelable[] parcelableArray;
                    block12: {
                        try {
                            parcelableArray = accountManagerFuture.getResult();
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            GetAuthTokenByTypeAndFeaturesTask.this.setException(operationCanceledException);
                            return;
                        }
                        catch (IOException iOException) {
                            GetAuthTokenByTypeAndFeaturesTask.this.setException(iOException);
                            return;
                        }
                        catch (AuthenticatorException authenticatorException) {
                            GetAuthTokenByTypeAndFeaturesTask.this.setException(authenticatorException);
                            return;
                        }
                        GetAuthTokenByTypeAndFeaturesTask.access$1202(GetAuthTokenByTypeAndFeaturesTask.this, parcelableArray.length);
                        if (parcelableArray.length != 0) break block12;
                        if (GetAuthTokenByTypeAndFeaturesTask.this.mActivity != null) {
                            GetAuthTokenByTypeAndFeaturesTask.this.mFuture = AccountManager.this.addAccount(GetAuthTokenByTypeAndFeaturesTask.this.mAccountType, GetAuthTokenByTypeAndFeaturesTask.this.mAuthTokenType, GetAuthTokenByTypeAndFeaturesTask.this.mFeatures, GetAuthTokenByTypeAndFeaturesTask.this.mAddAccountOptions, GetAuthTokenByTypeAndFeaturesTask.this.mActivity, GetAuthTokenByTypeAndFeaturesTask.this.mMyCallback, GetAuthTokenByTypeAndFeaturesTask.this.mHandler);
                            return;
                        }
                        Bundle bundle = new Bundle();
                        bundle.putString(AccountManager.KEY_ACCOUNT_NAME, null);
                        bundle.putString(AccountManager.KEY_ACCOUNT_TYPE, null);
                        bundle.putString(AccountManager.KEY_AUTHTOKEN, null);
                        try {
                            GetAuthTokenByTypeAndFeaturesTask.this.mResponse.onResult(bundle);
                            return;
                        }
                        catch (RemoteException remoteException) {
                            return;
                        }
                    }
                    if (parcelableArray.length == 1) {
                        if (GetAuthTokenByTypeAndFeaturesTask.this.mActivity == null) {
                            GetAuthTokenByTypeAndFeaturesTask.this.mFuture = AccountManager.this.getAuthToken(parcelableArray[0], GetAuthTokenByTypeAndFeaturesTask.this.mAuthTokenType, false, GetAuthTokenByTypeAndFeaturesTask.this.mMyCallback, GetAuthTokenByTypeAndFeaturesTask.this.mHandler);
                            return;
                        }
                        GetAuthTokenByTypeAndFeaturesTask.this.mFuture = AccountManager.this.getAuthToken(parcelableArray[0], GetAuthTokenByTypeAndFeaturesTask.this.mAuthTokenType, GetAuthTokenByTypeAndFeaturesTask.this.mLoginOptions, GetAuthTokenByTypeAndFeaturesTask.this.mActivity, GetAuthTokenByTypeAndFeaturesTask.this.mMyCallback, GetAuthTokenByTypeAndFeaturesTask.this.mHandler);
                        return;
                    }
                    if (GetAuthTokenByTypeAndFeaturesTask.this.mActivity != null) {
                        IAccountManagerResponse.Stub stub = new IAccountManagerResponse.Stub(){

                            @Override
                            public void onError(int n, String string2) throws RemoteException {
                                GetAuthTokenByTypeAndFeaturesTask.this.mResponse.onError(n, string2);
                            }

                            @Override
                            public void onResult(Bundle bundle) throws RemoteException {
                                Account account = new Account(bundle.getString(AccountManager.KEY_ACCOUNT_NAME), bundle.getString(AccountManager.KEY_ACCOUNT_TYPE));
                                GetAuthTokenByTypeAndFeaturesTask.this.mFuture = AccountManager.this.getAuthToken(account, GetAuthTokenByTypeAndFeaturesTask.this.mAuthTokenType, GetAuthTokenByTypeAndFeaturesTask.this.mLoginOptions, GetAuthTokenByTypeAndFeaturesTask.this.mActivity, GetAuthTokenByTypeAndFeaturesTask.this.mMyCallback, GetAuthTokenByTypeAndFeaturesTask.this.mHandler);
                            }
                        };
                        Intent intent = new Intent();
                        ComponentName componentName = ComponentName.unflattenFromString(Resources.getSystem().getString(17039426));
                        intent.setClassName(componentName.getPackageName(), componentName.getClassName());
                        intent.putExtra(AccountManager.KEY_ACCOUNTS, parcelableArray);
                        intent.putExtra(AccountManager.KEY_ACCOUNT_MANAGER_RESPONSE, new AccountManagerResponse(stub));
                        GetAuthTokenByTypeAndFeaturesTask.this.mActivity.startActivity(intent);
                        return;
                    }
                    Bundle bundle = new Bundle();
                    bundle.putString(AccountManager.KEY_ACCOUNTS, null);
                    try {
                        GetAuthTokenByTypeAndFeaturesTask.this.mResponse.onResult(bundle);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        return;
                    }
                }
            }, this.mHandler);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run(AccountManagerFuture<Bundle> accountManagerFuture) {
            Bundle bundle;
            try {
                bundle = accountManagerFuture.getResult();
                if (this.mNumAccounts == 0) {
                    String string2 = bundle.getString(AccountManager.KEY_ACCOUNT_NAME);
                    String string3 = bundle.getString(AccountManager.KEY_ACCOUNT_TYPE);
                    if (!TextUtils.isEmpty(string2) && !TextUtils.isEmpty(string3)) {
                        Account account = new Account(string2, string3);
                        this.mNumAccounts = 1;
                        AccountManager.this.getAuthToken(account, this.mAuthTokenType, null, this.mActivity, this.mMyCallback, this.mHandler);
                        return;
                    }
                    this.setException(new AuthenticatorException("account not in result"));
                    return;
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                this.cancel(true);
                return;
            }
            catch (IOException iOException) {
                this.setException(iOException);
                return;
            }
            catch (AuthenticatorException authenticatorException) {
                this.setException(authenticatorException);
                return;
            }
            {
                this.set(bundle);
                return;
            }
        }
    }
}

