/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import java.util.ArrayList;
import java.util.List;

public interface IAccessibilityServiceConnection
extends IInterface {
    public boolean computeClickPointInScreen(int var1, long var2, int var4, IAccessibilityInteractionConnectionCallback var5, long var6) throws RemoteException;

    public boolean findAccessibilityNodeInfoByAccessibilityId(int var1, long var2, int var4, IAccessibilityInteractionConnectionCallback var5, int var6, long var7) throws RemoteException;

    public boolean findAccessibilityNodeInfosByText(int var1, long var2, String var4, int var5, IAccessibilityInteractionConnectionCallback var6, long var7) throws RemoteException;

    public boolean findAccessibilityNodeInfosByViewId(int var1, long var2, String var4, int var5, IAccessibilityInteractionConnectionCallback var6, long var7) throws RemoteException;

    public boolean findFocus(int var1, long var2, int var4, int var5, IAccessibilityInteractionConnectionCallback var6, long var7) throws RemoteException;

    public boolean focusSearch(int var1, long var2, int var4, int var5, IAccessibilityInteractionConnectionCallback var6, long var7) throws RemoteException;

    public AccessibilityServiceInfo getServiceInfo() throws RemoteException;

    public AccessibilityWindowInfo getWindow(int var1) throws RemoteException;

    public List<AccessibilityWindowInfo> getWindows() throws RemoteException;

    public boolean performAccessibilityAction(int var1, long var2, int var4, Bundle var5, int var6, IAccessibilityInteractionConnectionCallback var7, long var8) throws RemoteException;

    public boolean performGlobalAction(int var1) throws RemoteException;

    public void setOnKeyEventResult(boolean var1, int var2) throws RemoteException;

    public void setServiceInfo(AccessibilityServiceInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAccessibilityServiceConnection {
        private static final String DESCRIPTOR = "android.accessibilityservice.IAccessibilityServiceConnection";
        static final int TRANSACTION_computeClickPointInScreen = 8;
        static final int TRANSACTION_findAccessibilityNodeInfoByAccessibilityId = 2;
        static final int TRANSACTION_findAccessibilityNodeInfosByText = 3;
        static final int TRANSACTION_findAccessibilityNodeInfosByViewId = 4;
        static final int TRANSACTION_findFocus = 5;
        static final int TRANSACTION_focusSearch = 6;
        static final int TRANSACTION_getServiceInfo = 11;
        static final int TRANSACTION_getWindow = 9;
        static final int TRANSACTION_getWindows = 10;
        static final int TRANSACTION_performAccessibilityAction = 7;
        static final int TRANSACTION_performGlobalAction = 12;
        static final int TRANSACTION_setOnKeyEventResult = 13;
        static final int TRANSACTION_setServiceInfo = 1;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAccessibilityServiceConnection asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IAccessibilityServiceConnection) {
                return (IAccessibilityServiceConnection)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    AccessibilityServiceInfo accessibilityServiceInfo = parcel.readInt() != 0 ? AccessibilityServiceInfo.CREATOR.createFromParcel(parcel) : null;
                    this.setServiceInfo(accessibilityServiceInfo);
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.findAccessibilityNodeInfoByAccessibilityId(parcel.readInt(), parcel.readLong(), parcel.readInt(), IAccessibilityInteractionConnectionCallback.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt(), parcel.readLong());
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.findAccessibilityNodeInfosByText(parcel.readInt(), parcel.readLong(), parcel.readString(), parcel.readInt(), IAccessibilityInteractionConnectionCallback.Stub.asInterface(parcel.readStrongBinder()), parcel.readLong());
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.findAccessibilityNodeInfosByViewId(parcel.readInt(), parcel.readLong(), parcel.readString(), parcel.readInt(), IAccessibilityInteractionConnectionCallback.Stub.asInterface(parcel.readStrongBinder()), parcel.readLong());
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.findFocus(parcel.readInt(), parcel.readLong(), parcel.readInt(), parcel.readInt(), IAccessibilityInteractionConnectionCallback.Stub.asInterface(parcel.readStrongBinder()), parcel.readLong());
                    parcel2.writeNoException();
                    int n6 = bl ? 1 : 0;
                    parcel2.writeInt(n6);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.focusSearch(parcel.readInt(), parcel.readLong(), parcel.readInt(), parcel.readInt(), IAccessibilityInteractionConnectionCallback.Stub.asInterface(parcel.readStrongBinder()), parcel.readLong());
                    parcel2.writeNoException();
                    int n7 = bl ? 1 : 0;
                    parcel2.writeInt(n7);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n8 = parcel.readInt();
                    long l = parcel.readLong();
                    int n9 = parcel.readInt();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    int n10 = parcel.readInt();
                    IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback = IAccessibilityInteractionConnectionCallback.Stub.asInterface(parcel.readStrongBinder());
                    long l2 = parcel.readLong();
                    boolean bl = this.performAccessibilityAction(n8, l, n9, bundle, n10, iAccessibilityInteractionConnectionCallback, l2);
                    parcel2.writeNoException();
                    int n11 = bl ? 1 : 0;
                    parcel2.writeInt(n11);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.computeClickPointInScreen(parcel.readInt(), parcel.readLong(), parcel.readInt(), IAccessibilityInteractionConnectionCallback.Stub.asInterface(parcel.readStrongBinder()), parcel.readLong());
                    parcel2.writeNoException();
                    int n12 = bl ? 1 : 0;
                    parcel2.writeInt(n12);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    AccessibilityWindowInfo accessibilityWindowInfo = this.getWindow(parcel.readInt());
                    parcel2.writeNoException();
                    if (accessibilityWindowInfo != null) {
                        parcel2.writeInt(1);
                        accessibilityWindowInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<AccessibilityWindowInfo> list = this.getWindows();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    AccessibilityServiceInfo accessibilityServiceInfo = this.getServiceInfo();
                    parcel2.writeNoException();
                    if (accessibilityServiceInfo != null) {
                        parcel2.writeInt(1);
                        accessibilityServiceInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.performGlobalAction(parcel.readInt());
                    parcel2.writeNoException();
                    int n13 = bl ? 1 : 0;
                    parcel2.writeInt(n13);
                    return true;
                }
                case 13: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            boolean bl = parcel.readInt() != 0;
            this.setOnKeyEventResult(bl, parcel.readInt());
            return true;
        }

        private static class Proxy
        implements IAccessibilityServiceConnection {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean computeClickPointInScreen(int n, long l, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, long l2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    parcel.writeInt(n2);
                    IBinder iBinder = iAccessibilityInteractionConnectionCallback != null ? iAccessibilityInteractionConnectionCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeLong(l2);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    boolean bl = false;
                    if (n3 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean findAccessibilityNodeInfoByAccessibilityId(int n, long l, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n3, long l2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    parcel.writeInt(n2);
                    IBinder iBinder = iAccessibilityInteractionConnectionCallback != null ? iAccessibilityInteractionConnectionCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n3);
                    parcel.writeLong(l2);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = parcel2.readInt();
                    boolean bl = false;
                    if (n4 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean findAccessibilityNodeInfosByText(int n, long l, String string2, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, long l2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    IBinder iBinder = iAccessibilityInteractionConnectionCallback != null ? iAccessibilityInteractionConnectionCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeLong(l2);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    boolean bl = false;
                    if (n3 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean findAccessibilityNodeInfosByViewId(int n, long l, String string2, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, long l2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    IBinder iBinder = iAccessibilityInteractionConnectionCallback != null ? iAccessibilityInteractionConnectionCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeLong(l2);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    boolean bl = false;
                    if (n3 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean findFocus(int n, long l, int n2, int n3, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, long l2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    IBinder iBinder = iAccessibilityInteractionConnectionCallback != null ? iAccessibilityInteractionConnectionCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeLong(l2);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = parcel2.readInt();
                    boolean bl = false;
                    if (n4 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean focusSearch(int n, long l, int n2, int n3, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, long l2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    IBinder iBinder = iAccessibilityInteractionConnectionCallback != null ? iAccessibilityInteractionConnectionCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeLong(l2);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = parcel2.readInt();
                    boolean bl = false;
                    if (n4 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public AccessibilityServiceInfo getServiceInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    AccessibilityServiceInfo accessibilityServiceInfo = parcel2.readInt() != 0 ? AccessibilityServiceInfo.CREATOR.createFromParcel(parcel2) : null;
                    return accessibilityServiceInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public AccessibilityWindowInfo getWindow(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    AccessibilityWindowInfo accessibilityWindowInfo = parcel2.readInt() != 0 ? AccessibilityWindowInfo.CREATOR.createFromParcel(parcel2) : null;
                    return accessibilityWindowInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<AccessibilityWindowInfo> getWindows() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<AccessibilityWindowInfo> arrayList = parcel2.createTypedArrayList(AccessibilityWindowInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean performAccessibilityAction(int n, long l, int n2, Bundle bundle, int n3, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, long l2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeLong(l);
                    parcel.writeInt(n2);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n3);
                    IBinder iBinder = iAccessibilityInteractionConnectionCallback != null ? iAccessibilityInteractionConnectionCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeLong(l2);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = parcel2.readInt();
                    boolean bl = n4 != 0;
                    return bl;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean performGlobalAction(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setOnKeyEventResult(boolean bl, int n) throws RemoteException {
                int n2 = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (!bl) {
                        n2 = 0;
                    }
                    parcel.writeInt(n2);
                    parcel.writeInt(n);
                    this.mRemote.transact(13, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setServiceInfo(AccessibilityServiceInfo accessibilityServiceInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (accessibilityServiceInfo != null) {
                        parcel.writeInt(1);
                        accessibilityServiceInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

