/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PatchingChain;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.options.Options;

public class NopEliminator
extends BodyTransformer {
    public NopEliminator(Singletons.Global g) {
    }

    public static NopEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_NopEliminator();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        JimpleBody body = (JimpleBody)b;
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Removing nops...");
        }
        PatchingChain<Unit> units = body.getUnits();
        Iterator stmtIt = units.snapshotIterator();
        while (stmtIt.hasNext()) {
            Unit u = (Unit)stmtIt.next();
            if (!(u instanceof NopStmt)) continue;
            boolean keepNop = false;
            if (b.getUnits().getLast() == u) {
                for (Trap t : b.getTraps()) {
                    if (t.getEndUnit() != u) continue;
                    keepNop = true;
                }
            }
            if (keepNop) continue;
            units.remove(u);
        }
    }
}

